#!/bin/bash
target_dir=/usr/local/include

# 如果是 arm 环境,则替换 so 文件
if [ "$(uname -m)" = "armv7l" ] || [ "$(uname -m)" = "aarch64" ]; then
    echo "arm environment!"
    cp fhe/lib_arm/* fhe
    cp openssl/lib_arm/* openssl
    cp tds/lib_arm/* tds
    cp zk/lib_arm/* zk
elif [ "$(uname -s)" = "CYGWIN_NT-10.0" ] || [ "$(uname -s)" = "MINGW64_NT-10.0" ] || [ "$(uname -s)" = "MSYS_NT-10.0" ]; then
     echo "Windows platform is not support"
     exit 1
else
    echo "skip to overwrite lib files"
fi

# 拷贝 lib 和头文件拷贝
echo "copy library to ${target_dir}"
cp -rf fhe ${target_dir}
cp -rf openssl ${target_dir}
cp -rf tds ${target_dir}
cp -rf zk ${target_dir}
echo "finish!"