// Copyright © 2024 ZAMA.
// All rights reserved.

#ifndef TFHE_RS_C_API_H
#define TFHE_RS_C_API_H

// Warning, this file is autogenerated by cbindgen. Do not modify this manually.

#include <stdarg.h>
#include <stdbool.h>
#include <stddef.h>
#include <stdint.h>
#include <stdlib.h>
#include "tfhe-c-api-dynamic-buffer.h"


typedef enum BooleanEncryptionKeyChoice {
  BooleanEncryptionKeyChoiceBig,
  BooleanEncryptionKeyChoiceSmall,
} BooleanEncryptionKeyChoice;

typedef enum ShortintEncryptionKeyChoice {
  ShortintEncryptionKeyChoiceBig,
  ShortintEncryptionKeyChoiceSmall,
} ShortintEncryptionKeyChoice;

typedef struct BooleanCiphertext BooleanCiphertext;

typedef struct BooleanClientKey BooleanClientKey;

typedef struct BooleanCompressedCiphertext BooleanCompressedCiphertext;

typedef struct BooleanCompressedServerKey BooleanCompressedServerKey;

typedef struct BooleanPublicKey BooleanPublicKey;

typedef struct BooleanServerKey BooleanServerKey;

typedef struct ClientKey ClientKey;

typedef struct CompactFheBool CompactFheBool;

typedef struct CompactFheBoolList CompactFheBoolList;

typedef struct CompactFheInt10 CompactFheInt10;

typedef struct CompactFheInt10List CompactFheInt10List;

typedef struct CompactFheInt12 CompactFheInt12;

typedef struct CompactFheInt128 CompactFheInt128;

typedef struct CompactFheInt128List CompactFheInt128List;

typedef struct CompactFheInt12List CompactFheInt12List;

typedef struct CompactFheInt14 CompactFheInt14;

typedef struct CompactFheInt14List CompactFheInt14List;

typedef struct CompactFheInt16 CompactFheInt16;

typedef struct CompactFheInt160 CompactFheInt160;

typedef struct CompactFheInt160List CompactFheInt160List;

typedef struct CompactFheInt16List CompactFheInt16List;

typedef struct CompactFheInt2 CompactFheInt2;

typedef struct CompactFheInt256 CompactFheInt256;

typedef struct CompactFheInt256List CompactFheInt256List;

typedef struct CompactFheInt2List CompactFheInt2List;

typedef struct CompactFheInt32 CompactFheInt32;

typedef struct CompactFheInt32List CompactFheInt32List;

typedef struct CompactFheInt4 CompactFheInt4;

typedef struct CompactFheInt4List CompactFheInt4List;

typedef struct CompactFheInt6 CompactFheInt6;

typedef struct CompactFheInt64 CompactFheInt64;

typedef struct CompactFheInt64List CompactFheInt64List;

typedef struct CompactFheInt6List CompactFheInt6List;

typedef struct CompactFheInt8 CompactFheInt8;

typedef struct CompactFheInt8List CompactFheInt8List;

typedef struct CompactFheUint10 CompactFheUint10;

typedef struct CompactFheUint10List CompactFheUint10List;

typedef struct CompactFheUint12 CompactFheUint12;

typedef struct CompactFheUint128 CompactFheUint128;

typedef struct CompactFheUint128List CompactFheUint128List;

typedef struct CompactFheUint12List CompactFheUint12List;

typedef struct CompactFheUint14 CompactFheUint14;

typedef struct CompactFheUint14List CompactFheUint14List;

typedef struct CompactFheUint16 CompactFheUint16;

typedef struct CompactFheUint160 CompactFheUint160;

typedef struct CompactFheUint160List CompactFheUint160List;

typedef struct CompactFheUint16List CompactFheUint16List;

typedef struct CompactFheUint2 CompactFheUint2;

typedef struct CompactFheUint256 CompactFheUint256;

typedef struct CompactFheUint256List CompactFheUint256List;

typedef struct CompactFheUint2List CompactFheUint2List;

typedef struct CompactFheUint32 CompactFheUint32;

typedef struct CompactFheUint32List CompactFheUint32List;

typedef struct CompactFheUint4 CompactFheUint4;

typedef struct CompactFheUint4List CompactFheUint4List;

typedef struct CompactFheUint6 CompactFheUint6;

typedef struct CompactFheUint64 CompactFheUint64;

typedef struct CompactFheUint64List CompactFheUint64List;

typedef struct CompactFheUint6List CompactFheUint6List;

typedef struct CompactFheUint8 CompactFheUint8;

typedef struct CompactFheUint8List CompactFheUint8List;

typedef struct CompactPublicKey CompactPublicKey;

typedef struct CompressedCompactPublicKey CompressedCompactPublicKey;

typedef struct CompressedFheBool CompressedFheBool;

typedef struct CompressedFheInt10 CompressedFheInt10;

typedef struct CompressedFheInt12 CompressedFheInt12;

typedef struct CompressedFheInt128 CompressedFheInt128;

typedef struct CompressedFheInt14 CompressedFheInt14;

typedef struct CompressedFheInt16 CompressedFheInt16;

typedef struct CompressedFheInt160 CompressedFheInt160;

typedef struct CompressedFheInt2 CompressedFheInt2;

typedef struct CompressedFheInt256 CompressedFheInt256;

typedef struct CompressedFheInt32 CompressedFheInt32;

typedef struct CompressedFheInt4 CompressedFheInt4;

typedef struct CompressedFheInt6 CompressedFheInt6;

typedef struct CompressedFheInt64 CompressedFheInt64;

typedef struct CompressedFheInt8 CompressedFheInt8;

typedef struct CompressedFheUint10 CompressedFheUint10;

typedef struct CompressedFheUint12 CompressedFheUint12;

typedef struct CompressedFheUint128 CompressedFheUint128;

typedef struct CompressedFheUint14 CompressedFheUint14;

typedef struct CompressedFheUint16 CompressedFheUint16;

typedef struct CompressedFheUint160 CompressedFheUint160;

typedef struct CompressedFheUint2 CompressedFheUint2;

typedef struct CompressedFheUint256 CompressedFheUint256;

typedef struct CompressedFheUint32 CompressedFheUint32;

typedef struct CompressedFheUint4 CompressedFheUint4;

typedef struct CompressedFheUint6 CompressedFheUint6;

typedef struct CompressedFheUint64 CompressedFheUint64;

typedef struct CompressedFheUint8 CompressedFheUint8;

/**
 * Compressed version of the ServerKey
 *
 * Allows to save storage space and transfer time.
 * Also, the CompressedServerKey is the key format that allows to select
 * the target hardware of the actual ServerKey when decompressing it.
 */
typedef struct CompressedServerKey CompressedServerKey;

typedef struct Config Config;

typedef struct ConfigBuilder ConfigBuilder;

typedef struct FheBool FheBool;

typedef struct FheInt10 FheInt10;

typedef struct FheInt12 FheInt12;

typedef struct FheInt128 FheInt128;

typedef struct FheInt14 FheInt14;

typedef struct FheInt16 FheInt16;

typedef struct FheInt160 FheInt160;

typedef struct FheInt2 FheInt2;

typedef struct FheInt256 FheInt256;

typedef struct FheInt32 FheInt32;

typedef struct FheInt4 FheInt4;

typedef struct FheInt6 FheInt6;

typedef struct FheInt64 FheInt64;

typedef struct FheInt8 FheInt8;

typedef struct FheUint10 FheUint10;

typedef struct FheUint12 FheUint12;

typedef struct FheUint128 FheUint128;

typedef struct FheUint14 FheUint14;

typedef struct FheUint16 FheUint16;

typedef struct FheUint160 FheUint160;

typedef struct FheUint2 FheUint2;

typedef struct FheUint256 FheUint256;

typedef struct FheUint32 FheUint32;

typedef struct FheUint4 FheUint4;

typedef struct FheUint6 FheUint6;

typedef struct FheUint64 FheUint64;

typedef struct FheUint8 FheUint8;

typedef struct PublicKey PublicKey;

typedef struct ServerKey ServerKey;

typedef struct ShortintBivariatePBSLookupTable ShortintBivariatePBSLookupTable;

typedef struct ShortintCiphertext ShortintCiphertext;

typedef struct ShortintClientKey ShortintClientKey;

typedef struct ShortintCompressedCiphertext ShortintCompressedCiphertext;

typedef struct ShortintCompressedPublicKey ShortintCompressedPublicKey;

typedef struct ShortintCompressedServerKey ShortintCompressedServerKey;

typedef struct ShortintPBSLookupTable ShortintPBSLookupTable;

typedef struct ShortintPublicKey ShortintPublicKey;

typedef struct ShortintServerKey ShortintServerKey;

/**
 * Used to limit number of threads
 *
 * This struct can be used to limit the number of threads
 * operations (ran inside this context) can use.
 *
 * A threading context creates and hold the specified number of threads
 */
typedef struct TfheThreadingContext TfheThreadingContext;

typedef struct Gaussian {
  double std;
} Gaussian;

typedef struct TUniform {
  uint32_t bound_log2;
} TUniform;

typedef union DynamicDistributionPayload {
  struct Gaussian gaussian;
  struct TUniform t_uniform;
} DynamicDistributionPayload;

typedef struct DynamicDistribution {
  uint64_t tag;
  union DynamicDistributionPayload distribution;
} DynamicDistribution;

typedef struct BooleanParameters {
  size_t lwe_dimension;
  size_t glwe_dimension;
  size_t polynomial_size;
  struct DynamicDistribution lwe_noise_distribution;
  struct DynamicDistribution glwe_noise_distribution;
  size_t pbs_base_log;
  size_t pbs_level;
  size_t ks_base_log;
  size_t ks_level;
  enum BooleanEncryptionKeyChoice encryption_key_choice;
} BooleanParameters;

/**
 * w0 and w1 are words in little endian order
 * using two's complement representation
 */
typedef struct I128 {
  uint64_t w0;
  uint64_t w1;
} I128;

/**
 * w0, w1, w2, w3 are words in little endian order
 * using two's complement representation
 */
typedef struct I256 {
  uint64_t w0;
  uint64_t w1;
  uint64_t w2;
  uint64_t w3;
} I256;

typedef struct U128 {
  uint64_t w0;
  uint64_t w1;
} U128;

typedef struct U256 {
  uint64_t w0;
  uint64_t w1;
  uint64_t w2;
  uint64_t w3;
} U256;

typedef struct ShortintPBSParameters {
  size_t lwe_dimension;
  size_t glwe_dimension;
  size_t polynomial_size;
  struct DynamicDistribution lwe_noise_distribution;
  struct DynamicDistribution glwe_noise_distribution;
  size_t pbs_base_log;
  size_t pbs_level;
  size_t ks_base_log;
  size_t ks_level;
  size_t message_modulus;
  size_t carry_modulus;
  size_t max_noise_level;
  double log2_p_fail;
  size_t modulus_power_of_2_exponent;
  enum ShortintEncryptionKeyChoice encryption_key_choice;
} ShortintPBSParameters;

typedef uint64_t (*BivariateLookupTableCallback)(uint64_t, uint64_t);

typedef uint64_t (*LookupTableCallback)(uint64_t);

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

extern const struct BooleanParameters BOOLEAN_PARAMETERS_SET_DEFAULT_PARAMETERS;

extern const struct BooleanParameters BOOLEAN_PARAMETERS_SET_DEFAULT_PARAMETERS_KS_PBS;

extern const struct BooleanParameters BOOLEAN_PARAMETERS_SET_TFHE_LIB_PARAMETERS;

extern const struct BooleanParameters BOOLEAN_PARAMETERS_SET_TFHE_LIB_PARAMETERS_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_1_CARRY_0;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_1_CARRY_0_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_1_CARRY_1;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_1_CARRY_1_COMPACT_PK_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_1_CARRY_1_COMPACT_PK_PBS_KS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_1_CARRY_1_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_1_CARRY_1_PBS_KS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_1_CARRY_2;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_1_CARRY_2_COMPACT_PK_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_1_CARRY_2_COMPACT_PK_KS_PBS_TUNIFORM_2M40;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_1_CARRY_2_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_1_CARRY_3;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_1_CARRY_3_COMPACT_PK_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_1_CARRY_3_COMPACT_PK_KS_PBS_TUNIFORM_2M40;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_1_CARRY_3_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_1_CARRY_4;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_1_CARRY_4_COMPACT_PK_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_1_CARRY_4_COMPACT_PK_KS_PBS_TUNIFORM_2M40;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_1_CARRY_4_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_1_CARRY_5;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_1_CARRY_5_COMPACT_PK_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_1_CARRY_5_COMPACT_PK_KS_PBS_TUNIFORM_2M40;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_1_CARRY_5_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_1_CARRY_6;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_1_CARRY_6_COMPACT_PK_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_1_CARRY_6_COMPACT_PK_KS_PBS_TUNIFORM_2M40;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_1_CARRY_6_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_1_CARRY_7;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_1_CARRY_7_COMPACT_PK_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_1_CARRY_7_COMPACT_PK_KS_PBS_TUNIFORM_2M40;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_1_CARRY_7_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_2_CARRY_0;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_2_CARRY_0_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_2_CARRY_1;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_2_CARRY_1_COMPACT_PK_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_2_CARRY_1_COMPACT_PK_KS_PBS_TUNIFORM_2M40;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_2_CARRY_1_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_2_CARRY_2;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_2_CARRY_2_COMPACT_PK_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_2_CARRY_2_COMPACT_PK_KS_PBS_TUNIFORM_2M40;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_2_CARRY_2_COMPACT_PK_PBS_KS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_2_CARRY_2_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_2_CARRY_2_PBS_KS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_2_CARRY_3;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_2_CARRY_3_COMPACT_PK_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_2_CARRY_3_COMPACT_PK_KS_PBS_TUNIFORM_2M40;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_2_CARRY_3_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_2_CARRY_4;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_2_CARRY_4_COMPACT_PK_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_2_CARRY_4_COMPACT_PK_KS_PBS_TUNIFORM_2M40;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_2_CARRY_4_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_2_CARRY_5;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_2_CARRY_5_COMPACT_PK_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_2_CARRY_5_COMPACT_PK_KS_PBS_TUNIFORM_2M40;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_2_CARRY_5_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_2_CARRY_6;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_2_CARRY_6_COMPACT_PK_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_2_CARRY_6_COMPACT_PK_KS_PBS_TUNIFORM_2M40;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_2_CARRY_6_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_3_CARRY_0;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_3_CARRY_0_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_3_CARRY_1;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_3_CARRY_1_COMPACT_PK_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_3_CARRY_1_COMPACT_PK_KS_PBS_TUNIFORM_2M40;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_3_CARRY_1_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_3_CARRY_2;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_3_CARRY_2_COMPACT_PK_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_3_CARRY_2_COMPACT_PK_KS_PBS_TUNIFORM_2M40;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_3_CARRY_2_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_3_CARRY_3;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_3_CARRY_3_COMPACT_PK_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_3_CARRY_3_COMPACT_PK_KS_PBS_TUNIFORM_2M40;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_3_CARRY_3_COMPACT_PK_PBS_KS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_3_CARRY_3_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_3_CARRY_3_PBS_KS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_3_CARRY_4;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_3_CARRY_4_COMPACT_PK_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_3_CARRY_4_COMPACT_PK_KS_PBS_TUNIFORM_2M40;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_3_CARRY_4_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_3_CARRY_5;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_3_CARRY_5_COMPACT_PK_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_3_CARRY_5_COMPACT_PK_KS_PBS_TUNIFORM_2M40;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_3_CARRY_5_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_4_CARRY_0;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_4_CARRY_0_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_4_CARRY_1;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_4_CARRY_1_COMPACT_PK_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_4_CARRY_1_COMPACT_PK_KS_PBS_TUNIFORM_2M40;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_4_CARRY_1_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_4_CARRY_2;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_4_CARRY_2_COMPACT_PK_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_4_CARRY_2_COMPACT_PK_KS_PBS_TUNIFORM_2M40;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_4_CARRY_2_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_4_CARRY_3;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_4_CARRY_3_COMPACT_PK_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_4_CARRY_3_COMPACT_PK_KS_PBS_TUNIFORM_2M40;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_4_CARRY_3_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_4_CARRY_4;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_4_CARRY_4_COMPACT_PK_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_4_CARRY_4_COMPACT_PK_KS_PBS_TUNIFORM_2M40;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_4_CARRY_4_COMPACT_PK_PBS_KS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_4_CARRY_4_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_4_CARRY_4_PBS_KS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_5_CARRY_0;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_5_CARRY_0_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_5_CARRY_1;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_5_CARRY_1_COMPACT_PK_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_5_CARRY_1_COMPACT_PK_KS_PBS_TUNIFORM_2M40;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_5_CARRY_1_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_5_CARRY_2;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_5_CARRY_2_COMPACT_PK_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_5_CARRY_2_COMPACT_PK_KS_PBS_TUNIFORM_2M40;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_5_CARRY_2_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_5_CARRY_3;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_5_CARRY_3_COMPACT_PK_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_5_CARRY_3_COMPACT_PK_KS_PBS_TUNIFORM_2M40;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_5_CARRY_3_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_6_CARRY_0;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_6_CARRY_0_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_6_CARRY_1;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_6_CARRY_1_COMPACT_PK_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_6_CARRY_1_COMPACT_PK_KS_PBS_TUNIFORM_2M40;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_6_CARRY_1_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_6_CARRY_2;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_6_CARRY_2_COMPACT_PK_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_6_CARRY_2_COMPACT_PK_KS_PBS_TUNIFORM_2M40;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_6_CARRY_2_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_7_CARRY_0;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_7_CARRY_0_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_7_CARRY_1;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_7_CARRY_1_COMPACT_PK_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_7_CARRY_1_COMPACT_PK_KS_PBS_TUNIFORM_2M40;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_7_CARRY_1_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_8_CARRY_0;

extern const struct ShortintPBSParameters SHORTINT_PARAM_MESSAGE_8_CARRY_0_KS_PBS;

extern const struct ShortintPBSParameters SHORTINT_PARAM_SMALL_MESSAGE_1_CARRY_1;

extern const struct ShortintPBSParameters SHORTINT_PARAM_SMALL_MESSAGE_2_CARRY_2;

extern const struct ShortintPBSParameters SHORTINT_PARAM_SMALL_MESSAGE_3_CARRY_3;

extern const struct ShortintPBSParameters SHORTINT_PARAM_SMALL_MESSAGE_4_CARRY_4;

int boolean_client_key_decrypt(const struct BooleanClientKey *client_key,
                               const struct BooleanCiphertext *ciphertext_to_decrypt,
                               bool *result);

int boolean_client_key_encrypt(const struct BooleanClientKey *client_key,
                               bool value_to_encrypt,
                               struct BooleanCiphertext **result);

int boolean_client_key_encrypt_compressed(const struct BooleanClientKey *client_key,
                                          bool value_to_encrypt,
                                          struct BooleanCompressedCiphertext **result);

int boolean_decompress_ciphertext(struct BooleanCompressedCiphertext *compressed_ciphertext,
                                  struct BooleanCiphertext **result);

int boolean_decompress_server_key(const struct BooleanCompressedServerKey *compressed_server_key,
                                  struct BooleanServerKey **result);

int boolean_deserialize_ciphertext(DynamicBufferView buffer_view,
                                   struct BooleanCiphertext **result);

int boolean_deserialize_client_key(DynamicBufferView buffer_view, struct BooleanClientKey **result);

int boolean_deserialize_compressed_ciphertext(DynamicBufferView buffer_view,
                                              struct BooleanCompressedCiphertext **result);

int boolean_deserialize_compressed_server_key(DynamicBufferView buffer_view,
                                              struct BooleanCompressedServerKey **result);

int boolean_deserialize_public_key(DynamicBufferView buffer_view, struct BooleanPublicKey **result);

int boolean_deserialize_server_key(DynamicBufferView buffer_view, struct BooleanServerKey **result);

int boolean_destroy_ciphertext(struct BooleanCiphertext *boolean_ciphertext);

int boolean_destroy_client_key(struct BooleanClientKey *client_key);

int boolean_destroy_compressed_ciphertext(struct BooleanCompressedCiphertext *boolean_ciphertext);

int boolean_destroy_compressed_server_key(struct BooleanCompressedServerKey *server_key);

int boolean_destroy_public_key(struct BooleanPublicKey *public_key);

int boolean_destroy_server_key(struct BooleanServerKey *server_key);

int boolean_gen_client_key(struct BooleanParameters boolean_parameters,
                           struct BooleanClientKey **result_client_key);

int boolean_gen_compressed_server_key(const struct BooleanClientKey *client_key,
                                      struct BooleanCompressedServerKey **result_server_key);

int boolean_gen_keys_with_default_parameters(struct BooleanClientKey **result_client_key,
                                             struct BooleanServerKey **result_server_key);

int boolean_gen_keys_with_parameters(struct BooleanParameters boolean_parameters,
                                     struct BooleanClientKey **result_client_key,
                                     struct BooleanServerKey **result_server_key);

int boolean_gen_public_key(const struct BooleanClientKey *client_key,
                           struct BooleanPublicKey **result);

int boolean_gen_server_key(const struct BooleanClientKey *client_key,
                           struct BooleanServerKey **result_server_key);

int boolean_public_key_encrypt(const struct BooleanPublicKey *public_key,
                               bool value_to_encrypt,
                               struct BooleanCiphertext **result);

int boolean_serialize_ciphertext(const struct BooleanCiphertext *ciphertext, DynamicBuffer *result);

int boolean_serialize_client_key(const struct BooleanClientKey *client_key, DynamicBuffer *result);

int boolean_serialize_compressed_ciphertext(const struct BooleanCompressedCiphertext *ciphertext,
                                            DynamicBuffer *result);

int boolean_serialize_compressed_server_key(const struct BooleanCompressedServerKey *server_key,
                                            DynamicBuffer *result);

int boolean_serialize_public_key(const struct BooleanPublicKey *public_key, DynamicBuffer *result);

int boolean_serialize_server_key(const struct BooleanServerKey *server_key, DynamicBuffer *result);

int boolean_server_key_and(const struct BooleanServerKey *server_key,
                           const struct BooleanCiphertext *ct_left,
                           const struct BooleanCiphertext *ct_right,
                           struct BooleanCiphertext **result);

int boolean_server_key_and_assign(const struct BooleanServerKey *server_key,
                                  struct BooleanCiphertext *ct_left,
                                  const struct BooleanCiphertext *ct_right);

int boolean_server_key_and_scalar(const struct BooleanServerKey *server_key,
                                  const struct BooleanCiphertext *ct_left,
                                  bool scalar,
                                  struct BooleanCiphertext **result);

int boolean_server_key_and_scalar_assign(const struct BooleanServerKey *server_key,
                                         struct BooleanCiphertext *ct_left,
                                         bool scalar);

int boolean_server_key_mux(const struct BooleanServerKey *server_key,
                           const struct BooleanCiphertext *ct_condition,
                           const struct BooleanCiphertext *ct_then,
                           const struct BooleanCiphertext *ct_else,
                           struct BooleanCiphertext **result);

int boolean_server_key_nand(const struct BooleanServerKey *server_key,
                            const struct BooleanCiphertext *ct_left,
                            const struct BooleanCiphertext *ct_right,
                            struct BooleanCiphertext **result);

int boolean_server_key_nand_assign(const struct BooleanServerKey *server_key,
                                   struct BooleanCiphertext *ct_left,
                                   const struct BooleanCiphertext *ct_right);

int boolean_server_key_nand_scalar(const struct BooleanServerKey *server_key,
                                   const struct BooleanCiphertext *ct_left,
                                   bool scalar,
                                   struct BooleanCiphertext **result);

int boolean_server_key_nand_scalar_assign(const struct BooleanServerKey *server_key,
                                          struct BooleanCiphertext *ct_left,
                                          bool scalar);

int boolean_server_key_nor(const struct BooleanServerKey *server_key,
                           const struct BooleanCiphertext *ct_left,
                           const struct BooleanCiphertext *ct_right,
                           struct BooleanCiphertext **result);

int boolean_server_key_nor_assign(const struct BooleanServerKey *server_key,
                                  struct BooleanCiphertext *ct_left,
                                  const struct BooleanCiphertext *ct_right);

int boolean_server_key_nor_scalar(const struct BooleanServerKey *server_key,
                                  const struct BooleanCiphertext *ct_left,
                                  bool scalar,
                                  struct BooleanCiphertext **result);

int boolean_server_key_nor_scalar_assign(const struct BooleanServerKey *server_key,
                                         struct BooleanCiphertext *ct_left,
                                         bool scalar);

int boolean_server_key_not(const struct BooleanServerKey *server_key,
                           const struct BooleanCiphertext *ct_input,
                           struct BooleanCiphertext **result);

int boolean_server_key_not_assign(const struct BooleanServerKey *server_key,
                                  struct BooleanCiphertext *ct_input);

int boolean_server_key_or(const struct BooleanServerKey *server_key,
                          const struct BooleanCiphertext *ct_left,
                          const struct BooleanCiphertext *ct_right,
                          struct BooleanCiphertext **result);

int boolean_server_key_or_assign(const struct BooleanServerKey *server_key,
                                 struct BooleanCiphertext *ct_left,
                                 const struct BooleanCiphertext *ct_right);

int boolean_server_key_or_scalar(const struct BooleanServerKey *server_key,
                                 const struct BooleanCiphertext *ct_left,
                                 bool scalar,
                                 struct BooleanCiphertext **result);

int boolean_server_key_or_scalar_assign(const struct BooleanServerKey *server_key,
                                        struct BooleanCiphertext *ct_left,
                                        bool scalar);

int boolean_server_key_xnor(const struct BooleanServerKey *server_key,
                            const struct BooleanCiphertext *ct_left,
                            const struct BooleanCiphertext *ct_right,
                            struct BooleanCiphertext **result);

int boolean_server_key_xnor_assign(const struct BooleanServerKey *server_key,
                                   struct BooleanCiphertext *ct_left,
                                   const struct BooleanCiphertext *ct_right);

int boolean_server_key_xnor_scalar(const struct BooleanServerKey *server_key,
                                   const struct BooleanCiphertext *ct_left,
                                   bool scalar,
                                   struct BooleanCiphertext **result);

int boolean_server_key_xnor_scalar_assign(const struct BooleanServerKey *server_key,
                                          struct BooleanCiphertext *ct_left,
                                          bool scalar);

int boolean_server_key_xor(const struct BooleanServerKey *server_key,
                           const struct BooleanCiphertext *ct_left,
                           const struct BooleanCiphertext *ct_right,
                           struct BooleanCiphertext **result);

int boolean_server_key_xor_assign(const struct BooleanServerKey *server_key,
                                  struct BooleanCiphertext *ct_left,
                                  const struct BooleanCiphertext *ct_right);

int boolean_server_key_xor_scalar(const struct BooleanServerKey *server_key,
                                  const struct BooleanCiphertext *ct_left,
                                  bool scalar,
                                  struct BooleanCiphertext **result);

int boolean_server_key_xor_scalar_assign(const struct BooleanServerKey *server_key,
                                         struct BooleanCiphertext *ct_left,
                                         bool scalar);

int boolean_trivial_encrypt(bool message, struct BooleanCiphertext **result);

int client_key_deserialize(DynamicBufferView buffer_view, struct ClientKey **result);

/**
 *ptr can be null (no-op in that case)
 */
int client_key_destroy(struct ClientKey *ptr);

/**
 * Generates a client key with the given config
 *
 * This function takes ownership of the config,
 * thus the given config pointer should not be used/freed after.
 */
int client_key_generate(struct Config *config, struct ClientKey **result_client_key);

int client_key_serialize(const struct ClientKey *sself, DynamicBuffer *result);

int compact_fhe_bool_clone(const struct CompactFheBool *sself, struct CompactFheBool **result);

int compact_fhe_bool_deserialize(DynamicBufferView buffer_view, struct CompactFheBool **result);

/**
 *ptr can be null (no-op in that case)
 */
int compact_fhe_bool_destroy(struct CompactFheBool *ptr);

int compact_fhe_bool_expand(const struct CompactFheBool *sself, struct FheBool **result);

int compact_fhe_bool_list_clone(const struct CompactFheBoolList *sself,
                                struct CompactFheBoolList **result);

int compact_fhe_bool_list_deserialize(DynamicBufferView buffer_view,
                                      struct CompactFheBoolList **result);

/**
 *ptr can be null (no-op in that case)
 */
int compact_fhe_bool_list_destroy(struct CompactFheBoolList *ptr);

int compact_fhe_bool_list_expand(const struct CompactFheBoolList *sself,
                                 struct FheBool **output,
                                 size_t output_len);

int compact_fhe_bool_list_len(const struct CompactFheBoolList *sself, size_t *result);

/**
 * Deserializes a list safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `exact_len`: exact lenght/size/number of element the list must have
 *    (not less nor more, otherwise, it's considered an error)
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compact_fhe_bool_list_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                      uint64_t serialized_size_limit,
                                                      const struct ServerKey *server_key,
                                                      size_t exact_len,
                                                      struct CompactFheBoolList **result);

int compact_fhe_bool_list_safe_serialize(const struct CompactFheBoolList *sself,
                                         DynamicBuffer *result,
                                         uint64_t serialized_size_limit);

int compact_fhe_bool_list_serialize(const struct CompactFheBoolList *sself, DynamicBuffer *result);

int compact_fhe_bool_list_try_encrypt_with_compact_public_key_bool(const bool *input,
                                                                   size_t input_len,
                                                                   const struct CompactPublicKey *public_key,
                                                                   struct CompactFheBoolList **result);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compact_fhe_bool_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                 uint64_t serialized_size_limit,
                                                 const struct ServerKey *server_key,
                                                 struct CompactFheBool **result);

int compact_fhe_bool_safe_serialize(const struct CompactFheBool *sself,
                                    DynamicBuffer *result,
                                    uint64_t serialized_size_limit);

int compact_fhe_bool_serialize(const struct CompactFheBool *sself, DynamicBuffer *result);

int compact_fhe_bool_try_encrypt_with_compact_public_key_bool(bool value,
                                                              const struct CompactPublicKey *public_key,
                                                              struct CompactFheBool **result);

int compact_fhe_int10_clone(const struct CompactFheInt10 *sself, struct CompactFheInt10 **result);

int compact_fhe_int10_deserialize(DynamicBufferView buffer_view, struct CompactFheInt10 **result);

/**
 *ptr can be null (no-op in that case)
 */
int compact_fhe_int10_destroy(struct CompactFheInt10 *ptr);

int compact_fhe_int10_expand(const struct CompactFheInt10 *sself, struct FheInt10 **output);

int compact_fhe_int10_list_clone(const struct CompactFheInt10List *sself,
                                 struct CompactFheInt10List **result);

int compact_fhe_int10_list_deserialize(DynamicBufferView buffer_view,
                                       struct CompactFheInt10List **result);

/**
 *ptr can be null (no-op in that case)
 */
int compact_fhe_int10_list_destroy(struct CompactFheInt10List *ptr);

int compact_fhe_int10_list_expand(const struct CompactFheInt10List *sself,
                                  struct FheInt10 **output,
                                  size_t output_len);

int compact_fhe_int10_list_len(const struct CompactFheInt10List *sself, size_t *result);

/**
 * Deserializes a list safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `exact_len`: exact lenght/size/number of element the list must have
 *    (not less nor more, otherwise, it's considered an error)
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compact_fhe_int10_list_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                       uint64_t serialized_size_limit,
                                                       const struct ServerKey *server_key,
                                                       size_t exact_len,
                                                       struct CompactFheInt10List **result);

int compact_fhe_int10_list_safe_serialize(const struct CompactFheInt10List *sself,
                                          DynamicBuffer *result,
                                          uint64_t serialized_size_limit);

int compact_fhe_int10_list_serialize(const struct CompactFheInt10List *sself,
                                     DynamicBuffer *result);

int compact_fhe_int10_list_try_encrypt_with_compact_public_key_i16(const int16_t *input,
                                                                   size_t input_len,
                                                                   const struct CompactPublicKey *public_key,
                                                                   struct CompactFheInt10List **result);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compact_fhe_int10_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                  uint64_t serialized_size_limit,
                                                  const struct ServerKey *server_key,
                                                  struct CompactFheInt10 **result);

int compact_fhe_int10_safe_serialize(const struct CompactFheInt10 *sself,
                                     DynamicBuffer *result,
                                     uint64_t serialized_size_limit);

int compact_fhe_int10_serialize(const struct CompactFheInt10 *sself, DynamicBuffer *result);

int compact_fhe_int10_try_encrypt_with_compact_public_key_i16(int16_t value,
                                                              const struct CompactPublicKey *public_key,
                                                              struct CompactFheInt10 **result);

int compact_fhe_int128_clone(const struct CompactFheInt128 *sself,
                             struct CompactFheInt128 **result);

int compact_fhe_int128_deserialize(DynamicBufferView buffer_view, struct CompactFheInt128 **result);

/**
 *ptr can be null (no-op in that case)
 */
int compact_fhe_int128_destroy(struct CompactFheInt128 *ptr);

int compact_fhe_int128_expand(const struct CompactFheInt128 *sself, struct FheInt128 **output);

int compact_fhe_int128_list_clone(const struct CompactFheInt128List *sself,
                                  struct CompactFheInt128List **result);

int compact_fhe_int128_list_deserialize(DynamicBufferView buffer_view,
                                        struct CompactFheInt128List **result);

/**
 *ptr can be null (no-op in that case)
 */
int compact_fhe_int128_list_destroy(struct CompactFheInt128List *ptr);

int compact_fhe_int128_list_expand(const struct CompactFheInt128List *sself,
                                   struct FheInt128 **output,
                                   size_t output_len);

int compact_fhe_int128_list_len(const struct CompactFheInt128List *sself, size_t *result);

/**
 * Deserializes a list safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `exact_len`: exact lenght/size/number of element the list must have
 *    (not less nor more, otherwise, it's considered an error)
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compact_fhe_int128_list_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                        uint64_t serialized_size_limit,
                                                        const struct ServerKey *server_key,
                                                        size_t exact_len,
                                                        struct CompactFheInt128List **result);

int compact_fhe_int128_list_safe_serialize(const struct CompactFheInt128List *sself,
                                           DynamicBuffer *result,
                                           uint64_t serialized_size_limit);

int compact_fhe_int128_list_serialize(const struct CompactFheInt128List *sself,
                                      DynamicBuffer *result);

int compact_fhe_int128_list_try_encrypt_with_compact_public_key_i128(const struct I128 *input,
                                                                     size_t input_len,
                                                                     const struct CompactPublicKey *public_key,
                                                                     struct CompactFheInt128List **result);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compact_fhe_int128_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                   uint64_t serialized_size_limit,
                                                   const struct ServerKey *server_key,
                                                   struct CompactFheInt128 **result);

int compact_fhe_int128_safe_serialize(const struct CompactFheInt128 *sself,
                                      DynamicBuffer *result,
                                      uint64_t serialized_size_limit);

int compact_fhe_int128_serialize(const struct CompactFheInt128 *sself, DynamicBuffer *result);

int compact_fhe_int128_try_encrypt_with_compact_public_key_i128(struct I128 value,
                                                                const struct CompactPublicKey *public_key,
                                                                struct CompactFheInt128 **result);

int compact_fhe_int12_clone(const struct CompactFheInt12 *sself, struct CompactFheInt12 **result);

int compact_fhe_int12_deserialize(DynamicBufferView buffer_view, struct CompactFheInt12 **result);

/**
 *ptr can be null (no-op in that case)
 */
int compact_fhe_int12_destroy(struct CompactFheInt12 *ptr);

int compact_fhe_int12_expand(const struct CompactFheInt12 *sself, struct FheInt12 **output);

int compact_fhe_int12_list_clone(const struct CompactFheInt12List *sself,
                                 struct CompactFheInt12List **result);

int compact_fhe_int12_list_deserialize(DynamicBufferView buffer_view,
                                       struct CompactFheInt12List **result);

/**
 *ptr can be null (no-op in that case)
 */
int compact_fhe_int12_list_destroy(struct CompactFheInt12List *ptr);

int compact_fhe_int12_list_expand(const struct CompactFheInt12List *sself,
                                  struct FheInt12 **output,
                                  size_t output_len);

int compact_fhe_int12_list_len(const struct CompactFheInt12List *sself, size_t *result);

/**
 * Deserializes a list safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `exact_len`: exact lenght/size/number of element the list must have
 *    (not less nor more, otherwise, it's considered an error)
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compact_fhe_int12_list_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                       uint64_t serialized_size_limit,
                                                       const struct ServerKey *server_key,
                                                       size_t exact_len,
                                                       struct CompactFheInt12List **result);

int compact_fhe_int12_list_safe_serialize(const struct CompactFheInt12List *sself,
                                          DynamicBuffer *result,
                                          uint64_t serialized_size_limit);

int compact_fhe_int12_list_serialize(const struct CompactFheInt12List *sself,
                                     DynamicBuffer *result);

int compact_fhe_int12_list_try_encrypt_with_compact_public_key_i16(const int16_t *input,
                                                                   size_t input_len,
                                                                   const struct CompactPublicKey *public_key,
                                                                   struct CompactFheInt12List **result);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compact_fhe_int12_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                  uint64_t serialized_size_limit,
                                                  const struct ServerKey *server_key,
                                                  struct CompactFheInt12 **result);

int compact_fhe_int12_safe_serialize(const struct CompactFheInt12 *sself,
                                     DynamicBuffer *result,
                                     uint64_t serialized_size_limit);

int compact_fhe_int12_serialize(const struct CompactFheInt12 *sself, DynamicBuffer *result);

int compact_fhe_int12_try_encrypt_with_compact_public_key_i16(int16_t value,
                                                              const struct CompactPublicKey *public_key,
                                                              struct CompactFheInt12 **result);

int compact_fhe_int14_clone(const struct CompactFheInt14 *sself, struct CompactFheInt14 **result);

int compact_fhe_int14_deserialize(DynamicBufferView buffer_view, struct CompactFheInt14 **result);

/**
 *ptr can be null (no-op in that case)
 */
int compact_fhe_int14_destroy(struct CompactFheInt14 *ptr);

int compact_fhe_int14_expand(const struct CompactFheInt14 *sself, struct FheInt14 **output);

int compact_fhe_int14_list_clone(const struct CompactFheInt14List *sself,
                                 struct CompactFheInt14List **result);

int compact_fhe_int14_list_deserialize(DynamicBufferView buffer_view,
                                       struct CompactFheInt14List **result);

/**
 *ptr can be null (no-op in that case)
 */
int compact_fhe_int14_list_destroy(struct CompactFheInt14List *ptr);

int compact_fhe_int14_list_expand(const struct CompactFheInt14List *sself,
                                  struct FheInt14 **output,
                                  size_t output_len);

int compact_fhe_int14_list_len(const struct CompactFheInt14List *sself, size_t *result);

/**
 * Deserializes a list safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `exact_len`: exact lenght/size/number of element the list must have
 *    (not less nor more, otherwise, it's considered an error)
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compact_fhe_int14_list_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                       uint64_t serialized_size_limit,
                                                       const struct ServerKey *server_key,
                                                       size_t exact_len,
                                                       struct CompactFheInt14List **result);

int compact_fhe_int14_list_safe_serialize(const struct CompactFheInt14List *sself,
                                          DynamicBuffer *result,
                                          uint64_t serialized_size_limit);

int compact_fhe_int14_list_serialize(const struct CompactFheInt14List *sself,
                                     DynamicBuffer *result);

int compact_fhe_int14_list_try_encrypt_with_compact_public_key_i16(const int16_t *input,
                                                                   size_t input_len,
                                                                   const struct CompactPublicKey *public_key,
                                                                   struct CompactFheInt14List **result);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compact_fhe_int14_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                  uint64_t serialized_size_limit,
                                                  const struct ServerKey *server_key,
                                                  struct CompactFheInt14 **result);

int compact_fhe_int14_safe_serialize(const struct CompactFheInt14 *sself,
                                     DynamicBuffer *result,
                                     uint64_t serialized_size_limit);

int compact_fhe_int14_serialize(const struct CompactFheInt14 *sself, DynamicBuffer *result);

int compact_fhe_int14_try_encrypt_with_compact_public_key_i16(int16_t value,
                                                              const struct CompactPublicKey *public_key,
                                                              struct CompactFheInt14 **result);

int compact_fhe_int160_clone(const struct CompactFheInt160 *sself,
                             struct CompactFheInt160 **result);

int compact_fhe_int160_deserialize(DynamicBufferView buffer_view, struct CompactFheInt160 **result);

/**
 *ptr can be null (no-op in that case)
 */
int compact_fhe_int160_destroy(struct CompactFheInt160 *ptr);

int compact_fhe_int160_expand(const struct CompactFheInt160 *sself, struct FheInt160 **output);

int compact_fhe_int160_list_clone(const struct CompactFheInt160List *sself,
                                  struct CompactFheInt160List **result);

int compact_fhe_int160_list_deserialize(DynamicBufferView buffer_view,
                                        struct CompactFheInt160List **result);

/**
 *ptr can be null (no-op in that case)
 */
int compact_fhe_int160_list_destroy(struct CompactFheInt160List *ptr);

int compact_fhe_int160_list_expand(const struct CompactFheInt160List *sself,
                                   struct FheInt160 **output,
                                   size_t output_len);

int compact_fhe_int160_list_len(const struct CompactFheInt160List *sself, size_t *result);

/**
 * Deserializes a list safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `exact_len`: exact lenght/size/number of element the list must have
 *    (not less nor more, otherwise, it's considered an error)
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compact_fhe_int160_list_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                        uint64_t serialized_size_limit,
                                                        const struct ServerKey *server_key,
                                                        size_t exact_len,
                                                        struct CompactFheInt160List **result);

int compact_fhe_int160_list_safe_serialize(const struct CompactFheInt160List *sself,
                                           DynamicBuffer *result,
                                           uint64_t serialized_size_limit);

int compact_fhe_int160_list_serialize(const struct CompactFheInt160List *sself,
                                      DynamicBuffer *result);

int compact_fhe_int160_list_try_encrypt_with_compact_public_key_i256(const struct I256 *input,
                                                                     size_t input_len,
                                                                     const struct CompactPublicKey *public_key,
                                                                     struct CompactFheInt160List **result);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compact_fhe_int160_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                   uint64_t serialized_size_limit,
                                                   const struct ServerKey *server_key,
                                                   struct CompactFheInt160 **result);

int compact_fhe_int160_safe_serialize(const struct CompactFheInt160 *sself,
                                      DynamicBuffer *result,
                                      uint64_t serialized_size_limit);

int compact_fhe_int160_serialize(const struct CompactFheInt160 *sself, DynamicBuffer *result);

int compact_fhe_int160_try_encrypt_with_compact_public_key_i256(struct I256 value,
                                                                const struct CompactPublicKey *public_key,
                                                                struct CompactFheInt160 **result);

int compact_fhe_int16_clone(const struct CompactFheInt16 *sself, struct CompactFheInt16 **result);

int compact_fhe_int16_deserialize(DynamicBufferView buffer_view, struct CompactFheInt16 **result);

/**
 *ptr can be null (no-op in that case)
 */
int compact_fhe_int16_destroy(struct CompactFheInt16 *ptr);

int compact_fhe_int16_expand(const struct CompactFheInt16 *sself, struct FheInt16 **output);

int compact_fhe_int16_list_clone(const struct CompactFheInt16List *sself,
                                 struct CompactFheInt16List **result);

int compact_fhe_int16_list_deserialize(DynamicBufferView buffer_view,
                                       struct CompactFheInt16List **result);

/**
 *ptr can be null (no-op in that case)
 */
int compact_fhe_int16_list_destroy(struct CompactFheInt16List *ptr);

int compact_fhe_int16_list_expand(const struct CompactFheInt16List *sself,
                                  struct FheInt16 **output,
                                  size_t output_len);

int compact_fhe_int16_list_len(const struct CompactFheInt16List *sself, size_t *result);

/**
 * Deserializes a list safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `exact_len`: exact lenght/size/number of element the list must have
 *    (not less nor more, otherwise, it's considered an error)
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compact_fhe_int16_list_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                       uint64_t serialized_size_limit,
                                                       const struct ServerKey *server_key,
                                                       size_t exact_len,
                                                       struct CompactFheInt16List **result);

int compact_fhe_int16_list_safe_serialize(const struct CompactFheInt16List *sself,
                                          DynamicBuffer *result,
                                          uint64_t serialized_size_limit);

int compact_fhe_int16_list_serialize(const struct CompactFheInt16List *sself,
                                     DynamicBuffer *result);

int compact_fhe_int16_list_try_encrypt_with_compact_public_key_i16(const int16_t *input,
                                                                   size_t input_len,
                                                                   const struct CompactPublicKey *public_key,
                                                                   struct CompactFheInt16List **result);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compact_fhe_int16_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                  uint64_t serialized_size_limit,
                                                  const struct ServerKey *server_key,
                                                  struct CompactFheInt16 **result);

int compact_fhe_int16_safe_serialize(const struct CompactFheInt16 *sself,
                                     DynamicBuffer *result,
                                     uint64_t serialized_size_limit);

int compact_fhe_int16_serialize(const struct CompactFheInt16 *sself, DynamicBuffer *result);

int compact_fhe_int16_try_encrypt_with_compact_public_key_i16(int16_t value,
                                                              const struct CompactPublicKey *public_key,
                                                              struct CompactFheInt16 **result);

int compact_fhe_int256_clone(const struct CompactFheInt256 *sself,
                             struct CompactFheInt256 **result);

int compact_fhe_int256_deserialize(DynamicBufferView buffer_view, struct CompactFheInt256 **result);

/**
 *ptr can be null (no-op in that case)
 */
int compact_fhe_int256_destroy(struct CompactFheInt256 *ptr);

int compact_fhe_int256_expand(const struct CompactFheInt256 *sself, struct FheInt256 **output);

int compact_fhe_int256_list_clone(const struct CompactFheInt256List *sself,
                                  struct CompactFheInt256List **result);

int compact_fhe_int256_list_deserialize(DynamicBufferView buffer_view,
                                        struct CompactFheInt256List **result);

/**
 *ptr can be null (no-op in that case)
 */
int compact_fhe_int256_list_destroy(struct CompactFheInt256List *ptr);

int compact_fhe_int256_list_expand(const struct CompactFheInt256List *sself,
                                   struct FheInt256 **output,
                                   size_t output_len);

int compact_fhe_int256_list_len(const struct CompactFheInt256List *sself, size_t *result);

/**
 * Deserializes a list safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `exact_len`: exact lenght/size/number of element the list must have
 *    (not less nor more, otherwise, it's considered an error)
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compact_fhe_int256_list_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                        uint64_t serialized_size_limit,
                                                        const struct ServerKey *server_key,
                                                        size_t exact_len,
                                                        struct CompactFheInt256List **result);

int compact_fhe_int256_list_safe_serialize(const struct CompactFheInt256List *sself,
                                           DynamicBuffer *result,
                                           uint64_t serialized_size_limit);

int compact_fhe_int256_list_serialize(const struct CompactFheInt256List *sself,
                                      DynamicBuffer *result);

int compact_fhe_int256_list_try_encrypt_with_compact_public_key_i256(const struct I256 *input,
                                                                     size_t input_len,
                                                                     const struct CompactPublicKey *public_key,
                                                                     struct CompactFheInt256List **result);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compact_fhe_int256_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                   uint64_t serialized_size_limit,
                                                   const struct ServerKey *server_key,
                                                   struct CompactFheInt256 **result);

int compact_fhe_int256_safe_serialize(const struct CompactFheInt256 *sself,
                                      DynamicBuffer *result,
                                      uint64_t serialized_size_limit);

int compact_fhe_int256_serialize(const struct CompactFheInt256 *sself, DynamicBuffer *result);

int compact_fhe_int256_try_encrypt_with_compact_public_key_i256(struct I256 value,
                                                                const struct CompactPublicKey *public_key,
                                                                struct CompactFheInt256 **result);

int compact_fhe_int2_clone(const struct CompactFheInt2 *sself, struct CompactFheInt2 **result);

int compact_fhe_int2_deserialize(DynamicBufferView buffer_view, struct CompactFheInt2 **result);

/**
 *ptr can be null (no-op in that case)
 */
int compact_fhe_int2_destroy(struct CompactFheInt2 *ptr);

int compact_fhe_int2_expand(const struct CompactFheInt2 *sself, struct FheInt2 **output);

int compact_fhe_int2_list_clone(const struct CompactFheInt2List *sself,
                                struct CompactFheInt2List **result);

int compact_fhe_int2_list_deserialize(DynamicBufferView buffer_view,
                                      struct CompactFheInt2List **result);

/**
 *ptr can be null (no-op in that case)
 */
int compact_fhe_int2_list_destroy(struct CompactFheInt2List *ptr);

int compact_fhe_int2_list_expand(const struct CompactFheInt2List *sself,
                                 struct FheInt2 **output,
                                 size_t output_len);

int compact_fhe_int2_list_len(const struct CompactFheInt2List *sself, size_t *result);

/**
 * Deserializes a list safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `exact_len`: exact lenght/size/number of element the list must have
 *    (not less nor more, otherwise, it's considered an error)
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compact_fhe_int2_list_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                      uint64_t serialized_size_limit,
                                                      const struct ServerKey *server_key,
                                                      size_t exact_len,
                                                      struct CompactFheInt2List **result);

int compact_fhe_int2_list_safe_serialize(const struct CompactFheInt2List *sself,
                                         DynamicBuffer *result,
                                         uint64_t serialized_size_limit);

int compact_fhe_int2_list_serialize(const struct CompactFheInt2List *sself, DynamicBuffer *result);

int compact_fhe_int2_list_try_encrypt_with_compact_public_key_i8(const int8_t *input,
                                                                 size_t input_len,
                                                                 const struct CompactPublicKey *public_key,
                                                                 struct CompactFheInt2List **result);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compact_fhe_int2_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                 uint64_t serialized_size_limit,
                                                 const struct ServerKey *server_key,
                                                 struct CompactFheInt2 **result);

int compact_fhe_int2_safe_serialize(const struct CompactFheInt2 *sself,
                                    DynamicBuffer *result,
                                    uint64_t serialized_size_limit);

int compact_fhe_int2_serialize(const struct CompactFheInt2 *sself, DynamicBuffer *result);

int compact_fhe_int2_try_encrypt_with_compact_public_key_i8(int8_t value,
                                                            const struct CompactPublicKey *public_key,
                                                            struct CompactFheInt2 **result);

int compact_fhe_int32_clone(const struct CompactFheInt32 *sself, struct CompactFheInt32 **result);

int compact_fhe_int32_deserialize(DynamicBufferView buffer_view, struct CompactFheInt32 **result);

/**
 *ptr can be null (no-op in that case)
 */
int compact_fhe_int32_destroy(struct CompactFheInt32 *ptr);

int compact_fhe_int32_expand(const struct CompactFheInt32 *sself, struct FheInt32 **output);

int compact_fhe_int32_list_clone(const struct CompactFheInt32List *sself,
                                 struct CompactFheInt32List **result);

int compact_fhe_int32_list_deserialize(DynamicBufferView buffer_view,
                                       struct CompactFheInt32List **result);

/**
 *ptr can be null (no-op in that case)
 */
int compact_fhe_int32_list_destroy(struct CompactFheInt32List *ptr);

int compact_fhe_int32_list_expand(const struct CompactFheInt32List *sself,
                                  struct FheInt32 **output,
                                  size_t output_len);

int compact_fhe_int32_list_len(const struct CompactFheInt32List *sself, size_t *result);

/**
 * Deserializes a list safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `exact_len`: exact lenght/size/number of element the list must have
 *    (not less nor more, otherwise, it's considered an error)
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compact_fhe_int32_list_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                       uint64_t serialized_size_limit,
                                                       const struct ServerKey *server_key,
                                                       size_t exact_len,
                                                       struct CompactFheInt32List **result);

int compact_fhe_int32_list_safe_serialize(const struct CompactFheInt32List *sself,
                                          DynamicBuffer *result,
                                          uint64_t serialized_size_limit);

int compact_fhe_int32_list_serialize(const struct CompactFheInt32List *sself,
                                     DynamicBuffer *result);

int compact_fhe_int32_list_try_encrypt_with_compact_public_key_i32(const int32_t *input,
                                                                   size_t input_len,
                                                                   const struct CompactPublicKey *public_key,
                                                                   struct CompactFheInt32List **result);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compact_fhe_int32_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                  uint64_t serialized_size_limit,
                                                  const struct ServerKey *server_key,
                                                  struct CompactFheInt32 **result);

int compact_fhe_int32_safe_serialize(const struct CompactFheInt32 *sself,
                                     DynamicBuffer *result,
                                     uint64_t serialized_size_limit);

int compact_fhe_int32_serialize(const struct CompactFheInt32 *sself, DynamicBuffer *result);

int compact_fhe_int32_try_encrypt_with_compact_public_key_i32(int32_t value,
                                                              const struct CompactPublicKey *public_key,
                                                              struct CompactFheInt32 **result);

int compact_fhe_int4_clone(const struct CompactFheInt4 *sself, struct CompactFheInt4 **result);

int compact_fhe_int4_deserialize(DynamicBufferView buffer_view, struct CompactFheInt4 **result);

/**
 *ptr can be null (no-op in that case)
 */
int compact_fhe_int4_destroy(struct CompactFheInt4 *ptr);

int compact_fhe_int4_expand(const struct CompactFheInt4 *sself, struct FheInt4 **output);

int compact_fhe_int4_list_clone(const struct CompactFheInt4List *sself,
                                struct CompactFheInt4List **result);

int compact_fhe_int4_list_deserialize(DynamicBufferView buffer_view,
                                      struct CompactFheInt4List **result);

/**
 *ptr can be null (no-op in that case)
 */
int compact_fhe_int4_list_destroy(struct CompactFheInt4List *ptr);

int compact_fhe_int4_list_expand(const struct CompactFheInt4List *sself,
                                 struct FheInt4 **output,
                                 size_t output_len);

int compact_fhe_int4_list_len(const struct CompactFheInt4List *sself, size_t *result);

/**
 * Deserializes a list safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `exact_len`: exact lenght/size/number of element the list must have
 *    (not less nor more, otherwise, it's considered an error)
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compact_fhe_int4_list_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                      uint64_t serialized_size_limit,
                                                      const struct ServerKey *server_key,
                                                      size_t exact_len,
                                                      struct CompactFheInt4List **result);

int compact_fhe_int4_list_safe_serialize(const struct CompactFheInt4List *sself,
                                         DynamicBuffer *result,
                                         uint64_t serialized_size_limit);

int compact_fhe_int4_list_serialize(const struct CompactFheInt4List *sself, DynamicBuffer *result);

int compact_fhe_int4_list_try_encrypt_with_compact_public_key_i8(const int8_t *input,
                                                                 size_t input_len,
                                                                 const struct CompactPublicKey *public_key,
                                                                 struct CompactFheInt4List **result);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compact_fhe_int4_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                 uint64_t serialized_size_limit,
                                                 const struct ServerKey *server_key,
                                                 struct CompactFheInt4 **result);

int compact_fhe_int4_safe_serialize(const struct CompactFheInt4 *sself,
                                    DynamicBuffer *result,
                                    uint64_t serialized_size_limit);

int compact_fhe_int4_serialize(const struct CompactFheInt4 *sself, DynamicBuffer *result);

int compact_fhe_int4_try_encrypt_with_compact_public_key_i8(int8_t value,
                                                            const struct CompactPublicKey *public_key,
                                                            struct CompactFheInt4 **result);

int compact_fhe_int64_clone(const struct CompactFheInt64 *sself, struct CompactFheInt64 **result);

int compact_fhe_int64_deserialize(DynamicBufferView buffer_view, struct CompactFheInt64 **result);

/**
 *ptr can be null (no-op in that case)
 */
int compact_fhe_int64_destroy(struct CompactFheInt64 *ptr);

int compact_fhe_int64_expand(const struct CompactFheInt64 *sself, struct FheInt64 **output);

int compact_fhe_int64_list_clone(const struct CompactFheInt64List *sself,
                                 struct CompactFheInt64List **result);

int compact_fhe_int64_list_deserialize(DynamicBufferView buffer_view,
                                       struct CompactFheInt64List **result);

/**
 *ptr can be null (no-op in that case)
 */
int compact_fhe_int64_list_destroy(struct CompactFheInt64List *ptr);

int compact_fhe_int64_list_expand(const struct CompactFheInt64List *sself,
                                  struct FheInt64 **output,
                                  size_t output_len);

int compact_fhe_int64_list_len(const struct CompactFheInt64List *sself, size_t *result);

/**
 * Deserializes a list safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `exact_len`: exact lenght/size/number of element the list must have
 *    (not less nor more, otherwise, it's considered an error)
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compact_fhe_int64_list_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                       uint64_t serialized_size_limit,
                                                       const struct ServerKey *server_key,
                                                       size_t exact_len,
                                                       struct CompactFheInt64List **result);

int compact_fhe_int64_list_safe_serialize(const struct CompactFheInt64List *sself,
                                          DynamicBuffer *result,
                                          uint64_t serialized_size_limit);

int compact_fhe_int64_list_serialize(const struct CompactFheInt64List *sself,
                                     DynamicBuffer *result);

int compact_fhe_int64_list_try_encrypt_with_compact_public_key_i64(const int64_t *input,
                                                                   size_t input_len,
                                                                   const struct CompactPublicKey *public_key,
                                                                   struct CompactFheInt64List **result);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compact_fhe_int64_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                  uint64_t serialized_size_limit,
                                                  const struct ServerKey *server_key,
                                                  struct CompactFheInt64 **result);

int compact_fhe_int64_safe_serialize(const struct CompactFheInt64 *sself,
                                     DynamicBuffer *result,
                                     uint64_t serialized_size_limit);

int compact_fhe_int64_serialize(const struct CompactFheInt64 *sself, DynamicBuffer *result);

int compact_fhe_int64_try_encrypt_with_compact_public_key_i64(int64_t value,
                                                              const struct CompactPublicKey *public_key,
                                                              struct CompactFheInt64 **result);

int compact_fhe_int6_clone(const struct CompactFheInt6 *sself, struct CompactFheInt6 **result);

int compact_fhe_int6_deserialize(DynamicBufferView buffer_view, struct CompactFheInt6 **result);

/**
 *ptr can be null (no-op in that case)
 */
int compact_fhe_int6_destroy(struct CompactFheInt6 *ptr);

int compact_fhe_int6_expand(const struct CompactFheInt6 *sself, struct FheInt6 **output);

int compact_fhe_int6_list_clone(const struct CompactFheInt6List *sself,
                                struct CompactFheInt6List **result);

int compact_fhe_int6_list_deserialize(DynamicBufferView buffer_view,
                                      struct CompactFheInt6List **result);

/**
 *ptr can be null (no-op in that case)
 */
int compact_fhe_int6_list_destroy(struct CompactFheInt6List *ptr);

int compact_fhe_int6_list_expand(const struct CompactFheInt6List *sself,
                                 struct FheInt6 **output,
                                 size_t output_len);

int compact_fhe_int6_list_len(const struct CompactFheInt6List *sself, size_t *result);

/**
 * Deserializes a list safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `exact_len`: exact lenght/size/number of element the list must have
 *    (not less nor more, otherwise, it's considered an error)
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compact_fhe_int6_list_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                      uint64_t serialized_size_limit,
                                                      const struct ServerKey *server_key,
                                                      size_t exact_len,
                                                      struct CompactFheInt6List **result);

int compact_fhe_int6_list_safe_serialize(const struct CompactFheInt6List *sself,
                                         DynamicBuffer *result,
                                         uint64_t serialized_size_limit);

int compact_fhe_int6_list_serialize(const struct CompactFheInt6List *sself, DynamicBuffer *result);

int compact_fhe_int6_list_try_encrypt_with_compact_public_key_i8(const int8_t *input,
                                                                 size_t input_len,
                                                                 const struct CompactPublicKey *public_key,
                                                                 struct CompactFheInt6List **result);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compact_fhe_int6_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                 uint64_t serialized_size_limit,
                                                 const struct ServerKey *server_key,
                                                 struct CompactFheInt6 **result);

int compact_fhe_int6_safe_serialize(const struct CompactFheInt6 *sself,
                                    DynamicBuffer *result,
                                    uint64_t serialized_size_limit);

int compact_fhe_int6_serialize(const struct CompactFheInt6 *sself, DynamicBuffer *result);

int compact_fhe_int6_try_encrypt_with_compact_public_key_i8(int8_t value,
                                                            const struct CompactPublicKey *public_key,
                                                            struct CompactFheInt6 **result);

int compact_fhe_int8_clone(const struct CompactFheInt8 *sself, struct CompactFheInt8 **result);

int compact_fhe_int8_deserialize(DynamicBufferView buffer_view, struct CompactFheInt8 **result);

/**
 *ptr can be null (no-op in that case)
 */
int compact_fhe_int8_destroy(struct CompactFheInt8 *ptr);

int compact_fhe_int8_expand(const struct CompactFheInt8 *sself, struct FheInt8 **output);

int compact_fhe_int8_list_clone(const struct CompactFheInt8List *sself,
                                struct CompactFheInt8List **result);

int compact_fhe_int8_list_deserialize(DynamicBufferView buffer_view,
                                      struct CompactFheInt8List **result);

/**
 *ptr can be null (no-op in that case)
 */
int compact_fhe_int8_list_destroy(struct CompactFheInt8List *ptr);

int compact_fhe_int8_list_expand(const struct CompactFheInt8List *sself,
                                 struct FheInt8 **output,
                                 size_t output_len);

int compact_fhe_int8_list_len(const struct CompactFheInt8List *sself, size_t *result);

/**
 * Deserializes a list safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `exact_len`: exact lenght/size/number of element the list must have
 *    (not less nor more, otherwise, it's considered an error)
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compact_fhe_int8_list_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                      uint64_t serialized_size_limit,
                                                      const struct ServerKey *server_key,
                                                      size_t exact_len,
                                                      struct CompactFheInt8List **result);

int compact_fhe_int8_list_safe_serialize(const struct CompactFheInt8List *sself,
                                         DynamicBuffer *result,
                                         uint64_t serialized_size_limit);

int compact_fhe_int8_list_serialize(const struct CompactFheInt8List *sself, DynamicBuffer *result);

int compact_fhe_int8_list_try_encrypt_with_compact_public_key_i8(const int8_t *input,
                                                                 size_t input_len,
                                                                 const struct CompactPublicKey *public_key,
                                                                 struct CompactFheInt8List **result);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compact_fhe_int8_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                 uint64_t serialized_size_limit,
                                                 const struct ServerKey *server_key,
                                                 struct CompactFheInt8 **result);

int compact_fhe_int8_safe_serialize(const struct CompactFheInt8 *sself,
                                    DynamicBuffer *result,
                                    uint64_t serialized_size_limit);

int compact_fhe_int8_serialize(const struct CompactFheInt8 *sself, DynamicBuffer *result);

int compact_fhe_int8_try_encrypt_with_compact_public_key_i8(int8_t value,
                                                            const struct CompactPublicKey *public_key,
                                                            struct CompactFheInt8 **result);

int compact_fhe_uint10_clone(const struct CompactFheUint10 *sself,
                             struct CompactFheUint10 **result);

int compact_fhe_uint10_deserialize(DynamicBufferView buffer_view, struct CompactFheUint10 **result);

/**
 *ptr can be null (no-op in that case)
 */
int compact_fhe_uint10_destroy(struct CompactFheUint10 *ptr);

int compact_fhe_uint10_expand(const struct CompactFheUint10 *sself, struct FheUint10 **output);

int compact_fhe_uint10_list_clone(const struct CompactFheUint10List *sself,
                                  struct CompactFheUint10List **result);

int compact_fhe_uint10_list_deserialize(DynamicBufferView buffer_view,
                                        struct CompactFheUint10List **result);

/**
 *ptr can be null (no-op in that case)
 */
int compact_fhe_uint10_list_destroy(struct CompactFheUint10List *ptr);

int compact_fhe_uint10_list_expand(const struct CompactFheUint10List *sself,
                                   struct FheUint10 **output,
                                   size_t output_len);

int compact_fhe_uint10_list_len(const struct CompactFheUint10List *sself, size_t *result);

/**
 * Deserializes a list safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `exact_len`: exact lenght/size/number of element the list must have
 *    (not less nor more, otherwise, it's considered an error)
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compact_fhe_uint10_list_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                        uint64_t serialized_size_limit,
                                                        const struct ServerKey *server_key,
                                                        size_t exact_len,
                                                        struct CompactFheUint10List **result);

int compact_fhe_uint10_list_safe_serialize(const struct CompactFheUint10List *sself,
                                           DynamicBuffer *result,
                                           uint64_t serialized_size_limit);

int compact_fhe_uint10_list_serialize(const struct CompactFheUint10List *sself,
                                      DynamicBuffer *result);

int compact_fhe_uint10_list_try_encrypt_with_compact_public_key_u16(const uint16_t *input,
                                                                    size_t input_len,
                                                                    const struct CompactPublicKey *public_key,
                                                                    struct CompactFheUint10List **result);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compact_fhe_uint10_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                   uint64_t serialized_size_limit,
                                                   const struct ServerKey *server_key,
                                                   struct CompactFheUint10 **result);

int compact_fhe_uint10_safe_serialize(const struct CompactFheUint10 *sself,
                                      DynamicBuffer *result,
                                      uint64_t serialized_size_limit);

int compact_fhe_uint10_serialize(const struct CompactFheUint10 *sself, DynamicBuffer *result);

int compact_fhe_uint10_try_encrypt_with_compact_public_key_u16(uint16_t value,
                                                               const struct CompactPublicKey *public_key,
                                                               struct CompactFheUint10 **result);

int compact_fhe_uint128_clone(const struct CompactFheUint128 *sself,
                              struct CompactFheUint128 **result);

int compact_fhe_uint128_deserialize(DynamicBufferView buffer_view,
                                    struct CompactFheUint128 **result);

/**
 *ptr can be null (no-op in that case)
 */
int compact_fhe_uint128_destroy(struct CompactFheUint128 *ptr);

int compact_fhe_uint128_expand(const struct CompactFheUint128 *sself, struct FheUint128 **output);

int compact_fhe_uint128_list_clone(const struct CompactFheUint128List *sself,
                                   struct CompactFheUint128List **result);

int compact_fhe_uint128_list_deserialize(DynamicBufferView buffer_view,
                                         struct CompactFheUint128List **result);

/**
 *ptr can be null (no-op in that case)
 */
int compact_fhe_uint128_list_destroy(struct CompactFheUint128List *ptr);

int compact_fhe_uint128_list_expand(const struct CompactFheUint128List *sself,
                                    struct FheUint128 **output,
                                    size_t output_len);

int compact_fhe_uint128_list_len(const struct CompactFheUint128List *sself, size_t *result);

/**
 * Deserializes a list safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `exact_len`: exact lenght/size/number of element the list must have
 *    (not less nor more, otherwise, it's considered an error)
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compact_fhe_uint128_list_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                         uint64_t serialized_size_limit,
                                                         const struct ServerKey *server_key,
                                                         size_t exact_len,
                                                         struct CompactFheUint128List **result);

int compact_fhe_uint128_list_safe_serialize(const struct CompactFheUint128List *sself,
                                            DynamicBuffer *result,
                                            uint64_t serialized_size_limit);

int compact_fhe_uint128_list_serialize(const struct CompactFheUint128List *sself,
                                       DynamicBuffer *result);

int compact_fhe_uint128_list_try_encrypt_with_compact_public_key_u128(const struct U128 *input,
                                                                      size_t input_len,
                                                                      const struct CompactPublicKey *public_key,
                                                                      struct CompactFheUint128List **result);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compact_fhe_uint128_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                    uint64_t serialized_size_limit,
                                                    const struct ServerKey *server_key,
                                                    struct CompactFheUint128 **result);

int compact_fhe_uint128_safe_serialize(const struct CompactFheUint128 *sself,
                                       DynamicBuffer *result,
                                       uint64_t serialized_size_limit);

int compact_fhe_uint128_serialize(const struct CompactFheUint128 *sself, DynamicBuffer *result);

int compact_fhe_uint128_try_encrypt_with_compact_public_key_u128(struct U128 value,
                                                                 const struct CompactPublicKey *public_key,
                                                                 struct CompactFheUint128 **result);

int compact_fhe_uint12_clone(const struct CompactFheUint12 *sself,
                             struct CompactFheUint12 **result);

int compact_fhe_uint12_deserialize(DynamicBufferView buffer_view, struct CompactFheUint12 **result);

/**
 *ptr can be null (no-op in that case)
 */
int compact_fhe_uint12_destroy(struct CompactFheUint12 *ptr);

int compact_fhe_uint12_expand(const struct CompactFheUint12 *sself, struct FheUint12 **output);

int compact_fhe_uint12_list_clone(const struct CompactFheUint12List *sself,
                                  struct CompactFheUint12List **result);

int compact_fhe_uint12_list_deserialize(DynamicBufferView buffer_view,
                                        struct CompactFheUint12List **result);

/**
 *ptr can be null (no-op in that case)
 */
int compact_fhe_uint12_list_destroy(struct CompactFheUint12List *ptr);

int compact_fhe_uint12_list_expand(const struct CompactFheUint12List *sself,
                                   struct FheUint12 **output,
                                   size_t output_len);

int compact_fhe_uint12_list_len(const struct CompactFheUint12List *sself, size_t *result);

/**
 * Deserializes a list safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `exact_len`: exact lenght/size/number of element the list must have
 *    (not less nor more, otherwise, it's considered an error)
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compact_fhe_uint12_list_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                        uint64_t serialized_size_limit,
                                                        const struct ServerKey *server_key,
                                                        size_t exact_len,
                                                        struct CompactFheUint12List **result);

int compact_fhe_uint12_list_safe_serialize(const struct CompactFheUint12List *sself,
                                           DynamicBuffer *result,
                                           uint64_t serialized_size_limit);

int compact_fhe_uint12_list_serialize(const struct CompactFheUint12List *sself,
                                      DynamicBuffer *result);

int compact_fhe_uint12_list_try_encrypt_with_compact_public_key_u16(const uint16_t *input,
                                                                    size_t input_len,
                                                                    const struct CompactPublicKey *public_key,
                                                                    struct CompactFheUint12List **result);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compact_fhe_uint12_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                   uint64_t serialized_size_limit,
                                                   const struct ServerKey *server_key,
                                                   struct CompactFheUint12 **result);

int compact_fhe_uint12_safe_serialize(const struct CompactFheUint12 *sself,
                                      DynamicBuffer *result,
                                      uint64_t serialized_size_limit);

int compact_fhe_uint12_serialize(const struct CompactFheUint12 *sself, DynamicBuffer *result);

int compact_fhe_uint12_try_encrypt_with_compact_public_key_u16(uint16_t value,
                                                               const struct CompactPublicKey *public_key,
                                                               struct CompactFheUint12 **result);

int compact_fhe_uint14_clone(const struct CompactFheUint14 *sself,
                             struct CompactFheUint14 **result);

int compact_fhe_uint14_deserialize(DynamicBufferView buffer_view, struct CompactFheUint14 **result);

/**
 *ptr can be null (no-op in that case)
 */
int compact_fhe_uint14_destroy(struct CompactFheUint14 *ptr);

int compact_fhe_uint14_expand(const struct CompactFheUint14 *sself, struct FheUint14 **output);

int compact_fhe_uint14_list_clone(const struct CompactFheUint14List *sself,
                                  struct CompactFheUint14List **result);

int compact_fhe_uint14_list_deserialize(DynamicBufferView buffer_view,
                                        struct CompactFheUint14List **result);

/**
 *ptr can be null (no-op in that case)
 */
int compact_fhe_uint14_list_destroy(struct CompactFheUint14List *ptr);

int compact_fhe_uint14_list_expand(const struct CompactFheUint14List *sself,
                                   struct FheUint14 **output,
                                   size_t output_len);

int compact_fhe_uint14_list_len(const struct CompactFheUint14List *sself, size_t *result);

/**
 * Deserializes a list safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `exact_len`: exact lenght/size/number of element the list must have
 *    (not less nor more, otherwise, it's considered an error)
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compact_fhe_uint14_list_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                        uint64_t serialized_size_limit,
                                                        const struct ServerKey *server_key,
                                                        size_t exact_len,
                                                        struct CompactFheUint14List **result);

int compact_fhe_uint14_list_safe_serialize(const struct CompactFheUint14List *sself,
                                           DynamicBuffer *result,
                                           uint64_t serialized_size_limit);

int compact_fhe_uint14_list_serialize(const struct CompactFheUint14List *sself,
                                      DynamicBuffer *result);

int compact_fhe_uint14_list_try_encrypt_with_compact_public_key_u16(const uint16_t *input,
                                                                    size_t input_len,
                                                                    const struct CompactPublicKey *public_key,
                                                                    struct CompactFheUint14List **result);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compact_fhe_uint14_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                   uint64_t serialized_size_limit,
                                                   const struct ServerKey *server_key,
                                                   struct CompactFheUint14 **result);

int compact_fhe_uint14_safe_serialize(const struct CompactFheUint14 *sself,
                                      DynamicBuffer *result,
                                      uint64_t serialized_size_limit);

int compact_fhe_uint14_serialize(const struct CompactFheUint14 *sself, DynamicBuffer *result);

int compact_fhe_uint14_try_encrypt_with_compact_public_key_u16(uint16_t value,
                                                               const struct CompactPublicKey *public_key,
                                                               struct CompactFheUint14 **result);

int compact_fhe_uint160_clone(const struct CompactFheUint160 *sself,
                              struct CompactFheUint160 **result);

int compact_fhe_uint160_deserialize(DynamicBufferView buffer_view,
                                    struct CompactFheUint160 **result);

/**
 *ptr can be null (no-op in that case)
 */
int compact_fhe_uint160_destroy(struct CompactFheUint160 *ptr);

int compact_fhe_uint160_expand(const struct CompactFheUint160 *sself, struct FheUint160 **output);

int compact_fhe_uint160_list_clone(const struct CompactFheUint160List *sself,
                                   struct CompactFheUint160List **result);

int compact_fhe_uint160_list_deserialize(DynamicBufferView buffer_view,
                                         struct CompactFheUint160List **result);

/**
 *ptr can be null (no-op in that case)
 */
int compact_fhe_uint160_list_destroy(struct CompactFheUint160List *ptr);

int compact_fhe_uint160_list_expand(const struct CompactFheUint160List *sself,
                                    struct FheUint160 **output,
                                    size_t output_len);

int compact_fhe_uint160_list_len(const struct CompactFheUint160List *sself, size_t *result);

/**
 * Deserializes a list safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `exact_len`: exact lenght/size/number of element the list must have
 *    (not less nor more, otherwise, it's considered an error)
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compact_fhe_uint160_list_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                         uint64_t serialized_size_limit,
                                                         const struct ServerKey *server_key,
                                                         size_t exact_len,
                                                         struct CompactFheUint160List **result);

int compact_fhe_uint160_list_safe_serialize(const struct CompactFheUint160List *sself,
                                            DynamicBuffer *result,
                                            uint64_t serialized_size_limit);

int compact_fhe_uint160_list_serialize(const struct CompactFheUint160List *sself,
                                       DynamicBuffer *result);

int compact_fhe_uint160_list_try_encrypt_with_compact_public_key_u256(const struct U256 *input,
                                                                      size_t input_len,
                                                                      const struct CompactPublicKey *public_key,
                                                                      struct CompactFheUint160List **result);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compact_fhe_uint160_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                    uint64_t serialized_size_limit,
                                                    const struct ServerKey *server_key,
                                                    struct CompactFheUint160 **result);

int compact_fhe_uint160_safe_serialize(const struct CompactFheUint160 *sself,
                                       DynamicBuffer *result,
                                       uint64_t serialized_size_limit);

int compact_fhe_uint160_serialize(const struct CompactFheUint160 *sself, DynamicBuffer *result);

int compact_fhe_uint160_try_encrypt_with_compact_public_key_u256(struct U256 value,
                                                                 const struct CompactPublicKey *public_key,
                                                                 struct CompactFheUint160 **result);

int compact_fhe_uint16_clone(const struct CompactFheUint16 *sself,
                             struct CompactFheUint16 **result);

int compact_fhe_uint16_deserialize(DynamicBufferView buffer_view, struct CompactFheUint16 **result);

/**
 *ptr can be null (no-op in that case)
 */
int compact_fhe_uint16_destroy(struct CompactFheUint16 *ptr);

int compact_fhe_uint16_expand(const struct CompactFheUint16 *sself, struct FheUint16 **output);

int compact_fhe_uint16_list_clone(const struct CompactFheUint16List *sself,
                                  struct CompactFheUint16List **result);

int compact_fhe_uint16_list_deserialize(DynamicBufferView buffer_view,
                                        struct CompactFheUint16List **result);

/**
 *ptr can be null (no-op in that case)
 */
int compact_fhe_uint16_list_destroy(struct CompactFheUint16List *ptr);

int compact_fhe_uint16_list_expand(const struct CompactFheUint16List *sself,
                                   struct FheUint16 **output,
                                   size_t output_len);

int compact_fhe_uint16_list_len(const struct CompactFheUint16List *sself, size_t *result);

/**
 * Deserializes a list safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `exact_len`: exact lenght/size/number of element the list must have
 *    (not less nor more, otherwise, it's considered an error)
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compact_fhe_uint16_list_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                        uint64_t serialized_size_limit,
                                                        const struct ServerKey *server_key,
                                                        size_t exact_len,
                                                        struct CompactFheUint16List **result);

int compact_fhe_uint16_list_safe_serialize(const struct CompactFheUint16List *sself,
                                           DynamicBuffer *result,
                                           uint64_t serialized_size_limit);

int compact_fhe_uint16_list_serialize(const struct CompactFheUint16List *sself,
                                      DynamicBuffer *result);

int compact_fhe_uint16_list_try_encrypt_with_compact_public_key_u16(const uint16_t *input,
                                                                    size_t input_len,
                                                                    const struct CompactPublicKey *public_key,
                                                                    struct CompactFheUint16List **result);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compact_fhe_uint16_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                   uint64_t serialized_size_limit,
                                                   const struct ServerKey *server_key,
                                                   struct CompactFheUint16 **result);

int compact_fhe_uint16_safe_serialize(const struct CompactFheUint16 *sself,
                                      DynamicBuffer *result,
                                      uint64_t serialized_size_limit);

int compact_fhe_uint16_serialize(const struct CompactFheUint16 *sself, DynamicBuffer *result);

int compact_fhe_uint16_try_encrypt_with_compact_public_key_u16(uint16_t value,
                                                               const struct CompactPublicKey *public_key,
                                                               struct CompactFheUint16 **result);

int compact_fhe_uint256_clone(const struct CompactFheUint256 *sself,
                              struct CompactFheUint256 **result);

int compact_fhe_uint256_deserialize(DynamicBufferView buffer_view,
                                    struct CompactFheUint256 **result);

/**
 *ptr can be null (no-op in that case)
 */
int compact_fhe_uint256_destroy(struct CompactFheUint256 *ptr);

int compact_fhe_uint256_expand(const struct CompactFheUint256 *sself, struct FheUint256 **output);

int compact_fhe_uint256_list_clone(const struct CompactFheUint256List *sself,
                                   struct CompactFheUint256List **result);

int compact_fhe_uint256_list_deserialize(DynamicBufferView buffer_view,
                                         struct CompactFheUint256List **result);

/**
 *ptr can be null (no-op in that case)
 */
int compact_fhe_uint256_list_destroy(struct CompactFheUint256List *ptr);

int compact_fhe_uint256_list_expand(const struct CompactFheUint256List *sself,
                                    struct FheUint256 **output,
                                    size_t output_len);

int compact_fhe_uint256_list_len(const struct CompactFheUint256List *sself, size_t *result);

/**
 * Deserializes a list safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `exact_len`: exact lenght/size/number of element the list must have
 *    (not less nor more, otherwise, it's considered an error)
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compact_fhe_uint256_list_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                         uint64_t serialized_size_limit,
                                                         const struct ServerKey *server_key,
                                                         size_t exact_len,
                                                         struct CompactFheUint256List **result);

int compact_fhe_uint256_list_safe_serialize(const struct CompactFheUint256List *sself,
                                            DynamicBuffer *result,
                                            uint64_t serialized_size_limit);

int compact_fhe_uint256_list_serialize(const struct CompactFheUint256List *sself,
                                       DynamicBuffer *result);

int compact_fhe_uint256_list_try_encrypt_with_compact_public_key_u256(const struct U256 *input,
                                                                      size_t input_len,
                                                                      const struct CompactPublicKey *public_key,
                                                                      struct CompactFheUint256List **result);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compact_fhe_uint256_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                    uint64_t serialized_size_limit,
                                                    const struct ServerKey *server_key,
                                                    struct CompactFheUint256 **result);

int compact_fhe_uint256_safe_serialize(const struct CompactFheUint256 *sself,
                                       DynamicBuffer *result,
                                       uint64_t serialized_size_limit);

int compact_fhe_uint256_serialize(const struct CompactFheUint256 *sself, DynamicBuffer *result);

int compact_fhe_uint256_try_encrypt_with_compact_public_key_u256(struct U256 value,
                                                                 const struct CompactPublicKey *public_key,
                                                                 struct CompactFheUint256 **result);

int compact_fhe_uint2_clone(const struct CompactFheUint2 *sself, struct CompactFheUint2 **result);

int compact_fhe_uint2_deserialize(DynamicBufferView buffer_view, struct CompactFheUint2 **result);

/**
 *ptr can be null (no-op in that case)
 */
int compact_fhe_uint2_destroy(struct CompactFheUint2 *ptr);

int compact_fhe_uint2_expand(const struct CompactFheUint2 *sself, struct FheUint2 **output);

int compact_fhe_uint2_list_clone(const struct CompactFheUint2List *sself,
                                 struct CompactFheUint2List **result);

int compact_fhe_uint2_list_deserialize(DynamicBufferView buffer_view,
                                       struct CompactFheUint2List **result);

/**
 *ptr can be null (no-op in that case)
 */
int compact_fhe_uint2_list_destroy(struct CompactFheUint2List *ptr);

int compact_fhe_uint2_list_expand(const struct CompactFheUint2List *sself,
                                  struct FheUint2 **output,
                                  size_t output_len);

int compact_fhe_uint2_list_len(const struct CompactFheUint2List *sself, size_t *result);

/**
 * Deserializes a list safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `exact_len`: exact lenght/size/number of element the list must have
 *    (not less nor more, otherwise, it's considered an error)
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compact_fhe_uint2_list_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                       uint64_t serialized_size_limit,
                                                       const struct ServerKey *server_key,
                                                       size_t exact_len,
                                                       struct CompactFheUint2List **result);

int compact_fhe_uint2_list_safe_serialize(const struct CompactFheUint2List *sself,
                                          DynamicBuffer *result,
                                          uint64_t serialized_size_limit);

int compact_fhe_uint2_list_serialize(const struct CompactFheUint2List *sself,
                                     DynamicBuffer *result);

int compact_fhe_uint2_list_try_encrypt_with_compact_public_key_u8(const uint8_t *input,
                                                                  size_t input_len,
                                                                  const struct CompactPublicKey *public_key,
                                                                  struct CompactFheUint2List **result);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compact_fhe_uint2_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                  uint64_t serialized_size_limit,
                                                  const struct ServerKey *server_key,
                                                  struct CompactFheUint2 **result);

int compact_fhe_uint2_safe_serialize(const struct CompactFheUint2 *sself,
                                     DynamicBuffer *result,
                                     uint64_t serialized_size_limit);

int compact_fhe_uint2_serialize(const struct CompactFheUint2 *sself, DynamicBuffer *result);

int compact_fhe_uint2_try_encrypt_with_compact_public_key_u8(uint8_t value,
                                                             const struct CompactPublicKey *public_key,
                                                             struct CompactFheUint2 **result);

int compact_fhe_uint32_clone(const struct CompactFheUint32 *sself,
                             struct CompactFheUint32 **result);

int compact_fhe_uint32_deserialize(DynamicBufferView buffer_view, struct CompactFheUint32 **result);

/**
 *ptr can be null (no-op in that case)
 */
int compact_fhe_uint32_destroy(struct CompactFheUint32 *ptr);

int compact_fhe_uint32_expand(const struct CompactFheUint32 *sself, struct FheUint32 **output);

int compact_fhe_uint32_list_clone(const struct CompactFheUint32List *sself,
                                  struct CompactFheUint32List **result);

int compact_fhe_uint32_list_deserialize(DynamicBufferView buffer_view,
                                        struct CompactFheUint32List **result);

/**
 *ptr can be null (no-op in that case)
 */
int compact_fhe_uint32_list_destroy(struct CompactFheUint32List *ptr);

int compact_fhe_uint32_list_expand(const struct CompactFheUint32List *sself,
                                   struct FheUint32 **output,
                                   size_t output_len);

int compact_fhe_uint32_list_len(const struct CompactFheUint32List *sself, size_t *result);

/**
 * Deserializes a list safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `exact_len`: exact lenght/size/number of element the list must have
 *    (not less nor more, otherwise, it's considered an error)
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compact_fhe_uint32_list_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                        uint64_t serialized_size_limit,
                                                        const struct ServerKey *server_key,
                                                        size_t exact_len,
                                                        struct CompactFheUint32List **result);

int compact_fhe_uint32_list_safe_serialize(const struct CompactFheUint32List *sself,
                                           DynamicBuffer *result,
                                           uint64_t serialized_size_limit);

int compact_fhe_uint32_list_serialize(const struct CompactFheUint32List *sself,
                                      DynamicBuffer *result);

int compact_fhe_uint32_list_try_encrypt_with_compact_public_key_u32(const uint32_t *input,
                                                                    size_t input_len,
                                                                    const struct CompactPublicKey *public_key,
                                                                    struct CompactFheUint32List **result);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compact_fhe_uint32_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                   uint64_t serialized_size_limit,
                                                   const struct ServerKey *server_key,
                                                   struct CompactFheUint32 **result);

int compact_fhe_uint32_safe_serialize(const struct CompactFheUint32 *sself,
                                      DynamicBuffer *result,
                                      uint64_t serialized_size_limit);

int compact_fhe_uint32_serialize(const struct CompactFheUint32 *sself, DynamicBuffer *result);

int compact_fhe_uint32_try_encrypt_with_compact_public_key_u32(uint32_t value,
                                                               const struct CompactPublicKey *public_key,
                                                               struct CompactFheUint32 **result);

int compact_fhe_uint4_clone(const struct CompactFheUint4 *sself, struct CompactFheUint4 **result);

int compact_fhe_uint4_deserialize(DynamicBufferView buffer_view, struct CompactFheUint4 **result);

/**
 *ptr can be null (no-op in that case)
 */
int compact_fhe_uint4_destroy(struct CompactFheUint4 *ptr);

int compact_fhe_uint4_expand(const struct CompactFheUint4 *sself, struct FheUint4 **output);

int compact_fhe_uint4_list_clone(const struct CompactFheUint4List *sself,
                                 struct CompactFheUint4List **result);

int compact_fhe_uint4_list_deserialize(DynamicBufferView buffer_view,
                                       struct CompactFheUint4List **result);

/**
 *ptr can be null (no-op in that case)
 */
int compact_fhe_uint4_list_destroy(struct CompactFheUint4List *ptr);

int compact_fhe_uint4_list_expand(const struct CompactFheUint4List *sself,
                                  struct FheUint4 **output,
                                  size_t output_len);

int compact_fhe_uint4_list_len(const struct CompactFheUint4List *sself, size_t *result);

/**
 * Deserializes a list safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `exact_len`: exact lenght/size/number of element the list must have
 *    (not less nor more, otherwise, it's considered an error)
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compact_fhe_uint4_list_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                       uint64_t serialized_size_limit,
                                                       const struct ServerKey *server_key,
                                                       size_t exact_len,
                                                       struct CompactFheUint4List **result);

int compact_fhe_uint4_list_safe_serialize(const struct CompactFheUint4List *sself,
                                          DynamicBuffer *result,
                                          uint64_t serialized_size_limit);

int compact_fhe_uint4_list_serialize(const struct CompactFheUint4List *sself,
                                     DynamicBuffer *result);

int compact_fhe_uint4_list_try_encrypt_with_compact_public_key_u8(const uint8_t *input,
                                                                  size_t input_len,
                                                                  const struct CompactPublicKey *public_key,
                                                                  struct CompactFheUint4List **result);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compact_fhe_uint4_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                  uint64_t serialized_size_limit,
                                                  const struct ServerKey *server_key,
                                                  struct CompactFheUint4 **result);

int compact_fhe_uint4_safe_serialize(const struct CompactFheUint4 *sself,
                                     DynamicBuffer *result,
                                     uint64_t serialized_size_limit);

int compact_fhe_uint4_serialize(const struct CompactFheUint4 *sself, DynamicBuffer *result);

int compact_fhe_uint4_try_encrypt_with_compact_public_key_u8(uint8_t value,
                                                             const struct CompactPublicKey *public_key,
                                                             struct CompactFheUint4 **result);

int compact_fhe_uint64_clone(const struct CompactFheUint64 *sself,
                             struct CompactFheUint64 **result);

int compact_fhe_uint64_deserialize(DynamicBufferView buffer_view, struct CompactFheUint64 **result);

/**
 *ptr can be null (no-op in that case)
 */
int compact_fhe_uint64_destroy(struct CompactFheUint64 *ptr);

int compact_fhe_uint64_expand(const struct CompactFheUint64 *sself, struct FheUint64 **output);

int compact_fhe_uint64_list_clone(const struct CompactFheUint64List *sself,
                                  struct CompactFheUint64List **result);

int compact_fhe_uint64_list_deserialize(DynamicBufferView buffer_view,
                                        struct CompactFheUint64List **result);

/**
 *ptr can be null (no-op in that case)
 */
int compact_fhe_uint64_list_destroy(struct CompactFheUint64List *ptr);

int compact_fhe_uint64_list_expand(const struct CompactFheUint64List *sself,
                                   struct FheUint64 **output,
                                   size_t output_len);

int compact_fhe_uint64_list_len(const struct CompactFheUint64List *sself, size_t *result);

/**
 * Deserializes a list safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `exact_len`: exact lenght/size/number of element the list must have
 *    (not less nor more, otherwise, it's considered an error)
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compact_fhe_uint64_list_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                        uint64_t serialized_size_limit,
                                                        const struct ServerKey *server_key,
                                                        size_t exact_len,
                                                        struct CompactFheUint64List **result);

int compact_fhe_uint64_list_safe_serialize(const struct CompactFheUint64List *sself,
                                           DynamicBuffer *result,
                                           uint64_t serialized_size_limit);

int compact_fhe_uint64_list_serialize(const struct CompactFheUint64List *sself,
                                      DynamicBuffer *result);

int compact_fhe_uint64_list_try_encrypt_with_compact_public_key_u64(const uint64_t *input,
                                                                    size_t input_len,
                                                                    const struct CompactPublicKey *public_key,
                                                                    struct CompactFheUint64List **result);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compact_fhe_uint64_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                   uint64_t serialized_size_limit,
                                                   const struct ServerKey *server_key,
                                                   struct CompactFheUint64 **result);

int compact_fhe_uint64_safe_serialize(const struct CompactFheUint64 *sself,
                                      DynamicBuffer *result,
                                      uint64_t serialized_size_limit);

int compact_fhe_uint64_serialize(const struct CompactFheUint64 *sself, DynamicBuffer *result);

int compact_fhe_uint64_try_encrypt_with_compact_public_key_u64(uint64_t value,
                                                               const struct CompactPublicKey *public_key,
                                                               struct CompactFheUint64 **result);

int compact_fhe_uint6_clone(const struct CompactFheUint6 *sself, struct CompactFheUint6 **result);

int compact_fhe_uint6_deserialize(DynamicBufferView buffer_view, struct CompactFheUint6 **result);

/**
 *ptr can be null (no-op in that case)
 */
int compact_fhe_uint6_destroy(struct CompactFheUint6 *ptr);

int compact_fhe_uint6_expand(const struct CompactFheUint6 *sself, struct FheUint6 **output);

int compact_fhe_uint6_list_clone(const struct CompactFheUint6List *sself,
                                 struct CompactFheUint6List **result);

int compact_fhe_uint6_list_deserialize(DynamicBufferView buffer_view,
                                       struct CompactFheUint6List **result);

/**
 *ptr can be null (no-op in that case)
 */
int compact_fhe_uint6_list_destroy(struct CompactFheUint6List *ptr);

int compact_fhe_uint6_list_expand(const struct CompactFheUint6List *sself,
                                  struct FheUint6 **output,
                                  size_t output_len);

int compact_fhe_uint6_list_len(const struct CompactFheUint6List *sself, size_t *result);

/**
 * Deserializes a list safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `exact_len`: exact lenght/size/number of element the list must have
 *    (not less nor more, otherwise, it's considered an error)
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compact_fhe_uint6_list_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                       uint64_t serialized_size_limit,
                                                       const struct ServerKey *server_key,
                                                       size_t exact_len,
                                                       struct CompactFheUint6List **result);

int compact_fhe_uint6_list_safe_serialize(const struct CompactFheUint6List *sself,
                                          DynamicBuffer *result,
                                          uint64_t serialized_size_limit);

int compact_fhe_uint6_list_serialize(const struct CompactFheUint6List *sself,
                                     DynamicBuffer *result);

int compact_fhe_uint6_list_try_encrypt_with_compact_public_key_u8(const uint8_t *input,
                                                                  size_t input_len,
                                                                  const struct CompactPublicKey *public_key,
                                                                  struct CompactFheUint6List **result);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compact_fhe_uint6_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                  uint64_t serialized_size_limit,
                                                  const struct ServerKey *server_key,
                                                  struct CompactFheUint6 **result);

int compact_fhe_uint6_safe_serialize(const struct CompactFheUint6 *sself,
                                     DynamicBuffer *result,
                                     uint64_t serialized_size_limit);

int compact_fhe_uint6_serialize(const struct CompactFheUint6 *sself, DynamicBuffer *result);

int compact_fhe_uint6_try_encrypt_with_compact_public_key_u8(uint8_t value,
                                                             const struct CompactPublicKey *public_key,
                                                             struct CompactFheUint6 **result);

int compact_fhe_uint8_clone(const struct CompactFheUint8 *sself, struct CompactFheUint8 **result);

int compact_fhe_uint8_deserialize(DynamicBufferView buffer_view, struct CompactFheUint8 **result);

/**
 *ptr can be null (no-op in that case)
 */
int compact_fhe_uint8_destroy(struct CompactFheUint8 *ptr);

int compact_fhe_uint8_expand(const struct CompactFheUint8 *sself, struct FheUint8 **output);

int compact_fhe_uint8_list_clone(const struct CompactFheUint8List *sself,
                                 struct CompactFheUint8List **result);

int compact_fhe_uint8_list_deserialize(DynamicBufferView buffer_view,
                                       struct CompactFheUint8List **result);

/**
 *ptr can be null (no-op in that case)
 */
int compact_fhe_uint8_list_destroy(struct CompactFheUint8List *ptr);

int compact_fhe_uint8_list_expand(const struct CompactFheUint8List *sself,
                                  struct FheUint8 **output,
                                  size_t output_len);

int compact_fhe_uint8_list_len(const struct CompactFheUint8List *sself, size_t *result);

/**
 * Deserializes a list safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `exact_len`: exact lenght/size/number of element the list must have
 *    (not less nor more, otherwise, it's considered an error)
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compact_fhe_uint8_list_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                       uint64_t serialized_size_limit,
                                                       const struct ServerKey *server_key,
                                                       size_t exact_len,
                                                       struct CompactFheUint8List **result);

int compact_fhe_uint8_list_safe_serialize(const struct CompactFheUint8List *sself,
                                          DynamicBuffer *result,
                                          uint64_t serialized_size_limit);

int compact_fhe_uint8_list_serialize(const struct CompactFheUint8List *sself,
                                     DynamicBuffer *result);

int compact_fhe_uint8_list_try_encrypt_with_compact_public_key_u8(const uint8_t *input,
                                                                  size_t input_len,
                                                                  const struct CompactPublicKey *public_key,
                                                                  struct CompactFheUint8List **result);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compact_fhe_uint8_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                  uint64_t serialized_size_limit,
                                                  const struct ServerKey *server_key,
                                                  struct CompactFheUint8 **result);

int compact_fhe_uint8_safe_serialize(const struct CompactFheUint8 *sself,
                                     DynamicBuffer *result,
                                     uint64_t serialized_size_limit);

int compact_fhe_uint8_serialize(const struct CompactFheUint8 *sself, DynamicBuffer *result);

int compact_fhe_uint8_try_encrypt_with_compact_public_key_u8(uint8_t value,
                                                             const struct CompactPublicKey *public_key,
                                                             struct CompactFheUint8 **result);

int compact_public_key_deserialize(DynamicBufferView buffer_view, struct CompactPublicKey **result);

/**
 *ptr can be null (no-op in that case)
 */
int compact_public_key_destroy(struct CompactPublicKey *ptr);

int compact_public_key_new(const struct ClientKey *client_key,
                           struct CompactPublicKey **result_public_key);

int compact_public_key_serialize(const struct CompactPublicKey *sself, DynamicBuffer *result);

int compressed_compact_public_key_decompress(const struct CompressedCompactPublicKey *public_key,
                                             struct CompactPublicKey **result_public_key);

int compressed_compact_public_key_deserialize(DynamicBufferView buffer_view,
                                              struct CompressedCompactPublicKey **result);

/**
 *ptr can be null (no-op in that case)
 */
int compressed_compact_public_key_destroy(struct CompressedCompactPublicKey *ptr);

int compressed_compact_public_key_new(const struct ClientKey *client_key,
                                      struct CompressedCompactPublicKey **result_public_key);

int compressed_compact_public_key_serialize(const struct CompressedCompactPublicKey *sself,
                                            DynamicBuffer *result);

int compressed_fhe_bool_clone(const struct CompressedFheBool *sself,
                              struct CompressedFheBool **result);

int compressed_fhe_bool_decompress(const struct CompressedFheBool *sself, struct FheBool **result);

int compressed_fhe_bool_deserialize(DynamicBufferView buffer_view,
                                    struct CompressedFheBool **result);

/**
 *ptr can be null (no-op in that case)
 */
int compressed_fhe_bool_destroy(struct CompressedFheBool *ptr);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compressed_fhe_bool_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                    uint64_t serialized_size_limit,
                                                    const struct ServerKey *server_key,
                                                    struct CompressedFheBool **result);

int compressed_fhe_bool_safe_serialize(const struct CompressedFheBool *sself,
                                       DynamicBuffer *result,
                                       uint64_t serialized_size_limit);

int compressed_fhe_bool_serialize(const struct CompressedFheBool *sself, DynamicBuffer *result);

int compressed_fhe_bool_try_encrypt_with_client_key_bool(bool value,
                                                         const struct ClientKey *client_key,
                                                         struct CompressedFheBool **result);

int compressed_fhe_int10_clone(const struct CompressedFheInt10 *sself,
                               struct CompressedFheInt10 **result);

int compressed_fhe_int10_decompress(const struct CompressedFheInt10 *sself,
                                    struct FheInt10 **result);

int compressed_fhe_int10_deserialize(DynamicBufferView buffer_view,
                                     struct CompressedFheInt10 **result);

/**
 *ptr can be null (no-op in that case)
 */
int compressed_fhe_int10_destroy(struct CompressedFheInt10 *ptr);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compressed_fhe_int10_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                     uint64_t serialized_size_limit,
                                                     const struct ServerKey *server_key,
                                                     struct CompressedFheInt10 **result);

int compressed_fhe_int10_safe_serialize(const struct CompressedFheInt10 *sself,
                                        DynamicBuffer *result,
                                        uint64_t serialized_size_limit);

int compressed_fhe_int10_serialize(const struct CompressedFheInt10 *sself, DynamicBuffer *result);

int compressed_fhe_int10_try_encrypt_with_client_key_i16(int16_t value,
                                                         const struct ClientKey *client_key,
                                                         struct CompressedFheInt10 **result);

int compressed_fhe_int128_clone(const struct CompressedFheInt128 *sself,
                                struct CompressedFheInt128 **result);

int compressed_fhe_int128_decompress(const struct CompressedFheInt128 *sself,
                                     struct FheInt128 **result);

int compressed_fhe_int128_deserialize(DynamicBufferView buffer_view,
                                      struct CompressedFheInt128 **result);

/**
 *ptr can be null (no-op in that case)
 */
int compressed_fhe_int128_destroy(struct CompressedFheInt128 *ptr);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compressed_fhe_int128_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                      uint64_t serialized_size_limit,
                                                      const struct ServerKey *server_key,
                                                      struct CompressedFheInt128 **result);

int compressed_fhe_int128_safe_serialize(const struct CompressedFheInt128 *sself,
                                         DynamicBuffer *result,
                                         uint64_t serialized_size_limit);

int compressed_fhe_int128_serialize(const struct CompressedFheInt128 *sself, DynamicBuffer *result);

int compressed_fhe_int128_try_encrypt_with_client_key_i128(struct I128 value,
                                                           const struct ClientKey *client_key,
                                                           struct CompressedFheInt128 **result);

int compressed_fhe_int12_clone(const struct CompressedFheInt12 *sself,
                               struct CompressedFheInt12 **result);

int compressed_fhe_int12_decompress(const struct CompressedFheInt12 *sself,
                                    struct FheInt12 **result);

int compressed_fhe_int12_deserialize(DynamicBufferView buffer_view,
                                     struct CompressedFheInt12 **result);

/**
 *ptr can be null (no-op in that case)
 */
int compressed_fhe_int12_destroy(struct CompressedFheInt12 *ptr);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compressed_fhe_int12_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                     uint64_t serialized_size_limit,
                                                     const struct ServerKey *server_key,
                                                     struct CompressedFheInt12 **result);

int compressed_fhe_int12_safe_serialize(const struct CompressedFheInt12 *sself,
                                        DynamicBuffer *result,
                                        uint64_t serialized_size_limit);

int compressed_fhe_int12_serialize(const struct CompressedFheInt12 *sself, DynamicBuffer *result);

int compressed_fhe_int12_try_encrypt_with_client_key_i16(int16_t value,
                                                         const struct ClientKey *client_key,
                                                         struct CompressedFheInt12 **result);

int compressed_fhe_int14_clone(const struct CompressedFheInt14 *sself,
                               struct CompressedFheInt14 **result);

int compressed_fhe_int14_decompress(const struct CompressedFheInt14 *sself,
                                    struct FheInt14 **result);

int compressed_fhe_int14_deserialize(DynamicBufferView buffer_view,
                                     struct CompressedFheInt14 **result);

/**
 *ptr can be null (no-op in that case)
 */
int compressed_fhe_int14_destroy(struct CompressedFheInt14 *ptr);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compressed_fhe_int14_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                     uint64_t serialized_size_limit,
                                                     const struct ServerKey *server_key,
                                                     struct CompressedFheInt14 **result);

int compressed_fhe_int14_safe_serialize(const struct CompressedFheInt14 *sself,
                                        DynamicBuffer *result,
                                        uint64_t serialized_size_limit);

int compressed_fhe_int14_serialize(const struct CompressedFheInt14 *sself, DynamicBuffer *result);

int compressed_fhe_int14_try_encrypt_with_client_key_i16(int16_t value,
                                                         const struct ClientKey *client_key,
                                                         struct CompressedFheInt14 **result);

int compressed_fhe_int160_clone(const struct CompressedFheInt160 *sself,
                                struct CompressedFheInt160 **result);

int compressed_fhe_int160_decompress(const struct CompressedFheInt160 *sself,
                                     struct FheInt160 **result);

int compressed_fhe_int160_deserialize(DynamicBufferView buffer_view,
                                      struct CompressedFheInt160 **result);

/**
 *ptr can be null (no-op in that case)
 */
int compressed_fhe_int160_destroy(struct CompressedFheInt160 *ptr);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compressed_fhe_int160_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                      uint64_t serialized_size_limit,
                                                      const struct ServerKey *server_key,
                                                      struct CompressedFheInt160 **result);

int compressed_fhe_int160_safe_serialize(const struct CompressedFheInt160 *sself,
                                         DynamicBuffer *result,
                                         uint64_t serialized_size_limit);

int compressed_fhe_int160_serialize(const struct CompressedFheInt160 *sself, DynamicBuffer *result);

int compressed_fhe_int160_try_encrypt_with_client_key_i256(struct I256 value,
                                                           const struct ClientKey *client_key,
                                                           struct CompressedFheInt160 **result);

int compressed_fhe_int16_clone(const struct CompressedFheInt16 *sself,
                               struct CompressedFheInt16 **result);

int compressed_fhe_int16_decompress(const struct CompressedFheInt16 *sself,
                                    struct FheInt16 **result);

int compressed_fhe_int16_deserialize(DynamicBufferView buffer_view,
                                     struct CompressedFheInt16 **result);

/**
 *ptr can be null (no-op in that case)
 */
int compressed_fhe_int16_destroy(struct CompressedFheInt16 *ptr);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compressed_fhe_int16_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                     uint64_t serialized_size_limit,
                                                     const struct ServerKey *server_key,
                                                     struct CompressedFheInt16 **result);

int compressed_fhe_int16_safe_serialize(const struct CompressedFheInt16 *sself,
                                        DynamicBuffer *result,
                                        uint64_t serialized_size_limit);

int compressed_fhe_int16_serialize(const struct CompressedFheInt16 *sself, DynamicBuffer *result);

int compressed_fhe_int16_try_encrypt_with_client_key_i16(int16_t value,
                                                         const struct ClientKey *client_key,
                                                         struct CompressedFheInt16 **result);

int compressed_fhe_int256_clone(const struct CompressedFheInt256 *sself,
                                struct CompressedFheInt256 **result);

int compressed_fhe_int256_decompress(const struct CompressedFheInt256 *sself,
                                     struct FheInt256 **result);

int compressed_fhe_int256_deserialize(DynamicBufferView buffer_view,
                                      struct CompressedFheInt256 **result);

/**
 *ptr can be null (no-op in that case)
 */
int compressed_fhe_int256_destroy(struct CompressedFheInt256 *ptr);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compressed_fhe_int256_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                      uint64_t serialized_size_limit,
                                                      const struct ServerKey *server_key,
                                                      struct CompressedFheInt256 **result);

int compressed_fhe_int256_safe_serialize(const struct CompressedFheInt256 *sself,
                                         DynamicBuffer *result,
                                         uint64_t serialized_size_limit);

int compressed_fhe_int256_serialize(const struct CompressedFheInt256 *sself, DynamicBuffer *result);

int compressed_fhe_int256_try_encrypt_with_client_key_i256(struct I256 value,
                                                           const struct ClientKey *client_key,
                                                           struct CompressedFheInt256 **result);

int compressed_fhe_int2_clone(const struct CompressedFheInt2 *sself,
                              struct CompressedFheInt2 **result);

int compressed_fhe_int2_decompress(const struct CompressedFheInt2 *sself, struct FheInt2 **result);

int compressed_fhe_int2_deserialize(DynamicBufferView buffer_view,
                                    struct CompressedFheInt2 **result);

/**
 *ptr can be null (no-op in that case)
 */
int compressed_fhe_int2_destroy(struct CompressedFheInt2 *ptr);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compressed_fhe_int2_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                    uint64_t serialized_size_limit,
                                                    const struct ServerKey *server_key,
                                                    struct CompressedFheInt2 **result);

int compressed_fhe_int2_safe_serialize(const struct CompressedFheInt2 *sself,
                                       DynamicBuffer *result,
                                       uint64_t serialized_size_limit);

int compressed_fhe_int2_serialize(const struct CompressedFheInt2 *sself, DynamicBuffer *result);

int compressed_fhe_int2_try_encrypt_with_client_key_i8(int8_t value,
                                                       const struct ClientKey *client_key,
                                                       struct CompressedFheInt2 **result);

int compressed_fhe_int32_clone(const struct CompressedFheInt32 *sself,
                               struct CompressedFheInt32 **result);

int compressed_fhe_int32_decompress(const struct CompressedFheInt32 *sself,
                                    struct FheInt32 **result);

int compressed_fhe_int32_deserialize(DynamicBufferView buffer_view,
                                     struct CompressedFheInt32 **result);

/**
 *ptr can be null (no-op in that case)
 */
int compressed_fhe_int32_destroy(struct CompressedFheInt32 *ptr);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compressed_fhe_int32_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                     uint64_t serialized_size_limit,
                                                     const struct ServerKey *server_key,
                                                     struct CompressedFheInt32 **result);

int compressed_fhe_int32_safe_serialize(const struct CompressedFheInt32 *sself,
                                        DynamicBuffer *result,
                                        uint64_t serialized_size_limit);

int compressed_fhe_int32_serialize(const struct CompressedFheInt32 *sself, DynamicBuffer *result);

int compressed_fhe_int32_try_encrypt_with_client_key_i32(int32_t value,
                                                         const struct ClientKey *client_key,
                                                         struct CompressedFheInt32 **result);

int compressed_fhe_int4_clone(const struct CompressedFheInt4 *sself,
                              struct CompressedFheInt4 **result);

int compressed_fhe_int4_decompress(const struct CompressedFheInt4 *sself, struct FheInt4 **result);

int compressed_fhe_int4_deserialize(DynamicBufferView buffer_view,
                                    struct CompressedFheInt4 **result);

/**
 *ptr can be null (no-op in that case)
 */
int compressed_fhe_int4_destroy(struct CompressedFheInt4 *ptr);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compressed_fhe_int4_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                    uint64_t serialized_size_limit,
                                                    const struct ServerKey *server_key,
                                                    struct CompressedFheInt4 **result);

int compressed_fhe_int4_safe_serialize(const struct CompressedFheInt4 *sself,
                                       DynamicBuffer *result,
                                       uint64_t serialized_size_limit);

int compressed_fhe_int4_serialize(const struct CompressedFheInt4 *sself, DynamicBuffer *result);

int compressed_fhe_int4_try_encrypt_with_client_key_i8(int8_t value,
                                                       const struct ClientKey *client_key,
                                                       struct CompressedFheInt4 **result);

int compressed_fhe_int64_clone(const struct CompressedFheInt64 *sself,
                               struct CompressedFheInt64 **result);

int compressed_fhe_int64_decompress(const struct CompressedFheInt64 *sself,
                                    struct FheInt64 **result);

int compressed_fhe_int64_deserialize(DynamicBufferView buffer_view,
                                     struct CompressedFheInt64 **result);

/**
 *ptr can be null (no-op in that case)
 */
int compressed_fhe_int64_destroy(struct CompressedFheInt64 *ptr);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compressed_fhe_int64_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                     uint64_t serialized_size_limit,
                                                     const struct ServerKey *server_key,
                                                     struct CompressedFheInt64 **result);

int compressed_fhe_int64_safe_serialize(const struct CompressedFheInt64 *sself,
                                        DynamicBuffer *result,
                                        uint64_t serialized_size_limit);

int compressed_fhe_int64_serialize(const struct CompressedFheInt64 *sself, DynamicBuffer *result);

int compressed_fhe_int64_try_encrypt_with_client_key_i64(int64_t value,
                                                         const struct ClientKey *client_key,
                                                         struct CompressedFheInt64 **result);

int compressed_fhe_int6_clone(const struct CompressedFheInt6 *sself,
                              struct CompressedFheInt6 **result);

int compressed_fhe_int6_decompress(const struct CompressedFheInt6 *sself, struct FheInt6 **result);

int compressed_fhe_int6_deserialize(DynamicBufferView buffer_view,
                                    struct CompressedFheInt6 **result);

/**
 *ptr can be null (no-op in that case)
 */
int compressed_fhe_int6_destroy(struct CompressedFheInt6 *ptr);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compressed_fhe_int6_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                    uint64_t serialized_size_limit,
                                                    const struct ServerKey *server_key,
                                                    struct CompressedFheInt6 **result);

int compressed_fhe_int6_safe_serialize(const struct CompressedFheInt6 *sself,
                                       DynamicBuffer *result,
                                       uint64_t serialized_size_limit);

int compressed_fhe_int6_serialize(const struct CompressedFheInt6 *sself, DynamicBuffer *result);

int compressed_fhe_int6_try_encrypt_with_client_key_i8(int8_t value,
                                                       const struct ClientKey *client_key,
                                                       struct CompressedFheInt6 **result);

int compressed_fhe_int8_clone(const struct CompressedFheInt8 *sself,
                              struct CompressedFheInt8 **result);

int compressed_fhe_int8_decompress(const struct CompressedFheInt8 *sself, struct FheInt8 **result);

int compressed_fhe_int8_deserialize(DynamicBufferView buffer_view,
                                    struct CompressedFheInt8 **result);

/**
 *ptr can be null (no-op in that case)
 */
int compressed_fhe_int8_destroy(struct CompressedFheInt8 *ptr);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compressed_fhe_int8_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                    uint64_t serialized_size_limit,
                                                    const struct ServerKey *server_key,
                                                    struct CompressedFheInt8 **result);

int compressed_fhe_int8_safe_serialize(const struct CompressedFheInt8 *sself,
                                       DynamicBuffer *result,
                                       uint64_t serialized_size_limit);

int compressed_fhe_int8_serialize(const struct CompressedFheInt8 *sself, DynamicBuffer *result);

int compressed_fhe_int8_try_encrypt_with_client_key_i8(int8_t value,
                                                       const struct ClientKey *client_key,
                                                       struct CompressedFheInt8 **result);

int compressed_fhe_uint10_clone(const struct CompressedFheUint10 *sself,
                                struct CompressedFheUint10 **result);

int compressed_fhe_uint10_decompress(const struct CompressedFheUint10 *sself,
                                     struct FheUint10 **result);

int compressed_fhe_uint10_deserialize(DynamicBufferView buffer_view,
                                      struct CompressedFheUint10 **result);

/**
 *ptr can be null (no-op in that case)
 */
int compressed_fhe_uint10_destroy(struct CompressedFheUint10 *ptr);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compressed_fhe_uint10_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                      uint64_t serialized_size_limit,
                                                      const struct ServerKey *server_key,
                                                      struct CompressedFheUint10 **result);

int compressed_fhe_uint10_safe_serialize(const struct CompressedFheUint10 *sself,
                                         DynamicBuffer *result,
                                         uint64_t serialized_size_limit);

int compressed_fhe_uint10_serialize(const struct CompressedFheUint10 *sself, DynamicBuffer *result);

int compressed_fhe_uint10_try_encrypt_with_client_key_u16(uint16_t value,
                                                          const struct ClientKey *client_key,
                                                          struct CompressedFheUint10 **result);

int compressed_fhe_uint128_clone(const struct CompressedFheUint128 *sself,
                                 struct CompressedFheUint128 **result);

int compressed_fhe_uint128_decompress(const struct CompressedFheUint128 *sself,
                                      struct FheUint128 **result);

int compressed_fhe_uint128_deserialize(DynamicBufferView buffer_view,
                                       struct CompressedFheUint128 **result);

/**
 *ptr can be null (no-op in that case)
 */
int compressed_fhe_uint128_destroy(struct CompressedFheUint128 *ptr);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compressed_fhe_uint128_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                       uint64_t serialized_size_limit,
                                                       const struct ServerKey *server_key,
                                                       struct CompressedFheUint128 **result);

int compressed_fhe_uint128_safe_serialize(const struct CompressedFheUint128 *sself,
                                          DynamicBuffer *result,
                                          uint64_t serialized_size_limit);

int compressed_fhe_uint128_serialize(const struct CompressedFheUint128 *sself,
                                     DynamicBuffer *result);

int compressed_fhe_uint128_try_encrypt_with_client_key_u128(struct U128 value,
                                                            const struct ClientKey *client_key,
                                                            struct CompressedFheUint128 **result);

int compressed_fhe_uint12_clone(const struct CompressedFheUint12 *sself,
                                struct CompressedFheUint12 **result);

int compressed_fhe_uint12_decompress(const struct CompressedFheUint12 *sself,
                                     struct FheUint12 **result);

int compressed_fhe_uint12_deserialize(DynamicBufferView buffer_view,
                                      struct CompressedFheUint12 **result);

/**
 *ptr can be null (no-op in that case)
 */
int compressed_fhe_uint12_destroy(struct CompressedFheUint12 *ptr);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compressed_fhe_uint12_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                      uint64_t serialized_size_limit,
                                                      const struct ServerKey *server_key,
                                                      struct CompressedFheUint12 **result);

int compressed_fhe_uint12_safe_serialize(const struct CompressedFheUint12 *sself,
                                         DynamicBuffer *result,
                                         uint64_t serialized_size_limit);

int compressed_fhe_uint12_serialize(const struct CompressedFheUint12 *sself, DynamicBuffer *result);

int compressed_fhe_uint12_try_encrypt_with_client_key_u16(uint16_t value,
                                                          const struct ClientKey *client_key,
                                                          struct CompressedFheUint12 **result);

int compressed_fhe_uint14_clone(const struct CompressedFheUint14 *sself,
                                struct CompressedFheUint14 **result);

int compressed_fhe_uint14_decompress(const struct CompressedFheUint14 *sself,
                                     struct FheUint14 **result);

int compressed_fhe_uint14_deserialize(DynamicBufferView buffer_view,
                                      struct CompressedFheUint14 **result);

/**
 *ptr can be null (no-op in that case)
 */
int compressed_fhe_uint14_destroy(struct CompressedFheUint14 *ptr);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compressed_fhe_uint14_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                      uint64_t serialized_size_limit,
                                                      const struct ServerKey *server_key,
                                                      struct CompressedFheUint14 **result);

int compressed_fhe_uint14_safe_serialize(const struct CompressedFheUint14 *sself,
                                         DynamicBuffer *result,
                                         uint64_t serialized_size_limit);

int compressed_fhe_uint14_serialize(const struct CompressedFheUint14 *sself, DynamicBuffer *result);

int compressed_fhe_uint14_try_encrypt_with_client_key_u16(uint16_t value,
                                                          const struct ClientKey *client_key,
                                                          struct CompressedFheUint14 **result);

int compressed_fhe_uint160_clone(const struct CompressedFheUint160 *sself,
                                 struct CompressedFheUint160 **result);

int compressed_fhe_uint160_decompress(const struct CompressedFheUint160 *sself,
                                      struct FheUint160 **result);

int compressed_fhe_uint160_deserialize(DynamicBufferView buffer_view,
                                       struct CompressedFheUint160 **result);

/**
 *ptr can be null (no-op in that case)
 */
int compressed_fhe_uint160_destroy(struct CompressedFheUint160 *ptr);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compressed_fhe_uint160_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                       uint64_t serialized_size_limit,
                                                       const struct ServerKey *server_key,
                                                       struct CompressedFheUint160 **result);

int compressed_fhe_uint160_safe_serialize(const struct CompressedFheUint160 *sself,
                                          DynamicBuffer *result,
                                          uint64_t serialized_size_limit);

int compressed_fhe_uint160_serialize(const struct CompressedFheUint160 *sself,
                                     DynamicBuffer *result);

int compressed_fhe_uint160_try_encrypt_with_client_key_u256(struct U256 value,
                                                            const struct ClientKey *client_key,
                                                            struct CompressedFheUint160 **result);

int compressed_fhe_uint16_clone(const struct CompressedFheUint16 *sself,
                                struct CompressedFheUint16 **result);

int compressed_fhe_uint16_decompress(const struct CompressedFheUint16 *sself,
                                     struct FheUint16 **result);

int compressed_fhe_uint16_deserialize(DynamicBufferView buffer_view,
                                      struct CompressedFheUint16 **result);

/**
 *ptr can be null (no-op in that case)
 */
int compressed_fhe_uint16_destroy(struct CompressedFheUint16 *ptr);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compressed_fhe_uint16_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                      uint64_t serialized_size_limit,
                                                      const struct ServerKey *server_key,
                                                      struct CompressedFheUint16 **result);

int compressed_fhe_uint16_safe_serialize(const struct CompressedFheUint16 *sself,
                                         DynamicBuffer *result,
                                         uint64_t serialized_size_limit);

int compressed_fhe_uint16_serialize(const struct CompressedFheUint16 *sself, DynamicBuffer *result);

int compressed_fhe_uint16_try_encrypt_with_client_key_u16(uint16_t value,
                                                          const struct ClientKey *client_key,
                                                          struct CompressedFheUint16 **result);

int compressed_fhe_uint256_clone(const struct CompressedFheUint256 *sself,
                                 struct CompressedFheUint256 **result);

int compressed_fhe_uint256_decompress(const struct CompressedFheUint256 *sself,
                                      struct FheUint256 **result);

int compressed_fhe_uint256_deserialize(DynamicBufferView buffer_view,
                                       struct CompressedFheUint256 **result);

/**
 *ptr can be null (no-op in that case)
 */
int compressed_fhe_uint256_destroy(struct CompressedFheUint256 *ptr);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compressed_fhe_uint256_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                       uint64_t serialized_size_limit,
                                                       const struct ServerKey *server_key,
                                                       struct CompressedFheUint256 **result);

int compressed_fhe_uint256_safe_serialize(const struct CompressedFheUint256 *sself,
                                          DynamicBuffer *result,
                                          uint64_t serialized_size_limit);

int compressed_fhe_uint256_serialize(const struct CompressedFheUint256 *sself,
                                     DynamicBuffer *result);

int compressed_fhe_uint256_try_encrypt_with_client_key_u256(struct U256 value,
                                                            const struct ClientKey *client_key,
                                                            struct CompressedFheUint256 **result);

int compressed_fhe_uint2_clone(const struct CompressedFheUint2 *sself,
                               struct CompressedFheUint2 **result);

int compressed_fhe_uint2_decompress(const struct CompressedFheUint2 *sself,
                                    struct FheUint2 **result);

int compressed_fhe_uint2_deserialize(DynamicBufferView buffer_view,
                                     struct CompressedFheUint2 **result);

/**
 *ptr can be null (no-op in that case)
 */
int compressed_fhe_uint2_destroy(struct CompressedFheUint2 *ptr);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compressed_fhe_uint2_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                     uint64_t serialized_size_limit,
                                                     const struct ServerKey *server_key,
                                                     struct CompressedFheUint2 **result);

int compressed_fhe_uint2_safe_serialize(const struct CompressedFheUint2 *sself,
                                        DynamicBuffer *result,
                                        uint64_t serialized_size_limit);

int compressed_fhe_uint2_serialize(const struct CompressedFheUint2 *sself, DynamicBuffer *result);

int compressed_fhe_uint2_try_encrypt_with_client_key_u8(uint8_t value,
                                                        const struct ClientKey *client_key,
                                                        struct CompressedFheUint2 **result);

int compressed_fhe_uint32_clone(const struct CompressedFheUint32 *sself,
                                struct CompressedFheUint32 **result);

int compressed_fhe_uint32_decompress(const struct CompressedFheUint32 *sself,
                                     struct FheUint32 **result);

int compressed_fhe_uint32_deserialize(DynamicBufferView buffer_view,
                                      struct CompressedFheUint32 **result);

/**
 *ptr can be null (no-op in that case)
 */
int compressed_fhe_uint32_destroy(struct CompressedFheUint32 *ptr);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compressed_fhe_uint32_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                      uint64_t serialized_size_limit,
                                                      const struct ServerKey *server_key,
                                                      struct CompressedFheUint32 **result);

int compressed_fhe_uint32_safe_serialize(const struct CompressedFheUint32 *sself,
                                         DynamicBuffer *result,
                                         uint64_t serialized_size_limit);

int compressed_fhe_uint32_serialize(const struct CompressedFheUint32 *sself, DynamicBuffer *result);

int compressed_fhe_uint32_try_encrypt_with_client_key_u32(uint32_t value,
                                                          const struct ClientKey *client_key,
                                                          struct CompressedFheUint32 **result);

int compressed_fhe_uint4_clone(const struct CompressedFheUint4 *sself,
                               struct CompressedFheUint4 **result);

int compressed_fhe_uint4_decompress(const struct CompressedFheUint4 *sself,
                                    struct FheUint4 **result);

int compressed_fhe_uint4_deserialize(DynamicBufferView buffer_view,
                                     struct CompressedFheUint4 **result);

/**
 *ptr can be null (no-op in that case)
 */
int compressed_fhe_uint4_destroy(struct CompressedFheUint4 *ptr);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compressed_fhe_uint4_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                     uint64_t serialized_size_limit,
                                                     const struct ServerKey *server_key,
                                                     struct CompressedFheUint4 **result);

int compressed_fhe_uint4_safe_serialize(const struct CompressedFheUint4 *sself,
                                        DynamicBuffer *result,
                                        uint64_t serialized_size_limit);

int compressed_fhe_uint4_serialize(const struct CompressedFheUint4 *sself, DynamicBuffer *result);

int compressed_fhe_uint4_try_encrypt_with_client_key_u8(uint8_t value,
                                                        const struct ClientKey *client_key,
                                                        struct CompressedFheUint4 **result);

int compressed_fhe_uint64_clone(const struct CompressedFheUint64 *sself,
                                struct CompressedFheUint64 **result);

int compressed_fhe_uint64_decompress(const struct CompressedFheUint64 *sself,
                                     struct FheUint64 **result);

int compressed_fhe_uint64_deserialize(DynamicBufferView buffer_view,
                                      struct CompressedFheUint64 **result);

/**
 *ptr can be null (no-op in that case)
 */
int compressed_fhe_uint64_destroy(struct CompressedFheUint64 *ptr);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compressed_fhe_uint64_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                      uint64_t serialized_size_limit,
                                                      const struct ServerKey *server_key,
                                                      struct CompressedFheUint64 **result);

int compressed_fhe_uint64_safe_serialize(const struct CompressedFheUint64 *sself,
                                         DynamicBuffer *result,
                                         uint64_t serialized_size_limit);

int compressed_fhe_uint64_serialize(const struct CompressedFheUint64 *sself, DynamicBuffer *result);

int compressed_fhe_uint64_try_encrypt_with_client_key_u64(uint64_t value,
                                                          const struct ClientKey *client_key,
                                                          struct CompressedFheUint64 **result);

int compressed_fhe_uint6_clone(const struct CompressedFheUint6 *sself,
                               struct CompressedFheUint6 **result);

int compressed_fhe_uint6_decompress(const struct CompressedFheUint6 *sself,
                                    struct FheUint6 **result);

int compressed_fhe_uint6_deserialize(DynamicBufferView buffer_view,
                                     struct CompressedFheUint6 **result);

/**
 *ptr can be null (no-op in that case)
 */
int compressed_fhe_uint6_destroy(struct CompressedFheUint6 *ptr);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compressed_fhe_uint6_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                     uint64_t serialized_size_limit,
                                                     const struct ServerKey *server_key,
                                                     struct CompressedFheUint6 **result);

int compressed_fhe_uint6_safe_serialize(const struct CompressedFheUint6 *sself,
                                        DynamicBuffer *result,
                                        uint64_t serialized_size_limit);

int compressed_fhe_uint6_serialize(const struct CompressedFheUint6 *sself, DynamicBuffer *result);

int compressed_fhe_uint6_try_encrypt_with_client_key_u8(uint8_t value,
                                                        const struct ClientKey *client_key,
                                                        struct CompressedFheUint6 **result);

int compressed_fhe_uint8_clone(const struct CompressedFheUint8 *sself,
                               struct CompressedFheUint8 **result);

int compressed_fhe_uint8_decompress(const struct CompressedFheUint8 *sself,
                                    struct FheUint8 **result);

int compressed_fhe_uint8_deserialize(DynamicBufferView buffer_view,
                                     struct CompressedFheUint8 **result);

/**
 *ptr can be null (no-op in that case)
 */
int compressed_fhe_uint8_destroy(struct CompressedFheUint8 *ptr);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int compressed_fhe_uint8_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                                     uint64_t serialized_size_limit,
                                                     const struct ServerKey *server_key,
                                                     struct CompressedFheUint8 **result);

int compressed_fhe_uint8_safe_serialize(const struct CompressedFheUint8 *sself,
                                        DynamicBuffer *result,
                                        uint64_t serialized_size_limit);

int compressed_fhe_uint8_serialize(const struct CompressedFheUint8 *sself, DynamicBuffer *result);

int compressed_fhe_uint8_try_encrypt_with_client_key_u8(uint8_t value,
                                                        const struct ClientKey *client_key,
                                                        struct CompressedFheUint8 **result);

/**
 * Decompresses the CompressedServerKey to a ServerKey that lives on CPU
 */
int compressed_server_key_decompress(const struct CompressedServerKey *compressed_server_key,
                                     struct ServerKey **result_server_key);

int compressed_server_key_deserialize(DynamicBufferView buffer_view,
                                      struct CompressedServerKey **result);

/**
 *ptr can be null (no-op in that case)
 */
int compressed_server_key_destroy(struct CompressedServerKey *ptr);

/**
 * Creates a new compressed server key
 */
int compressed_server_key_new(const struct ClientKey *client_key,
                              struct CompressedServerKey **result_server_key);

int compressed_server_key_serialize(const struct CompressedServerKey *sself, DynamicBuffer *result);

/**
 * Takes ownership of the builder
 */
int config_builder_build(struct ConfigBuilder *builder, struct Config **result);

int config_builder_clone(const struct ConfigBuilder *input, struct ConfigBuilder **result);

int config_builder_default(struct ConfigBuilder **result);

int config_builder_default_with_big_encryption(struct ConfigBuilder **builder);

int config_builder_default_with_small_encryption(struct ConfigBuilder **builder);

/**
 *ptr can be null (no-op in that case)
 */
int config_builder_destroy(struct ConfigBuilder *ptr);

int config_builder_use_custom_parameters(struct ConfigBuilder **builder,
                                         struct ShortintPBSParameters shortint_block_parameters);

/**
 *ptr can be null (no-op in that case)
 */
int config_destroy(struct Config *ptr);

int core_crypto_ggsw_encrypt(uint64_t *output_ct_ptr,
                             uint64_t pt,
                             const uint64_t *glwe_sk_ptr,
                             size_t glwe_sk_dim,
                             size_t poly_size,
                             size_t level_count,
                             size_t base_log,
                             struct DynamicDistribution glwe_noise_distribution,
                             uint64_t seed_low_bytes,
                             uint64_t seed_high_bytes);

int core_crypto_glwe_decrypt(uint64_t *output_pt,
                             const uint64_t *input_ct_ptr,
                             const uint64_t *glwe_sk_ptr,
                             size_t glwe_sk_dim,
                             size_t glwe_poly_size);

int core_crypto_lwe_decrypt(uint64_t *output_pt,
                            const uint64_t *input_ct_ptr,
                            const uint64_t *lwe_sk_ptr,
                            size_t lwe_sk_dim);

int core_crypto_lwe_encrypt(uint64_t *output_ct_ptr,
                            uint64_t pt,
                            const uint64_t *lwe_sk_ptr,
                            size_t lwe_sk_dim,
                            struct DynamicDistribution lwe_noise_distribution,
                            uint64_t seed_low_bytes,
                            uint64_t seed_high_bytes);

int core_crypto_lwe_multi_bit_bootstrapping_key_element_size(size_t input_lwe_sk_dim,
                                                             size_t output_glwe_sk_dim,
                                                             size_t output_glwe_sk_poly_size,
                                                             size_t lwe_multi_bit_level_count,
                                                             size_t lwe_multi_bit_grouping_factor,
                                                             size_t *result);

int core_crypto_lwe_secret_key(uint64_t *output_lwe_sk_ptr,
                               size_t lwe_sk_dim,
                               uint64_t seed_low_bytes,
                               uint64_t seed_high_bytes);

int core_crypto_par_generate_lwe_bootstrapping_key(uint64_t *output_bsk_ptr,
                                                   size_t bsk_base_log,
                                                   size_t bsk_level_count,
                                                   const uint64_t *input_lwe_sk_ptr,
                                                   size_t input_lwe_sk_dim,
                                                   const uint64_t *output_glwe_sk_ptr,
                                                   size_t output_glwe_sk_dim,
                                                   size_t output_glwe_sk_poly_size,
                                                   struct DynamicDistribution glwe_noise_distribution,
                                                   uint64_t seed_low_bytes,
                                                   uint64_t seed_high_bytes);

int core_crypto_par_generate_lwe_keyswitch_key(uint64_t *output_ksk_ptr,
                                               size_t ksk_base_log,
                                               size_t ksk_level_count,
                                               const uint64_t *input_lwe_sk_ptr,
                                               size_t input_lwe_sk_dim,
                                               const uint64_t *output_lwe_sk_ptr,
                                               size_t output_lwe_sk_dim,
                                               struct DynamicDistribution lwe_noise_distribution,
                                               uint64_t seed_low_bytes,
                                               uint64_t seed_high_bytes);

int core_crypto_par_generate_lwe_multi_bit_bootstrapping_key(const uint64_t *input_lwe_sk_ptr,
                                                             size_t input_lwe_sk_dim,
                                                             const uint64_t *output_glwe_sk_ptr,
                                                             size_t output_glwe_sk_dim,
                                                             size_t output_glwe_sk_poly_size,
                                                             uint64_t *lwe_multi_bit_ptr,
                                                             size_t lwe_multi_bit_base_log,
                                                             size_t lwe_multi_bit_level_count,
                                                             size_t lwe_multi_bit_grouping_factor,
                                                             struct DynamicDistribution glwe_noise_distribution,
                                                             uint64_t seed_low_bytes,
                                                             uint64_t seed_high_bytes);

int core_crypto_par_generate_lwe_private_functional_keyswitch_key(uint64_t *output_pksk_ptr,
                                                                  size_t pksk_base_log,
                                                                  size_t pksk_level_count,
                                                                  const uint64_t *input_lwe_sk_ptr,
                                                                  size_t input_lwe_sk_dim,
                                                                  const uint64_t *output_glwe_sk_ptr,
                                                                  size_t poly_size,
                                                                  size_t glwe_dim,
                                                                  struct DynamicDistribution lwe_noise_distribution,
                                                                  uint64_t seed_low_bytes,
                                                                  uint64_t seed_high_bytes);

int fhe_bool_bitand(const struct FheBool *lhs, const struct FheBool *rhs, struct FheBool **result);

int fhe_bool_bitand_assign(struct FheBool *lhs, const struct FheBool *rhs);

int fhe_bool_bitor(const struct FheBool *lhs, const struct FheBool *rhs, struct FheBool **result);

int fhe_bool_bitor_assign(struct FheBool *lhs, const struct FheBool *rhs);

int fhe_bool_bitxor(const struct FheBool *lhs, const struct FheBool *rhs, struct FheBool **result);

int fhe_bool_bitxor_assign(struct FheBool *lhs, const struct FheBool *rhs);

int fhe_bool_cast_into_fhe_int10(const struct FheBool *sself, struct FheInt10 **result);

int fhe_bool_cast_into_fhe_int12(const struct FheBool *sself, struct FheInt12 **result);

int fhe_bool_cast_into_fhe_int128(const struct FheBool *sself, struct FheInt128 **result);

int fhe_bool_cast_into_fhe_int14(const struct FheBool *sself, struct FheInt14 **result);

int fhe_bool_cast_into_fhe_int16(const struct FheBool *sself, struct FheInt16 **result);

int fhe_bool_cast_into_fhe_int160(const struct FheBool *sself, struct FheInt160 **result);

int fhe_bool_cast_into_fhe_int2(const struct FheBool *sself, struct FheInt2 **result);

int fhe_bool_cast_into_fhe_int256(const struct FheBool *sself, struct FheInt256 **result);

int fhe_bool_cast_into_fhe_int32(const struct FheBool *sself, struct FheInt32 **result);

int fhe_bool_cast_into_fhe_int4(const struct FheBool *sself, struct FheInt4 **result);

int fhe_bool_cast_into_fhe_int6(const struct FheBool *sself, struct FheInt6 **result);

int fhe_bool_cast_into_fhe_int64(const struct FheBool *sself, struct FheInt64 **result);

int fhe_bool_cast_into_fhe_int8(const struct FheBool *sself, struct FheInt8 **result);

int fhe_bool_cast_into_fhe_uint10(const struct FheBool *sself, struct FheUint10 **result);

int fhe_bool_cast_into_fhe_uint128(const struct FheBool *sself, struct FheUint128 **result);

int fhe_bool_cast_into_fhe_uint14(const struct FheBool *sself, struct FheUint14 **result);

int fhe_bool_cast_into_fhe_uint16(const struct FheBool *sself, struct FheUint16 **result);

int fhe_bool_cast_into_fhe_uint160(const struct FheBool *sself, struct FheUint160 **result);

int fhe_bool_cast_into_fhe_uint2(const struct FheBool *sself, struct FheUint2 **result);

int fhe_bool_cast_into_fhe_uint256(const struct FheBool *sself, struct FheUint256 **result);

int fhe_bool_cast_into_fhe_uint32(const struct FheBool *sself, struct FheUint32 **result);

int fhe_bool_cast_into_fhe_uint4(const struct FheBool *sself, struct FheUint4 **result);

int fhe_bool_cast_into_fhe_uint6(const struct FheBool *sself, struct FheUint6 **result);

int fhe_bool_cast_into_fhe_uint64(const struct FheBool *sself, struct FheUint64 **result);

int fhe_bool_cast_into_fhe_uint8(const struct FheBool *sself, struct FheUint8 **result);

int fhe_bool_clone(const struct FheBool *sself, struct FheBool **result);

int fhe_bool_compress(const struct FheBool *sself, struct CompressedFheBool **result);

int fhe_bool_decrypt(const struct FheBool *encrypted_value,
                     const struct ClientKey *client_key,
                     bool *result);

int fhe_bool_deserialize(DynamicBufferView buffer_view, struct FheBool **result);

/**
 *ptr can be null (no-op in that case)
 */
int fhe_bool_destroy(struct FheBool *ptr);

int fhe_bool_eq(const struct FheBool *lhs, const struct FheBool *rhs, struct FheBool **result);

int fhe_bool_ne(const struct FheBool *lhs, const struct FheBool *rhs, struct FheBool **result);

int fhe_bool_not(const struct FheBool *input, struct FheBool **result);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int fhe_bool_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                         uint64_t serialized_size_limit,
                                         const struct ServerKey *server_key,
                                         struct FheBool **result);

int fhe_bool_safe_serialize(const struct FheBool *sself,
                            DynamicBuffer *result,
                            uint64_t serialized_size_limit);

int fhe_bool_scalar_bitand(const struct FheBool *lhs, bool rhs, struct FheBool **result);

int fhe_bool_scalar_bitand_assign(struct FheBool *lhs, bool rhs);

int fhe_bool_scalar_bitor(const struct FheBool *lhs, bool rhs, struct FheBool **result);

int fhe_bool_scalar_bitor_assign(struct FheBool *lhs, bool rhs);

int fhe_bool_scalar_bitxor(const struct FheBool *lhs, bool rhs, struct FheBool **result);

int fhe_bool_scalar_bitxor_assign(struct FheBool *lhs, bool rhs);

int fhe_bool_scalar_eq(const struct FheBool *lhs, bool rhs, struct FheBool **result);

int fhe_bool_scalar_ne(const struct FheBool *lhs, bool rhs, struct FheBool **result);

int fhe_bool_serialize(const struct FheBool *sself, DynamicBuffer *result);

int fhe_bool_try_decrypt_trivial(const struct FheBool *encrypted_value, bool *result);

int fhe_bool_try_encrypt_trivial_bool(bool value, struct FheBool **result);

int fhe_bool_try_encrypt_with_client_key_bool(bool value,
                                              const struct ClientKey *client_key,
                                              struct FheBool **result);

int fhe_bool_try_encrypt_with_compact_public_key_bool(bool value,
                                                      const struct CompactPublicKey *public_key,
                                                      struct FheBool **result);

int fhe_bool_try_encrypt_with_public_key_bool(bool value,
                                              const struct PublicKey *public_key,
                                              struct FheBool **result);

int fhe_int10_add(const struct FheInt10 *lhs, const struct FheInt10 *rhs, struct FheInt10 **result);

int fhe_int10_add_assign(struct FheInt10 *lhs, const struct FheInt10 *rhs);

int fhe_int10_bitand(const struct FheInt10 *lhs,
                     const struct FheInt10 *rhs,
                     struct FheInt10 **result);

int fhe_int10_bitand_assign(struct FheInt10 *lhs, const struct FheInt10 *rhs);

int fhe_int10_bitor(const struct FheInt10 *lhs,
                    const struct FheInt10 *rhs,
                    struct FheInt10 **result);

int fhe_int10_bitor_assign(struct FheInt10 *lhs, const struct FheInt10 *rhs);

int fhe_int10_bitxor(const struct FheInt10 *lhs,
                     const struct FheInt10 *rhs,
                     struct FheInt10 **result);

int fhe_int10_bitxor_assign(struct FheInt10 *lhs, const struct FheInt10 *rhs);

int fhe_int10_cast_into_fhe_int10(const struct FheInt10 *sself, struct FheInt10 **result);

int fhe_int10_cast_into_fhe_int12(const struct FheInt10 *sself, struct FheInt12 **result);

int fhe_int10_cast_into_fhe_int128(const struct FheInt10 *sself, struct FheInt128 **result);

int fhe_int10_cast_into_fhe_int14(const struct FheInt10 *sself, struct FheInt14 **result);

int fhe_int10_cast_into_fhe_int16(const struct FheInt10 *sself, struct FheInt16 **result);

int fhe_int10_cast_into_fhe_int160(const struct FheInt10 *sself, struct FheInt160 **result);

int fhe_int10_cast_into_fhe_int2(const struct FheInt10 *sself, struct FheInt2 **result);

int fhe_int10_cast_into_fhe_int256(const struct FheInt10 *sself, struct FheInt256 **result);

int fhe_int10_cast_into_fhe_int32(const struct FheInt10 *sself, struct FheInt32 **result);

int fhe_int10_cast_into_fhe_int4(const struct FheInt10 *sself, struct FheInt4 **result);

int fhe_int10_cast_into_fhe_int6(const struct FheInt10 *sself, struct FheInt6 **result);

int fhe_int10_cast_into_fhe_int64(const struct FheInt10 *sself, struct FheInt64 **result);

int fhe_int10_cast_into_fhe_int8(const struct FheInt10 *sself, struct FheInt8 **result);

int fhe_int10_cast_into_fhe_uint10(const struct FheInt10 *sself, struct FheUint10 **result);

int fhe_int10_cast_into_fhe_uint128(const struct FheInt10 *sself, struct FheUint128 **result);

int fhe_int10_cast_into_fhe_uint14(const struct FheInt10 *sself, struct FheUint14 **result);

int fhe_int10_cast_into_fhe_uint16(const struct FheInt10 *sself, struct FheUint16 **result);

int fhe_int10_cast_into_fhe_uint160(const struct FheInt10 *sself, struct FheUint160 **result);

int fhe_int10_cast_into_fhe_uint2(const struct FheInt10 *sself, struct FheUint2 **result);

int fhe_int10_cast_into_fhe_uint256(const struct FheInt10 *sself, struct FheUint256 **result);

int fhe_int10_cast_into_fhe_uint32(const struct FheInt10 *sself, struct FheUint32 **result);

int fhe_int10_cast_into_fhe_uint4(const struct FheInt10 *sself, struct FheUint4 **result);

int fhe_int10_cast_into_fhe_uint6(const struct FheInt10 *sself, struct FheUint6 **result);

int fhe_int10_cast_into_fhe_uint64(const struct FheInt10 *sself, struct FheUint64 **result);

int fhe_int10_cast_into_fhe_uint8(const struct FheInt10 *sself, struct FheUint8 **result);

/**
 * Returns the base 2 logarithm of the number, rounded down.
 *
 * Also returns a boolean flag that is true if the result is valid (i.e input was > 0)
 */
int fhe_int10_checked_ilog2(const struct FheInt10 *input,
                            struct FheUint32 **result_1,
                            struct FheBool **result_2);

int fhe_int10_clone(const struct FheInt10 *sself, struct FheInt10 **result);

int fhe_int10_compress(const struct FheInt10 *sself, struct CompressedFheInt10 **result);

int fhe_int10_decrypt(const struct FheInt10 *encrypted_value,
                      const struct ClientKey *client_key,
                      int16_t *result);

int fhe_int10_deserialize(DynamicBufferView buffer_view, struct FheInt10 **result);

/**
 *ptr can be null (no-op in that case)
 */
int fhe_int10_destroy(struct FheInt10 *ptr);

int fhe_int10_div(const struct FheInt10 *lhs, const struct FheInt10 *rhs, struct FheInt10 **result);

int fhe_int10_div_assign(struct FheInt10 *lhs, const struct FheInt10 *rhs);

int fhe_int10_div_rem(const struct FheInt10 *lhs,
                      const struct FheInt10 *rhs,
                      struct FheInt10 **q_result,
                      struct FheInt10 **r_result);

int fhe_int10_eq(const struct FheInt10 *lhs, const struct FheInt10 *rhs, struct FheBool **result);

int fhe_int10_ge(const struct FheInt10 *lhs, const struct FheInt10 *rhs, struct FheBool **result);

int fhe_int10_gt(const struct FheInt10 *lhs, const struct FheInt10 *rhs, struct FheBool **result);

int fhe_int10_if_then_else(const struct FheBool *condition_ct,
                           const struct FheInt10 *then_ct,
                           const struct FheInt10 *else_ct,
                           struct FheInt10 **result);

/**
 * Returns the base 2 logarithm of the number, rounded down.
 *
 * Result has no meaning if self encrypts a value that is <= 0.
 * See `checked_ilog2`
 */
int fhe_int10_ilog2(const struct FheInt10 *input, struct FheUint32 **result);

int fhe_int10_le(const struct FheInt10 *lhs, const struct FheInt10 *rhs, struct FheBool **result);

/**
 * Returns the number of leading ones in the binary representation of input.
 */
int fhe_int10_leading_ones(const struct FheInt10 *input, struct FheUint32 **result);

/**
 * Returns the number of leading zeros in the binary representation of input.
 */
int fhe_int10_leading_zeros(const struct FheInt10 *input, struct FheUint32 **result);

int fhe_int10_lt(const struct FheInt10 *lhs, const struct FheInt10 *rhs, struct FheBool **result);

int fhe_int10_max(const struct FheInt10 *lhs, const struct FheInt10 *rhs, struct FheInt10 **result);

int fhe_int10_min(const struct FheInt10 *lhs, const struct FheInt10 *rhs, struct FheInt10 **result);

int fhe_int10_mul(const struct FheInt10 *lhs, const struct FheInt10 *rhs, struct FheInt10 **result);

int fhe_int10_mul_assign(struct FheInt10 *lhs, const struct FheInt10 *rhs);

int fhe_int10_ne(const struct FheInt10 *lhs, const struct FheInt10 *rhs, struct FheBool **result);

int fhe_int10_neg(const struct FheInt10 *input, struct FheInt10 **result);

int fhe_int10_not(const struct FheInt10 *input, struct FheInt10 **result);

int fhe_int10_overflowing_add(const struct FheInt10 *lhs,
                              const struct FheInt10 *rhs,
                              struct FheInt10 **out_result,
                              struct FheBool **out_overflowed);

int fhe_int10_overflowing_mul(const struct FheInt10 *lhs,
                              const struct FheInt10 *rhs,
                              struct FheInt10 **out_result,
                              struct FheBool **out_overflowed);

int fhe_int10_overflowing_sub(const struct FheInt10 *lhs,
                              const struct FheInt10 *rhs,
                              struct FheInt10 **out_result,
                              struct FheBool **out_overflowed);

int fhe_int10_rem(const struct FheInt10 *lhs, const struct FheInt10 *rhs, struct FheInt10 **result);

int fhe_int10_rem_assign(struct FheInt10 *lhs, const struct FheInt10 *rhs);

int fhe_int10_rotate_left(const struct FheInt10 *lhs,
                          const struct FheUint10 *rhs,
                          struct FheInt10 **result);

int fhe_int10_rotate_left_assign(struct FheInt10 *lhs, const struct FheUint10 *rhs);

int fhe_int10_rotate_right(const struct FheInt10 *lhs,
                           const struct FheUint10 *rhs,
                           struct FheInt10 **result);

int fhe_int10_rotate_right_assign(struct FheInt10 *lhs, const struct FheUint10 *rhs);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int fhe_int10_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                          uint64_t serialized_size_limit,
                                          const struct ServerKey *server_key,
                                          struct FheInt10 **result);

int fhe_int10_safe_serialize(const struct FheInt10 *sself,
                             DynamicBuffer *result,
                             uint64_t serialized_size_limit);

int fhe_int10_scalar_add(const struct FheInt10 *lhs, int16_t rhs, struct FheInt10 **result);

int fhe_int10_scalar_add_assign(struct FheInt10 *lhs, int16_t rhs);

int fhe_int10_scalar_bitand(const struct FheInt10 *lhs, int16_t rhs, struct FheInt10 **result);

int fhe_int10_scalar_bitand_assign(struct FheInt10 *lhs, int16_t rhs);

int fhe_int10_scalar_bitor(const struct FheInt10 *lhs, int16_t rhs, struct FheInt10 **result);

int fhe_int10_scalar_bitor_assign(struct FheInt10 *lhs, int16_t rhs);

int fhe_int10_scalar_bitxor(const struct FheInt10 *lhs, int16_t rhs, struct FheInt10 **result);

int fhe_int10_scalar_bitxor_assign(struct FheInt10 *lhs, int16_t rhs);

int fhe_int10_scalar_div(const struct FheInt10 *lhs, int16_t rhs, struct FheInt10 **result);

int fhe_int10_scalar_div_assign(struct FheInt10 *lhs, int16_t rhs);

int fhe_int10_scalar_div_rem(const struct FheInt10 *lhs,
                             int16_t rhs,
                             struct FheInt10 **q_result,
                             struct FheInt10 **r_result);

int fhe_int10_scalar_eq(const struct FheInt10 *lhs, int16_t rhs, struct FheBool **result);

int fhe_int10_scalar_ge(const struct FheInt10 *lhs, int16_t rhs, struct FheBool **result);

int fhe_int10_scalar_gt(const struct FheInt10 *lhs, int16_t rhs, struct FheBool **result);

int fhe_int10_scalar_le(const struct FheInt10 *lhs, int16_t rhs, struct FheBool **result);

int fhe_int10_scalar_lt(const struct FheInt10 *lhs, int16_t rhs, struct FheBool **result);

int fhe_int10_scalar_max(const struct FheInt10 *lhs, int16_t rhs, struct FheInt10 **result);

int fhe_int10_scalar_min(const struct FheInt10 *lhs, int16_t rhs, struct FheInt10 **result);

int fhe_int10_scalar_mul(const struct FheInt10 *lhs, int16_t rhs, struct FheInt10 **result);

int fhe_int10_scalar_mul_assign(struct FheInt10 *lhs, int16_t rhs);

int fhe_int10_scalar_ne(const struct FheInt10 *lhs, int16_t rhs, struct FheBool **result);

int fhe_int10_scalar_rem(const struct FheInt10 *lhs, int16_t rhs, struct FheInt10 **result);

int fhe_int10_scalar_rem_assign(struct FheInt10 *lhs, int16_t rhs);

int fhe_int10_scalar_rotate_left(const struct FheInt10 *lhs,
                                 uint16_t rhs,
                                 struct FheInt10 **result);

int fhe_int10_scalar_rotate_left_assign(struct FheInt10 *lhs, uint16_t rhs);

int fhe_int10_scalar_rotate_right(const struct FheInt10 *lhs,
                                  uint16_t rhs,
                                  struct FheInt10 **result);

int fhe_int10_scalar_rotate_right_assign(struct FheInt10 *lhs, uint16_t rhs);

int fhe_int10_scalar_shl(const struct FheInt10 *lhs, uint16_t rhs, struct FheInt10 **result);

int fhe_int10_scalar_shl_assign(struct FheInt10 *lhs, uint16_t rhs);

int fhe_int10_scalar_shr(const struct FheInt10 *lhs, uint16_t rhs, struct FheInt10 **result);

int fhe_int10_scalar_shr_assign(struct FheInt10 *lhs, uint16_t rhs);

int fhe_int10_scalar_sub(const struct FheInt10 *lhs, int16_t rhs, struct FheInt10 **result);

int fhe_int10_scalar_sub_assign(struct FheInt10 *lhs, int16_t rhs);

int fhe_int10_serialize(const struct FheInt10 *sself, DynamicBuffer *result);

int fhe_int10_shl(const struct FheInt10 *lhs,
                  const struct FheUint10 *rhs,
                  struct FheInt10 **result);

int fhe_int10_shl_assign(struct FheInt10 *lhs, const struct FheUint10 *rhs);

int fhe_int10_shr(const struct FheInt10 *lhs,
                  const struct FheUint10 *rhs,
                  struct FheInt10 **result);

int fhe_int10_shr_assign(struct FheInt10 *lhs, const struct FheUint10 *rhs);

int fhe_int10_sub(const struct FheInt10 *lhs, const struct FheInt10 *rhs, struct FheInt10 **result);

int fhe_int10_sub_assign(struct FheInt10 *lhs, const struct FheInt10 *rhs);

int fhe_int10_sum(const struct FheInt10 *const *lhs, size_t len, struct FheInt10 **out_result);

/**
 * Returns the number of trailing ones in the binary representation of input.
 */
int fhe_int10_trailing_ones(const struct FheInt10 *input, struct FheUint32 **result);

/**
 * Returns the number of trailing zeros in the binary representation of input.
 */
int fhe_int10_trailing_zeros(const struct FheInt10 *input, struct FheUint32 **result);

int fhe_int10_try_decrypt_trivial(const struct FheInt10 *encrypted_value, int16_t *result);

int fhe_int10_try_encrypt_trivial_i16(int16_t value, struct FheInt10 **result);

int fhe_int10_try_encrypt_with_client_key_i16(int16_t value,
                                              const struct ClientKey *client_key,
                                              struct FheInt10 **result);

int fhe_int10_try_encrypt_with_compact_public_key_i16(int16_t value,
                                                      const struct CompactPublicKey *public_key,
                                                      struct FheInt10 **result);

int fhe_int10_try_encrypt_with_public_key_i16(int16_t value,
                                              const struct PublicKey *public_key,
                                              struct FheInt10 **result);

int fhe_int128_add(const struct FheInt128 *lhs,
                   const struct FheInt128 *rhs,
                   struct FheInt128 **result);

int fhe_int128_add_assign(struct FheInt128 *lhs, const struct FheInt128 *rhs);

int fhe_int128_bitand(const struct FheInt128 *lhs,
                      const struct FheInt128 *rhs,
                      struct FheInt128 **result);

int fhe_int128_bitand_assign(struct FheInt128 *lhs, const struct FheInt128 *rhs);

int fhe_int128_bitor(const struct FheInt128 *lhs,
                     const struct FheInt128 *rhs,
                     struct FheInt128 **result);

int fhe_int128_bitor_assign(struct FheInt128 *lhs, const struct FheInt128 *rhs);

int fhe_int128_bitxor(const struct FheInt128 *lhs,
                      const struct FheInt128 *rhs,
                      struct FheInt128 **result);

int fhe_int128_bitxor_assign(struct FheInt128 *lhs, const struct FheInt128 *rhs);

int fhe_int128_cast_into_fhe_int10(const struct FheInt128 *sself, struct FheInt10 **result);

int fhe_int128_cast_into_fhe_int12(const struct FheInt128 *sself, struct FheInt12 **result);

int fhe_int128_cast_into_fhe_int128(const struct FheInt128 *sself, struct FheInt128 **result);

int fhe_int128_cast_into_fhe_int14(const struct FheInt128 *sself, struct FheInt14 **result);

int fhe_int128_cast_into_fhe_int16(const struct FheInt128 *sself, struct FheInt16 **result);

int fhe_int128_cast_into_fhe_int160(const struct FheInt128 *sself, struct FheInt160 **result);

int fhe_int128_cast_into_fhe_int2(const struct FheInt128 *sself, struct FheInt2 **result);

int fhe_int128_cast_into_fhe_int256(const struct FheInt128 *sself, struct FheInt256 **result);

int fhe_int128_cast_into_fhe_int32(const struct FheInt128 *sself, struct FheInt32 **result);

int fhe_int128_cast_into_fhe_int4(const struct FheInt128 *sself, struct FheInt4 **result);

int fhe_int128_cast_into_fhe_int6(const struct FheInt128 *sself, struct FheInt6 **result);

int fhe_int128_cast_into_fhe_int64(const struct FheInt128 *sself, struct FheInt64 **result);

int fhe_int128_cast_into_fhe_int8(const struct FheInt128 *sself, struct FheInt8 **result);

int fhe_int128_cast_into_fhe_uint10(const struct FheInt128 *sself, struct FheUint10 **result);

int fhe_int128_cast_into_fhe_uint128(const struct FheInt128 *sself, struct FheUint128 **result);

int fhe_int128_cast_into_fhe_uint14(const struct FheInt128 *sself, struct FheUint14 **result);

int fhe_int128_cast_into_fhe_uint16(const struct FheInt128 *sself, struct FheUint16 **result);

int fhe_int128_cast_into_fhe_uint160(const struct FheInt128 *sself, struct FheUint160 **result);

int fhe_int128_cast_into_fhe_uint2(const struct FheInt128 *sself, struct FheUint2 **result);

int fhe_int128_cast_into_fhe_uint256(const struct FheInt128 *sself, struct FheUint256 **result);

int fhe_int128_cast_into_fhe_uint32(const struct FheInt128 *sself, struct FheUint32 **result);

int fhe_int128_cast_into_fhe_uint4(const struct FheInt128 *sself, struct FheUint4 **result);

int fhe_int128_cast_into_fhe_uint6(const struct FheInt128 *sself, struct FheUint6 **result);

int fhe_int128_cast_into_fhe_uint64(const struct FheInt128 *sself, struct FheUint64 **result);

int fhe_int128_cast_into_fhe_uint8(const struct FheInt128 *sself, struct FheUint8 **result);

/**
 * Returns the base 2 logarithm of the number, rounded down.
 *
 * Also returns a boolean flag that is true if the result is valid (i.e input was > 0)
 */
int fhe_int128_checked_ilog2(const struct FheInt128 *input,
                             struct FheUint32 **result_1,
                             struct FheBool **result_2);

int fhe_int128_clone(const struct FheInt128 *sself, struct FheInt128 **result);

int fhe_int128_compress(const struct FheInt128 *sself, struct CompressedFheInt128 **result);

int fhe_int128_decrypt(const struct FheInt128 *encrypted_value,
                       const struct ClientKey *client_key,
                       struct I128 *result);

int fhe_int128_deserialize(DynamicBufferView buffer_view, struct FheInt128 **result);

/**
 *ptr can be null (no-op in that case)
 */
int fhe_int128_destroy(struct FheInt128 *ptr);

int fhe_int128_div(const struct FheInt128 *lhs,
                   const struct FheInt128 *rhs,
                   struct FheInt128 **result);

int fhe_int128_div_assign(struct FheInt128 *lhs, const struct FheInt128 *rhs);

int fhe_int128_div_rem(const struct FheInt128 *lhs,
                       const struct FheInt128 *rhs,
                       struct FheInt128 **q_result,
                       struct FheInt128 **r_result);

int fhe_int128_eq(const struct FheInt128 *lhs,
                  const struct FheInt128 *rhs,
                  struct FheBool **result);

int fhe_int128_ge(const struct FheInt128 *lhs,
                  const struct FheInt128 *rhs,
                  struct FheBool **result);

int fhe_int128_gt(const struct FheInt128 *lhs,
                  const struct FheInt128 *rhs,
                  struct FheBool **result);

int fhe_int128_if_then_else(const struct FheBool *condition_ct,
                            const struct FheInt128 *then_ct,
                            const struct FheInt128 *else_ct,
                            struct FheInt128 **result);

/**
 * Returns the base 2 logarithm of the number, rounded down.
 *
 * Result has no meaning if self encrypts a value that is <= 0.
 * See `checked_ilog2`
 */
int fhe_int128_ilog2(const struct FheInt128 *input, struct FheUint32 **result);

int fhe_int128_le(const struct FheInt128 *lhs,
                  const struct FheInt128 *rhs,
                  struct FheBool **result);

/**
 * Returns the number of leading ones in the binary representation of input.
 */
int fhe_int128_leading_ones(const struct FheInt128 *input, struct FheUint32 **result);

/**
 * Returns the number of leading zeros in the binary representation of input.
 */
int fhe_int128_leading_zeros(const struct FheInt128 *input, struct FheUint32 **result);

int fhe_int128_lt(const struct FheInt128 *lhs,
                  const struct FheInt128 *rhs,
                  struct FheBool **result);

int fhe_int128_max(const struct FheInt128 *lhs,
                   const struct FheInt128 *rhs,
                   struct FheInt128 **result);

int fhe_int128_min(const struct FheInt128 *lhs,
                   const struct FheInt128 *rhs,
                   struct FheInt128 **result);

int fhe_int128_mul(const struct FheInt128 *lhs,
                   const struct FheInt128 *rhs,
                   struct FheInt128 **result);

int fhe_int128_mul_assign(struct FheInt128 *lhs, const struct FheInt128 *rhs);

int fhe_int128_ne(const struct FheInt128 *lhs,
                  const struct FheInt128 *rhs,
                  struct FheBool **result);

int fhe_int128_neg(const struct FheInt128 *input, struct FheInt128 **result);

int fhe_int128_not(const struct FheInt128 *input, struct FheInt128 **result);

int fhe_int128_overflowing_add(const struct FheInt128 *lhs,
                               const struct FheInt128 *rhs,
                               struct FheInt128 **out_result,
                               struct FheBool **out_overflowed);

int fhe_int128_overflowing_mul(const struct FheInt128 *lhs,
                               const struct FheInt128 *rhs,
                               struct FheInt128 **out_result,
                               struct FheBool **out_overflowed);

int fhe_int128_overflowing_sub(const struct FheInt128 *lhs,
                               const struct FheInt128 *rhs,
                               struct FheInt128 **out_result,
                               struct FheBool **out_overflowed);

int fhe_int128_rem(const struct FheInt128 *lhs,
                   const struct FheInt128 *rhs,
                   struct FheInt128 **result);

int fhe_int128_rem_assign(struct FheInt128 *lhs, const struct FheInt128 *rhs);

int fhe_int128_rotate_left(const struct FheInt128 *lhs,
                           const struct FheUint128 *rhs,
                           struct FheInt128 **result);

int fhe_int128_rotate_left_assign(struct FheInt128 *lhs, const struct FheUint128 *rhs);

int fhe_int128_rotate_right(const struct FheInt128 *lhs,
                            const struct FheUint128 *rhs,
                            struct FheInt128 **result);

int fhe_int128_rotate_right_assign(struct FheInt128 *lhs, const struct FheUint128 *rhs);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int fhe_int128_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                           uint64_t serialized_size_limit,
                                           const struct ServerKey *server_key,
                                           struct FheInt128 **result);

int fhe_int128_safe_serialize(const struct FheInt128 *sself,
                              DynamicBuffer *result,
                              uint64_t serialized_size_limit);

int fhe_int128_scalar_add(const struct FheInt128 *lhs, struct I128 rhs, struct FheInt128 **result);

int fhe_int128_scalar_add_assign(struct FheInt128 *lhs, struct I128 rhs);

int fhe_int128_scalar_bitand(const struct FheInt128 *lhs,
                             struct I128 rhs,
                             struct FheInt128 **result);

int fhe_int128_scalar_bitand_assign(struct FheInt128 *lhs, struct I128 rhs);

int fhe_int128_scalar_bitor(const struct FheInt128 *lhs,
                            struct I128 rhs,
                            struct FheInt128 **result);

int fhe_int128_scalar_bitor_assign(struct FheInt128 *lhs, struct I128 rhs);

int fhe_int128_scalar_bitxor(const struct FheInt128 *lhs,
                             struct I128 rhs,
                             struct FheInt128 **result);

int fhe_int128_scalar_bitxor_assign(struct FheInt128 *lhs, struct I128 rhs);

int fhe_int128_scalar_div(const struct FheInt128 *lhs, struct I128 rhs, struct FheInt128 **result);

int fhe_int128_scalar_div_assign(struct FheInt128 *lhs, struct I128 rhs);

int fhe_int128_scalar_div_rem(const struct FheInt128 *lhs,
                              struct I128 rhs,
                              struct FheInt128 **q_result,
                              struct FheInt128 **r_result);

int fhe_int128_scalar_eq(const struct FheInt128 *lhs, struct I128 rhs, struct FheBool **result);

int fhe_int128_scalar_ge(const struct FheInt128 *lhs, struct I128 rhs, struct FheBool **result);

int fhe_int128_scalar_gt(const struct FheInt128 *lhs, struct I128 rhs, struct FheBool **result);

int fhe_int128_scalar_le(const struct FheInt128 *lhs, struct I128 rhs, struct FheBool **result);

int fhe_int128_scalar_lt(const struct FheInt128 *lhs, struct I128 rhs, struct FheBool **result);

int fhe_int128_scalar_max(const struct FheInt128 *lhs, struct I128 rhs, struct FheInt128 **result);

int fhe_int128_scalar_min(const struct FheInt128 *lhs, struct I128 rhs, struct FheInt128 **result);

int fhe_int128_scalar_mul(const struct FheInt128 *lhs, struct I128 rhs, struct FheInt128 **result);

int fhe_int128_scalar_mul_assign(struct FheInt128 *lhs, struct I128 rhs);

int fhe_int128_scalar_ne(const struct FheInt128 *lhs, struct I128 rhs, struct FheBool **result);

int fhe_int128_scalar_rem(const struct FheInt128 *lhs, struct I128 rhs, struct FheInt128 **result);

int fhe_int128_scalar_rem_assign(struct FheInt128 *lhs, struct I128 rhs);

int fhe_int128_scalar_rotate_left(const struct FheInt128 *lhs,
                                  struct U128 rhs,
                                  struct FheInt128 **result);

int fhe_int128_scalar_rotate_left_assign(struct FheInt128 *lhs, struct U128 rhs);

int fhe_int128_scalar_rotate_right(const struct FheInt128 *lhs,
                                   struct U128 rhs,
                                   struct FheInt128 **result);

int fhe_int128_scalar_rotate_right_assign(struct FheInt128 *lhs, struct U128 rhs);

int fhe_int128_scalar_shl(const struct FheInt128 *lhs, struct U128 rhs, struct FheInt128 **result);

int fhe_int128_scalar_shl_assign(struct FheInt128 *lhs, struct U128 rhs);

int fhe_int128_scalar_shr(const struct FheInt128 *lhs, struct U128 rhs, struct FheInt128 **result);

int fhe_int128_scalar_shr_assign(struct FheInt128 *lhs, struct U128 rhs);

int fhe_int128_scalar_sub(const struct FheInt128 *lhs, struct I128 rhs, struct FheInt128 **result);

int fhe_int128_scalar_sub_assign(struct FheInt128 *lhs, struct I128 rhs);

int fhe_int128_serialize(const struct FheInt128 *sself, DynamicBuffer *result);

int fhe_int128_shl(const struct FheInt128 *lhs,
                   const struct FheUint128 *rhs,
                   struct FheInt128 **result);

int fhe_int128_shl_assign(struct FheInt128 *lhs, const struct FheUint128 *rhs);

int fhe_int128_shr(const struct FheInt128 *lhs,
                   const struct FheUint128 *rhs,
                   struct FheInt128 **result);

int fhe_int128_shr_assign(struct FheInt128 *lhs, const struct FheUint128 *rhs);

int fhe_int128_sub(const struct FheInt128 *lhs,
                   const struct FheInt128 *rhs,
                   struct FheInt128 **result);

int fhe_int128_sub_assign(struct FheInt128 *lhs, const struct FheInt128 *rhs);

int fhe_int128_sum(const struct FheInt128 *const *lhs, size_t len, struct FheInt128 **out_result);

/**
 * Returns the number of trailing ones in the binary representation of input.
 */
int fhe_int128_trailing_ones(const struct FheInt128 *input, struct FheUint32 **result);

/**
 * Returns the number of trailing zeros in the binary representation of input.
 */
int fhe_int128_trailing_zeros(const struct FheInt128 *input, struct FheUint32 **result);

int fhe_int128_try_decrypt_trivial(const struct FheInt128 *encrypted_value, struct I128 *result);

int fhe_int128_try_encrypt_trivial_i128(struct I128 value, struct FheInt128 **result);

int fhe_int128_try_encrypt_with_client_key_i128(struct I128 value,
                                                const struct ClientKey *client_key,
                                                struct FheInt128 **result);

int fhe_int128_try_encrypt_with_compact_public_key_i128(struct I128 value,
                                                        const struct CompactPublicKey *public_key,
                                                        struct FheInt128 **result);

int fhe_int128_try_encrypt_with_public_key_i128(struct I128 value,
                                                const struct PublicKey *public_key,
                                                struct FheInt128 **result);

int fhe_int12_add(const struct FheInt12 *lhs, const struct FheInt12 *rhs, struct FheInt12 **result);

int fhe_int12_add_assign(struct FheInt12 *lhs, const struct FheInt12 *rhs);

int fhe_int12_bitand(const struct FheInt12 *lhs,
                     const struct FheInt12 *rhs,
                     struct FheInt12 **result);

int fhe_int12_bitand_assign(struct FheInt12 *lhs, const struct FheInt12 *rhs);

int fhe_int12_bitor(const struct FheInt12 *lhs,
                    const struct FheInt12 *rhs,
                    struct FheInt12 **result);

int fhe_int12_bitor_assign(struct FheInt12 *lhs, const struct FheInt12 *rhs);

int fhe_int12_bitxor(const struct FheInt12 *lhs,
                     const struct FheInt12 *rhs,
                     struct FheInt12 **result);

int fhe_int12_bitxor_assign(struct FheInt12 *lhs, const struct FheInt12 *rhs);

int fhe_int12_cast_into_fhe_int10(const struct FheInt12 *sself, struct FheInt10 **result);

int fhe_int12_cast_into_fhe_int12(const struct FheInt12 *sself, struct FheInt12 **result);

int fhe_int12_cast_into_fhe_int128(const struct FheInt12 *sself, struct FheInt128 **result);

int fhe_int12_cast_into_fhe_int14(const struct FheInt12 *sself, struct FheInt14 **result);

int fhe_int12_cast_into_fhe_int16(const struct FheInt12 *sself, struct FheInt16 **result);

int fhe_int12_cast_into_fhe_int160(const struct FheInt12 *sself, struct FheInt160 **result);

int fhe_int12_cast_into_fhe_int2(const struct FheInt12 *sself, struct FheInt2 **result);

int fhe_int12_cast_into_fhe_int256(const struct FheInt12 *sself, struct FheInt256 **result);

int fhe_int12_cast_into_fhe_int32(const struct FheInt12 *sself, struct FheInt32 **result);

int fhe_int12_cast_into_fhe_int4(const struct FheInt12 *sself, struct FheInt4 **result);

int fhe_int12_cast_into_fhe_int6(const struct FheInt12 *sself, struct FheInt6 **result);

int fhe_int12_cast_into_fhe_int64(const struct FheInt12 *sself, struct FheInt64 **result);

int fhe_int12_cast_into_fhe_int8(const struct FheInt12 *sself, struct FheInt8 **result);

int fhe_int12_cast_into_fhe_uint10(const struct FheInt12 *sself, struct FheUint10 **result);

int fhe_int12_cast_into_fhe_uint128(const struct FheInt12 *sself, struct FheUint128 **result);

int fhe_int12_cast_into_fhe_uint14(const struct FheInt12 *sself, struct FheUint14 **result);

int fhe_int12_cast_into_fhe_uint16(const struct FheInt12 *sself, struct FheUint16 **result);

int fhe_int12_cast_into_fhe_uint160(const struct FheInt12 *sself, struct FheUint160 **result);

int fhe_int12_cast_into_fhe_uint2(const struct FheInt12 *sself, struct FheUint2 **result);

int fhe_int12_cast_into_fhe_uint256(const struct FheInt12 *sself, struct FheUint256 **result);

int fhe_int12_cast_into_fhe_uint32(const struct FheInt12 *sself, struct FheUint32 **result);

int fhe_int12_cast_into_fhe_uint4(const struct FheInt12 *sself, struct FheUint4 **result);

int fhe_int12_cast_into_fhe_uint6(const struct FheInt12 *sself, struct FheUint6 **result);

int fhe_int12_cast_into_fhe_uint64(const struct FheInt12 *sself, struct FheUint64 **result);

int fhe_int12_cast_into_fhe_uint8(const struct FheInt12 *sself, struct FheUint8 **result);

/**
 * Returns the base 2 logarithm of the number, rounded down.
 *
 * Also returns a boolean flag that is true if the result is valid (i.e input was > 0)
 */
int fhe_int12_checked_ilog2(const struct FheInt12 *input,
                            struct FheUint32 **result_1,
                            struct FheBool **result_2);

int fhe_int12_clone(const struct FheInt12 *sself, struct FheInt12 **result);

int fhe_int12_compress(const struct FheInt12 *sself, struct CompressedFheInt12 **result);

int fhe_int12_decrypt(const struct FheInt12 *encrypted_value,
                      const struct ClientKey *client_key,
                      int16_t *result);

int fhe_int12_deserialize(DynamicBufferView buffer_view, struct FheInt12 **result);

/**
 *ptr can be null (no-op in that case)
 */
int fhe_int12_destroy(struct FheInt12 *ptr);

int fhe_int12_div(const struct FheInt12 *lhs, const struct FheInt12 *rhs, struct FheInt12 **result);

int fhe_int12_div_assign(struct FheInt12 *lhs, const struct FheInt12 *rhs);

int fhe_int12_div_rem(const struct FheInt12 *lhs,
                      const struct FheInt12 *rhs,
                      struct FheInt12 **q_result,
                      struct FheInt12 **r_result);

int fhe_int12_eq(const struct FheInt12 *lhs, const struct FheInt12 *rhs, struct FheBool **result);

int fhe_int12_ge(const struct FheInt12 *lhs, const struct FheInt12 *rhs, struct FheBool **result);

int fhe_int12_gt(const struct FheInt12 *lhs, const struct FheInt12 *rhs, struct FheBool **result);

int fhe_int12_if_then_else(const struct FheBool *condition_ct,
                           const struct FheInt12 *then_ct,
                           const struct FheInt12 *else_ct,
                           struct FheInt12 **result);

/**
 * Returns the base 2 logarithm of the number, rounded down.
 *
 * Result has no meaning if self encrypts a value that is <= 0.
 * See `checked_ilog2`
 */
int fhe_int12_ilog2(const struct FheInt12 *input, struct FheUint32 **result);

int fhe_int12_le(const struct FheInt12 *lhs, const struct FheInt12 *rhs, struct FheBool **result);

/**
 * Returns the number of leading ones in the binary representation of input.
 */
int fhe_int12_leading_ones(const struct FheInt12 *input, struct FheUint32 **result);

/**
 * Returns the number of leading zeros in the binary representation of input.
 */
int fhe_int12_leading_zeros(const struct FheInt12 *input, struct FheUint32 **result);

int fhe_int12_lt(const struct FheInt12 *lhs, const struct FheInt12 *rhs, struct FheBool **result);

int fhe_int12_max(const struct FheInt12 *lhs, const struct FheInt12 *rhs, struct FheInt12 **result);

int fhe_int12_min(const struct FheInt12 *lhs, const struct FheInt12 *rhs, struct FheInt12 **result);

int fhe_int12_mul(const struct FheInt12 *lhs, const struct FheInt12 *rhs, struct FheInt12 **result);

int fhe_int12_mul_assign(struct FheInt12 *lhs, const struct FheInt12 *rhs);

int fhe_int12_ne(const struct FheInt12 *lhs, const struct FheInt12 *rhs, struct FheBool **result);

int fhe_int12_neg(const struct FheInt12 *input, struct FheInt12 **result);

int fhe_int12_not(const struct FheInt12 *input, struct FheInt12 **result);

int fhe_int12_overflowing_add(const struct FheInt12 *lhs,
                              const struct FheInt12 *rhs,
                              struct FheInt12 **out_result,
                              struct FheBool **out_overflowed);

int fhe_int12_overflowing_mul(const struct FheInt12 *lhs,
                              const struct FheInt12 *rhs,
                              struct FheInt12 **out_result,
                              struct FheBool **out_overflowed);

int fhe_int12_overflowing_sub(const struct FheInt12 *lhs,
                              const struct FheInt12 *rhs,
                              struct FheInt12 **out_result,
                              struct FheBool **out_overflowed);

int fhe_int12_rem(const struct FheInt12 *lhs, const struct FheInt12 *rhs, struct FheInt12 **result);

int fhe_int12_rem_assign(struct FheInt12 *lhs, const struct FheInt12 *rhs);

int fhe_int12_rotate_left(const struct FheInt12 *lhs,
                          const struct FheUint12 *rhs,
                          struct FheInt12 **result);

int fhe_int12_rotate_left_assign(struct FheInt12 *lhs, const struct FheUint12 *rhs);

int fhe_int12_rotate_right(const struct FheInt12 *lhs,
                           const struct FheUint12 *rhs,
                           struct FheInt12 **result);

int fhe_int12_rotate_right_assign(struct FheInt12 *lhs, const struct FheUint12 *rhs);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int fhe_int12_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                          uint64_t serialized_size_limit,
                                          const struct ServerKey *server_key,
                                          struct FheInt12 **result);

int fhe_int12_safe_serialize(const struct FheInt12 *sself,
                             DynamicBuffer *result,
                             uint64_t serialized_size_limit);

int fhe_int12_scalar_add(const struct FheInt12 *lhs, int16_t rhs, struct FheInt12 **result);

int fhe_int12_scalar_add_assign(struct FheInt12 *lhs, int16_t rhs);

int fhe_int12_scalar_bitand(const struct FheInt12 *lhs, int16_t rhs, struct FheInt12 **result);

int fhe_int12_scalar_bitand_assign(struct FheInt12 *lhs, int16_t rhs);

int fhe_int12_scalar_bitor(const struct FheInt12 *lhs, int16_t rhs, struct FheInt12 **result);

int fhe_int12_scalar_bitor_assign(struct FheInt12 *lhs, int16_t rhs);

int fhe_int12_scalar_bitxor(const struct FheInt12 *lhs, int16_t rhs, struct FheInt12 **result);

int fhe_int12_scalar_bitxor_assign(struct FheInt12 *lhs, int16_t rhs);

int fhe_int12_scalar_div(const struct FheInt12 *lhs, int16_t rhs, struct FheInt12 **result);

int fhe_int12_scalar_div_assign(struct FheInt12 *lhs, int16_t rhs);

int fhe_int12_scalar_div_rem(const struct FheInt12 *lhs,
                             int16_t rhs,
                             struct FheInt12 **q_result,
                             struct FheInt12 **r_result);

int fhe_int12_scalar_eq(const struct FheInt12 *lhs, int16_t rhs, struct FheBool **result);

int fhe_int12_scalar_ge(const struct FheInt12 *lhs, int16_t rhs, struct FheBool **result);

int fhe_int12_scalar_gt(const struct FheInt12 *lhs, int16_t rhs, struct FheBool **result);

int fhe_int12_scalar_le(const struct FheInt12 *lhs, int16_t rhs, struct FheBool **result);

int fhe_int12_scalar_lt(const struct FheInt12 *lhs, int16_t rhs, struct FheBool **result);

int fhe_int12_scalar_max(const struct FheInt12 *lhs, int16_t rhs, struct FheInt12 **result);

int fhe_int12_scalar_min(const struct FheInt12 *lhs, int16_t rhs, struct FheInt12 **result);

int fhe_int12_scalar_mul(const struct FheInt12 *lhs, int16_t rhs, struct FheInt12 **result);

int fhe_int12_scalar_mul_assign(struct FheInt12 *lhs, int16_t rhs);

int fhe_int12_scalar_ne(const struct FheInt12 *lhs, int16_t rhs, struct FheBool **result);

int fhe_int12_scalar_rem(const struct FheInt12 *lhs, int16_t rhs, struct FheInt12 **result);

int fhe_int12_scalar_rem_assign(struct FheInt12 *lhs, int16_t rhs);

int fhe_int12_scalar_rotate_left(const struct FheInt12 *lhs,
                                 uint16_t rhs,
                                 struct FheInt12 **result);

int fhe_int12_scalar_rotate_left_assign(struct FheInt12 *lhs, uint16_t rhs);

int fhe_int12_scalar_rotate_right(const struct FheInt12 *lhs,
                                  uint16_t rhs,
                                  struct FheInt12 **result);

int fhe_int12_scalar_rotate_right_assign(struct FheInt12 *lhs, uint16_t rhs);

int fhe_int12_scalar_shl(const struct FheInt12 *lhs, uint16_t rhs, struct FheInt12 **result);

int fhe_int12_scalar_shl_assign(struct FheInt12 *lhs, uint16_t rhs);

int fhe_int12_scalar_shr(const struct FheInt12 *lhs, uint16_t rhs, struct FheInt12 **result);

int fhe_int12_scalar_shr_assign(struct FheInt12 *lhs, uint16_t rhs);

int fhe_int12_scalar_sub(const struct FheInt12 *lhs, int16_t rhs, struct FheInt12 **result);

int fhe_int12_scalar_sub_assign(struct FheInt12 *lhs, int16_t rhs);

int fhe_int12_serialize(const struct FheInt12 *sself, DynamicBuffer *result);

int fhe_int12_shl(const struct FheInt12 *lhs,
                  const struct FheUint12 *rhs,
                  struct FheInt12 **result);

int fhe_int12_shl_assign(struct FheInt12 *lhs, const struct FheUint12 *rhs);

int fhe_int12_shr(const struct FheInt12 *lhs,
                  const struct FheUint12 *rhs,
                  struct FheInt12 **result);

int fhe_int12_shr_assign(struct FheInt12 *lhs, const struct FheUint12 *rhs);

int fhe_int12_sub(const struct FheInt12 *lhs, const struct FheInt12 *rhs, struct FheInt12 **result);

int fhe_int12_sub_assign(struct FheInt12 *lhs, const struct FheInt12 *rhs);

int fhe_int12_sum(const struct FheInt12 *const *lhs, size_t len, struct FheInt12 **out_result);

/**
 * Returns the number of trailing ones in the binary representation of input.
 */
int fhe_int12_trailing_ones(const struct FheInt12 *input, struct FheUint32 **result);

/**
 * Returns the number of trailing zeros in the binary representation of input.
 */
int fhe_int12_trailing_zeros(const struct FheInt12 *input, struct FheUint32 **result);

int fhe_int12_try_decrypt_trivial(const struct FheInt12 *encrypted_value, int16_t *result);

int fhe_int12_try_encrypt_trivial_i16(int16_t value, struct FheInt12 **result);

int fhe_int12_try_encrypt_with_client_key_i16(int16_t value,
                                              const struct ClientKey *client_key,
                                              struct FheInt12 **result);

int fhe_int12_try_encrypt_with_compact_public_key_i16(int16_t value,
                                                      const struct CompactPublicKey *public_key,
                                                      struct FheInt12 **result);

int fhe_int12_try_encrypt_with_public_key_i16(int16_t value,
                                              const struct PublicKey *public_key,
                                              struct FheInt12 **result);

int fhe_int14_add(const struct FheInt14 *lhs, const struct FheInt14 *rhs, struct FheInt14 **result);

int fhe_int14_add_assign(struct FheInt14 *lhs, const struct FheInt14 *rhs);

int fhe_int14_bitand(const struct FheInt14 *lhs,
                     const struct FheInt14 *rhs,
                     struct FheInt14 **result);

int fhe_int14_bitand_assign(struct FheInt14 *lhs, const struct FheInt14 *rhs);

int fhe_int14_bitor(const struct FheInt14 *lhs,
                    const struct FheInt14 *rhs,
                    struct FheInt14 **result);

int fhe_int14_bitor_assign(struct FheInt14 *lhs, const struct FheInt14 *rhs);

int fhe_int14_bitxor(const struct FheInt14 *lhs,
                     const struct FheInt14 *rhs,
                     struct FheInt14 **result);

int fhe_int14_bitxor_assign(struct FheInt14 *lhs, const struct FheInt14 *rhs);

int fhe_int14_cast_into_fhe_int10(const struct FheInt14 *sself, struct FheInt10 **result);

int fhe_int14_cast_into_fhe_int12(const struct FheInt14 *sself, struct FheInt12 **result);

int fhe_int14_cast_into_fhe_int128(const struct FheInt14 *sself, struct FheInt128 **result);

int fhe_int14_cast_into_fhe_int14(const struct FheInt14 *sself, struct FheInt14 **result);

int fhe_int14_cast_into_fhe_int16(const struct FheInt14 *sself, struct FheInt16 **result);

int fhe_int14_cast_into_fhe_int160(const struct FheInt14 *sself, struct FheInt160 **result);

int fhe_int14_cast_into_fhe_int2(const struct FheInt14 *sself, struct FheInt2 **result);

int fhe_int14_cast_into_fhe_int256(const struct FheInt14 *sself, struct FheInt256 **result);

int fhe_int14_cast_into_fhe_int32(const struct FheInt14 *sself, struct FheInt32 **result);

int fhe_int14_cast_into_fhe_int4(const struct FheInt14 *sself, struct FheInt4 **result);

int fhe_int14_cast_into_fhe_int6(const struct FheInt14 *sself, struct FheInt6 **result);

int fhe_int14_cast_into_fhe_int64(const struct FheInt14 *sself, struct FheInt64 **result);

int fhe_int14_cast_into_fhe_int8(const struct FheInt14 *sself, struct FheInt8 **result);

int fhe_int14_cast_into_fhe_uint10(const struct FheInt14 *sself, struct FheUint10 **result);

int fhe_int14_cast_into_fhe_uint128(const struct FheInt14 *sself, struct FheUint128 **result);

int fhe_int14_cast_into_fhe_uint14(const struct FheInt14 *sself, struct FheUint14 **result);

int fhe_int14_cast_into_fhe_uint16(const struct FheInt14 *sself, struct FheUint16 **result);

int fhe_int14_cast_into_fhe_uint160(const struct FheInt14 *sself, struct FheUint160 **result);

int fhe_int14_cast_into_fhe_uint2(const struct FheInt14 *sself, struct FheUint2 **result);

int fhe_int14_cast_into_fhe_uint256(const struct FheInt14 *sself, struct FheUint256 **result);

int fhe_int14_cast_into_fhe_uint32(const struct FheInt14 *sself, struct FheUint32 **result);

int fhe_int14_cast_into_fhe_uint4(const struct FheInt14 *sself, struct FheUint4 **result);

int fhe_int14_cast_into_fhe_uint6(const struct FheInt14 *sself, struct FheUint6 **result);

int fhe_int14_cast_into_fhe_uint64(const struct FheInt14 *sself, struct FheUint64 **result);

int fhe_int14_cast_into_fhe_uint8(const struct FheInt14 *sself, struct FheUint8 **result);

/**
 * Returns the base 2 logarithm of the number, rounded down.
 *
 * Also returns a boolean flag that is true if the result is valid (i.e input was > 0)
 */
int fhe_int14_checked_ilog2(const struct FheInt14 *input,
                            struct FheUint32 **result_1,
                            struct FheBool **result_2);

int fhe_int14_clone(const struct FheInt14 *sself, struct FheInt14 **result);

int fhe_int14_compress(const struct FheInt14 *sself, struct CompressedFheInt14 **result);

int fhe_int14_decrypt(const struct FheInt14 *encrypted_value,
                      const struct ClientKey *client_key,
                      int16_t *result);

int fhe_int14_deserialize(DynamicBufferView buffer_view, struct FheInt14 **result);

/**
 *ptr can be null (no-op in that case)
 */
int fhe_int14_destroy(struct FheInt14 *ptr);

int fhe_int14_div(const struct FheInt14 *lhs, const struct FheInt14 *rhs, struct FheInt14 **result);

int fhe_int14_div_assign(struct FheInt14 *lhs, const struct FheInt14 *rhs);

int fhe_int14_div_rem(const struct FheInt14 *lhs,
                      const struct FheInt14 *rhs,
                      struct FheInt14 **q_result,
                      struct FheInt14 **r_result);

int fhe_int14_eq(const struct FheInt14 *lhs, const struct FheInt14 *rhs, struct FheBool **result);

int fhe_int14_ge(const struct FheInt14 *lhs, const struct FheInt14 *rhs, struct FheBool **result);

int fhe_int14_gt(const struct FheInt14 *lhs, const struct FheInt14 *rhs, struct FheBool **result);

int fhe_int14_if_then_else(const struct FheBool *condition_ct,
                           const struct FheInt14 *then_ct,
                           const struct FheInt14 *else_ct,
                           struct FheInt14 **result);

/**
 * Returns the base 2 logarithm of the number, rounded down.
 *
 * Result has no meaning if self encrypts a value that is <= 0.
 * See `checked_ilog2`
 */
int fhe_int14_ilog2(const struct FheInt14 *input, struct FheUint32 **result);

int fhe_int14_le(const struct FheInt14 *lhs, const struct FheInt14 *rhs, struct FheBool **result);

/**
 * Returns the number of leading ones in the binary representation of input.
 */
int fhe_int14_leading_ones(const struct FheInt14 *input, struct FheUint32 **result);

/**
 * Returns the number of leading zeros in the binary representation of input.
 */
int fhe_int14_leading_zeros(const struct FheInt14 *input, struct FheUint32 **result);

int fhe_int14_lt(const struct FheInt14 *lhs, const struct FheInt14 *rhs, struct FheBool **result);

int fhe_int14_max(const struct FheInt14 *lhs, const struct FheInt14 *rhs, struct FheInt14 **result);

int fhe_int14_min(const struct FheInt14 *lhs, const struct FheInt14 *rhs, struct FheInt14 **result);

int fhe_int14_mul(const struct FheInt14 *lhs, const struct FheInt14 *rhs, struct FheInt14 **result);

int fhe_int14_mul_assign(struct FheInt14 *lhs, const struct FheInt14 *rhs);

int fhe_int14_ne(const struct FheInt14 *lhs, const struct FheInt14 *rhs, struct FheBool **result);

int fhe_int14_neg(const struct FheInt14 *input, struct FheInt14 **result);

int fhe_int14_not(const struct FheInt14 *input, struct FheInt14 **result);

int fhe_int14_overflowing_add(const struct FheInt14 *lhs,
                              const struct FheInt14 *rhs,
                              struct FheInt14 **out_result,
                              struct FheBool **out_overflowed);

int fhe_int14_overflowing_mul(const struct FheInt14 *lhs,
                              const struct FheInt14 *rhs,
                              struct FheInt14 **out_result,
                              struct FheBool **out_overflowed);

int fhe_int14_overflowing_sub(const struct FheInt14 *lhs,
                              const struct FheInt14 *rhs,
                              struct FheInt14 **out_result,
                              struct FheBool **out_overflowed);

int fhe_int14_rem(const struct FheInt14 *lhs, const struct FheInt14 *rhs, struct FheInt14 **result);

int fhe_int14_rem_assign(struct FheInt14 *lhs, const struct FheInt14 *rhs);

int fhe_int14_rotate_left(const struct FheInt14 *lhs,
                          const struct FheUint14 *rhs,
                          struct FheInt14 **result);

int fhe_int14_rotate_left_assign(struct FheInt14 *lhs, const struct FheUint14 *rhs);

int fhe_int14_rotate_right(const struct FheInt14 *lhs,
                           const struct FheUint14 *rhs,
                           struct FheInt14 **result);

int fhe_int14_rotate_right_assign(struct FheInt14 *lhs, const struct FheUint14 *rhs);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int fhe_int14_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                          uint64_t serialized_size_limit,
                                          const struct ServerKey *server_key,
                                          struct FheInt14 **result);

int fhe_int14_safe_serialize(const struct FheInt14 *sself,
                             DynamicBuffer *result,
                             uint64_t serialized_size_limit);

int fhe_int14_scalar_add(const struct FheInt14 *lhs, int16_t rhs, struct FheInt14 **result);

int fhe_int14_scalar_add_assign(struct FheInt14 *lhs, int16_t rhs);

int fhe_int14_scalar_bitand(const struct FheInt14 *lhs, int16_t rhs, struct FheInt14 **result);

int fhe_int14_scalar_bitand_assign(struct FheInt14 *lhs, int16_t rhs);

int fhe_int14_scalar_bitor(const struct FheInt14 *lhs, int16_t rhs, struct FheInt14 **result);

int fhe_int14_scalar_bitor_assign(struct FheInt14 *lhs, int16_t rhs);

int fhe_int14_scalar_bitxor(const struct FheInt14 *lhs, int16_t rhs, struct FheInt14 **result);

int fhe_int14_scalar_bitxor_assign(struct FheInt14 *lhs, int16_t rhs);

int fhe_int14_scalar_div(const struct FheInt14 *lhs, int16_t rhs, struct FheInt14 **result);

int fhe_int14_scalar_div_assign(struct FheInt14 *lhs, int16_t rhs);

int fhe_int14_scalar_div_rem(const struct FheInt14 *lhs,
                             int16_t rhs,
                             struct FheInt14 **q_result,
                             struct FheInt14 **r_result);

int fhe_int14_scalar_eq(const struct FheInt14 *lhs, int16_t rhs, struct FheBool **result);

int fhe_int14_scalar_ge(const struct FheInt14 *lhs, int16_t rhs, struct FheBool **result);

int fhe_int14_scalar_gt(const struct FheInt14 *lhs, int16_t rhs, struct FheBool **result);

int fhe_int14_scalar_le(const struct FheInt14 *lhs, int16_t rhs, struct FheBool **result);

int fhe_int14_scalar_lt(const struct FheInt14 *lhs, int16_t rhs, struct FheBool **result);

int fhe_int14_scalar_max(const struct FheInt14 *lhs, int16_t rhs, struct FheInt14 **result);

int fhe_int14_scalar_min(const struct FheInt14 *lhs, int16_t rhs, struct FheInt14 **result);

int fhe_int14_scalar_mul(const struct FheInt14 *lhs, int16_t rhs, struct FheInt14 **result);

int fhe_int14_scalar_mul_assign(struct FheInt14 *lhs, int16_t rhs);

int fhe_int14_scalar_ne(const struct FheInt14 *lhs, int16_t rhs, struct FheBool **result);

int fhe_int14_scalar_rem(const struct FheInt14 *lhs, int16_t rhs, struct FheInt14 **result);

int fhe_int14_scalar_rem_assign(struct FheInt14 *lhs, int16_t rhs);

int fhe_int14_scalar_rotate_left(const struct FheInt14 *lhs,
                                 uint16_t rhs,
                                 struct FheInt14 **result);

int fhe_int14_scalar_rotate_left_assign(struct FheInt14 *lhs, uint16_t rhs);

int fhe_int14_scalar_rotate_right(const struct FheInt14 *lhs,
                                  uint16_t rhs,
                                  struct FheInt14 **result);

int fhe_int14_scalar_rotate_right_assign(struct FheInt14 *lhs, uint16_t rhs);

int fhe_int14_scalar_shl(const struct FheInt14 *lhs, uint16_t rhs, struct FheInt14 **result);

int fhe_int14_scalar_shl_assign(struct FheInt14 *lhs, uint16_t rhs);

int fhe_int14_scalar_shr(const struct FheInt14 *lhs, uint16_t rhs, struct FheInt14 **result);

int fhe_int14_scalar_shr_assign(struct FheInt14 *lhs, uint16_t rhs);

int fhe_int14_scalar_sub(const struct FheInt14 *lhs, int16_t rhs, struct FheInt14 **result);

int fhe_int14_scalar_sub_assign(struct FheInt14 *lhs, int16_t rhs);

int fhe_int14_serialize(const struct FheInt14 *sself, DynamicBuffer *result);

int fhe_int14_shl(const struct FheInt14 *lhs,
                  const struct FheUint14 *rhs,
                  struct FheInt14 **result);

int fhe_int14_shl_assign(struct FheInt14 *lhs, const struct FheUint14 *rhs);

int fhe_int14_shr(const struct FheInt14 *lhs,
                  const struct FheUint14 *rhs,
                  struct FheInt14 **result);

int fhe_int14_shr_assign(struct FheInt14 *lhs, const struct FheUint14 *rhs);

int fhe_int14_sub(const struct FheInt14 *lhs, const struct FheInt14 *rhs, struct FheInt14 **result);

int fhe_int14_sub_assign(struct FheInt14 *lhs, const struct FheInt14 *rhs);

int fhe_int14_sum(const struct FheInt14 *const *lhs, size_t len, struct FheInt14 **out_result);

/**
 * Returns the number of trailing ones in the binary representation of input.
 */
int fhe_int14_trailing_ones(const struct FheInt14 *input, struct FheUint32 **result);

/**
 * Returns the number of trailing zeros in the binary representation of input.
 */
int fhe_int14_trailing_zeros(const struct FheInt14 *input, struct FheUint32 **result);

int fhe_int14_try_decrypt_trivial(const struct FheInt14 *encrypted_value, int16_t *result);

int fhe_int14_try_encrypt_trivial_i16(int16_t value, struct FheInt14 **result);

int fhe_int14_try_encrypt_with_client_key_i16(int16_t value,
                                              const struct ClientKey *client_key,
                                              struct FheInt14 **result);

int fhe_int14_try_encrypt_with_compact_public_key_i16(int16_t value,
                                                      const struct CompactPublicKey *public_key,
                                                      struct FheInt14 **result);

int fhe_int14_try_encrypt_with_public_key_i16(int16_t value,
                                              const struct PublicKey *public_key,
                                              struct FheInt14 **result);

int fhe_int160_add(const struct FheInt160 *lhs,
                   const struct FheInt160 *rhs,
                   struct FheInt160 **result);

int fhe_int160_add_assign(struct FheInt160 *lhs, const struct FheInt160 *rhs);

int fhe_int160_bitand(const struct FheInt160 *lhs,
                      const struct FheInt160 *rhs,
                      struct FheInt160 **result);

int fhe_int160_bitand_assign(struct FheInt160 *lhs, const struct FheInt160 *rhs);

int fhe_int160_bitor(const struct FheInt160 *lhs,
                     const struct FheInt160 *rhs,
                     struct FheInt160 **result);

int fhe_int160_bitor_assign(struct FheInt160 *lhs, const struct FheInt160 *rhs);

int fhe_int160_bitxor(const struct FheInt160 *lhs,
                      const struct FheInt160 *rhs,
                      struct FheInt160 **result);

int fhe_int160_bitxor_assign(struct FheInt160 *lhs, const struct FheInt160 *rhs);

int fhe_int160_cast_into_fhe_int10(const struct FheInt160 *sself, struct FheInt10 **result);

int fhe_int160_cast_into_fhe_int12(const struct FheInt160 *sself, struct FheInt12 **result);

int fhe_int160_cast_into_fhe_int128(const struct FheInt160 *sself, struct FheInt128 **result);

int fhe_int160_cast_into_fhe_int14(const struct FheInt160 *sself, struct FheInt14 **result);

int fhe_int160_cast_into_fhe_int16(const struct FheInt160 *sself, struct FheInt16 **result);

int fhe_int160_cast_into_fhe_int160(const struct FheInt160 *sself, struct FheInt160 **result);

int fhe_int160_cast_into_fhe_int2(const struct FheInt160 *sself, struct FheInt2 **result);

int fhe_int160_cast_into_fhe_int256(const struct FheInt160 *sself, struct FheInt256 **result);

int fhe_int160_cast_into_fhe_int32(const struct FheInt160 *sself, struct FheInt32 **result);

int fhe_int160_cast_into_fhe_int4(const struct FheInt160 *sself, struct FheInt4 **result);

int fhe_int160_cast_into_fhe_int6(const struct FheInt160 *sself, struct FheInt6 **result);

int fhe_int160_cast_into_fhe_int64(const struct FheInt160 *sself, struct FheInt64 **result);

int fhe_int160_cast_into_fhe_int8(const struct FheInt160 *sself, struct FheInt8 **result);

int fhe_int160_cast_into_fhe_uint10(const struct FheInt160 *sself, struct FheUint10 **result);

int fhe_int160_cast_into_fhe_uint128(const struct FheInt160 *sself, struct FheUint128 **result);

int fhe_int160_cast_into_fhe_uint14(const struct FheInt160 *sself, struct FheUint14 **result);

int fhe_int160_cast_into_fhe_uint16(const struct FheInt160 *sself, struct FheUint16 **result);

int fhe_int160_cast_into_fhe_uint160(const struct FheInt160 *sself, struct FheUint160 **result);

int fhe_int160_cast_into_fhe_uint2(const struct FheInt160 *sself, struct FheUint2 **result);

int fhe_int160_cast_into_fhe_uint256(const struct FheInt160 *sself, struct FheUint256 **result);

int fhe_int160_cast_into_fhe_uint32(const struct FheInt160 *sself, struct FheUint32 **result);

int fhe_int160_cast_into_fhe_uint4(const struct FheInt160 *sself, struct FheUint4 **result);

int fhe_int160_cast_into_fhe_uint6(const struct FheInt160 *sself, struct FheUint6 **result);

int fhe_int160_cast_into_fhe_uint64(const struct FheInt160 *sself, struct FheUint64 **result);

int fhe_int160_cast_into_fhe_uint8(const struct FheInt160 *sself, struct FheUint8 **result);

/**
 * Returns the base 2 logarithm of the number, rounded down.
 *
 * Also returns a boolean flag that is true if the result is valid (i.e input was > 0)
 */
int fhe_int160_checked_ilog2(const struct FheInt160 *input,
                             struct FheUint32 **result_1,
                             struct FheBool **result_2);

int fhe_int160_clone(const struct FheInt160 *sself, struct FheInt160 **result);

int fhe_int160_compress(const struct FheInt160 *sself, struct CompressedFheInt160 **result);

int fhe_int160_decrypt(const struct FheInt160 *encrypted_value,
                       const struct ClientKey *client_key,
                       struct I256 *result);

int fhe_int160_deserialize(DynamicBufferView buffer_view, struct FheInt160 **result);

/**
 *ptr can be null (no-op in that case)
 */
int fhe_int160_destroy(struct FheInt160 *ptr);

int fhe_int160_div(const struct FheInt160 *lhs,
                   const struct FheInt160 *rhs,
                   struct FheInt160 **result);

int fhe_int160_div_assign(struct FheInt160 *lhs, const struct FheInt160 *rhs);

int fhe_int160_div_rem(const struct FheInt160 *lhs,
                       const struct FheInt160 *rhs,
                       struct FheInt160 **q_result,
                       struct FheInt160 **r_result);

int fhe_int160_eq(const struct FheInt160 *lhs,
                  const struct FheInt160 *rhs,
                  struct FheBool **result);

int fhe_int160_ge(const struct FheInt160 *lhs,
                  const struct FheInt160 *rhs,
                  struct FheBool **result);

int fhe_int160_gt(const struct FheInt160 *lhs,
                  const struct FheInt160 *rhs,
                  struct FheBool **result);

int fhe_int160_if_then_else(const struct FheBool *condition_ct,
                            const struct FheInt160 *then_ct,
                            const struct FheInt160 *else_ct,
                            struct FheInt160 **result);

/**
 * Returns the base 2 logarithm of the number, rounded down.
 *
 * Result has no meaning if self encrypts a value that is <= 0.
 * See `checked_ilog2`
 */
int fhe_int160_ilog2(const struct FheInt160 *input, struct FheUint32 **result);

int fhe_int160_le(const struct FheInt160 *lhs,
                  const struct FheInt160 *rhs,
                  struct FheBool **result);

/**
 * Returns the number of leading ones in the binary representation of input.
 */
int fhe_int160_leading_ones(const struct FheInt160 *input, struct FheUint32 **result);

/**
 * Returns the number of leading zeros in the binary representation of input.
 */
int fhe_int160_leading_zeros(const struct FheInt160 *input, struct FheUint32 **result);

int fhe_int160_lt(const struct FheInt160 *lhs,
                  const struct FheInt160 *rhs,
                  struct FheBool **result);

int fhe_int160_max(const struct FheInt160 *lhs,
                   const struct FheInt160 *rhs,
                   struct FheInt160 **result);

int fhe_int160_min(const struct FheInt160 *lhs,
                   const struct FheInt160 *rhs,
                   struct FheInt160 **result);

int fhe_int160_mul(const struct FheInt160 *lhs,
                   const struct FheInt160 *rhs,
                   struct FheInt160 **result);

int fhe_int160_mul_assign(struct FheInt160 *lhs, const struct FheInt160 *rhs);

int fhe_int160_ne(const struct FheInt160 *lhs,
                  const struct FheInt160 *rhs,
                  struct FheBool **result);

int fhe_int160_neg(const struct FheInt160 *input, struct FheInt160 **result);

int fhe_int160_not(const struct FheInt160 *input, struct FheInt160 **result);

int fhe_int160_overflowing_add(const struct FheInt160 *lhs,
                               const struct FheInt160 *rhs,
                               struct FheInt160 **out_result,
                               struct FheBool **out_overflowed);

int fhe_int160_overflowing_mul(const struct FheInt160 *lhs,
                               const struct FheInt160 *rhs,
                               struct FheInt160 **out_result,
                               struct FheBool **out_overflowed);

int fhe_int160_overflowing_sub(const struct FheInt160 *lhs,
                               const struct FheInt160 *rhs,
                               struct FheInt160 **out_result,
                               struct FheBool **out_overflowed);

int fhe_int160_rem(const struct FheInt160 *lhs,
                   const struct FheInt160 *rhs,
                   struct FheInt160 **result);

int fhe_int160_rem_assign(struct FheInt160 *lhs, const struct FheInt160 *rhs);

int fhe_int160_rotate_left(const struct FheInt160 *lhs,
                           const struct FheUint160 *rhs,
                           struct FheInt160 **result);

int fhe_int160_rotate_left_assign(struct FheInt160 *lhs, const struct FheUint160 *rhs);

int fhe_int160_rotate_right(const struct FheInt160 *lhs,
                            const struct FheUint160 *rhs,
                            struct FheInt160 **result);

int fhe_int160_rotate_right_assign(struct FheInt160 *lhs, const struct FheUint160 *rhs);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int fhe_int160_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                           uint64_t serialized_size_limit,
                                           const struct ServerKey *server_key,
                                           struct FheInt160 **result);

int fhe_int160_safe_serialize(const struct FheInt160 *sself,
                              DynamicBuffer *result,
                              uint64_t serialized_size_limit);

int fhe_int160_scalar_add(const struct FheInt160 *lhs, struct I256 rhs, struct FheInt160 **result);

int fhe_int160_scalar_add_assign(struct FheInt160 *lhs, struct I256 rhs);

int fhe_int160_scalar_bitand(const struct FheInt160 *lhs,
                             struct I256 rhs,
                             struct FheInt160 **result);

int fhe_int160_scalar_bitand_assign(struct FheInt160 *lhs, struct I256 rhs);

int fhe_int160_scalar_bitor(const struct FheInt160 *lhs,
                            struct I256 rhs,
                            struct FheInt160 **result);

int fhe_int160_scalar_bitor_assign(struct FheInt160 *lhs, struct I256 rhs);

int fhe_int160_scalar_bitxor(const struct FheInt160 *lhs,
                             struct I256 rhs,
                             struct FheInt160 **result);

int fhe_int160_scalar_bitxor_assign(struct FheInt160 *lhs, struct I256 rhs);

int fhe_int160_scalar_div(const struct FheInt160 *lhs, struct I256 rhs, struct FheInt160 **result);

int fhe_int160_scalar_div_assign(struct FheInt160 *lhs, struct I256 rhs);

int fhe_int160_scalar_div_rem(const struct FheInt160 *lhs,
                              struct I256 rhs,
                              struct FheInt160 **q_result,
                              struct FheInt160 **r_result);

int fhe_int160_scalar_eq(const struct FheInt160 *lhs, struct I256 rhs, struct FheBool **result);

int fhe_int160_scalar_ge(const struct FheInt160 *lhs, struct I256 rhs, struct FheBool **result);

int fhe_int160_scalar_gt(const struct FheInt160 *lhs, struct I256 rhs, struct FheBool **result);

int fhe_int160_scalar_le(const struct FheInt160 *lhs, struct I256 rhs, struct FheBool **result);

int fhe_int160_scalar_lt(const struct FheInt160 *lhs, struct I256 rhs, struct FheBool **result);

int fhe_int160_scalar_max(const struct FheInt160 *lhs, struct I256 rhs, struct FheInt160 **result);

int fhe_int160_scalar_min(const struct FheInt160 *lhs, struct I256 rhs, struct FheInt160 **result);

int fhe_int160_scalar_mul(const struct FheInt160 *lhs, struct I256 rhs, struct FheInt160 **result);

int fhe_int160_scalar_mul_assign(struct FheInt160 *lhs, struct I256 rhs);

int fhe_int160_scalar_ne(const struct FheInt160 *lhs, struct I256 rhs, struct FheBool **result);

int fhe_int160_scalar_rem(const struct FheInt160 *lhs, struct I256 rhs, struct FheInt160 **result);

int fhe_int160_scalar_rem_assign(struct FheInt160 *lhs, struct I256 rhs);

int fhe_int160_scalar_rotate_left(const struct FheInt160 *lhs,
                                  struct U256 rhs,
                                  struct FheInt160 **result);

int fhe_int160_scalar_rotate_left_assign(struct FheInt160 *lhs, struct U256 rhs);

int fhe_int160_scalar_rotate_right(const struct FheInt160 *lhs,
                                   struct U256 rhs,
                                   struct FheInt160 **result);

int fhe_int160_scalar_rotate_right_assign(struct FheInt160 *lhs, struct U256 rhs);

int fhe_int160_scalar_shl(const struct FheInt160 *lhs, struct U256 rhs, struct FheInt160 **result);

int fhe_int160_scalar_shl_assign(struct FheInt160 *lhs, struct U256 rhs);

int fhe_int160_scalar_shr(const struct FheInt160 *lhs, struct U256 rhs, struct FheInt160 **result);

int fhe_int160_scalar_shr_assign(struct FheInt160 *lhs, struct U256 rhs);

int fhe_int160_scalar_sub(const struct FheInt160 *lhs, struct I256 rhs, struct FheInt160 **result);

int fhe_int160_scalar_sub_assign(struct FheInt160 *lhs, struct I256 rhs);

int fhe_int160_serialize(const struct FheInt160 *sself, DynamicBuffer *result);

int fhe_int160_shl(const struct FheInt160 *lhs,
                   const struct FheUint160 *rhs,
                   struct FheInt160 **result);

int fhe_int160_shl_assign(struct FheInt160 *lhs, const struct FheUint160 *rhs);

int fhe_int160_shr(const struct FheInt160 *lhs,
                   const struct FheUint160 *rhs,
                   struct FheInt160 **result);

int fhe_int160_shr_assign(struct FheInt160 *lhs, const struct FheUint160 *rhs);

int fhe_int160_sub(const struct FheInt160 *lhs,
                   const struct FheInt160 *rhs,
                   struct FheInt160 **result);

int fhe_int160_sub_assign(struct FheInt160 *lhs, const struct FheInt160 *rhs);

int fhe_int160_sum(const struct FheInt160 *const *lhs, size_t len, struct FheInt160 **out_result);

/**
 * Returns the number of trailing ones in the binary representation of input.
 */
int fhe_int160_trailing_ones(const struct FheInt160 *input, struct FheUint32 **result);

/**
 * Returns the number of trailing zeros in the binary representation of input.
 */
int fhe_int160_trailing_zeros(const struct FheInt160 *input, struct FheUint32 **result);

int fhe_int160_try_decrypt_trivial(const struct FheInt160 *encrypted_value, struct I256 *result);

int fhe_int160_try_encrypt_trivial_i256(struct I256 value, struct FheInt160 **result);

int fhe_int160_try_encrypt_with_client_key_i256(struct I256 value,
                                                const struct ClientKey *client_key,
                                                struct FheInt160 **result);

int fhe_int160_try_encrypt_with_compact_public_key_i256(struct I256 value,
                                                        const struct CompactPublicKey *public_key,
                                                        struct FheInt160 **result);

int fhe_int160_try_encrypt_with_public_key_i256(struct I256 value,
                                                const struct PublicKey *public_key,
                                                struct FheInt160 **result);

int fhe_int16_add(const struct FheInt16 *lhs, const struct FheInt16 *rhs, struct FheInt16 **result);

int fhe_int16_add_assign(struct FheInt16 *lhs, const struct FheInt16 *rhs);

int fhe_int16_bitand(const struct FheInt16 *lhs,
                     const struct FheInt16 *rhs,
                     struct FheInt16 **result);

int fhe_int16_bitand_assign(struct FheInt16 *lhs, const struct FheInt16 *rhs);

int fhe_int16_bitor(const struct FheInt16 *lhs,
                    const struct FheInt16 *rhs,
                    struct FheInt16 **result);

int fhe_int16_bitor_assign(struct FheInt16 *lhs, const struct FheInt16 *rhs);

int fhe_int16_bitxor(const struct FheInt16 *lhs,
                     const struct FheInt16 *rhs,
                     struct FheInt16 **result);

int fhe_int16_bitxor_assign(struct FheInt16 *lhs, const struct FheInt16 *rhs);

int fhe_int16_cast_into_fhe_int10(const struct FheInt16 *sself, struct FheInt10 **result);

int fhe_int16_cast_into_fhe_int12(const struct FheInt16 *sself, struct FheInt12 **result);

int fhe_int16_cast_into_fhe_int128(const struct FheInt16 *sself, struct FheInt128 **result);

int fhe_int16_cast_into_fhe_int14(const struct FheInt16 *sself, struct FheInt14 **result);

int fhe_int16_cast_into_fhe_int16(const struct FheInt16 *sself, struct FheInt16 **result);

int fhe_int16_cast_into_fhe_int160(const struct FheInt16 *sself, struct FheInt160 **result);

int fhe_int16_cast_into_fhe_int2(const struct FheInt16 *sself, struct FheInt2 **result);

int fhe_int16_cast_into_fhe_int256(const struct FheInt16 *sself, struct FheInt256 **result);

int fhe_int16_cast_into_fhe_int32(const struct FheInt16 *sself, struct FheInt32 **result);

int fhe_int16_cast_into_fhe_int4(const struct FheInt16 *sself, struct FheInt4 **result);

int fhe_int16_cast_into_fhe_int6(const struct FheInt16 *sself, struct FheInt6 **result);

int fhe_int16_cast_into_fhe_int64(const struct FheInt16 *sself, struct FheInt64 **result);

int fhe_int16_cast_into_fhe_int8(const struct FheInt16 *sself, struct FheInt8 **result);

int fhe_int16_cast_into_fhe_uint10(const struct FheInt16 *sself, struct FheUint10 **result);

int fhe_int16_cast_into_fhe_uint128(const struct FheInt16 *sself, struct FheUint128 **result);

int fhe_int16_cast_into_fhe_uint14(const struct FheInt16 *sself, struct FheUint14 **result);

int fhe_int16_cast_into_fhe_uint16(const struct FheInt16 *sself, struct FheUint16 **result);

int fhe_int16_cast_into_fhe_uint160(const struct FheInt16 *sself, struct FheUint160 **result);

int fhe_int16_cast_into_fhe_uint2(const struct FheInt16 *sself, struct FheUint2 **result);

int fhe_int16_cast_into_fhe_uint256(const struct FheInt16 *sself, struct FheUint256 **result);

int fhe_int16_cast_into_fhe_uint32(const struct FheInt16 *sself, struct FheUint32 **result);

int fhe_int16_cast_into_fhe_uint4(const struct FheInt16 *sself, struct FheUint4 **result);

int fhe_int16_cast_into_fhe_uint6(const struct FheInt16 *sself, struct FheUint6 **result);

int fhe_int16_cast_into_fhe_uint64(const struct FheInt16 *sself, struct FheUint64 **result);

int fhe_int16_cast_into_fhe_uint8(const struct FheInt16 *sself, struct FheUint8 **result);

/**
 * Returns the base 2 logarithm of the number, rounded down.
 *
 * Also returns a boolean flag that is true if the result is valid (i.e input was > 0)
 */
int fhe_int16_checked_ilog2(const struct FheInt16 *input,
                            struct FheUint32 **result_1,
                            struct FheBool **result_2);

int fhe_int16_clone(const struct FheInt16 *sself, struct FheInt16 **result);

int fhe_int16_compress(const struct FheInt16 *sself, struct CompressedFheInt16 **result);

int fhe_int16_decrypt(const struct FheInt16 *encrypted_value,
                      const struct ClientKey *client_key,
                      int16_t *result);

int fhe_int16_deserialize(DynamicBufferView buffer_view, struct FheInt16 **result);

/**
 *ptr can be null (no-op in that case)
 */
int fhe_int16_destroy(struct FheInt16 *ptr);

int fhe_int16_div(const struct FheInt16 *lhs, const struct FheInt16 *rhs, struct FheInt16 **result);

int fhe_int16_div_assign(struct FheInt16 *lhs, const struct FheInt16 *rhs);

int fhe_int16_div_rem(const struct FheInt16 *lhs,
                      const struct FheInt16 *rhs,
                      struct FheInt16 **q_result,
                      struct FheInt16 **r_result);

int fhe_int16_eq(const struct FheInt16 *lhs, const struct FheInt16 *rhs, struct FheBool **result);

int fhe_int16_ge(const struct FheInt16 *lhs, const struct FheInt16 *rhs, struct FheBool **result);

int fhe_int16_gt(const struct FheInt16 *lhs, const struct FheInt16 *rhs, struct FheBool **result);

int fhe_int16_if_then_else(const struct FheBool *condition_ct,
                           const struct FheInt16 *then_ct,
                           const struct FheInt16 *else_ct,
                           struct FheInt16 **result);

/**
 * Returns the base 2 logarithm of the number, rounded down.
 *
 * Result has no meaning if self encrypts a value that is <= 0.
 * See `checked_ilog2`
 */
int fhe_int16_ilog2(const struct FheInt16 *input, struct FheUint32 **result);

int fhe_int16_le(const struct FheInt16 *lhs, const struct FheInt16 *rhs, struct FheBool **result);

/**
 * Returns the number of leading ones in the binary representation of input.
 */
int fhe_int16_leading_ones(const struct FheInt16 *input, struct FheUint32 **result);

/**
 * Returns the number of leading zeros in the binary representation of input.
 */
int fhe_int16_leading_zeros(const struct FheInt16 *input, struct FheUint32 **result);

int fhe_int16_lt(const struct FheInt16 *lhs, const struct FheInt16 *rhs, struct FheBool **result);

int fhe_int16_max(const struct FheInt16 *lhs, const struct FheInt16 *rhs, struct FheInt16 **result);

int fhe_int16_min(const struct FheInt16 *lhs, const struct FheInt16 *rhs, struct FheInt16 **result);

int fhe_int16_mul(const struct FheInt16 *lhs, const struct FheInt16 *rhs, struct FheInt16 **result);

int fhe_int16_mul_assign(struct FheInt16 *lhs, const struct FheInt16 *rhs);

int fhe_int16_ne(const struct FheInt16 *lhs, const struct FheInt16 *rhs, struct FheBool **result);

int fhe_int16_neg(const struct FheInt16 *input, struct FheInt16 **result);

int fhe_int16_not(const struct FheInt16 *input, struct FheInt16 **result);

int fhe_int16_overflowing_add(const struct FheInt16 *lhs,
                              const struct FheInt16 *rhs,
                              struct FheInt16 **out_result,
                              struct FheBool **out_overflowed);

int fhe_int16_overflowing_mul(const struct FheInt16 *lhs,
                              const struct FheInt16 *rhs,
                              struct FheInt16 **out_result,
                              struct FheBool **out_overflowed);

int fhe_int16_overflowing_sub(const struct FheInt16 *lhs,
                              const struct FheInt16 *rhs,
                              struct FheInt16 **out_result,
                              struct FheBool **out_overflowed);

int fhe_int16_rem(const struct FheInt16 *lhs, const struct FheInt16 *rhs, struct FheInt16 **result);

int fhe_int16_rem_assign(struct FheInt16 *lhs, const struct FheInt16 *rhs);

int fhe_int16_rotate_left(const struct FheInt16 *lhs,
                          const struct FheUint16 *rhs,
                          struct FheInt16 **result);

int fhe_int16_rotate_left_assign(struct FheInt16 *lhs, const struct FheUint16 *rhs);

int fhe_int16_rotate_right(const struct FheInt16 *lhs,
                           const struct FheUint16 *rhs,
                           struct FheInt16 **result);

int fhe_int16_rotate_right_assign(struct FheInt16 *lhs, const struct FheUint16 *rhs);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int fhe_int16_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                          uint64_t serialized_size_limit,
                                          const struct ServerKey *server_key,
                                          struct FheInt16 **result);

int fhe_int16_safe_serialize(const struct FheInt16 *sself,
                             DynamicBuffer *result,
                             uint64_t serialized_size_limit);

int fhe_int16_scalar_add(const struct FheInt16 *lhs, int16_t rhs, struct FheInt16 **result);

int fhe_int16_scalar_add_assign(struct FheInt16 *lhs, int16_t rhs);

int fhe_int16_scalar_bitand(const struct FheInt16 *lhs, int16_t rhs, struct FheInt16 **result);

int fhe_int16_scalar_bitand_assign(struct FheInt16 *lhs, int16_t rhs);

int fhe_int16_scalar_bitor(const struct FheInt16 *lhs, int16_t rhs, struct FheInt16 **result);

int fhe_int16_scalar_bitor_assign(struct FheInt16 *lhs, int16_t rhs);

int fhe_int16_scalar_bitxor(const struct FheInt16 *lhs, int16_t rhs, struct FheInt16 **result);

int fhe_int16_scalar_bitxor_assign(struct FheInt16 *lhs, int16_t rhs);

int fhe_int16_scalar_div(const struct FheInt16 *lhs, int16_t rhs, struct FheInt16 **result);

int fhe_int16_scalar_div_assign(struct FheInt16 *lhs, int16_t rhs);

int fhe_int16_scalar_div_rem(const struct FheInt16 *lhs,
                             int16_t rhs,
                             struct FheInt16 **q_result,
                             struct FheInt16 **r_result);

int fhe_int16_scalar_eq(const struct FheInt16 *lhs, int16_t rhs, struct FheBool **result);

int fhe_int16_scalar_ge(const struct FheInt16 *lhs, int16_t rhs, struct FheBool **result);

int fhe_int16_scalar_gt(const struct FheInt16 *lhs, int16_t rhs, struct FheBool **result);

int fhe_int16_scalar_le(const struct FheInt16 *lhs, int16_t rhs, struct FheBool **result);

int fhe_int16_scalar_lt(const struct FheInt16 *lhs, int16_t rhs, struct FheBool **result);

int fhe_int16_scalar_max(const struct FheInt16 *lhs, int16_t rhs, struct FheInt16 **result);

int fhe_int16_scalar_min(const struct FheInt16 *lhs, int16_t rhs, struct FheInt16 **result);

int fhe_int16_scalar_mul(const struct FheInt16 *lhs, int16_t rhs, struct FheInt16 **result);

int fhe_int16_scalar_mul_assign(struct FheInt16 *lhs, int16_t rhs);

int fhe_int16_scalar_ne(const struct FheInt16 *lhs, int16_t rhs, struct FheBool **result);

int fhe_int16_scalar_rem(const struct FheInt16 *lhs, int16_t rhs, struct FheInt16 **result);

int fhe_int16_scalar_rem_assign(struct FheInt16 *lhs, int16_t rhs);

int fhe_int16_scalar_rotate_left(const struct FheInt16 *lhs,
                                 uint16_t rhs,
                                 struct FheInt16 **result);

int fhe_int16_scalar_rotate_left_assign(struct FheInt16 *lhs, uint16_t rhs);

int fhe_int16_scalar_rotate_right(const struct FheInt16 *lhs,
                                  uint16_t rhs,
                                  struct FheInt16 **result);

int fhe_int16_scalar_rotate_right_assign(struct FheInt16 *lhs, uint16_t rhs);

int fhe_int16_scalar_shl(const struct FheInt16 *lhs, uint16_t rhs, struct FheInt16 **result);

int fhe_int16_scalar_shl_assign(struct FheInt16 *lhs, uint16_t rhs);

int fhe_int16_scalar_shr(const struct FheInt16 *lhs, uint16_t rhs, struct FheInt16 **result);

int fhe_int16_scalar_shr_assign(struct FheInt16 *lhs, uint16_t rhs);

int fhe_int16_scalar_sub(const struct FheInt16 *lhs, int16_t rhs, struct FheInt16 **result);

int fhe_int16_scalar_sub_assign(struct FheInt16 *lhs, int16_t rhs);

int fhe_int16_serialize(const struct FheInt16 *sself, DynamicBuffer *result);

int fhe_int16_shl(const struct FheInt16 *lhs,
                  const struct FheUint16 *rhs,
                  struct FheInt16 **result);

int fhe_int16_shl_assign(struct FheInt16 *lhs, const struct FheUint16 *rhs);

int fhe_int16_shr(const struct FheInt16 *lhs,
                  const struct FheUint16 *rhs,
                  struct FheInt16 **result);

int fhe_int16_shr_assign(struct FheInt16 *lhs, const struct FheUint16 *rhs);

int fhe_int16_sub(const struct FheInt16 *lhs, const struct FheInt16 *rhs, struct FheInt16 **result);

int fhe_int16_sub_assign(struct FheInt16 *lhs, const struct FheInt16 *rhs);

int fhe_int16_sum(const struct FheInt16 *const *lhs, size_t len, struct FheInt16 **out_result);

/**
 * Returns the number of trailing ones in the binary representation of input.
 */
int fhe_int16_trailing_ones(const struct FheInt16 *input, struct FheUint32 **result);

/**
 * Returns the number of trailing zeros in the binary representation of input.
 */
int fhe_int16_trailing_zeros(const struct FheInt16 *input, struct FheUint32 **result);

int fhe_int16_try_decrypt_trivial(const struct FheInt16 *encrypted_value, int16_t *result);

int fhe_int16_try_encrypt_trivial_i16(int16_t value, struct FheInt16 **result);

int fhe_int16_try_encrypt_with_client_key_i16(int16_t value,
                                              const struct ClientKey *client_key,
                                              struct FheInt16 **result);

int fhe_int16_try_encrypt_with_compact_public_key_i16(int16_t value,
                                                      const struct CompactPublicKey *public_key,
                                                      struct FheInt16 **result);

int fhe_int16_try_encrypt_with_public_key_i16(int16_t value,
                                              const struct PublicKey *public_key,
                                              struct FheInt16 **result);

int fhe_int256_add(const struct FheInt256 *lhs,
                   const struct FheInt256 *rhs,
                   struct FheInt256 **result);

int fhe_int256_add_assign(struct FheInt256 *lhs, const struct FheInt256 *rhs);

int fhe_int256_bitand(const struct FheInt256 *lhs,
                      const struct FheInt256 *rhs,
                      struct FheInt256 **result);

int fhe_int256_bitand_assign(struct FheInt256 *lhs, const struct FheInt256 *rhs);

int fhe_int256_bitor(const struct FheInt256 *lhs,
                     const struct FheInt256 *rhs,
                     struct FheInt256 **result);

int fhe_int256_bitor_assign(struct FheInt256 *lhs, const struct FheInt256 *rhs);

int fhe_int256_bitxor(const struct FheInt256 *lhs,
                      const struct FheInt256 *rhs,
                      struct FheInt256 **result);

int fhe_int256_bitxor_assign(struct FheInt256 *lhs, const struct FheInt256 *rhs);

int fhe_int256_cast_into_fhe_int10(const struct FheInt256 *sself, struct FheInt10 **result);

int fhe_int256_cast_into_fhe_int12(const struct FheInt256 *sself, struct FheInt12 **result);

int fhe_int256_cast_into_fhe_int128(const struct FheInt256 *sself, struct FheInt128 **result);

int fhe_int256_cast_into_fhe_int14(const struct FheInt256 *sself, struct FheInt14 **result);

int fhe_int256_cast_into_fhe_int16(const struct FheInt256 *sself, struct FheInt16 **result);

int fhe_int256_cast_into_fhe_int160(const struct FheInt256 *sself, struct FheInt160 **result);

int fhe_int256_cast_into_fhe_int2(const struct FheInt256 *sself, struct FheInt2 **result);

int fhe_int256_cast_into_fhe_int256(const struct FheInt256 *sself, struct FheInt256 **result);

int fhe_int256_cast_into_fhe_int32(const struct FheInt256 *sself, struct FheInt32 **result);

int fhe_int256_cast_into_fhe_int4(const struct FheInt256 *sself, struct FheInt4 **result);

int fhe_int256_cast_into_fhe_int6(const struct FheInt256 *sself, struct FheInt6 **result);

int fhe_int256_cast_into_fhe_int64(const struct FheInt256 *sself, struct FheInt64 **result);

int fhe_int256_cast_into_fhe_int8(const struct FheInt256 *sself, struct FheInt8 **result);

int fhe_int256_cast_into_fhe_uint10(const struct FheInt256 *sself, struct FheUint10 **result);

int fhe_int256_cast_into_fhe_uint128(const struct FheInt256 *sself, struct FheUint128 **result);

int fhe_int256_cast_into_fhe_uint14(const struct FheInt256 *sself, struct FheUint14 **result);

int fhe_int256_cast_into_fhe_uint16(const struct FheInt256 *sself, struct FheUint16 **result);

int fhe_int256_cast_into_fhe_uint160(const struct FheInt256 *sself, struct FheUint160 **result);

int fhe_int256_cast_into_fhe_uint2(const struct FheInt256 *sself, struct FheUint2 **result);

int fhe_int256_cast_into_fhe_uint256(const struct FheInt256 *sself, struct FheUint256 **result);

int fhe_int256_cast_into_fhe_uint32(const struct FheInt256 *sself, struct FheUint32 **result);

int fhe_int256_cast_into_fhe_uint4(const struct FheInt256 *sself, struct FheUint4 **result);

int fhe_int256_cast_into_fhe_uint6(const struct FheInt256 *sself, struct FheUint6 **result);

int fhe_int256_cast_into_fhe_uint64(const struct FheInt256 *sself, struct FheUint64 **result);

int fhe_int256_cast_into_fhe_uint8(const struct FheInt256 *sself, struct FheUint8 **result);

/**
 * Returns the base 2 logarithm of the number, rounded down.
 *
 * Also returns a boolean flag that is true if the result is valid (i.e input was > 0)
 */
int fhe_int256_checked_ilog2(const struct FheInt256 *input,
                             struct FheUint32 **result_1,
                             struct FheBool **result_2);

int fhe_int256_clone(const struct FheInt256 *sself, struct FheInt256 **result);

int fhe_int256_compress(const struct FheInt256 *sself, struct CompressedFheInt256 **result);

int fhe_int256_decrypt(const struct FheInt256 *encrypted_value,
                       const struct ClientKey *client_key,
                       struct I256 *result);

int fhe_int256_deserialize(DynamicBufferView buffer_view, struct FheInt256 **result);

/**
 *ptr can be null (no-op in that case)
 */
int fhe_int256_destroy(struct FheInt256 *ptr);

int fhe_int256_div(const struct FheInt256 *lhs,
                   const struct FheInt256 *rhs,
                   struct FheInt256 **result);

int fhe_int256_div_assign(struct FheInt256 *lhs, const struct FheInt256 *rhs);

int fhe_int256_div_rem(const struct FheInt256 *lhs,
                       const struct FheInt256 *rhs,
                       struct FheInt256 **q_result,
                       struct FheInt256 **r_result);

int fhe_int256_eq(const struct FheInt256 *lhs,
                  const struct FheInt256 *rhs,
                  struct FheBool **result);

int fhe_int256_ge(const struct FheInt256 *lhs,
                  const struct FheInt256 *rhs,
                  struct FheBool **result);

int fhe_int256_gt(const struct FheInt256 *lhs,
                  const struct FheInt256 *rhs,
                  struct FheBool **result);

int fhe_int256_if_then_else(const struct FheBool *condition_ct,
                            const struct FheInt256 *then_ct,
                            const struct FheInt256 *else_ct,
                            struct FheInt256 **result);

/**
 * Returns the base 2 logarithm of the number, rounded down.
 *
 * Result has no meaning if self encrypts a value that is <= 0.
 * See `checked_ilog2`
 */
int fhe_int256_ilog2(const struct FheInt256 *input, struct FheUint32 **result);

int fhe_int256_le(const struct FheInt256 *lhs,
                  const struct FheInt256 *rhs,
                  struct FheBool **result);

/**
 * Returns the number of leading ones in the binary representation of input.
 */
int fhe_int256_leading_ones(const struct FheInt256 *input, struct FheUint32 **result);

/**
 * Returns the number of leading zeros in the binary representation of input.
 */
int fhe_int256_leading_zeros(const struct FheInt256 *input, struct FheUint32 **result);

int fhe_int256_lt(const struct FheInt256 *lhs,
                  const struct FheInt256 *rhs,
                  struct FheBool **result);

int fhe_int256_max(const struct FheInt256 *lhs,
                   const struct FheInt256 *rhs,
                   struct FheInt256 **result);

int fhe_int256_min(const struct FheInt256 *lhs,
                   const struct FheInt256 *rhs,
                   struct FheInt256 **result);

int fhe_int256_mul(const struct FheInt256 *lhs,
                   const struct FheInt256 *rhs,
                   struct FheInt256 **result);

int fhe_int256_mul_assign(struct FheInt256 *lhs, const struct FheInt256 *rhs);

int fhe_int256_ne(const struct FheInt256 *lhs,
                  const struct FheInt256 *rhs,
                  struct FheBool **result);

int fhe_int256_neg(const struct FheInt256 *input, struct FheInt256 **result);

int fhe_int256_not(const struct FheInt256 *input, struct FheInt256 **result);

int fhe_int256_overflowing_add(const struct FheInt256 *lhs,
                               const struct FheInt256 *rhs,
                               struct FheInt256 **out_result,
                               struct FheBool **out_overflowed);

int fhe_int256_overflowing_mul(const struct FheInt256 *lhs,
                               const struct FheInt256 *rhs,
                               struct FheInt256 **out_result,
                               struct FheBool **out_overflowed);

int fhe_int256_overflowing_sub(const struct FheInt256 *lhs,
                               const struct FheInt256 *rhs,
                               struct FheInt256 **out_result,
                               struct FheBool **out_overflowed);

int fhe_int256_rem(const struct FheInt256 *lhs,
                   const struct FheInt256 *rhs,
                   struct FheInt256 **result);

int fhe_int256_rem_assign(struct FheInt256 *lhs, const struct FheInt256 *rhs);

int fhe_int256_rotate_left(const struct FheInt256 *lhs,
                           const struct FheUint256 *rhs,
                           struct FheInt256 **result);

int fhe_int256_rotate_left_assign(struct FheInt256 *lhs, const struct FheUint256 *rhs);

int fhe_int256_rotate_right(const struct FheInt256 *lhs,
                            const struct FheUint256 *rhs,
                            struct FheInt256 **result);

int fhe_int256_rotate_right_assign(struct FheInt256 *lhs, const struct FheUint256 *rhs);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int fhe_int256_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                           uint64_t serialized_size_limit,
                                           const struct ServerKey *server_key,
                                           struct FheInt256 **result);

int fhe_int256_safe_serialize(const struct FheInt256 *sself,
                              DynamicBuffer *result,
                              uint64_t serialized_size_limit);

int fhe_int256_scalar_add(const struct FheInt256 *lhs, struct I256 rhs, struct FheInt256 **result);

int fhe_int256_scalar_add_assign(struct FheInt256 *lhs, struct I256 rhs);

int fhe_int256_scalar_bitand(const struct FheInt256 *lhs,
                             struct I256 rhs,
                             struct FheInt256 **result);

int fhe_int256_scalar_bitand_assign(struct FheInt256 *lhs, struct I256 rhs);

int fhe_int256_scalar_bitor(const struct FheInt256 *lhs,
                            struct I256 rhs,
                            struct FheInt256 **result);

int fhe_int256_scalar_bitor_assign(struct FheInt256 *lhs, struct I256 rhs);

int fhe_int256_scalar_bitxor(const struct FheInt256 *lhs,
                             struct I256 rhs,
                             struct FheInt256 **result);

int fhe_int256_scalar_bitxor_assign(struct FheInt256 *lhs, struct I256 rhs);

int fhe_int256_scalar_div(const struct FheInt256 *lhs, struct I256 rhs, struct FheInt256 **result);

int fhe_int256_scalar_div_assign(struct FheInt256 *lhs, struct I256 rhs);

int fhe_int256_scalar_div_rem(const struct FheInt256 *lhs,
                              struct I256 rhs,
                              struct FheInt256 **q_result,
                              struct FheInt256 **r_result);

int fhe_int256_scalar_eq(const struct FheInt256 *lhs, struct I256 rhs, struct FheBool **result);

int fhe_int256_scalar_ge(const struct FheInt256 *lhs, struct I256 rhs, struct FheBool **result);

int fhe_int256_scalar_gt(const struct FheInt256 *lhs, struct I256 rhs, struct FheBool **result);

int fhe_int256_scalar_le(const struct FheInt256 *lhs, struct I256 rhs, struct FheBool **result);

int fhe_int256_scalar_lt(const struct FheInt256 *lhs, struct I256 rhs, struct FheBool **result);

int fhe_int256_scalar_max(const struct FheInt256 *lhs, struct I256 rhs, struct FheInt256 **result);

int fhe_int256_scalar_min(const struct FheInt256 *lhs, struct I256 rhs, struct FheInt256 **result);

int fhe_int256_scalar_mul(const struct FheInt256 *lhs, struct I256 rhs, struct FheInt256 **result);

int fhe_int256_scalar_mul_assign(struct FheInt256 *lhs, struct I256 rhs);

int fhe_int256_scalar_ne(const struct FheInt256 *lhs, struct I256 rhs, struct FheBool **result);

int fhe_int256_scalar_rem(const struct FheInt256 *lhs, struct I256 rhs, struct FheInt256 **result);

int fhe_int256_scalar_rem_assign(struct FheInt256 *lhs, struct I256 rhs);

int fhe_int256_scalar_rotate_left(const struct FheInt256 *lhs,
                                  struct U256 rhs,
                                  struct FheInt256 **result);

int fhe_int256_scalar_rotate_left_assign(struct FheInt256 *lhs, struct U256 rhs);

int fhe_int256_scalar_rotate_right(const struct FheInt256 *lhs,
                                   struct U256 rhs,
                                   struct FheInt256 **result);

int fhe_int256_scalar_rotate_right_assign(struct FheInt256 *lhs, struct U256 rhs);

int fhe_int256_scalar_shl(const struct FheInt256 *lhs, struct U256 rhs, struct FheInt256 **result);

int fhe_int256_scalar_shl_assign(struct FheInt256 *lhs, struct U256 rhs);

int fhe_int256_scalar_shr(const struct FheInt256 *lhs, struct U256 rhs, struct FheInt256 **result);

int fhe_int256_scalar_shr_assign(struct FheInt256 *lhs, struct U256 rhs);

int fhe_int256_scalar_sub(const struct FheInt256 *lhs, struct I256 rhs, struct FheInt256 **result);

int fhe_int256_scalar_sub_assign(struct FheInt256 *lhs, struct I256 rhs);

int fhe_int256_serialize(const struct FheInt256 *sself, DynamicBuffer *result);

int fhe_int256_shl(const struct FheInt256 *lhs,
                   const struct FheUint256 *rhs,
                   struct FheInt256 **result);

int fhe_int256_shl_assign(struct FheInt256 *lhs, const struct FheUint256 *rhs);

int fhe_int256_shr(const struct FheInt256 *lhs,
                   const struct FheUint256 *rhs,
                   struct FheInt256 **result);

int fhe_int256_shr_assign(struct FheInt256 *lhs, const struct FheUint256 *rhs);

int fhe_int256_sub(const struct FheInt256 *lhs,
                   const struct FheInt256 *rhs,
                   struct FheInt256 **result);

int fhe_int256_sub_assign(struct FheInt256 *lhs, const struct FheInt256 *rhs);

int fhe_int256_sum(const struct FheInt256 *const *lhs, size_t len, struct FheInt256 **out_result);

/**
 * Returns the number of trailing ones in the binary representation of input.
 */
int fhe_int256_trailing_ones(const struct FheInt256 *input, struct FheUint32 **result);

/**
 * Returns the number of trailing zeros in the binary representation of input.
 */
int fhe_int256_trailing_zeros(const struct FheInt256 *input, struct FheUint32 **result);

int fhe_int256_try_decrypt_trivial(const struct FheInt256 *encrypted_value, struct I256 *result);

int fhe_int256_try_encrypt_trivial_i256(struct I256 value, struct FheInt256 **result);

int fhe_int256_try_encrypt_with_client_key_i256(struct I256 value,
                                                const struct ClientKey *client_key,
                                                struct FheInt256 **result);

int fhe_int256_try_encrypt_with_compact_public_key_i256(struct I256 value,
                                                        const struct CompactPublicKey *public_key,
                                                        struct FheInt256 **result);

int fhe_int256_try_encrypt_with_public_key_i256(struct I256 value,
                                                const struct PublicKey *public_key,
                                                struct FheInt256 **result);

int fhe_int2_add(const struct FheInt2 *lhs, const struct FheInt2 *rhs, struct FheInt2 **result);

int fhe_int2_add_assign(struct FheInt2 *lhs, const struct FheInt2 *rhs);

int fhe_int2_bitand(const struct FheInt2 *lhs, const struct FheInt2 *rhs, struct FheInt2 **result);

int fhe_int2_bitand_assign(struct FheInt2 *lhs, const struct FheInt2 *rhs);

int fhe_int2_bitor(const struct FheInt2 *lhs, const struct FheInt2 *rhs, struct FheInt2 **result);

int fhe_int2_bitor_assign(struct FheInt2 *lhs, const struct FheInt2 *rhs);

int fhe_int2_bitxor(const struct FheInt2 *lhs, const struct FheInt2 *rhs, struct FheInt2 **result);

int fhe_int2_bitxor_assign(struct FheInt2 *lhs, const struct FheInt2 *rhs);

int fhe_int2_cast_into_fhe_int10(const struct FheInt2 *sself, struct FheInt10 **result);

int fhe_int2_cast_into_fhe_int12(const struct FheInt2 *sself, struct FheInt12 **result);

int fhe_int2_cast_into_fhe_int128(const struct FheInt2 *sself, struct FheInt128 **result);

int fhe_int2_cast_into_fhe_int14(const struct FheInt2 *sself, struct FheInt14 **result);

int fhe_int2_cast_into_fhe_int16(const struct FheInt2 *sself, struct FheInt16 **result);

int fhe_int2_cast_into_fhe_int160(const struct FheInt2 *sself, struct FheInt160 **result);

int fhe_int2_cast_into_fhe_int2(const struct FheInt2 *sself, struct FheInt2 **result);

int fhe_int2_cast_into_fhe_int256(const struct FheInt2 *sself, struct FheInt256 **result);

int fhe_int2_cast_into_fhe_int32(const struct FheInt2 *sself, struct FheInt32 **result);

int fhe_int2_cast_into_fhe_int4(const struct FheInt2 *sself, struct FheInt4 **result);

int fhe_int2_cast_into_fhe_int6(const struct FheInt2 *sself, struct FheInt6 **result);

int fhe_int2_cast_into_fhe_int64(const struct FheInt2 *sself, struct FheInt64 **result);

int fhe_int2_cast_into_fhe_int8(const struct FheInt2 *sself, struct FheInt8 **result);

int fhe_int2_cast_into_fhe_uint10(const struct FheInt2 *sself, struct FheUint10 **result);

int fhe_int2_cast_into_fhe_uint128(const struct FheInt2 *sself, struct FheUint128 **result);

int fhe_int2_cast_into_fhe_uint14(const struct FheInt2 *sself, struct FheUint14 **result);

int fhe_int2_cast_into_fhe_uint16(const struct FheInt2 *sself, struct FheUint16 **result);

int fhe_int2_cast_into_fhe_uint160(const struct FheInt2 *sself, struct FheUint160 **result);

int fhe_int2_cast_into_fhe_uint2(const struct FheInt2 *sself, struct FheUint2 **result);

int fhe_int2_cast_into_fhe_uint256(const struct FheInt2 *sself, struct FheUint256 **result);

int fhe_int2_cast_into_fhe_uint32(const struct FheInt2 *sself, struct FheUint32 **result);

int fhe_int2_cast_into_fhe_uint4(const struct FheInt2 *sself, struct FheUint4 **result);

int fhe_int2_cast_into_fhe_uint6(const struct FheInt2 *sself, struct FheUint6 **result);

int fhe_int2_cast_into_fhe_uint64(const struct FheInt2 *sself, struct FheUint64 **result);

int fhe_int2_cast_into_fhe_uint8(const struct FheInt2 *sself, struct FheUint8 **result);

/**
 * Returns the base 2 logarithm of the number, rounded down.
 *
 * Also returns a boolean flag that is true if the result is valid (i.e input was > 0)
 */
int fhe_int2_checked_ilog2(const struct FheInt2 *input,
                           struct FheUint32 **result_1,
                           struct FheBool **result_2);

int fhe_int2_clone(const struct FheInt2 *sself, struct FheInt2 **result);

int fhe_int2_compress(const struct FheInt2 *sself, struct CompressedFheInt2 **result);

int fhe_int2_decrypt(const struct FheInt2 *encrypted_value,
                     const struct ClientKey *client_key,
                     int8_t *result);

int fhe_int2_deserialize(DynamicBufferView buffer_view, struct FheInt2 **result);

/**
 *ptr can be null (no-op in that case)
 */
int fhe_int2_destroy(struct FheInt2 *ptr);

int fhe_int2_div(const struct FheInt2 *lhs, const struct FheInt2 *rhs, struct FheInt2 **result);

int fhe_int2_div_assign(struct FheInt2 *lhs, const struct FheInt2 *rhs);

int fhe_int2_div_rem(const struct FheInt2 *lhs,
                     const struct FheInt2 *rhs,
                     struct FheInt2 **q_result,
                     struct FheInt2 **r_result);

int fhe_int2_eq(const struct FheInt2 *lhs, const struct FheInt2 *rhs, struct FheBool **result);

int fhe_int2_ge(const struct FheInt2 *lhs, const struct FheInt2 *rhs, struct FheBool **result);

int fhe_int2_gt(const struct FheInt2 *lhs, const struct FheInt2 *rhs, struct FheBool **result);

int fhe_int2_if_then_else(const struct FheBool *condition_ct,
                          const struct FheInt2 *then_ct,
                          const struct FheInt2 *else_ct,
                          struct FheInt2 **result);

/**
 * Returns the base 2 logarithm of the number, rounded down.
 *
 * Result has no meaning if self encrypts a value that is <= 0.
 * See `checked_ilog2`
 */
int fhe_int2_ilog2(const struct FheInt2 *input, struct FheUint32 **result);

int fhe_int2_le(const struct FheInt2 *lhs, const struct FheInt2 *rhs, struct FheBool **result);

/**
 * Returns the number of leading ones in the binary representation of input.
 */
int fhe_int2_leading_ones(const struct FheInt2 *input, struct FheUint32 **result);

/**
 * Returns the number of leading zeros in the binary representation of input.
 */
int fhe_int2_leading_zeros(const struct FheInt2 *input, struct FheUint32 **result);

int fhe_int2_lt(const struct FheInt2 *lhs, const struct FheInt2 *rhs, struct FheBool **result);

int fhe_int2_max(const struct FheInt2 *lhs, const struct FheInt2 *rhs, struct FheInt2 **result);

int fhe_int2_min(const struct FheInt2 *lhs, const struct FheInt2 *rhs, struct FheInt2 **result);

int fhe_int2_mul(const struct FheInt2 *lhs, const struct FheInt2 *rhs, struct FheInt2 **result);

int fhe_int2_mul_assign(struct FheInt2 *lhs, const struct FheInt2 *rhs);

int fhe_int2_ne(const struct FheInt2 *lhs, const struct FheInt2 *rhs, struct FheBool **result);

int fhe_int2_neg(const struct FheInt2 *input, struct FheInt2 **result);

int fhe_int2_not(const struct FheInt2 *input, struct FheInt2 **result);

int fhe_int2_overflowing_add(const struct FheInt2 *lhs,
                             const struct FheInt2 *rhs,
                             struct FheInt2 **out_result,
                             struct FheBool **out_overflowed);

int fhe_int2_overflowing_mul(const struct FheInt2 *lhs,
                             const struct FheInt2 *rhs,
                             struct FheInt2 **out_result,
                             struct FheBool **out_overflowed);

int fhe_int2_overflowing_sub(const struct FheInt2 *lhs,
                             const struct FheInt2 *rhs,
                             struct FheInt2 **out_result,
                             struct FheBool **out_overflowed);

int fhe_int2_rem(const struct FheInt2 *lhs, const struct FheInt2 *rhs, struct FheInt2 **result);

int fhe_int2_rem_assign(struct FheInt2 *lhs, const struct FheInt2 *rhs);

int fhe_int2_rotate_left(const struct FheInt2 *lhs,
                         const struct FheUint2 *rhs,
                         struct FheInt2 **result);

int fhe_int2_rotate_left_assign(struct FheInt2 *lhs, const struct FheUint2 *rhs);

int fhe_int2_rotate_right(const struct FheInt2 *lhs,
                          const struct FheUint2 *rhs,
                          struct FheInt2 **result);

int fhe_int2_rotate_right_assign(struct FheInt2 *lhs, const struct FheUint2 *rhs);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int fhe_int2_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                         uint64_t serialized_size_limit,
                                         const struct ServerKey *server_key,
                                         struct FheInt2 **result);

int fhe_int2_safe_serialize(const struct FheInt2 *sself,
                            DynamicBuffer *result,
                            uint64_t serialized_size_limit);

int fhe_int2_scalar_add(const struct FheInt2 *lhs, int8_t rhs, struct FheInt2 **result);

int fhe_int2_scalar_add_assign(struct FheInt2 *lhs, int8_t rhs);

int fhe_int2_scalar_bitand(const struct FheInt2 *lhs, int8_t rhs, struct FheInt2 **result);

int fhe_int2_scalar_bitand_assign(struct FheInt2 *lhs, int8_t rhs);

int fhe_int2_scalar_bitor(const struct FheInt2 *lhs, int8_t rhs, struct FheInt2 **result);

int fhe_int2_scalar_bitor_assign(struct FheInt2 *lhs, int8_t rhs);

int fhe_int2_scalar_bitxor(const struct FheInt2 *lhs, int8_t rhs, struct FheInt2 **result);

int fhe_int2_scalar_bitxor_assign(struct FheInt2 *lhs, int8_t rhs);

int fhe_int2_scalar_div(const struct FheInt2 *lhs, int8_t rhs, struct FheInt2 **result);

int fhe_int2_scalar_div_assign(struct FheInt2 *lhs, int8_t rhs);

int fhe_int2_scalar_div_rem(const struct FheInt2 *lhs,
                            int8_t rhs,
                            struct FheInt2 **q_result,
                            struct FheInt2 **r_result);

int fhe_int2_scalar_eq(const struct FheInt2 *lhs, int8_t rhs, struct FheBool **result);

int fhe_int2_scalar_ge(const struct FheInt2 *lhs, int8_t rhs, struct FheBool **result);

int fhe_int2_scalar_gt(const struct FheInt2 *lhs, int8_t rhs, struct FheBool **result);

int fhe_int2_scalar_le(const struct FheInt2 *lhs, int8_t rhs, struct FheBool **result);

int fhe_int2_scalar_lt(const struct FheInt2 *lhs, int8_t rhs, struct FheBool **result);

int fhe_int2_scalar_max(const struct FheInt2 *lhs, int8_t rhs, struct FheInt2 **result);

int fhe_int2_scalar_min(const struct FheInt2 *lhs, int8_t rhs, struct FheInt2 **result);

int fhe_int2_scalar_mul(const struct FheInt2 *lhs, int8_t rhs, struct FheInt2 **result);

int fhe_int2_scalar_mul_assign(struct FheInt2 *lhs, int8_t rhs);

int fhe_int2_scalar_ne(const struct FheInt2 *lhs, int8_t rhs, struct FheBool **result);

int fhe_int2_scalar_rem(const struct FheInt2 *lhs, int8_t rhs, struct FheInt2 **result);

int fhe_int2_scalar_rem_assign(struct FheInt2 *lhs, int8_t rhs);

int fhe_int2_scalar_rotate_left(const struct FheInt2 *lhs, uint8_t rhs, struct FheInt2 **result);

int fhe_int2_scalar_rotate_left_assign(struct FheInt2 *lhs, uint8_t rhs);

int fhe_int2_scalar_rotate_right(const struct FheInt2 *lhs, uint8_t rhs, struct FheInt2 **result);

int fhe_int2_scalar_rotate_right_assign(struct FheInt2 *lhs, uint8_t rhs);

int fhe_int2_scalar_shl(const struct FheInt2 *lhs, uint8_t rhs, struct FheInt2 **result);

int fhe_int2_scalar_shl_assign(struct FheInt2 *lhs, uint8_t rhs);

int fhe_int2_scalar_shr(const struct FheInt2 *lhs, uint8_t rhs, struct FheInt2 **result);

int fhe_int2_scalar_shr_assign(struct FheInt2 *lhs, uint8_t rhs);

int fhe_int2_scalar_sub(const struct FheInt2 *lhs, int8_t rhs, struct FheInt2 **result);

int fhe_int2_scalar_sub_assign(struct FheInt2 *lhs, int8_t rhs);

int fhe_int2_serialize(const struct FheInt2 *sself, DynamicBuffer *result);

int fhe_int2_shl(const struct FheInt2 *lhs, const struct FheUint2 *rhs, struct FheInt2 **result);

int fhe_int2_shl_assign(struct FheInt2 *lhs, const struct FheUint2 *rhs);

int fhe_int2_shr(const struct FheInt2 *lhs, const struct FheUint2 *rhs, struct FheInt2 **result);

int fhe_int2_shr_assign(struct FheInt2 *lhs, const struct FheUint2 *rhs);

int fhe_int2_sub(const struct FheInt2 *lhs, const struct FheInt2 *rhs, struct FheInt2 **result);

int fhe_int2_sub_assign(struct FheInt2 *lhs, const struct FheInt2 *rhs);

int fhe_int2_sum(const struct FheInt2 *const *lhs, size_t len, struct FheInt2 **out_result);

/**
 * Returns the number of trailing ones in the binary representation of input.
 */
int fhe_int2_trailing_ones(const struct FheInt2 *input, struct FheUint32 **result);

/**
 * Returns the number of trailing zeros in the binary representation of input.
 */
int fhe_int2_trailing_zeros(const struct FheInt2 *input, struct FheUint32 **result);

int fhe_int2_try_decrypt_trivial(const struct FheInt2 *encrypted_value, int8_t *result);

int fhe_int2_try_encrypt_trivial_i8(int8_t value, struct FheInt2 **result);

int fhe_int2_try_encrypt_with_client_key_i8(int8_t value,
                                            const struct ClientKey *client_key,
                                            struct FheInt2 **result);

int fhe_int2_try_encrypt_with_compact_public_key_i8(int8_t value,
                                                    const struct CompactPublicKey *public_key,
                                                    struct FheInt2 **result);

int fhe_int2_try_encrypt_with_public_key_i8(int8_t value,
                                            const struct PublicKey *public_key,
                                            struct FheInt2 **result);

int fhe_int32_add(const struct FheInt32 *lhs, const struct FheInt32 *rhs, struct FheInt32 **result);

int fhe_int32_add_assign(struct FheInt32 *lhs, const struct FheInt32 *rhs);

int fhe_int32_bitand(const struct FheInt32 *lhs,
                     const struct FheInt32 *rhs,
                     struct FheInt32 **result);

int fhe_int32_bitand_assign(struct FheInt32 *lhs, const struct FheInt32 *rhs);

int fhe_int32_bitor(const struct FheInt32 *lhs,
                    const struct FheInt32 *rhs,
                    struct FheInt32 **result);

int fhe_int32_bitor_assign(struct FheInt32 *lhs, const struct FheInt32 *rhs);

int fhe_int32_bitxor(const struct FheInt32 *lhs,
                     const struct FheInt32 *rhs,
                     struct FheInt32 **result);

int fhe_int32_bitxor_assign(struct FheInt32 *lhs, const struct FheInt32 *rhs);

int fhe_int32_cast_into_fhe_int10(const struct FheInt32 *sself, struct FheInt10 **result);

int fhe_int32_cast_into_fhe_int12(const struct FheInt32 *sself, struct FheInt12 **result);

int fhe_int32_cast_into_fhe_int128(const struct FheInt32 *sself, struct FheInt128 **result);

int fhe_int32_cast_into_fhe_int14(const struct FheInt32 *sself, struct FheInt14 **result);

int fhe_int32_cast_into_fhe_int16(const struct FheInt32 *sself, struct FheInt16 **result);

int fhe_int32_cast_into_fhe_int160(const struct FheInt32 *sself, struct FheInt160 **result);

int fhe_int32_cast_into_fhe_int2(const struct FheInt32 *sself, struct FheInt2 **result);

int fhe_int32_cast_into_fhe_int256(const struct FheInt32 *sself, struct FheInt256 **result);

int fhe_int32_cast_into_fhe_int32(const struct FheInt32 *sself, struct FheInt32 **result);

int fhe_int32_cast_into_fhe_int4(const struct FheInt32 *sself, struct FheInt4 **result);

int fhe_int32_cast_into_fhe_int6(const struct FheInt32 *sself, struct FheInt6 **result);

int fhe_int32_cast_into_fhe_int64(const struct FheInt32 *sself, struct FheInt64 **result);

int fhe_int32_cast_into_fhe_int8(const struct FheInt32 *sself, struct FheInt8 **result);

int fhe_int32_cast_into_fhe_uint10(const struct FheInt32 *sself, struct FheUint10 **result);

int fhe_int32_cast_into_fhe_uint128(const struct FheInt32 *sself, struct FheUint128 **result);

int fhe_int32_cast_into_fhe_uint14(const struct FheInt32 *sself, struct FheUint14 **result);

int fhe_int32_cast_into_fhe_uint16(const struct FheInt32 *sself, struct FheUint16 **result);

int fhe_int32_cast_into_fhe_uint160(const struct FheInt32 *sself, struct FheUint160 **result);

int fhe_int32_cast_into_fhe_uint2(const struct FheInt32 *sself, struct FheUint2 **result);

int fhe_int32_cast_into_fhe_uint256(const struct FheInt32 *sself, struct FheUint256 **result);

int fhe_int32_cast_into_fhe_uint32(const struct FheInt32 *sself, struct FheUint32 **result);

int fhe_int32_cast_into_fhe_uint4(const struct FheInt32 *sself, struct FheUint4 **result);

int fhe_int32_cast_into_fhe_uint6(const struct FheInt32 *sself, struct FheUint6 **result);

int fhe_int32_cast_into_fhe_uint64(const struct FheInt32 *sself, struct FheUint64 **result);

int fhe_int32_cast_into_fhe_uint8(const struct FheInt32 *sself, struct FheUint8 **result);

/**
 * Returns the base 2 logarithm of the number, rounded down.
 *
 * Also returns a boolean flag that is true if the result is valid (i.e input was > 0)
 */
int fhe_int32_checked_ilog2(const struct FheInt32 *input,
                            struct FheUint32 **result_1,
                            struct FheBool **result_2);

int fhe_int32_clone(const struct FheInt32 *sself, struct FheInt32 **result);

int fhe_int32_compress(const struct FheInt32 *sself, struct CompressedFheInt32 **result);

int fhe_int32_decrypt(const struct FheInt32 *encrypted_value,
                      const struct ClientKey *client_key,
                      int32_t *result);

int fhe_int32_deserialize(DynamicBufferView buffer_view, struct FheInt32 **result);

/**
 *ptr can be null (no-op in that case)
 */
int fhe_int32_destroy(struct FheInt32 *ptr);

int fhe_int32_div(const struct FheInt32 *lhs, const struct FheInt32 *rhs, struct FheInt32 **result);

int fhe_int32_div_assign(struct FheInt32 *lhs, const struct FheInt32 *rhs);

int fhe_int32_div_rem(const struct FheInt32 *lhs,
                      const struct FheInt32 *rhs,
                      struct FheInt32 **q_result,
                      struct FheInt32 **r_result);

int fhe_int32_eq(const struct FheInt32 *lhs, const struct FheInt32 *rhs, struct FheBool **result);

int fhe_int32_ge(const struct FheInt32 *lhs, const struct FheInt32 *rhs, struct FheBool **result);

int fhe_int32_gt(const struct FheInt32 *lhs, const struct FheInt32 *rhs, struct FheBool **result);

int fhe_int32_if_then_else(const struct FheBool *condition_ct,
                           const struct FheInt32 *then_ct,
                           const struct FheInt32 *else_ct,
                           struct FheInt32 **result);

/**
 * Returns the base 2 logarithm of the number, rounded down.
 *
 * Result has no meaning if self encrypts a value that is <= 0.
 * See `checked_ilog2`
 */
int fhe_int32_ilog2(const struct FheInt32 *input, struct FheUint32 **result);

int fhe_int32_le(const struct FheInt32 *lhs, const struct FheInt32 *rhs, struct FheBool **result);

/**
 * Returns the number of leading ones in the binary representation of input.
 */
int fhe_int32_leading_ones(const struct FheInt32 *input, struct FheUint32 **result);

/**
 * Returns the number of leading zeros in the binary representation of input.
 */
int fhe_int32_leading_zeros(const struct FheInt32 *input, struct FheUint32 **result);

int fhe_int32_lt(const struct FheInt32 *lhs, const struct FheInt32 *rhs, struct FheBool **result);

int fhe_int32_max(const struct FheInt32 *lhs, const struct FheInt32 *rhs, struct FheInt32 **result);

int fhe_int32_min(const struct FheInt32 *lhs, const struct FheInt32 *rhs, struct FheInt32 **result);

int fhe_int32_mul(const struct FheInt32 *lhs, const struct FheInt32 *rhs, struct FheInt32 **result);

int fhe_int32_mul_assign(struct FheInt32 *lhs, const struct FheInt32 *rhs);

int fhe_int32_ne(const struct FheInt32 *lhs, const struct FheInt32 *rhs, struct FheBool **result);

int fhe_int32_neg(const struct FheInt32 *input, struct FheInt32 **result);

int fhe_int32_not(const struct FheInt32 *input, struct FheInt32 **result);

int fhe_int32_overflowing_add(const struct FheInt32 *lhs,
                              const struct FheInt32 *rhs,
                              struct FheInt32 **out_result,
                              struct FheBool **out_overflowed);

int fhe_int32_overflowing_mul(const struct FheInt32 *lhs,
                              const struct FheInt32 *rhs,
                              struct FheInt32 **out_result,
                              struct FheBool **out_overflowed);

int fhe_int32_overflowing_sub(const struct FheInt32 *lhs,
                              const struct FheInt32 *rhs,
                              struct FheInt32 **out_result,
                              struct FheBool **out_overflowed);

int fhe_int32_rem(const struct FheInt32 *lhs, const struct FheInt32 *rhs, struct FheInt32 **result);

int fhe_int32_rem_assign(struct FheInt32 *lhs, const struct FheInt32 *rhs);

int fhe_int32_rotate_left(const struct FheInt32 *lhs,
                          const struct FheUint32 *rhs,
                          struct FheInt32 **result);

int fhe_int32_rotate_left_assign(struct FheInt32 *lhs, const struct FheUint32 *rhs);

int fhe_int32_rotate_right(const struct FheInt32 *lhs,
                           const struct FheUint32 *rhs,
                           struct FheInt32 **result);

int fhe_int32_rotate_right_assign(struct FheInt32 *lhs, const struct FheUint32 *rhs);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int fhe_int32_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                          uint64_t serialized_size_limit,
                                          const struct ServerKey *server_key,
                                          struct FheInt32 **result);

int fhe_int32_safe_serialize(const struct FheInt32 *sself,
                             DynamicBuffer *result,
                             uint64_t serialized_size_limit);

int fhe_int32_scalar_add(const struct FheInt32 *lhs, int32_t rhs, struct FheInt32 **result);

int fhe_int32_scalar_add_assign(struct FheInt32 *lhs, int32_t rhs);

int fhe_int32_scalar_bitand(const struct FheInt32 *lhs, int32_t rhs, struct FheInt32 **result);

int fhe_int32_scalar_bitand_assign(struct FheInt32 *lhs, int32_t rhs);

int fhe_int32_scalar_bitor(const struct FheInt32 *lhs, int32_t rhs, struct FheInt32 **result);

int fhe_int32_scalar_bitor_assign(struct FheInt32 *lhs, int32_t rhs);

int fhe_int32_scalar_bitxor(const struct FheInt32 *lhs, int32_t rhs, struct FheInt32 **result);

int fhe_int32_scalar_bitxor_assign(struct FheInt32 *lhs, int32_t rhs);

int fhe_int32_scalar_div(const struct FheInt32 *lhs, int32_t rhs, struct FheInt32 **result);

int fhe_int32_scalar_div_assign(struct FheInt32 *lhs, int32_t rhs);

int fhe_int32_scalar_div_rem(const struct FheInt32 *lhs,
                             int32_t rhs,
                             struct FheInt32 **q_result,
                             struct FheInt32 **r_result);

int fhe_int32_scalar_eq(const struct FheInt32 *lhs, int32_t rhs, struct FheBool **result);

int fhe_int32_scalar_ge(const struct FheInt32 *lhs, int32_t rhs, struct FheBool **result);

int fhe_int32_scalar_gt(const struct FheInt32 *lhs, int32_t rhs, struct FheBool **result);

int fhe_int32_scalar_le(const struct FheInt32 *lhs, int32_t rhs, struct FheBool **result);

int fhe_int32_scalar_lt(const struct FheInt32 *lhs, int32_t rhs, struct FheBool **result);

int fhe_int32_scalar_max(const struct FheInt32 *lhs, int32_t rhs, struct FheInt32 **result);

int fhe_int32_scalar_min(const struct FheInt32 *lhs, int32_t rhs, struct FheInt32 **result);

int fhe_int32_scalar_mul(const struct FheInt32 *lhs, int32_t rhs, struct FheInt32 **result);

int fhe_int32_scalar_mul_assign(struct FheInt32 *lhs, int32_t rhs);

int fhe_int32_scalar_ne(const struct FheInt32 *lhs, int32_t rhs, struct FheBool **result);

int fhe_int32_scalar_rem(const struct FheInt32 *lhs, int32_t rhs, struct FheInt32 **result);

int fhe_int32_scalar_rem_assign(struct FheInt32 *lhs, int32_t rhs);

int fhe_int32_scalar_rotate_left(const struct FheInt32 *lhs,
                                 uint32_t rhs,
                                 struct FheInt32 **result);

int fhe_int32_scalar_rotate_left_assign(struct FheInt32 *lhs, uint32_t rhs);

int fhe_int32_scalar_rotate_right(const struct FheInt32 *lhs,
                                  uint32_t rhs,
                                  struct FheInt32 **result);

int fhe_int32_scalar_rotate_right_assign(struct FheInt32 *lhs, uint32_t rhs);

int fhe_int32_scalar_shl(const struct FheInt32 *lhs, uint32_t rhs, struct FheInt32 **result);

int fhe_int32_scalar_shl_assign(struct FheInt32 *lhs, uint32_t rhs);

int fhe_int32_scalar_shr(const struct FheInt32 *lhs, uint32_t rhs, struct FheInt32 **result);

int fhe_int32_scalar_shr_assign(struct FheInt32 *lhs, uint32_t rhs);

int fhe_int32_scalar_sub(const struct FheInt32 *lhs, int32_t rhs, struct FheInt32 **result);

int fhe_int32_scalar_sub_assign(struct FheInt32 *lhs, int32_t rhs);

int fhe_int32_serialize(const struct FheInt32 *sself, DynamicBuffer *result);

int fhe_int32_shl(const struct FheInt32 *lhs,
                  const struct FheUint32 *rhs,
                  struct FheInt32 **result);

int fhe_int32_shl_assign(struct FheInt32 *lhs, const struct FheUint32 *rhs);

int fhe_int32_shr(const struct FheInt32 *lhs,
                  const struct FheUint32 *rhs,
                  struct FheInt32 **result);

int fhe_int32_shr_assign(struct FheInt32 *lhs, const struct FheUint32 *rhs);

int fhe_int32_sub(const struct FheInt32 *lhs, const struct FheInt32 *rhs, struct FheInt32 **result);

int fhe_int32_sub_assign(struct FheInt32 *lhs, const struct FheInt32 *rhs);

int fhe_int32_sum(const struct FheInt32 *const *lhs, size_t len, struct FheInt32 **out_result);

/**
 * Returns the number of trailing ones in the binary representation of input.
 */
int fhe_int32_trailing_ones(const struct FheInt32 *input, struct FheUint32 **result);

/**
 * Returns the number of trailing zeros in the binary representation of input.
 */
int fhe_int32_trailing_zeros(const struct FheInt32 *input, struct FheUint32 **result);

int fhe_int32_try_decrypt_trivial(const struct FheInt32 *encrypted_value, int32_t *result);

int fhe_int32_try_encrypt_trivial_i32(int32_t value, struct FheInt32 **result);

int fhe_int32_try_encrypt_with_client_key_i32(int32_t value,
                                              const struct ClientKey *client_key,
                                              struct FheInt32 **result);

int fhe_int32_try_encrypt_with_compact_public_key_i32(int32_t value,
                                                      const struct CompactPublicKey *public_key,
                                                      struct FheInt32 **result);

int fhe_int32_try_encrypt_with_public_key_i32(int32_t value,
                                              const struct PublicKey *public_key,
                                              struct FheInt32 **result);

int fhe_int4_add(const struct FheInt4 *lhs, const struct FheInt4 *rhs, struct FheInt4 **result);

int fhe_int4_add_assign(struct FheInt4 *lhs, const struct FheInt4 *rhs);

int fhe_int4_bitand(const struct FheInt4 *lhs, const struct FheInt4 *rhs, struct FheInt4 **result);

int fhe_int4_bitand_assign(struct FheInt4 *lhs, const struct FheInt4 *rhs);

int fhe_int4_bitor(const struct FheInt4 *lhs, const struct FheInt4 *rhs, struct FheInt4 **result);

int fhe_int4_bitor_assign(struct FheInt4 *lhs, const struct FheInt4 *rhs);

int fhe_int4_bitxor(const struct FheInt4 *lhs, const struct FheInt4 *rhs, struct FheInt4 **result);

int fhe_int4_bitxor_assign(struct FheInt4 *lhs, const struct FheInt4 *rhs);

int fhe_int4_cast_into_fhe_int10(const struct FheInt4 *sself, struct FheInt10 **result);

int fhe_int4_cast_into_fhe_int12(const struct FheInt4 *sself, struct FheInt12 **result);

int fhe_int4_cast_into_fhe_int128(const struct FheInt4 *sself, struct FheInt128 **result);

int fhe_int4_cast_into_fhe_int14(const struct FheInt4 *sself, struct FheInt14 **result);

int fhe_int4_cast_into_fhe_int16(const struct FheInt4 *sself, struct FheInt16 **result);

int fhe_int4_cast_into_fhe_int160(const struct FheInt4 *sself, struct FheInt160 **result);

int fhe_int4_cast_into_fhe_int2(const struct FheInt4 *sself, struct FheInt2 **result);

int fhe_int4_cast_into_fhe_int256(const struct FheInt4 *sself, struct FheInt256 **result);

int fhe_int4_cast_into_fhe_int32(const struct FheInt4 *sself, struct FheInt32 **result);

int fhe_int4_cast_into_fhe_int4(const struct FheInt4 *sself, struct FheInt4 **result);

int fhe_int4_cast_into_fhe_int6(const struct FheInt4 *sself, struct FheInt6 **result);

int fhe_int4_cast_into_fhe_int64(const struct FheInt4 *sself, struct FheInt64 **result);

int fhe_int4_cast_into_fhe_int8(const struct FheInt4 *sself, struct FheInt8 **result);

int fhe_int4_cast_into_fhe_uint10(const struct FheInt4 *sself, struct FheUint10 **result);

int fhe_int4_cast_into_fhe_uint128(const struct FheInt4 *sself, struct FheUint128 **result);

int fhe_int4_cast_into_fhe_uint14(const struct FheInt4 *sself, struct FheUint14 **result);

int fhe_int4_cast_into_fhe_uint16(const struct FheInt4 *sself, struct FheUint16 **result);

int fhe_int4_cast_into_fhe_uint160(const struct FheInt4 *sself, struct FheUint160 **result);

int fhe_int4_cast_into_fhe_uint2(const struct FheInt4 *sself, struct FheUint2 **result);

int fhe_int4_cast_into_fhe_uint256(const struct FheInt4 *sself, struct FheUint256 **result);

int fhe_int4_cast_into_fhe_uint32(const struct FheInt4 *sself, struct FheUint32 **result);

int fhe_int4_cast_into_fhe_uint4(const struct FheInt4 *sself, struct FheUint4 **result);

int fhe_int4_cast_into_fhe_uint6(const struct FheInt4 *sself, struct FheUint6 **result);

int fhe_int4_cast_into_fhe_uint64(const struct FheInt4 *sself, struct FheUint64 **result);

int fhe_int4_cast_into_fhe_uint8(const struct FheInt4 *sself, struct FheUint8 **result);

/**
 * Returns the base 2 logarithm of the number, rounded down.
 *
 * Also returns a boolean flag that is true if the result is valid (i.e input was > 0)
 */
int fhe_int4_checked_ilog2(const struct FheInt4 *input,
                           struct FheUint32 **result_1,
                           struct FheBool **result_2);

int fhe_int4_clone(const struct FheInt4 *sself, struct FheInt4 **result);

int fhe_int4_compress(const struct FheInt4 *sself, struct CompressedFheInt4 **result);

int fhe_int4_decrypt(const struct FheInt4 *encrypted_value,
                     const struct ClientKey *client_key,
                     int8_t *result);

int fhe_int4_deserialize(DynamicBufferView buffer_view, struct FheInt4 **result);

/**
 *ptr can be null (no-op in that case)
 */
int fhe_int4_destroy(struct FheInt4 *ptr);

int fhe_int4_div(const struct FheInt4 *lhs, const struct FheInt4 *rhs, struct FheInt4 **result);

int fhe_int4_div_assign(struct FheInt4 *lhs, const struct FheInt4 *rhs);

int fhe_int4_div_rem(const struct FheInt4 *lhs,
                     const struct FheInt4 *rhs,
                     struct FheInt4 **q_result,
                     struct FheInt4 **r_result);

int fhe_int4_eq(const struct FheInt4 *lhs, const struct FheInt4 *rhs, struct FheBool **result);

int fhe_int4_ge(const struct FheInt4 *lhs, const struct FheInt4 *rhs, struct FheBool **result);

int fhe_int4_gt(const struct FheInt4 *lhs, const struct FheInt4 *rhs, struct FheBool **result);

int fhe_int4_if_then_else(const struct FheBool *condition_ct,
                          const struct FheInt4 *then_ct,
                          const struct FheInt4 *else_ct,
                          struct FheInt4 **result);

/**
 * Returns the base 2 logarithm of the number, rounded down.
 *
 * Result has no meaning if self encrypts a value that is <= 0.
 * See `checked_ilog2`
 */
int fhe_int4_ilog2(const struct FheInt4 *input, struct FheUint32 **result);

int fhe_int4_le(const struct FheInt4 *lhs, const struct FheInt4 *rhs, struct FheBool **result);

/**
 * Returns the number of leading ones in the binary representation of input.
 */
int fhe_int4_leading_ones(const struct FheInt4 *input, struct FheUint32 **result);

/**
 * Returns the number of leading zeros in the binary representation of input.
 */
int fhe_int4_leading_zeros(const struct FheInt4 *input, struct FheUint32 **result);

int fhe_int4_lt(const struct FheInt4 *lhs, const struct FheInt4 *rhs, struct FheBool **result);

int fhe_int4_max(const struct FheInt4 *lhs, const struct FheInt4 *rhs, struct FheInt4 **result);

int fhe_int4_min(const struct FheInt4 *lhs, const struct FheInt4 *rhs, struct FheInt4 **result);

int fhe_int4_mul(const struct FheInt4 *lhs, const struct FheInt4 *rhs, struct FheInt4 **result);

int fhe_int4_mul_assign(struct FheInt4 *lhs, const struct FheInt4 *rhs);

int fhe_int4_ne(const struct FheInt4 *lhs, const struct FheInt4 *rhs, struct FheBool **result);

int fhe_int4_neg(const struct FheInt4 *input, struct FheInt4 **result);

int fhe_int4_not(const struct FheInt4 *input, struct FheInt4 **result);

int fhe_int4_overflowing_add(const struct FheInt4 *lhs,
                             const struct FheInt4 *rhs,
                             struct FheInt4 **out_result,
                             struct FheBool **out_overflowed);

int fhe_int4_overflowing_mul(const struct FheInt4 *lhs,
                             const struct FheInt4 *rhs,
                             struct FheInt4 **out_result,
                             struct FheBool **out_overflowed);

int fhe_int4_overflowing_sub(const struct FheInt4 *lhs,
                             const struct FheInt4 *rhs,
                             struct FheInt4 **out_result,
                             struct FheBool **out_overflowed);

int fhe_int4_rem(const struct FheInt4 *lhs, const struct FheInt4 *rhs, struct FheInt4 **result);

int fhe_int4_rem_assign(struct FheInt4 *lhs, const struct FheInt4 *rhs);

int fhe_int4_rotate_left(const struct FheInt4 *lhs,
                         const struct FheUint4 *rhs,
                         struct FheInt4 **result);

int fhe_int4_rotate_left_assign(struct FheInt4 *lhs, const struct FheUint4 *rhs);

int fhe_int4_rotate_right(const struct FheInt4 *lhs,
                          const struct FheUint4 *rhs,
                          struct FheInt4 **result);

int fhe_int4_rotate_right_assign(struct FheInt4 *lhs, const struct FheUint4 *rhs);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int fhe_int4_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                         uint64_t serialized_size_limit,
                                         const struct ServerKey *server_key,
                                         struct FheInt4 **result);

int fhe_int4_safe_serialize(const struct FheInt4 *sself,
                            DynamicBuffer *result,
                            uint64_t serialized_size_limit);

int fhe_int4_scalar_add(const struct FheInt4 *lhs, int8_t rhs, struct FheInt4 **result);

int fhe_int4_scalar_add_assign(struct FheInt4 *lhs, int8_t rhs);

int fhe_int4_scalar_bitand(const struct FheInt4 *lhs, int8_t rhs, struct FheInt4 **result);

int fhe_int4_scalar_bitand_assign(struct FheInt4 *lhs, int8_t rhs);

int fhe_int4_scalar_bitor(const struct FheInt4 *lhs, int8_t rhs, struct FheInt4 **result);

int fhe_int4_scalar_bitor_assign(struct FheInt4 *lhs, int8_t rhs);

int fhe_int4_scalar_bitxor(const struct FheInt4 *lhs, int8_t rhs, struct FheInt4 **result);

int fhe_int4_scalar_bitxor_assign(struct FheInt4 *lhs, int8_t rhs);

int fhe_int4_scalar_div(const struct FheInt4 *lhs, int8_t rhs, struct FheInt4 **result);

int fhe_int4_scalar_div_assign(struct FheInt4 *lhs, int8_t rhs);

int fhe_int4_scalar_div_rem(const struct FheInt4 *lhs,
                            int8_t rhs,
                            struct FheInt4 **q_result,
                            struct FheInt4 **r_result);

int fhe_int4_scalar_eq(const struct FheInt4 *lhs, int8_t rhs, struct FheBool **result);

int fhe_int4_scalar_ge(const struct FheInt4 *lhs, int8_t rhs, struct FheBool **result);

int fhe_int4_scalar_gt(const struct FheInt4 *lhs, int8_t rhs, struct FheBool **result);

int fhe_int4_scalar_le(const struct FheInt4 *lhs, int8_t rhs, struct FheBool **result);

int fhe_int4_scalar_lt(const struct FheInt4 *lhs, int8_t rhs, struct FheBool **result);

int fhe_int4_scalar_max(const struct FheInt4 *lhs, int8_t rhs, struct FheInt4 **result);

int fhe_int4_scalar_min(const struct FheInt4 *lhs, int8_t rhs, struct FheInt4 **result);

int fhe_int4_scalar_mul(const struct FheInt4 *lhs, int8_t rhs, struct FheInt4 **result);

int fhe_int4_scalar_mul_assign(struct FheInt4 *lhs, int8_t rhs);

int fhe_int4_scalar_ne(const struct FheInt4 *lhs, int8_t rhs, struct FheBool **result);

int fhe_int4_scalar_rem(const struct FheInt4 *lhs, int8_t rhs, struct FheInt4 **result);

int fhe_int4_scalar_rem_assign(struct FheInt4 *lhs, int8_t rhs);

int fhe_int4_scalar_rotate_left(const struct FheInt4 *lhs, uint8_t rhs, struct FheInt4 **result);

int fhe_int4_scalar_rotate_left_assign(struct FheInt4 *lhs, uint8_t rhs);

int fhe_int4_scalar_rotate_right(const struct FheInt4 *lhs, uint8_t rhs, struct FheInt4 **result);

int fhe_int4_scalar_rotate_right_assign(struct FheInt4 *lhs, uint8_t rhs);

int fhe_int4_scalar_shl(const struct FheInt4 *lhs, uint8_t rhs, struct FheInt4 **result);

int fhe_int4_scalar_shl_assign(struct FheInt4 *lhs, uint8_t rhs);

int fhe_int4_scalar_shr(const struct FheInt4 *lhs, uint8_t rhs, struct FheInt4 **result);

int fhe_int4_scalar_shr_assign(struct FheInt4 *lhs, uint8_t rhs);

int fhe_int4_scalar_sub(const struct FheInt4 *lhs, int8_t rhs, struct FheInt4 **result);

int fhe_int4_scalar_sub_assign(struct FheInt4 *lhs, int8_t rhs);

int fhe_int4_serialize(const struct FheInt4 *sself, DynamicBuffer *result);

int fhe_int4_shl(const struct FheInt4 *lhs, const struct FheUint4 *rhs, struct FheInt4 **result);

int fhe_int4_shl_assign(struct FheInt4 *lhs, const struct FheUint4 *rhs);

int fhe_int4_shr(const struct FheInt4 *lhs, const struct FheUint4 *rhs, struct FheInt4 **result);

int fhe_int4_shr_assign(struct FheInt4 *lhs, const struct FheUint4 *rhs);

int fhe_int4_sub(const struct FheInt4 *lhs, const struct FheInt4 *rhs, struct FheInt4 **result);

int fhe_int4_sub_assign(struct FheInt4 *lhs, const struct FheInt4 *rhs);

int fhe_int4_sum(const struct FheInt4 *const *lhs, size_t len, struct FheInt4 **out_result);

/**
 * Returns the number of trailing ones in the binary representation of input.
 */
int fhe_int4_trailing_ones(const struct FheInt4 *input, struct FheUint32 **result);

/**
 * Returns the number of trailing zeros in the binary representation of input.
 */
int fhe_int4_trailing_zeros(const struct FheInt4 *input, struct FheUint32 **result);

int fhe_int4_try_decrypt_trivial(const struct FheInt4 *encrypted_value, int8_t *result);

int fhe_int4_try_encrypt_trivial_i8(int8_t value, struct FheInt4 **result);

int fhe_int4_try_encrypt_with_client_key_i8(int8_t value,
                                            const struct ClientKey *client_key,
                                            struct FheInt4 **result);

int fhe_int4_try_encrypt_with_compact_public_key_i8(int8_t value,
                                                    const struct CompactPublicKey *public_key,
                                                    struct FheInt4 **result);

int fhe_int4_try_encrypt_with_public_key_i8(int8_t value,
                                            const struct PublicKey *public_key,
                                            struct FheInt4 **result);

int fhe_int64_add(const struct FheInt64 *lhs, const struct FheInt64 *rhs, struct FheInt64 **result);

int fhe_int64_add_assign(struct FheInt64 *lhs, const struct FheInt64 *rhs);

int fhe_int64_bitand(const struct FheInt64 *lhs,
                     const struct FheInt64 *rhs,
                     struct FheInt64 **result);

int fhe_int64_bitand_assign(struct FheInt64 *lhs, const struct FheInt64 *rhs);

int fhe_int64_bitor(const struct FheInt64 *lhs,
                    const struct FheInt64 *rhs,
                    struct FheInt64 **result);

int fhe_int64_bitor_assign(struct FheInt64 *lhs, const struct FheInt64 *rhs);

int fhe_int64_bitxor(const struct FheInt64 *lhs,
                     const struct FheInt64 *rhs,
                     struct FheInt64 **result);

int fhe_int64_bitxor_assign(struct FheInt64 *lhs, const struct FheInt64 *rhs);

int fhe_int64_cast_into_fhe_int10(const struct FheInt64 *sself, struct FheInt10 **result);

int fhe_int64_cast_into_fhe_int12(const struct FheInt64 *sself, struct FheInt12 **result);

int fhe_int64_cast_into_fhe_int128(const struct FheInt64 *sself, struct FheInt128 **result);

int fhe_int64_cast_into_fhe_int14(const struct FheInt64 *sself, struct FheInt14 **result);

int fhe_int64_cast_into_fhe_int16(const struct FheInt64 *sself, struct FheInt16 **result);

int fhe_int64_cast_into_fhe_int160(const struct FheInt64 *sself, struct FheInt160 **result);

int fhe_int64_cast_into_fhe_int2(const struct FheInt64 *sself, struct FheInt2 **result);

int fhe_int64_cast_into_fhe_int256(const struct FheInt64 *sself, struct FheInt256 **result);

int fhe_int64_cast_into_fhe_int32(const struct FheInt64 *sself, struct FheInt32 **result);

int fhe_int64_cast_into_fhe_int4(const struct FheInt64 *sself, struct FheInt4 **result);

int fhe_int64_cast_into_fhe_int6(const struct FheInt64 *sself, struct FheInt6 **result);

int fhe_int64_cast_into_fhe_int64(const struct FheInt64 *sself, struct FheInt64 **result);

int fhe_int64_cast_into_fhe_int8(const struct FheInt64 *sself, struct FheInt8 **result);

int fhe_int64_cast_into_fhe_uint10(const struct FheInt64 *sself, struct FheUint10 **result);

int fhe_int64_cast_into_fhe_uint128(const struct FheInt64 *sself, struct FheUint128 **result);

int fhe_int64_cast_into_fhe_uint14(const struct FheInt64 *sself, struct FheUint14 **result);

int fhe_int64_cast_into_fhe_uint16(const struct FheInt64 *sself, struct FheUint16 **result);

int fhe_int64_cast_into_fhe_uint160(const struct FheInt64 *sself, struct FheUint160 **result);

int fhe_int64_cast_into_fhe_uint2(const struct FheInt64 *sself, struct FheUint2 **result);

int fhe_int64_cast_into_fhe_uint256(const struct FheInt64 *sself, struct FheUint256 **result);

int fhe_int64_cast_into_fhe_uint32(const struct FheInt64 *sself, struct FheUint32 **result);

int fhe_int64_cast_into_fhe_uint4(const struct FheInt64 *sself, struct FheUint4 **result);

int fhe_int64_cast_into_fhe_uint6(const struct FheInt64 *sself, struct FheUint6 **result);

int fhe_int64_cast_into_fhe_uint64(const struct FheInt64 *sself, struct FheUint64 **result);

int fhe_int64_cast_into_fhe_uint8(const struct FheInt64 *sself, struct FheUint8 **result);

/**
 * Returns the base 2 logarithm of the number, rounded down.
 *
 * Also returns a boolean flag that is true if the result is valid (i.e input was > 0)
 */
int fhe_int64_checked_ilog2(const struct FheInt64 *input,
                            struct FheUint32 **result_1,
                            struct FheBool **result_2);

int fhe_int64_clone(const struct FheInt64 *sself, struct FheInt64 **result);

int fhe_int64_compress(const struct FheInt64 *sself, struct CompressedFheInt64 **result);

int fhe_int64_decrypt(const struct FheInt64 *encrypted_value,
                      const struct ClientKey *client_key,
                      int64_t *result);

int fhe_int64_deserialize(DynamicBufferView buffer_view, struct FheInt64 **result);

/**
 *ptr can be null (no-op in that case)
 */
int fhe_int64_destroy(struct FheInt64 *ptr);

int fhe_int64_div(const struct FheInt64 *lhs, const struct FheInt64 *rhs, struct FheInt64 **result);

int fhe_int64_div_assign(struct FheInt64 *lhs, const struct FheInt64 *rhs);

int fhe_int64_div_rem(const struct FheInt64 *lhs,
                      const struct FheInt64 *rhs,
                      struct FheInt64 **q_result,
                      struct FheInt64 **r_result);

int fhe_int64_eq(const struct FheInt64 *lhs, const struct FheInt64 *rhs, struct FheBool **result);

int fhe_int64_ge(const struct FheInt64 *lhs, const struct FheInt64 *rhs, struct FheBool **result);

int fhe_int64_gt(const struct FheInt64 *lhs, const struct FheInt64 *rhs, struct FheBool **result);

int fhe_int64_if_then_else(const struct FheBool *condition_ct,
                           const struct FheInt64 *then_ct,
                           const struct FheInt64 *else_ct,
                           struct FheInt64 **result);

/**
 * Returns the base 2 logarithm of the number, rounded down.
 *
 * Result has no meaning if self encrypts a value that is <= 0.
 * See `checked_ilog2`
 */
int fhe_int64_ilog2(const struct FheInt64 *input, struct FheUint32 **result);

int fhe_int64_le(const struct FheInt64 *lhs, const struct FheInt64 *rhs, struct FheBool **result);

/**
 * Returns the number of leading ones in the binary representation of input.
 */
int fhe_int64_leading_ones(const struct FheInt64 *input, struct FheUint32 **result);

/**
 * Returns the number of leading zeros in the binary representation of input.
 */
int fhe_int64_leading_zeros(const struct FheInt64 *input, struct FheUint32 **result);

int fhe_int64_lt(const struct FheInt64 *lhs, const struct FheInt64 *rhs, struct FheBool **result);

int fhe_int64_max(const struct FheInt64 *lhs, const struct FheInt64 *rhs, struct FheInt64 **result);

int fhe_int64_min(const struct FheInt64 *lhs, const struct FheInt64 *rhs, struct FheInt64 **result);

int fhe_int64_mul(const struct FheInt64 *lhs, const struct FheInt64 *rhs, struct FheInt64 **result);

int fhe_int64_mul_assign(struct FheInt64 *lhs, const struct FheInt64 *rhs);

int fhe_int64_ne(const struct FheInt64 *lhs, const struct FheInt64 *rhs, struct FheBool **result);

int fhe_int64_neg(const struct FheInt64 *input, struct FheInt64 **result);

int fhe_int64_not(const struct FheInt64 *input, struct FheInt64 **result);

int fhe_int64_overflowing_add(const struct FheInt64 *lhs,
                              const struct FheInt64 *rhs,
                              struct FheInt64 **out_result,
                              struct FheBool **out_overflowed);

int fhe_int64_overflowing_mul(const struct FheInt64 *lhs,
                              const struct FheInt64 *rhs,
                              struct FheInt64 **out_result,
                              struct FheBool **out_overflowed);

int fhe_int64_overflowing_sub(const struct FheInt64 *lhs,
                              const struct FheInt64 *rhs,
                              struct FheInt64 **out_result,
                              struct FheBool **out_overflowed);

int fhe_int64_rem(const struct FheInt64 *lhs, const struct FheInt64 *rhs, struct FheInt64 **result);

int fhe_int64_rem_assign(struct FheInt64 *lhs, const struct FheInt64 *rhs);

int fhe_int64_rotate_left(const struct FheInt64 *lhs,
                          const struct FheUint64 *rhs,
                          struct FheInt64 **result);

int fhe_int64_rotate_left_assign(struct FheInt64 *lhs, const struct FheUint64 *rhs);

int fhe_int64_rotate_right(const struct FheInt64 *lhs,
                           const struct FheUint64 *rhs,
                           struct FheInt64 **result);

int fhe_int64_rotate_right_assign(struct FheInt64 *lhs, const struct FheUint64 *rhs);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int fhe_int64_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                          uint64_t serialized_size_limit,
                                          const struct ServerKey *server_key,
                                          struct FheInt64 **result);

int fhe_int64_safe_serialize(const struct FheInt64 *sself,
                             DynamicBuffer *result,
                             uint64_t serialized_size_limit);

int fhe_int64_scalar_add(const struct FheInt64 *lhs, int64_t rhs, struct FheInt64 **result);

int fhe_int64_scalar_add_assign(struct FheInt64 *lhs, int64_t rhs);

int fhe_int64_scalar_bitand(const struct FheInt64 *lhs, int64_t rhs, struct FheInt64 **result);

int fhe_int64_scalar_bitand_assign(struct FheInt64 *lhs, int64_t rhs);

int fhe_int64_scalar_bitor(const struct FheInt64 *lhs, int64_t rhs, struct FheInt64 **result);

int fhe_int64_scalar_bitor_assign(struct FheInt64 *lhs, int64_t rhs);

int fhe_int64_scalar_bitxor(const struct FheInt64 *lhs, int64_t rhs, struct FheInt64 **result);

int fhe_int64_scalar_bitxor_assign(struct FheInt64 *lhs, int64_t rhs);

int fhe_int64_scalar_div(const struct FheInt64 *lhs, int64_t rhs, struct FheInt64 **result);

int fhe_int64_scalar_div_assign(struct FheInt64 *lhs, int64_t rhs);

int fhe_int64_scalar_div_rem(const struct FheInt64 *lhs,
                             int64_t rhs,
                             struct FheInt64 **q_result,
                             struct FheInt64 **r_result);

int fhe_int64_scalar_eq(const struct FheInt64 *lhs, int64_t rhs, struct FheBool **result);

int fhe_int64_scalar_ge(const struct FheInt64 *lhs, int64_t rhs, struct FheBool **result);

int fhe_int64_scalar_gt(const struct FheInt64 *lhs, int64_t rhs, struct FheBool **result);

int fhe_int64_scalar_le(const struct FheInt64 *lhs, int64_t rhs, struct FheBool **result);

int fhe_int64_scalar_lt(const struct FheInt64 *lhs, int64_t rhs, struct FheBool **result);

int fhe_int64_scalar_max(const struct FheInt64 *lhs, int64_t rhs, struct FheInt64 **result);

int fhe_int64_scalar_min(const struct FheInt64 *lhs, int64_t rhs, struct FheInt64 **result);

int fhe_int64_scalar_mul(const struct FheInt64 *lhs, int64_t rhs, struct FheInt64 **result);

int fhe_int64_scalar_mul_assign(struct FheInt64 *lhs, int64_t rhs);

int fhe_int64_scalar_ne(const struct FheInt64 *lhs, int64_t rhs, struct FheBool **result);

int fhe_int64_scalar_rem(const struct FheInt64 *lhs, int64_t rhs, struct FheInt64 **result);

int fhe_int64_scalar_rem_assign(struct FheInt64 *lhs, int64_t rhs);

int fhe_int64_scalar_rotate_left(const struct FheInt64 *lhs,
                                 uint64_t rhs,
                                 struct FheInt64 **result);

int fhe_int64_scalar_rotate_left_assign(struct FheInt64 *lhs, uint64_t rhs);

int fhe_int64_scalar_rotate_right(const struct FheInt64 *lhs,
                                  uint64_t rhs,
                                  struct FheInt64 **result);

int fhe_int64_scalar_rotate_right_assign(struct FheInt64 *lhs, uint64_t rhs);

int fhe_int64_scalar_shl(const struct FheInt64 *lhs, uint64_t rhs, struct FheInt64 **result);

int fhe_int64_scalar_shl_assign(struct FheInt64 *lhs, uint64_t rhs);

int fhe_int64_scalar_shr(const struct FheInt64 *lhs, uint64_t rhs, struct FheInt64 **result);

int fhe_int64_scalar_shr_assign(struct FheInt64 *lhs, uint64_t rhs);

int fhe_int64_scalar_sub(const struct FheInt64 *lhs, int64_t rhs, struct FheInt64 **result);

int fhe_int64_scalar_sub_assign(struct FheInt64 *lhs, int64_t rhs);

int fhe_int64_serialize(const struct FheInt64 *sself, DynamicBuffer *result);

int fhe_int64_shl(const struct FheInt64 *lhs,
                  const struct FheUint64 *rhs,
                  struct FheInt64 **result);

int fhe_int64_shl_assign(struct FheInt64 *lhs, const struct FheUint64 *rhs);

int fhe_int64_shr(const struct FheInt64 *lhs,
                  const struct FheUint64 *rhs,
                  struct FheInt64 **result);

int fhe_int64_shr_assign(struct FheInt64 *lhs, const struct FheUint64 *rhs);

int fhe_int64_sub(const struct FheInt64 *lhs, const struct FheInt64 *rhs, struct FheInt64 **result);

int fhe_int64_sub_assign(struct FheInt64 *lhs, const struct FheInt64 *rhs);

int fhe_int64_sum(const struct FheInt64 *const *lhs, size_t len, struct FheInt64 **out_result);

/**
 * Returns the number of trailing ones in the binary representation of input.
 */
int fhe_int64_trailing_ones(const struct FheInt64 *input, struct FheUint32 **result);

/**
 * Returns the number of trailing zeros in the binary representation of input.
 */
int fhe_int64_trailing_zeros(const struct FheInt64 *input, struct FheUint32 **result);

int fhe_int64_try_decrypt_trivial(const struct FheInt64 *encrypted_value, int64_t *result);

int fhe_int64_try_encrypt_trivial_i64(int64_t value, struct FheInt64 **result);

int fhe_int64_try_encrypt_with_client_key_i64(int64_t value,
                                              const struct ClientKey *client_key,
                                              struct FheInt64 **result);

int fhe_int64_try_encrypt_with_compact_public_key_i64(int64_t value,
                                                      const struct CompactPublicKey *public_key,
                                                      struct FheInt64 **result);

int fhe_int64_try_encrypt_with_public_key_i64(int64_t value,
                                              const struct PublicKey *public_key,
                                              struct FheInt64 **result);

int fhe_int6_add(const struct FheInt6 *lhs, const struct FheInt6 *rhs, struct FheInt6 **result);

int fhe_int6_add_assign(struct FheInt6 *lhs, const struct FheInt6 *rhs);

int fhe_int6_bitand(const struct FheInt6 *lhs, const struct FheInt6 *rhs, struct FheInt6 **result);

int fhe_int6_bitand_assign(struct FheInt6 *lhs, const struct FheInt6 *rhs);

int fhe_int6_bitor(const struct FheInt6 *lhs, const struct FheInt6 *rhs, struct FheInt6 **result);

int fhe_int6_bitor_assign(struct FheInt6 *lhs, const struct FheInt6 *rhs);

int fhe_int6_bitxor(const struct FheInt6 *lhs, const struct FheInt6 *rhs, struct FheInt6 **result);

int fhe_int6_bitxor_assign(struct FheInt6 *lhs, const struct FheInt6 *rhs);

int fhe_int6_cast_into_fhe_int10(const struct FheInt6 *sself, struct FheInt10 **result);

int fhe_int6_cast_into_fhe_int12(const struct FheInt6 *sself, struct FheInt12 **result);

int fhe_int6_cast_into_fhe_int128(const struct FheInt6 *sself, struct FheInt128 **result);

int fhe_int6_cast_into_fhe_int14(const struct FheInt6 *sself, struct FheInt14 **result);

int fhe_int6_cast_into_fhe_int16(const struct FheInt6 *sself, struct FheInt16 **result);

int fhe_int6_cast_into_fhe_int160(const struct FheInt6 *sself, struct FheInt160 **result);

int fhe_int6_cast_into_fhe_int2(const struct FheInt6 *sself, struct FheInt2 **result);

int fhe_int6_cast_into_fhe_int256(const struct FheInt6 *sself, struct FheInt256 **result);

int fhe_int6_cast_into_fhe_int32(const struct FheInt6 *sself, struct FheInt32 **result);

int fhe_int6_cast_into_fhe_int4(const struct FheInt6 *sself, struct FheInt4 **result);

int fhe_int6_cast_into_fhe_int6(const struct FheInt6 *sself, struct FheInt6 **result);

int fhe_int6_cast_into_fhe_int64(const struct FheInt6 *sself, struct FheInt64 **result);

int fhe_int6_cast_into_fhe_int8(const struct FheInt6 *sself, struct FheInt8 **result);

int fhe_int6_cast_into_fhe_uint10(const struct FheInt6 *sself, struct FheUint10 **result);

int fhe_int6_cast_into_fhe_uint128(const struct FheInt6 *sself, struct FheUint128 **result);

int fhe_int6_cast_into_fhe_uint14(const struct FheInt6 *sself, struct FheUint14 **result);

int fhe_int6_cast_into_fhe_uint16(const struct FheInt6 *sself, struct FheUint16 **result);

int fhe_int6_cast_into_fhe_uint160(const struct FheInt6 *sself, struct FheUint160 **result);

int fhe_int6_cast_into_fhe_uint2(const struct FheInt6 *sself, struct FheUint2 **result);

int fhe_int6_cast_into_fhe_uint256(const struct FheInt6 *sself, struct FheUint256 **result);

int fhe_int6_cast_into_fhe_uint32(const struct FheInt6 *sself, struct FheUint32 **result);

int fhe_int6_cast_into_fhe_uint4(const struct FheInt6 *sself, struct FheUint4 **result);

int fhe_int6_cast_into_fhe_uint6(const struct FheInt6 *sself, struct FheUint6 **result);

int fhe_int6_cast_into_fhe_uint64(const struct FheInt6 *sself, struct FheUint64 **result);

int fhe_int6_cast_into_fhe_uint8(const struct FheInt6 *sself, struct FheUint8 **result);

/**
 * Returns the base 2 logarithm of the number, rounded down.
 *
 * Also returns a boolean flag that is true if the result is valid (i.e input was > 0)
 */
int fhe_int6_checked_ilog2(const struct FheInt6 *input,
                           struct FheUint32 **result_1,
                           struct FheBool **result_2);

int fhe_int6_clone(const struct FheInt6 *sself, struct FheInt6 **result);

int fhe_int6_compress(const struct FheInt6 *sself, struct CompressedFheInt6 **result);

int fhe_int6_decrypt(const struct FheInt6 *encrypted_value,
                     const struct ClientKey *client_key,
                     int8_t *result);

int fhe_int6_deserialize(DynamicBufferView buffer_view, struct FheInt6 **result);

/**
 *ptr can be null (no-op in that case)
 */
int fhe_int6_destroy(struct FheInt6 *ptr);

int fhe_int6_div(const struct FheInt6 *lhs, const struct FheInt6 *rhs, struct FheInt6 **result);

int fhe_int6_div_assign(struct FheInt6 *lhs, const struct FheInt6 *rhs);

int fhe_int6_div_rem(const struct FheInt6 *lhs,
                     const struct FheInt6 *rhs,
                     struct FheInt6 **q_result,
                     struct FheInt6 **r_result);

int fhe_int6_eq(const struct FheInt6 *lhs, const struct FheInt6 *rhs, struct FheBool **result);

int fhe_int6_ge(const struct FheInt6 *lhs, const struct FheInt6 *rhs, struct FheBool **result);

int fhe_int6_gt(const struct FheInt6 *lhs, const struct FheInt6 *rhs, struct FheBool **result);

int fhe_int6_if_then_else(const struct FheBool *condition_ct,
                          const struct FheInt6 *then_ct,
                          const struct FheInt6 *else_ct,
                          struct FheInt6 **result);

/**
 * Returns the base 2 logarithm of the number, rounded down.
 *
 * Result has no meaning if self encrypts a value that is <= 0.
 * See `checked_ilog2`
 */
int fhe_int6_ilog2(const struct FheInt6 *input, struct FheUint32 **result);

int fhe_int6_le(const struct FheInt6 *lhs, const struct FheInt6 *rhs, struct FheBool **result);

/**
 * Returns the number of leading ones in the binary representation of input.
 */
int fhe_int6_leading_ones(const struct FheInt6 *input, struct FheUint32 **result);

/**
 * Returns the number of leading zeros in the binary representation of input.
 */
int fhe_int6_leading_zeros(const struct FheInt6 *input, struct FheUint32 **result);

int fhe_int6_lt(const struct FheInt6 *lhs, const struct FheInt6 *rhs, struct FheBool **result);

int fhe_int6_max(const struct FheInt6 *lhs, const struct FheInt6 *rhs, struct FheInt6 **result);

int fhe_int6_min(const struct FheInt6 *lhs, const struct FheInt6 *rhs, struct FheInt6 **result);

int fhe_int6_mul(const struct FheInt6 *lhs, const struct FheInt6 *rhs, struct FheInt6 **result);

int fhe_int6_mul_assign(struct FheInt6 *lhs, const struct FheInt6 *rhs);

int fhe_int6_ne(const struct FheInt6 *lhs, const struct FheInt6 *rhs, struct FheBool **result);

int fhe_int6_neg(const struct FheInt6 *input, struct FheInt6 **result);

int fhe_int6_not(const struct FheInt6 *input, struct FheInt6 **result);

int fhe_int6_overflowing_add(const struct FheInt6 *lhs,
                             const struct FheInt6 *rhs,
                             struct FheInt6 **out_result,
                             struct FheBool **out_overflowed);

int fhe_int6_overflowing_mul(const struct FheInt6 *lhs,
                             const struct FheInt6 *rhs,
                             struct FheInt6 **out_result,
                             struct FheBool **out_overflowed);

int fhe_int6_overflowing_sub(const struct FheInt6 *lhs,
                             const struct FheInt6 *rhs,
                             struct FheInt6 **out_result,
                             struct FheBool **out_overflowed);

int fhe_int6_rem(const struct FheInt6 *lhs, const struct FheInt6 *rhs, struct FheInt6 **result);

int fhe_int6_rem_assign(struct FheInt6 *lhs, const struct FheInt6 *rhs);

int fhe_int6_rotate_left(const struct FheInt6 *lhs,
                         const struct FheUint6 *rhs,
                         struct FheInt6 **result);

int fhe_int6_rotate_left_assign(struct FheInt6 *lhs, const struct FheUint6 *rhs);

int fhe_int6_rotate_right(const struct FheInt6 *lhs,
                          const struct FheUint6 *rhs,
                          struct FheInt6 **result);

int fhe_int6_rotate_right_assign(struct FheInt6 *lhs, const struct FheUint6 *rhs);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int fhe_int6_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                         uint64_t serialized_size_limit,
                                         const struct ServerKey *server_key,
                                         struct FheInt6 **result);

int fhe_int6_safe_serialize(const struct FheInt6 *sself,
                            DynamicBuffer *result,
                            uint64_t serialized_size_limit);

int fhe_int6_scalar_add(const struct FheInt6 *lhs, int8_t rhs, struct FheInt6 **result);

int fhe_int6_scalar_add_assign(struct FheInt6 *lhs, int8_t rhs);

int fhe_int6_scalar_bitand(const struct FheInt6 *lhs, int8_t rhs, struct FheInt6 **result);

int fhe_int6_scalar_bitand_assign(struct FheInt6 *lhs, int8_t rhs);

int fhe_int6_scalar_bitor(const struct FheInt6 *lhs, int8_t rhs, struct FheInt6 **result);

int fhe_int6_scalar_bitor_assign(struct FheInt6 *lhs, int8_t rhs);

int fhe_int6_scalar_bitxor(const struct FheInt6 *lhs, int8_t rhs, struct FheInt6 **result);

int fhe_int6_scalar_bitxor_assign(struct FheInt6 *lhs, int8_t rhs);

int fhe_int6_scalar_div(const struct FheInt6 *lhs, int8_t rhs, struct FheInt6 **result);

int fhe_int6_scalar_div_assign(struct FheInt6 *lhs, int8_t rhs);

int fhe_int6_scalar_div_rem(const struct FheInt6 *lhs,
                            int8_t rhs,
                            struct FheInt6 **q_result,
                            struct FheInt6 **r_result);

int fhe_int6_scalar_eq(const struct FheInt6 *lhs, int8_t rhs, struct FheBool **result);

int fhe_int6_scalar_ge(const struct FheInt6 *lhs, int8_t rhs, struct FheBool **result);

int fhe_int6_scalar_gt(const struct FheInt6 *lhs, int8_t rhs, struct FheBool **result);

int fhe_int6_scalar_le(const struct FheInt6 *lhs, int8_t rhs, struct FheBool **result);

int fhe_int6_scalar_lt(const struct FheInt6 *lhs, int8_t rhs, struct FheBool **result);

int fhe_int6_scalar_max(const struct FheInt6 *lhs, int8_t rhs, struct FheInt6 **result);

int fhe_int6_scalar_min(const struct FheInt6 *lhs, int8_t rhs, struct FheInt6 **result);

int fhe_int6_scalar_mul(const struct FheInt6 *lhs, int8_t rhs, struct FheInt6 **result);

int fhe_int6_scalar_mul_assign(struct FheInt6 *lhs, int8_t rhs);

int fhe_int6_scalar_ne(const struct FheInt6 *lhs, int8_t rhs, struct FheBool **result);

int fhe_int6_scalar_rem(const struct FheInt6 *lhs, int8_t rhs, struct FheInt6 **result);

int fhe_int6_scalar_rem_assign(struct FheInt6 *lhs, int8_t rhs);

int fhe_int6_scalar_rotate_left(const struct FheInt6 *lhs, uint8_t rhs, struct FheInt6 **result);

int fhe_int6_scalar_rotate_left_assign(struct FheInt6 *lhs, uint8_t rhs);

int fhe_int6_scalar_rotate_right(const struct FheInt6 *lhs, uint8_t rhs, struct FheInt6 **result);

int fhe_int6_scalar_rotate_right_assign(struct FheInt6 *lhs, uint8_t rhs);

int fhe_int6_scalar_shl(const struct FheInt6 *lhs, uint8_t rhs, struct FheInt6 **result);

int fhe_int6_scalar_shl_assign(struct FheInt6 *lhs, uint8_t rhs);

int fhe_int6_scalar_shr(const struct FheInt6 *lhs, uint8_t rhs, struct FheInt6 **result);

int fhe_int6_scalar_shr_assign(struct FheInt6 *lhs, uint8_t rhs);

int fhe_int6_scalar_sub(const struct FheInt6 *lhs, int8_t rhs, struct FheInt6 **result);

int fhe_int6_scalar_sub_assign(struct FheInt6 *lhs, int8_t rhs);

int fhe_int6_serialize(const struct FheInt6 *sself, DynamicBuffer *result);

int fhe_int6_shl(const struct FheInt6 *lhs, const struct FheUint6 *rhs, struct FheInt6 **result);

int fhe_int6_shl_assign(struct FheInt6 *lhs, const struct FheUint6 *rhs);

int fhe_int6_shr(const struct FheInt6 *lhs, const struct FheUint6 *rhs, struct FheInt6 **result);

int fhe_int6_shr_assign(struct FheInt6 *lhs, const struct FheUint6 *rhs);

int fhe_int6_sub(const struct FheInt6 *lhs, const struct FheInt6 *rhs, struct FheInt6 **result);

int fhe_int6_sub_assign(struct FheInt6 *lhs, const struct FheInt6 *rhs);

int fhe_int6_sum(const struct FheInt6 *const *lhs, size_t len, struct FheInt6 **out_result);

/**
 * Returns the number of trailing ones in the binary representation of input.
 */
int fhe_int6_trailing_ones(const struct FheInt6 *input, struct FheUint32 **result);

/**
 * Returns the number of trailing zeros in the binary representation of input.
 */
int fhe_int6_trailing_zeros(const struct FheInt6 *input, struct FheUint32 **result);

int fhe_int6_try_decrypt_trivial(const struct FheInt6 *encrypted_value, int8_t *result);

int fhe_int6_try_encrypt_trivial_i8(int8_t value, struct FheInt6 **result);

int fhe_int6_try_encrypt_with_client_key_i8(int8_t value,
                                            const struct ClientKey *client_key,
                                            struct FheInt6 **result);

int fhe_int6_try_encrypt_with_compact_public_key_i8(int8_t value,
                                                    const struct CompactPublicKey *public_key,
                                                    struct FheInt6 **result);

int fhe_int6_try_encrypt_with_public_key_i8(int8_t value,
                                            const struct PublicKey *public_key,
                                            struct FheInt6 **result);

int fhe_int8_add(const struct FheInt8 *lhs, const struct FheInt8 *rhs, struct FheInt8 **result);

int fhe_int8_add_assign(struct FheInt8 *lhs, const struct FheInt8 *rhs);

int fhe_int8_bitand(const struct FheInt8 *lhs, const struct FheInt8 *rhs, struct FheInt8 **result);

int fhe_int8_bitand_assign(struct FheInt8 *lhs, const struct FheInt8 *rhs);

int fhe_int8_bitor(const struct FheInt8 *lhs, const struct FheInt8 *rhs, struct FheInt8 **result);

int fhe_int8_bitor_assign(struct FheInt8 *lhs, const struct FheInt8 *rhs);

int fhe_int8_bitxor(const struct FheInt8 *lhs, const struct FheInt8 *rhs, struct FheInt8 **result);

int fhe_int8_bitxor_assign(struct FheInt8 *lhs, const struct FheInt8 *rhs);

int fhe_int8_cast_into_fhe_int10(const struct FheInt8 *sself, struct FheInt10 **result);

int fhe_int8_cast_into_fhe_int12(const struct FheInt8 *sself, struct FheInt12 **result);

int fhe_int8_cast_into_fhe_int128(const struct FheInt8 *sself, struct FheInt128 **result);

int fhe_int8_cast_into_fhe_int14(const struct FheInt8 *sself, struct FheInt14 **result);

int fhe_int8_cast_into_fhe_int16(const struct FheInt8 *sself, struct FheInt16 **result);

int fhe_int8_cast_into_fhe_int160(const struct FheInt8 *sself, struct FheInt160 **result);

int fhe_int8_cast_into_fhe_int2(const struct FheInt8 *sself, struct FheInt2 **result);

int fhe_int8_cast_into_fhe_int256(const struct FheInt8 *sself, struct FheInt256 **result);

int fhe_int8_cast_into_fhe_int32(const struct FheInt8 *sself, struct FheInt32 **result);

int fhe_int8_cast_into_fhe_int4(const struct FheInt8 *sself, struct FheInt4 **result);

int fhe_int8_cast_into_fhe_int6(const struct FheInt8 *sself, struct FheInt6 **result);

int fhe_int8_cast_into_fhe_int64(const struct FheInt8 *sself, struct FheInt64 **result);

int fhe_int8_cast_into_fhe_int8(const struct FheInt8 *sself, struct FheInt8 **result);

int fhe_int8_cast_into_fhe_uint10(const struct FheInt8 *sself, struct FheUint10 **result);

int fhe_int8_cast_into_fhe_uint128(const struct FheInt8 *sself, struct FheUint128 **result);

int fhe_int8_cast_into_fhe_uint14(const struct FheInt8 *sself, struct FheUint14 **result);

int fhe_int8_cast_into_fhe_uint16(const struct FheInt8 *sself, struct FheUint16 **result);

int fhe_int8_cast_into_fhe_uint160(const struct FheInt8 *sself, struct FheUint160 **result);

int fhe_int8_cast_into_fhe_uint2(const struct FheInt8 *sself, struct FheUint2 **result);

int fhe_int8_cast_into_fhe_uint256(const struct FheInt8 *sself, struct FheUint256 **result);

int fhe_int8_cast_into_fhe_uint32(const struct FheInt8 *sself, struct FheUint32 **result);

int fhe_int8_cast_into_fhe_uint4(const struct FheInt8 *sself, struct FheUint4 **result);

int fhe_int8_cast_into_fhe_uint6(const struct FheInt8 *sself, struct FheUint6 **result);

int fhe_int8_cast_into_fhe_uint64(const struct FheInt8 *sself, struct FheUint64 **result);

int fhe_int8_cast_into_fhe_uint8(const struct FheInt8 *sself, struct FheUint8 **result);

/**
 * Returns the base 2 logarithm of the number, rounded down.
 *
 * Also returns a boolean flag that is true if the result is valid (i.e input was > 0)
 */
int fhe_int8_checked_ilog2(const struct FheInt8 *input,
                           struct FheUint32 **result_1,
                           struct FheBool **result_2);

int fhe_int8_clone(const struct FheInt8 *sself, struct FheInt8 **result);

int fhe_int8_compress(const struct FheInt8 *sself, struct CompressedFheInt8 **result);

int fhe_int8_decrypt(const struct FheInt8 *encrypted_value,
                     const struct ClientKey *client_key,
                     int8_t *result);

int fhe_int8_deserialize(DynamicBufferView buffer_view, struct FheInt8 **result);

/**
 *ptr can be null (no-op in that case)
 */
int fhe_int8_destroy(struct FheInt8 *ptr);

int fhe_int8_div(const struct FheInt8 *lhs, const struct FheInt8 *rhs, struct FheInt8 **result);

int fhe_int8_div_assign(struct FheInt8 *lhs, const struct FheInt8 *rhs);

int fhe_int8_div_rem(const struct FheInt8 *lhs,
                     const struct FheInt8 *rhs,
                     struct FheInt8 **q_result,
                     struct FheInt8 **r_result);

int fhe_int8_eq(const struct FheInt8 *lhs, const struct FheInt8 *rhs, struct FheBool **result);

int fhe_int8_ge(const struct FheInt8 *lhs, const struct FheInt8 *rhs, struct FheBool **result);

int fhe_int8_gt(const struct FheInt8 *lhs, const struct FheInt8 *rhs, struct FheBool **result);

int fhe_int8_if_then_else(const struct FheBool *condition_ct,
                          const struct FheInt8 *then_ct,
                          const struct FheInt8 *else_ct,
                          struct FheInt8 **result);

/**
 * Returns the base 2 logarithm of the number, rounded down.
 *
 * Result has no meaning if self encrypts a value that is <= 0.
 * See `checked_ilog2`
 */
int fhe_int8_ilog2(const struct FheInt8 *input, struct FheUint32 **result);

int fhe_int8_le(const struct FheInt8 *lhs, const struct FheInt8 *rhs, struct FheBool **result);

/**
 * Returns the number of leading ones in the binary representation of input.
 */
int fhe_int8_leading_ones(const struct FheInt8 *input, struct FheUint32 **result);

/**
 * Returns the number of leading zeros in the binary representation of input.
 */
int fhe_int8_leading_zeros(const struct FheInt8 *input, struct FheUint32 **result);

int fhe_int8_lt(const struct FheInt8 *lhs, const struct FheInt8 *rhs, struct FheBool **result);

int fhe_int8_max(const struct FheInt8 *lhs, const struct FheInt8 *rhs, struct FheInt8 **result);

int fhe_int8_min(const struct FheInt8 *lhs, const struct FheInt8 *rhs, struct FheInt8 **result);

int fhe_int8_mul(const struct FheInt8 *lhs, const struct FheInt8 *rhs, struct FheInt8 **result);

int fhe_int8_mul_assign(struct FheInt8 *lhs, const struct FheInt8 *rhs);

int fhe_int8_ne(const struct FheInt8 *lhs, const struct FheInt8 *rhs, struct FheBool **result);

int fhe_int8_neg(const struct FheInt8 *input, struct FheInt8 **result);

int fhe_int8_not(const struct FheInt8 *input, struct FheInt8 **result);

int fhe_int8_overflowing_add(const struct FheInt8 *lhs,
                             const struct FheInt8 *rhs,
                             struct FheInt8 **out_result,
                             struct FheBool **out_overflowed);

int fhe_int8_overflowing_mul(const struct FheInt8 *lhs,
                             const struct FheInt8 *rhs,
                             struct FheInt8 **out_result,
                             struct FheBool **out_overflowed);

int fhe_int8_overflowing_sub(const struct FheInt8 *lhs,
                             const struct FheInt8 *rhs,
                             struct FheInt8 **out_result,
                             struct FheBool **out_overflowed);

int fhe_int8_rem(const struct FheInt8 *lhs, const struct FheInt8 *rhs, struct FheInt8 **result);

int fhe_int8_rem_assign(struct FheInt8 *lhs, const struct FheInt8 *rhs);

int fhe_int8_rotate_left(const struct FheInt8 *lhs,
                         const struct FheUint8 *rhs,
                         struct FheInt8 **result);

int fhe_int8_rotate_left_assign(struct FheInt8 *lhs, const struct FheUint8 *rhs);

int fhe_int8_rotate_right(const struct FheInt8 *lhs,
                          const struct FheUint8 *rhs,
                          struct FheInt8 **result);

int fhe_int8_rotate_right_assign(struct FheInt8 *lhs, const struct FheUint8 *rhs);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int fhe_int8_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                         uint64_t serialized_size_limit,
                                         const struct ServerKey *server_key,
                                         struct FheInt8 **result);

int fhe_int8_safe_serialize(const struct FheInt8 *sself,
                            DynamicBuffer *result,
                            uint64_t serialized_size_limit);

int fhe_int8_scalar_add(const struct FheInt8 *lhs, int8_t rhs, struct FheInt8 **result);

int fhe_int8_scalar_add_assign(struct FheInt8 *lhs, int8_t rhs);

int fhe_int8_scalar_bitand(const struct FheInt8 *lhs, int8_t rhs, struct FheInt8 **result);

int fhe_int8_scalar_bitand_assign(struct FheInt8 *lhs, int8_t rhs);

int fhe_int8_scalar_bitor(const struct FheInt8 *lhs, int8_t rhs, struct FheInt8 **result);

int fhe_int8_scalar_bitor_assign(struct FheInt8 *lhs, int8_t rhs);

int fhe_int8_scalar_bitxor(const struct FheInt8 *lhs, int8_t rhs, struct FheInt8 **result);

int fhe_int8_scalar_bitxor_assign(struct FheInt8 *lhs, int8_t rhs);

int fhe_int8_scalar_div(const struct FheInt8 *lhs, int8_t rhs, struct FheInt8 **result);

int fhe_int8_scalar_div_assign(struct FheInt8 *lhs, int8_t rhs);

int fhe_int8_scalar_div_rem(const struct FheInt8 *lhs,
                            int8_t rhs,
                            struct FheInt8 **q_result,
                            struct FheInt8 **r_result);

int fhe_int8_scalar_eq(const struct FheInt8 *lhs, int8_t rhs, struct FheBool **result);

int fhe_int8_scalar_ge(const struct FheInt8 *lhs, int8_t rhs, struct FheBool **result);

int fhe_int8_scalar_gt(const struct FheInt8 *lhs, int8_t rhs, struct FheBool **result);

int fhe_int8_scalar_le(const struct FheInt8 *lhs, int8_t rhs, struct FheBool **result);

int fhe_int8_scalar_lt(const struct FheInt8 *lhs, int8_t rhs, struct FheBool **result);

int fhe_int8_scalar_max(const struct FheInt8 *lhs, int8_t rhs, struct FheInt8 **result);

int fhe_int8_scalar_min(const struct FheInt8 *lhs, int8_t rhs, struct FheInt8 **result);

int fhe_int8_scalar_mul(const struct FheInt8 *lhs, int8_t rhs, struct FheInt8 **result);

int fhe_int8_scalar_mul_assign(struct FheInt8 *lhs, int8_t rhs);

int fhe_int8_scalar_ne(const struct FheInt8 *lhs, int8_t rhs, struct FheBool **result);

int fhe_int8_scalar_rem(const struct FheInt8 *lhs, int8_t rhs, struct FheInt8 **result);

int fhe_int8_scalar_rem_assign(struct FheInt8 *lhs, int8_t rhs);

int fhe_int8_scalar_rotate_left(const struct FheInt8 *lhs, uint8_t rhs, struct FheInt8 **result);

int fhe_int8_scalar_rotate_left_assign(struct FheInt8 *lhs, uint8_t rhs);

int fhe_int8_scalar_rotate_right(const struct FheInt8 *lhs, uint8_t rhs, struct FheInt8 **result);

int fhe_int8_scalar_rotate_right_assign(struct FheInt8 *lhs, uint8_t rhs);

int fhe_int8_scalar_shl(const struct FheInt8 *lhs, uint8_t rhs, struct FheInt8 **result);

int fhe_int8_scalar_shl_assign(struct FheInt8 *lhs, uint8_t rhs);

int fhe_int8_scalar_shr(const struct FheInt8 *lhs, uint8_t rhs, struct FheInt8 **result);

int fhe_int8_scalar_shr_assign(struct FheInt8 *lhs, uint8_t rhs);

int fhe_int8_scalar_sub(const struct FheInt8 *lhs, int8_t rhs, struct FheInt8 **result);

int fhe_int8_scalar_sub_assign(struct FheInt8 *lhs, int8_t rhs);

int fhe_int8_serialize(const struct FheInt8 *sself, DynamicBuffer *result);

int fhe_int8_shl(const struct FheInt8 *lhs, const struct FheUint8 *rhs, struct FheInt8 **result);

int fhe_int8_shl_assign(struct FheInt8 *lhs, const struct FheUint8 *rhs);

int fhe_int8_shr(const struct FheInt8 *lhs, const struct FheUint8 *rhs, struct FheInt8 **result);

int fhe_int8_shr_assign(struct FheInt8 *lhs, const struct FheUint8 *rhs);

int fhe_int8_sub(const struct FheInt8 *lhs, const struct FheInt8 *rhs, struct FheInt8 **result);

int fhe_int8_sub_assign(struct FheInt8 *lhs, const struct FheInt8 *rhs);

int fhe_int8_sum(const struct FheInt8 *const *lhs, size_t len, struct FheInt8 **out_result);

/**
 * Returns the number of trailing ones in the binary representation of input.
 */
int fhe_int8_trailing_ones(const struct FheInt8 *input, struct FheUint32 **result);

/**
 * Returns the number of trailing zeros in the binary representation of input.
 */
int fhe_int8_trailing_zeros(const struct FheInt8 *input, struct FheUint32 **result);

int fhe_int8_try_decrypt_trivial(const struct FheInt8 *encrypted_value, int8_t *result);

int fhe_int8_try_encrypt_trivial_i8(int8_t value, struct FheInt8 **result);

int fhe_int8_try_encrypt_with_client_key_i8(int8_t value,
                                            const struct ClientKey *client_key,
                                            struct FheInt8 **result);

int fhe_int8_try_encrypt_with_compact_public_key_i8(int8_t value,
                                                    const struct CompactPublicKey *public_key,
                                                    struct FheInt8 **result);

int fhe_int8_try_encrypt_with_public_key_i8(int8_t value,
                                            const struct PublicKey *public_key,
                                            struct FheInt8 **result);

int fhe_uint10_add(const struct FheUint10 *lhs,
                   const struct FheUint10 *rhs,
                   struct FheUint10 **result);

int fhe_uint10_add_assign(struct FheUint10 *lhs, const struct FheUint10 *rhs);

int fhe_uint10_bitand(const struct FheUint10 *lhs,
                      const struct FheUint10 *rhs,
                      struct FheUint10 **result);

int fhe_uint10_bitand_assign(struct FheUint10 *lhs, const struct FheUint10 *rhs);

int fhe_uint10_bitor(const struct FheUint10 *lhs,
                     const struct FheUint10 *rhs,
                     struct FheUint10 **result);

int fhe_uint10_bitor_assign(struct FheUint10 *lhs, const struct FheUint10 *rhs);

int fhe_uint10_bitxor(const struct FheUint10 *lhs,
                      const struct FheUint10 *rhs,
                      struct FheUint10 **result);

int fhe_uint10_bitxor_assign(struct FheUint10 *lhs, const struct FheUint10 *rhs);

int fhe_uint10_cast_into_fhe_int10(const struct FheUint10 *sself, struct FheInt10 **result);

int fhe_uint10_cast_into_fhe_int12(const struct FheUint10 *sself, struct FheInt12 **result);

int fhe_uint10_cast_into_fhe_int128(const struct FheUint10 *sself, struct FheInt128 **result);

int fhe_uint10_cast_into_fhe_int14(const struct FheUint10 *sself, struct FheInt14 **result);

int fhe_uint10_cast_into_fhe_int16(const struct FheUint10 *sself, struct FheInt16 **result);

int fhe_uint10_cast_into_fhe_int160(const struct FheUint10 *sself, struct FheInt160 **result);

int fhe_uint10_cast_into_fhe_int2(const struct FheUint10 *sself, struct FheInt2 **result);

int fhe_uint10_cast_into_fhe_int256(const struct FheUint10 *sself, struct FheInt256 **result);

int fhe_uint10_cast_into_fhe_int32(const struct FheUint10 *sself, struct FheInt32 **result);

int fhe_uint10_cast_into_fhe_int4(const struct FheUint10 *sself, struct FheInt4 **result);

int fhe_uint10_cast_into_fhe_int6(const struct FheUint10 *sself, struct FheInt6 **result);

int fhe_uint10_cast_into_fhe_int64(const struct FheUint10 *sself, struct FheInt64 **result);

int fhe_uint10_cast_into_fhe_int8(const struct FheUint10 *sself, struct FheInt8 **result);

int fhe_uint10_cast_into_fhe_uint10(const struct FheUint10 *sself, struct FheUint10 **result);

int fhe_uint10_cast_into_fhe_uint128(const struct FheUint10 *sself, struct FheUint128 **result);

int fhe_uint10_cast_into_fhe_uint14(const struct FheUint10 *sself, struct FheUint14 **result);

int fhe_uint10_cast_into_fhe_uint16(const struct FheUint10 *sself, struct FheUint16 **result);

int fhe_uint10_cast_into_fhe_uint160(const struct FheUint10 *sself, struct FheUint160 **result);

int fhe_uint10_cast_into_fhe_uint2(const struct FheUint10 *sself, struct FheUint2 **result);

int fhe_uint10_cast_into_fhe_uint256(const struct FheUint10 *sself, struct FheUint256 **result);

int fhe_uint10_cast_into_fhe_uint32(const struct FheUint10 *sself, struct FheUint32 **result);

int fhe_uint10_cast_into_fhe_uint4(const struct FheUint10 *sself, struct FheUint4 **result);

int fhe_uint10_cast_into_fhe_uint6(const struct FheUint10 *sself, struct FheUint6 **result);

int fhe_uint10_cast_into_fhe_uint64(const struct FheUint10 *sself, struct FheUint64 **result);

int fhe_uint10_cast_into_fhe_uint8(const struct FheUint10 *sself, struct FheUint8 **result);

/**
 * Returns the base 2 logarithm of the number, rounded down.
 *
 * Also returns a boolean flag that is true if the result is valid (i.e input was > 0)
 */
int fhe_uint10_checked_ilog2(const struct FheUint10 *input,
                             struct FheUint32 **result_1,
                             struct FheBool **result_2);

int fhe_uint10_clone(const struct FheUint10 *sself, struct FheUint10 **result);

int fhe_uint10_compress(const struct FheUint10 *sself, struct CompressedFheUint10 **result);

int fhe_uint10_decrypt(const struct FheUint10 *encrypted_value,
                       const struct ClientKey *client_key,
                       uint16_t *result);

int fhe_uint10_deserialize(DynamicBufferView buffer_view, struct FheUint10 **result);

/**
 *ptr can be null (no-op in that case)
 */
int fhe_uint10_destroy(struct FheUint10 *ptr);

int fhe_uint10_div(const struct FheUint10 *lhs,
                   const struct FheUint10 *rhs,
                   struct FheUint10 **result);

int fhe_uint10_div_assign(struct FheUint10 *lhs, const struct FheUint10 *rhs);

int fhe_uint10_div_rem(const struct FheUint10 *lhs,
                       const struct FheUint10 *rhs,
                       struct FheUint10 **q_result,
                       struct FheUint10 **r_result);

int fhe_uint10_eq(const struct FheUint10 *lhs,
                  const struct FheUint10 *rhs,
                  struct FheBool **result);

int fhe_uint10_ge(const struct FheUint10 *lhs,
                  const struct FheUint10 *rhs,
                  struct FheBool **result);

int fhe_uint10_gt(const struct FheUint10 *lhs,
                  const struct FheUint10 *rhs,
                  struct FheBool **result);

int fhe_uint10_if_then_else(const struct FheBool *condition_ct,
                            const struct FheUint10 *then_ct,
                            const struct FheUint10 *else_ct,
                            struct FheUint10 **result);

/**
 * Returns the base 2 logarithm of the number, rounded down.
 *
 * Result has no meaning if self encrypts a value that is <= 0.
 * See `checked_ilog2`
 */
int fhe_uint10_ilog2(const struct FheUint10 *input, struct FheUint32 **result);

int fhe_uint10_le(const struct FheUint10 *lhs,
                  const struct FheUint10 *rhs,
                  struct FheBool **result);

/**
 * Returns the number of leading ones in the binary representation of input.
 */
int fhe_uint10_leading_ones(const struct FheUint10 *input, struct FheUint32 **result);

/**
 * Returns the number of leading zeros in the binary representation of input.
 */
int fhe_uint10_leading_zeros(const struct FheUint10 *input, struct FheUint32 **result);

int fhe_uint10_lt(const struct FheUint10 *lhs,
                  const struct FheUint10 *rhs,
                  struct FheBool **result);

int fhe_uint10_max(const struct FheUint10 *lhs,
                   const struct FheUint10 *rhs,
                   struct FheUint10 **result);

int fhe_uint10_min(const struct FheUint10 *lhs,
                   const struct FheUint10 *rhs,
                   struct FheUint10 **result);

int fhe_uint10_mul(const struct FheUint10 *lhs,
                   const struct FheUint10 *rhs,
                   struct FheUint10 **result);

int fhe_uint10_mul_assign(struct FheUint10 *lhs, const struct FheUint10 *rhs);

int fhe_uint10_ne(const struct FheUint10 *lhs,
                  const struct FheUint10 *rhs,
                  struct FheBool **result);

int fhe_uint10_neg(const struct FheUint10 *input, struct FheUint10 **result);

int fhe_uint10_not(const struct FheUint10 *input, struct FheUint10 **result);

int fhe_uint10_overflowing_add(const struct FheUint10 *lhs,
                               const struct FheUint10 *rhs,
                               struct FheUint10 **out_result,
                               struct FheBool **out_overflowed);

int fhe_uint10_overflowing_mul(const struct FheUint10 *lhs,
                               const struct FheUint10 *rhs,
                               struct FheUint10 **out_result,
                               struct FheBool **out_overflowed);

int fhe_uint10_overflowing_sub(const struct FheUint10 *lhs,
                               const struct FheUint10 *rhs,
                               struct FheUint10 **out_result,
                               struct FheBool **out_overflowed);

int fhe_uint10_rem(const struct FheUint10 *lhs,
                   const struct FheUint10 *rhs,
                   struct FheUint10 **result);

int fhe_uint10_rem_assign(struct FheUint10 *lhs, const struct FheUint10 *rhs);

int fhe_uint10_rotate_left(const struct FheUint10 *lhs,
                           const struct FheUint10 *rhs,
                           struct FheUint10 **result);

int fhe_uint10_rotate_left_assign(struct FheUint10 *lhs, const struct FheUint10 *rhs);

int fhe_uint10_rotate_right(const struct FheUint10 *lhs,
                            const struct FheUint10 *rhs,
                            struct FheUint10 **result);

int fhe_uint10_rotate_right_assign(struct FheUint10 *lhs, const struct FheUint10 *rhs);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int fhe_uint10_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                           uint64_t serialized_size_limit,
                                           const struct ServerKey *server_key,
                                           struct FheUint10 **result);

int fhe_uint10_safe_serialize(const struct FheUint10 *sself,
                              DynamicBuffer *result,
                              uint64_t serialized_size_limit);

int fhe_uint10_scalar_add(const struct FheUint10 *lhs, uint16_t rhs, struct FheUint10 **result);

int fhe_uint10_scalar_add_assign(struct FheUint10 *lhs, uint16_t rhs);

int fhe_uint10_scalar_bitand(const struct FheUint10 *lhs, uint16_t rhs, struct FheUint10 **result);

int fhe_uint10_scalar_bitand_assign(struct FheUint10 *lhs, uint16_t rhs);

int fhe_uint10_scalar_bitor(const struct FheUint10 *lhs, uint16_t rhs, struct FheUint10 **result);

int fhe_uint10_scalar_bitor_assign(struct FheUint10 *lhs, uint16_t rhs);

int fhe_uint10_scalar_bitxor(const struct FheUint10 *lhs, uint16_t rhs, struct FheUint10 **result);

int fhe_uint10_scalar_bitxor_assign(struct FheUint10 *lhs, uint16_t rhs);

int fhe_uint10_scalar_div(const struct FheUint10 *lhs, uint16_t rhs, struct FheUint10 **result);

int fhe_uint10_scalar_div_assign(struct FheUint10 *lhs, uint16_t rhs);

int fhe_uint10_scalar_div_rem(const struct FheUint10 *lhs,
                              uint16_t rhs,
                              struct FheUint10 **q_result,
                              struct FheUint10 **r_result);

int fhe_uint10_scalar_eq(const struct FheUint10 *lhs, uint16_t rhs, struct FheBool **result);

int fhe_uint10_scalar_ge(const struct FheUint10 *lhs, uint16_t rhs, struct FheBool **result);

int fhe_uint10_scalar_gt(const struct FheUint10 *lhs, uint16_t rhs, struct FheBool **result);

int fhe_uint10_scalar_le(const struct FheUint10 *lhs, uint16_t rhs, struct FheBool **result);

int fhe_uint10_scalar_lt(const struct FheUint10 *lhs, uint16_t rhs, struct FheBool **result);

int fhe_uint10_scalar_max(const struct FheUint10 *lhs, uint16_t rhs, struct FheUint10 **result);

int fhe_uint10_scalar_min(const struct FheUint10 *lhs, uint16_t rhs, struct FheUint10 **result);

int fhe_uint10_scalar_mul(const struct FheUint10 *lhs, uint16_t rhs, struct FheUint10 **result);

int fhe_uint10_scalar_mul_assign(struct FheUint10 *lhs, uint16_t rhs);

int fhe_uint10_scalar_ne(const struct FheUint10 *lhs, uint16_t rhs, struct FheBool **result);

int fhe_uint10_scalar_rem(const struct FheUint10 *lhs, uint16_t rhs, struct FheUint10 **result);

int fhe_uint10_scalar_rem_assign(struct FheUint10 *lhs, uint16_t rhs);

int fhe_uint10_scalar_rotate_left(const struct FheUint10 *lhs,
                                  uint16_t rhs,
                                  struct FheUint10 **result);

int fhe_uint10_scalar_rotate_left_assign(struct FheUint10 *lhs, uint16_t rhs);

int fhe_uint10_scalar_rotate_right(const struct FheUint10 *lhs,
                                   uint16_t rhs,
                                   struct FheUint10 **result);

int fhe_uint10_scalar_rotate_right_assign(struct FheUint10 *lhs, uint16_t rhs);

int fhe_uint10_scalar_shl(const struct FheUint10 *lhs, uint16_t rhs, struct FheUint10 **result);

int fhe_uint10_scalar_shl_assign(struct FheUint10 *lhs, uint16_t rhs);

int fhe_uint10_scalar_shr(const struct FheUint10 *lhs, uint16_t rhs, struct FheUint10 **result);

int fhe_uint10_scalar_shr_assign(struct FheUint10 *lhs, uint16_t rhs);

int fhe_uint10_scalar_sub(const struct FheUint10 *lhs, uint16_t rhs, struct FheUint10 **result);

int fhe_uint10_scalar_sub_assign(struct FheUint10 *lhs, uint16_t rhs);

int fhe_uint10_serialize(const struct FheUint10 *sself, DynamicBuffer *result);

int fhe_uint10_shl(const struct FheUint10 *lhs,
                   const struct FheUint10 *rhs,
                   struct FheUint10 **result);

int fhe_uint10_shl_assign(struct FheUint10 *lhs, const struct FheUint10 *rhs);

int fhe_uint10_shr(const struct FheUint10 *lhs,
                   const struct FheUint10 *rhs,
                   struct FheUint10 **result);

int fhe_uint10_shr_assign(struct FheUint10 *lhs, const struct FheUint10 *rhs);

int fhe_uint10_sub(const struct FheUint10 *lhs,
                   const struct FheUint10 *rhs,
                   struct FheUint10 **result);

int fhe_uint10_sub_assign(struct FheUint10 *lhs, const struct FheUint10 *rhs);

int fhe_uint10_sum(const struct FheUint10 *const *lhs, size_t len, struct FheUint10 **out_result);

/**
 * Returns the number of trailing ones in the binary representation of input.
 */
int fhe_uint10_trailing_ones(const struct FheUint10 *input, struct FheUint32 **result);

/**
 * Returns the number of trailing zeros in the binary representation of input.
 */
int fhe_uint10_trailing_zeros(const struct FheUint10 *input, struct FheUint32 **result);

int fhe_uint10_try_decrypt_trivial(const struct FheUint10 *encrypted_value, uint16_t *result);

int fhe_uint10_try_encrypt_trivial_u16(uint16_t value, struct FheUint10 **result);

int fhe_uint10_try_encrypt_with_client_key_u16(uint16_t value,
                                               const struct ClientKey *client_key,
                                               struct FheUint10 **result);

int fhe_uint10_try_encrypt_with_compact_public_key_u16(uint16_t value,
                                                       const struct CompactPublicKey *public_key,
                                                       struct FheUint10 **result);

int fhe_uint10_try_encrypt_with_public_key_u16(uint16_t value,
                                               const struct PublicKey *public_key,
                                               struct FheUint10 **result);

int fhe_uint128_add(const struct FheUint128 *lhs,
                    const struct FheUint128 *rhs,
                    struct FheUint128 **result);

int fhe_uint128_add_assign(struct FheUint128 *lhs, const struct FheUint128 *rhs);

int fhe_uint128_bitand(const struct FheUint128 *lhs,
                       const struct FheUint128 *rhs,
                       struct FheUint128 **result);

int fhe_uint128_bitand_assign(struct FheUint128 *lhs, const struct FheUint128 *rhs);

int fhe_uint128_bitor(const struct FheUint128 *lhs,
                      const struct FheUint128 *rhs,
                      struct FheUint128 **result);

int fhe_uint128_bitor_assign(struct FheUint128 *lhs, const struct FheUint128 *rhs);

int fhe_uint128_bitxor(const struct FheUint128 *lhs,
                       const struct FheUint128 *rhs,
                       struct FheUint128 **result);

int fhe_uint128_bitxor_assign(struct FheUint128 *lhs, const struct FheUint128 *rhs);

int fhe_uint128_cast_into_fhe_int10(const struct FheUint128 *sself, struct FheInt10 **result);

int fhe_uint128_cast_into_fhe_int12(const struct FheUint128 *sself, struct FheInt12 **result);

int fhe_uint128_cast_into_fhe_int128(const struct FheUint128 *sself, struct FheInt128 **result);

int fhe_uint128_cast_into_fhe_int14(const struct FheUint128 *sself, struct FheInt14 **result);

int fhe_uint128_cast_into_fhe_int16(const struct FheUint128 *sself, struct FheInt16 **result);

int fhe_uint128_cast_into_fhe_int160(const struct FheUint128 *sself, struct FheInt160 **result);

int fhe_uint128_cast_into_fhe_int2(const struct FheUint128 *sself, struct FheInt2 **result);

int fhe_uint128_cast_into_fhe_int256(const struct FheUint128 *sself, struct FheInt256 **result);

int fhe_uint128_cast_into_fhe_int32(const struct FheUint128 *sself, struct FheInt32 **result);

int fhe_uint128_cast_into_fhe_int4(const struct FheUint128 *sself, struct FheInt4 **result);

int fhe_uint128_cast_into_fhe_int6(const struct FheUint128 *sself, struct FheInt6 **result);

int fhe_uint128_cast_into_fhe_int64(const struct FheUint128 *sself, struct FheInt64 **result);

int fhe_uint128_cast_into_fhe_int8(const struct FheUint128 *sself, struct FheInt8 **result);

int fhe_uint128_cast_into_fhe_uint10(const struct FheUint128 *sself, struct FheUint10 **result);

int fhe_uint128_cast_into_fhe_uint128(const struct FheUint128 *sself, struct FheUint128 **result);

int fhe_uint128_cast_into_fhe_uint14(const struct FheUint128 *sself, struct FheUint14 **result);

int fhe_uint128_cast_into_fhe_uint16(const struct FheUint128 *sself, struct FheUint16 **result);

int fhe_uint128_cast_into_fhe_uint160(const struct FheUint128 *sself, struct FheUint160 **result);

int fhe_uint128_cast_into_fhe_uint2(const struct FheUint128 *sself, struct FheUint2 **result);

int fhe_uint128_cast_into_fhe_uint256(const struct FheUint128 *sself, struct FheUint256 **result);

int fhe_uint128_cast_into_fhe_uint32(const struct FheUint128 *sself, struct FheUint32 **result);

int fhe_uint128_cast_into_fhe_uint4(const struct FheUint128 *sself, struct FheUint4 **result);

int fhe_uint128_cast_into_fhe_uint6(const struct FheUint128 *sself, struct FheUint6 **result);

int fhe_uint128_cast_into_fhe_uint64(const struct FheUint128 *sself, struct FheUint64 **result);

int fhe_uint128_cast_into_fhe_uint8(const struct FheUint128 *sself, struct FheUint8 **result);

/**
 * Returns the base 2 logarithm of the number, rounded down.
 *
 * Also returns a boolean flag that is true if the result is valid (i.e input was > 0)
 */
int fhe_uint128_checked_ilog2(const struct FheUint128 *input,
                              struct FheUint32 **result_1,
                              struct FheBool **result_2);

int fhe_uint128_clone(const struct FheUint128 *sself, struct FheUint128 **result);

int fhe_uint128_compress(const struct FheUint128 *sself, struct CompressedFheUint128 **result);

int fhe_uint128_decrypt(const struct FheUint128 *encrypted_value,
                        const struct ClientKey *client_key,
                        struct U128 *result);

int fhe_uint128_deserialize(DynamicBufferView buffer_view, struct FheUint128 **result);

/**
 *ptr can be null (no-op in that case)
 */
int fhe_uint128_destroy(struct FheUint128 *ptr);

int fhe_uint128_div(const struct FheUint128 *lhs,
                    const struct FheUint128 *rhs,
                    struct FheUint128 **result);

int fhe_uint128_div_assign(struct FheUint128 *lhs, const struct FheUint128 *rhs);

int fhe_uint128_div_rem(const struct FheUint128 *lhs,
                        const struct FheUint128 *rhs,
                        struct FheUint128 **q_result,
                        struct FheUint128 **r_result);

int fhe_uint128_eq(const struct FheUint128 *lhs,
                   const struct FheUint128 *rhs,
                   struct FheBool **result);

int fhe_uint128_ge(const struct FheUint128 *lhs,
                   const struct FheUint128 *rhs,
                   struct FheBool **result);

int fhe_uint128_gt(const struct FheUint128 *lhs,
                   const struct FheUint128 *rhs,
                   struct FheBool **result);

int fhe_uint128_if_then_else(const struct FheBool *condition_ct,
                             const struct FheUint128 *then_ct,
                             const struct FheUint128 *else_ct,
                             struct FheUint128 **result);

/**
 * Returns the base 2 logarithm of the number, rounded down.
 *
 * Result has no meaning if self encrypts a value that is <= 0.
 * See `checked_ilog2`
 */
int fhe_uint128_ilog2(const struct FheUint128 *input, struct FheUint32 **result);

int fhe_uint128_le(const struct FheUint128 *lhs,
                   const struct FheUint128 *rhs,
                   struct FheBool **result);

/**
 * Returns the number of leading ones in the binary representation of input.
 */
int fhe_uint128_leading_ones(const struct FheUint128 *input, struct FheUint32 **result);

/**
 * Returns the number of leading zeros in the binary representation of input.
 */
int fhe_uint128_leading_zeros(const struct FheUint128 *input, struct FheUint32 **result);

int fhe_uint128_lt(const struct FheUint128 *lhs,
                   const struct FheUint128 *rhs,
                   struct FheBool **result);

int fhe_uint128_max(const struct FheUint128 *lhs,
                    const struct FheUint128 *rhs,
                    struct FheUint128 **result);

int fhe_uint128_min(const struct FheUint128 *lhs,
                    const struct FheUint128 *rhs,
                    struct FheUint128 **result);

int fhe_uint128_mul(const struct FheUint128 *lhs,
                    const struct FheUint128 *rhs,
                    struct FheUint128 **result);

int fhe_uint128_mul_assign(struct FheUint128 *lhs, const struct FheUint128 *rhs);

int fhe_uint128_ne(const struct FheUint128 *lhs,
                   const struct FheUint128 *rhs,
                   struct FheBool **result);

int fhe_uint128_neg(const struct FheUint128 *input, struct FheUint128 **result);

int fhe_uint128_not(const struct FheUint128 *input, struct FheUint128 **result);

int fhe_uint128_overflowing_add(const struct FheUint128 *lhs,
                                const struct FheUint128 *rhs,
                                struct FheUint128 **out_result,
                                struct FheBool **out_overflowed);

int fhe_uint128_overflowing_mul(const struct FheUint128 *lhs,
                                const struct FheUint128 *rhs,
                                struct FheUint128 **out_result,
                                struct FheBool **out_overflowed);

int fhe_uint128_overflowing_sub(const struct FheUint128 *lhs,
                                const struct FheUint128 *rhs,
                                struct FheUint128 **out_result,
                                struct FheBool **out_overflowed);

int fhe_uint128_rem(const struct FheUint128 *lhs,
                    const struct FheUint128 *rhs,
                    struct FheUint128 **result);

int fhe_uint128_rem_assign(struct FheUint128 *lhs, const struct FheUint128 *rhs);

int fhe_uint128_rotate_left(const struct FheUint128 *lhs,
                            const struct FheUint128 *rhs,
                            struct FheUint128 **result);

int fhe_uint128_rotate_left_assign(struct FheUint128 *lhs, const struct FheUint128 *rhs);

int fhe_uint128_rotate_right(const struct FheUint128 *lhs,
                             const struct FheUint128 *rhs,
                             struct FheUint128 **result);

int fhe_uint128_rotate_right_assign(struct FheUint128 *lhs, const struct FheUint128 *rhs);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int fhe_uint128_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                            uint64_t serialized_size_limit,
                                            const struct ServerKey *server_key,
                                            struct FheUint128 **result);

int fhe_uint128_safe_serialize(const struct FheUint128 *sself,
                               DynamicBuffer *result,
                               uint64_t serialized_size_limit);

int fhe_uint128_scalar_add(const struct FheUint128 *lhs,
                           struct U128 rhs,
                           struct FheUint128 **result);

int fhe_uint128_scalar_add_assign(struct FheUint128 *lhs, struct U128 rhs);

int fhe_uint128_scalar_bitand(const struct FheUint128 *lhs,
                              struct U128 rhs,
                              struct FheUint128 **result);

int fhe_uint128_scalar_bitand_assign(struct FheUint128 *lhs, struct U128 rhs);

int fhe_uint128_scalar_bitor(const struct FheUint128 *lhs,
                             struct U128 rhs,
                             struct FheUint128 **result);

int fhe_uint128_scalar_bitor_assign(struct FheUint128 *lhs, struct U128 rhs);

int fhe_uint128_scalar_bitxor(const struct FheUint128 *lhs,
                              struct U128 rhs,
                              struct FheUint128 **result);

int fhe_uint128_scalar_bitxor_assign(struct FheUint128 *lhs, struct U128 rhs);

int fhe_uint128_scalar_div(const struct FheUint128 *lhs,
                           struct U128 rhs,
                           struct FheUint128 **result);

int fhe_uint128_scalar_div_assign(struct FheUint128 *lhs, struct U128 rhs);

int fhe_uint128_scalar_div_rem(const struct FheUint128 *lhs,
                               struct U128 rhs,
                               struct FheUint128 **q_result,
                               struct FheUint128 **r_result);

int fhe_uint128_scalar_eq(const struct FheUint128 *lhs, struct U128 rhs, struct FheBool **result);

int fhe_uint128_scalar_ge(const struct FheUint128 *lhs, struct U128 rhs, struct FheBool **result);

int fhe_uint128_scalar_gt(const struct FheUint128 *lhs, struct U128 rhs, struct FheBool **result);

int fhe_uint128_scalar_le(const struct FheUint128 *lhs, struct U128 rhs, struct FheBool **result);

int fhe_uint128_scalar_lt(const struct FheUint128 *lhs, struct U128 rhs, struct FheBool **result);

int fhe_uint128_scalar_max(const struct FheUint128 *lhs,
                           struct U128 rhs,
                           struct FheUint128 **result);

int fhe_uint128_scalar_min(const struct FheUint128 *lhs,
                           struct U128 rhs,
                           struct FheUint128 **result);

int fhe_uint128_scalar_mul(const struct FheUint128 *lhs,
                           struct U128 rhs,
                           struct FheUint128 **result);

int fhe_uint128_scalar_mul_assign(struct FheUint128 *lhs, struct U128 rhs);

int fhe_uint128_scalar_ne(const struct FheUint128 *lhs, struct U128 rhs, struct FheBool **result);

int fhe_uint128_scalar_rem(const struct FheUint128 *lhs,
                           struct U128 rhs,
                           struct FheUint128 **result);

int fhe_uint128_scalar_rem_assign(struct FheUint128 *lhs, struct U128 rhs);

int fhe_uint128_scalar_rotate_left(const struct FheUint128 *lhs,
                                   struct U128 rhs,
                                   struct FheUint128 **result);

int fhe_uint128_scalar_rotate_left_assign(struct FheUint128 *lhs, struct U128 rhs);

int fhe_uint128_scalar_rotate_right(const struct FheUint128 *lhs,
                                    struct U128 rhs,
                                    struct FheUint128 **result);

int fhe_uint128_scalar_rotate_right_assign(struct FheUint128 *lhs, struct U128 rhs);

int fhe_uint128_scalar_shl(const struct FheUint128 *lhs,
                           struct U128 rhs,
                           struct FheUint128 **result);

int fhe_uint128_scalar_shl_assign(struct FheUint128 *lhs, struct U128 rhs);

int fhe_uint128_scalar_shr(const struct FheUint128 *lhs,
                           struct U128 rhs,
                           struct FheUint128 **result);

int fhe_uint128_scalar_shr_assign(struct FheUint128 *lhs, struct U128 rhs);

int fhe_uint128_scalar_sub(const struct FheUint128 *lhs,
                           struct U128 rhs,
                           struct FheUint128 **result);

int fhe_uint128_scalar_sub_assign(struct FheUint128 *lhs, struct U128 rhs);

int fhe_uint128_serialize(const struct FheUint128 *sself, DynamicBuffer *result);

int fhe_uint128_shl(const struct FheUint128 *lhs,
                    const struct FheUint128 *rhs,
                    struct FheUint128 **result);

int fhe_uint128_shl_assign(struct FheUint128 *lhs, const struct FheUint128 *rhs);

int fhe_uint128_shr(const struct FheUint128 *lhs,
                    const struct FheUint128 *rhs,
                    struct FheUint128 **result);

int fhe_uint128_shr_assign(struct FheUint128 *lhs, const struct FheUint128 *rhs);

int fhe_uint128_sub(const struct FheUint128 *lhs,
                    const struct FheUint128 *rhs,
                    struct FheUint128 **result);

int fhe_uint128_sub_assign(struct FheUint128 *lhs, const struct FheUint128 *rhs);

int fhe_uint128_sum(const struct FheUint128 *const *lhs,
                    size_t len,
                    struct FheUint128 **out_result);

/**
 * Returns the number of trailing ones in the binary representation of input.
 */
int fhe_uint128_trailing_ones(const struct FheUint128 *input, struct FheUint32 **result);

/**
 * Returns the number of trailing zeros in the binary representation of input.
 */
int fhe_uint128_trailing_zeros(const struct FheUint128 *input, struct FheUint32 **result);

int fhe_uint128_try_decrypt_trivial(const struct FheUint128 *encrypted_value, struct U128 *result);

int fhe_uint128_try_encrypt_trivial_u128(struct U128 value, struct FheUint128 **result);

int fhe_uint128_try_encrypt_with_client_key_u128(struct U128 value,
                                                 const struct ClientKey *client_key,
                                                 struct FheUint128 **result);

int fhe_uint128_try_encrypt_with_compact_public_key_u128(struct U128 value,
                                                         const struct CompactPublicKey *public_key,
                                                         struct FheUint128 **result);

int fhe_uint128_try_encrypt_with_public_key_u128(struct U128 value,
                                                 const struct PublicKey *public_key,
                                                 struct FheUint128 **result);

int fhe_uint12_add(const struct FheUint12 *lhs,
                   const struct FheUint12 *rhs,
                   struct FheUint12 **result);

int fhe_uint12_add_assign(struct FheUint12 *lhs, const struct FheUint12 *rhs);

int fhe_uint12_bitand(const struct FheUint12 *lhs,
                      const struct FheUint12 *rhs,
                      struct FheUint12 **result);

int fhe_uint12_bitand_assign(struct FheUint12 *lhs, const struct FheUint12 *rhs);

int fhe_uint12_bitor(const struct FheUint12 *lhs,
                     const struct FheUint12 *rhs,
                     struct FheUint12 **result);

int fhe_uint12_bitor_assign(struct FheUint12 *lhs, const struct FheUint12 *rhs);

int fhe_uint12_bitxor(const struct FheUint12 *lhs,
                      const struct FheUint12 *rhs,
                      struct FheUint12 **result);

int fhe_uint12_bitxor_assign(struct FheUint12 *lhs, const struct FheUint12 *rhs);

int fhe_uint12_cast_into_fhe_int10(const struct FheUint12 *sself, struct FheInt10 **result);

int fhe_uint12_cast_into_fhe_int12(const struct FheUint12 *sself, struct FheInt12 **result);

int fhe_uint12_cast_into_fhe_int128(const struct FheUint12 *sself, struct FheInt128 **result);

int fhe_uint12_cast_into_fhe_int14(const struct FheUint12 *sself, struct FheInt14 **result);

int fhe_uint12_cast_into_fhe_int16(const struct FheUint12 *sself, struct FheInt16 **result);

int fhe_uint12_cast_into_fhe_int160(const struct FheUint12 *sself, struct FheInt160 **result);

int fhe_uint12_cast_into_fhe_int2(const struct FheUint12 *sself, struct FheInt2 **result);

int fhe_uint12_cast_into_fhe_int256(const struct FheUint12 *sself, struct FheInt256 **result);

int fhe_uint12_cast_into_fhe_int32(const struct FheUint12 *sself, struct FheInt32 **result);

int fhe_uint12_cast_into_fhe_int4(const struct FheUint12 *sself, struct FheInt4 **result);

int fhe_uint12_cast_into_fhe_int6(const struct FheUint12 *sself, struct FheInt6 **result);

int fhe_uint12_cast_into_fhe_int64(const struct FheUint12 *sself, struct FheInt64 **result);

int fhe_uint12_cast_into_fhe_int8(const struct FheUint12 *sself, struct FheInt8 **result);

int fhe_uint12_cast_into_fhe_uint10(const struct FheUint12 *sself, struct FheUint10 **result);

int fhe_uint12_cast_into_fhe_uint128(const struct FheUint12 *sself, struct FheUint128 **result);

int fhe_uint12_cast_into_fhe_uint14(const struct FheUint12 *sself, struct FheUint14 **result);

int fhe_uint12_cast_into_fhe_uint16(const struct FheUint12 *sself, struct FheUint16 **result);

int fhe_uint12_cast_into_fhe_uint160(const struct FheUint12 *sself, struct FheUint160 **result);

int fhe_uint12_cast_into_fhe_uint2(const struct FheUint12 *sself, struct FheUint2 **result);

int fhe_uint12_cast_into_fhe_uint256(const struct FheUint12 *sself, struct FheUint256 **result);

int fhe_uint12_cast_into_fhe_uint32(const struct FheUint12 *sself, struct FheUint32 **result);

int fhe_uint12_cast_into_fhe_uint4(const struct FheUint12 *sself, struct FheUint4 **result);

int fhe_uint12_cast_into_fhe_uint6(const struct FheUint12 *sself, struct FheUint6 **result);

int fhe_uint12_cast_into_fhe_uint64(const struct FheUint12 *sself, struct FheUint64 **result);

int fhe_uint12_cast_into_fhe_uint8(const struct FheUint12 *sself, struct FheUint8 **result);

/**
 * Returns the base 2 logarithm of the number, rounded down.
 *
 * Also returns a boolean flag that is true if the result is valid (i.e input was > 0)
 */
int fhe_uint12_checked_ilog2(const struct FheUint12 *input,
                             struct FheUint32 **result_1,
                             struct FheBool **result_2);

int fhe_uint12_clone(const struct FheUint12 *sself, struct FheUint12 **result);

int fhe_uint12_compress(const struct FheUint12 *sself, struct CompressedFheUint12 **result);

int fhe_uint12_decrypt(const struct FheUint12 *encrypted_value,
                       const struct ClientKey *client_key,
                       uint16_t *result);

int fhe_uint12_deserialize(DynamicBufferView buffer_view, struct FheUint12 **result);

/**
 *ptr can be null (no-op in that case)
 */
int fhe_uint12_destroy(struct FheUint12 *ptr);

int fhe_uint12_div(const struct FheUint12 *lhs,
                   const struct FheUint12 *rhs,
                   struct FheUint12 **result);

int fhe_uint12_div_assign(struct FheUint12 *lhs, const struct FheUint12 *rhs);

int fhe_uint12_div_rem(const struct FheUint12 *lhs,
                       const struct FheUint12 *rhs,
                       struct FheUint12 **q_result,
                       struct FheUint12 **r_result);

int fhe_uint12_eq(const struct FheUint12 *lhs,
                  const struct FheUint12 *rhs,
                  struct FheBool **result);

int fhe_uint12_ge(const struct FheUint12 *lhs,
                  const struct FheUint12 *rhs,
                  struct FheBool **result);

int fhe_uint12_gt(const struct FheUint12 *lhs,
                  const struct FheUint12 *rhs,
                  struct FheBool **result);

int fhe_uint12_if_then_else(const struct FheBool *condition_ct,
                            const struct FheUint12 *then_ct,
                            const struct FheUint12 *else_ct,
                            struct FheUint12 **result);

/**
 * Returns the base 2 logarithm of the number, rounded down.
 *
 * Result has no meaning if self encrypts a value that is <= 0.
 * See `checked_ilog2`
 */
int fhe_uint12_ilog2(const struct FheUint12 *input, struct FheUint32 **result);

int fhe_uint12_le(const struct FheUint12 *lhs,
                  const struct FheUint12 *rhs,
                  struct FheBool **result);

/**
 * Returns the number of leading ones in the binary representation of input.
 */
int fhe_uint12_leading_ones(const struct FheUint12 *input, struct FheUint32 **result);

/**
 * Returns the number of leading zeros in the binary representation of input.
 */
int fhe_uint12_leading_zeros(const struct FheUint12 *input, struct FheUint32 **result);

int fhe_uint12_lt(const struct FheUint12 *lhs,
                  const struct FheUint12 *rhs,
                  struct FheBool **result);

int fhe_uint12_max(const struct FheUint12 *lhs,
                   const struct FheUint12 *rhs,
                   struct FheUint12 **result);

int fhe_uint12_min(const struct FheUint12 *lhs,
                   const struct FheUint12 *rhs,
                   struct FheUint12 **result);

int fhe_uint12_mul(const struct FheUint12 *lhs,
                   const struct FheUint12 *rhs,
                   struct FheUint12 **result);

int fhe_uint12_mul_assign(struct FheUint12 *lhs, const struct FheUint12 *rhs);

int fhe_uint12_ne(const struct FheUint12 *lhs,
                  const struct FheUint12 *rhs,
                  struct FheBool **result);

int fhe_uint12_neg(const struct FheUint12 *input, struct FheUint12 **result);

int fhe_uint12_not(const struct FheUint12 *input, struct FheUint12 **result);

int fhe_uint12_overflowing_add(const struct FheUint12 *lhs,
                               const struct FheUint12 *rhs,
                               struct FheUint12 **out_result,
                               struct FheBool **out_overflowed);

int fhe_uint12_overflowing_mul(const struct FheUint12 *lhs,
                               const struct FheUint12 *rhs,
                               struct FheUint12 **out_result,
                               struct FheBool **out_overflowed);

int fhe_uint12_overflowing_sub(const struct FheUint12 *lhs,
                               const struct FheUint12 *rhs,
                               struct FheUint12 **out_result,
                               struct FheBool **out_overflowed);

int fhe_uint12_rem(const struct FheUint12 *lhs,
                   const struct FheUint12 *rhs,
                   struct FheUint12 **result);

int fhe_uint12_rem_assign(struct FheUint12 *lhs, const struct FheUint12 *rhs);

int fhe_uint12_rotate_left(const struct FheUint12 *lhs,
                           const struct FheUint12 *rhs,
                           struct FheUint12 **result);

int fhe_uint12_rotate_left_assign(struct FheUint12 *lhs, const struct FheUint12 *rhs);

int fhe_uint12_rotate_right(const struct FheUint12 *lhs,
                            const struct FheUint12 *rhs,
                            struct FheUint12 **result);

int fhe_uint12_rotate_right_assign(struct FheUint12 *lhs, const struct FheUint12 *rhs);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int fhe_uint12_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                           uint64_t serialized_size_limit,
                                           const struct ServerKey *server_key,
                                           struct FheUint12 **result);

int fhe_uint12_safe_serialize(const struct FheUint12 *sself,
                              DynamicBuffer *result,
                              uint64_t serialized_size_limit);

int fhe_uint12_scalar_add(const struct FheUint12 *lhs, uint16_t rhs, struct FheUint12 **result);

int fhe_uint12_scalar_add_assign(struct FheUint12 *lhs, uint16_t rhs);

int fhe_uint12_scalar_bitand(const struct FheUint12 *lhs, uint16_t rhs, struct FheUint12 **result);

int fhe_uint12_scalar_bitand_assign(struct FheUint12 *lhs, uint16_t rhs);

int fhe_uint12_scalar_bitor(const struct FheUint12 *lhs, uint16_t rhs, struct FheUint12 **result);

int fhe_uint12_scalar_bitor_assign(struct FheUint12 *lhs, uint16_t rhs);

int fhe_uint12_scalar_bitxor(const struct FheUint12 *lhs, uint16_t rhs, struct FheUint12 **result);

int fhe_uint12_scalar_bitxor_assign(struct FheUint12 *lhs, uint16_t rhs);

int fhe_uint12_scalar_div(const struct FheUint12 *lhs, uint16_t rhs, struct FheUint12 **result);

int fhe_uint12_scalar_div_assign(struct FheUint12 *lhs, uint16_t rhs);

int fhe_uint12_scalar_div_rem(const struct FheUint12 *lhs,
                              uint16_t rhs,
                              struct FheUint12 **q_result,
                              struct FheUint12 **r_result);

int fhe_uint12_scalar_eq(const struct FheUint12 *lhs, uint16_t rhs, struct FheBool **result);

int fhe_uint12_scalar_ge(const struct FheUint12 *lhs, uint16_t rhs, struct FheBool **result);

int fhe_uint12_scalar_gt(const struct FheUint12 *lhs, uint16_t rhs, struct FheBool **result);

int fhe_uint12_scalar_le(const struct FheUint12 *lhs, uint16_t rhs, struct FheBool **result);

int fhe_uint12_scalar_lt(const struct FheUint12 *lhs, uint16_t rhs, struct FheBool **result);

int fhe_uint12_scalar_max(const struct FheUint12 *lhs, uint16_t rhs, struct FheUint12 **result);

int fhe_uint12_scalar_min(const struct FheUint12 *lhs, uint16_t rhs, struct FheUint12 **result);

int fhe_uint12_scalar_mul(const struct FheUint12 *lhs, uint16_t rhs, struct FheUint12 **result);

int fhe_uint12_scalar_mul_assign(struct FheUint12 *lhs, uint16_t rhs);

int fhe_uint12_scalar_ne(const struct FheUint12 *lhs, uint16_t rhs, struct FheBool **result);

int fhe_uint12_scalar_rem(const struct FheUint12 *lhs, uint16_t rhs, struct FheUint12 **result);

int fhe_uint12_scalar_rem_assign(struct FheUint12 *lhs, uint16_t rhs);

int fhe_uint12_scalar_rotate_left(const struct FheUint12 *lhs,
                                  uint16_t rhs,
                                  struct FheUint12 **result);

int fhe_uint12_scalar_rotate_left_assign(struct FheUint12 *lhs, uint16_t rhs);

int fhe_uint12_scalar_rotate_right(const struct FheUint12 *lhs,
                                   uint16_t rhs,
                                   struct FheUint12 **result);

int fhe_uint12_scalar_rotate_right_assign(struct FheUint12 *lhs, uint16_t rhs);

int fhe_uint12_scalar_shl(const struct FheUint12 *lhs, uint16_t rhs, struct FheUint12 **result);

int fhe_uint12_scalar_shl_assign(struct FheUint12 *lhs, uint16_t rhs);

int fhe_uint12_scalar_shr(const struct FheUint12 *lhs, uint16_t rhs, struct FheUint12 **result);

int fhe_uint12_scalar_shr_assign(struct FheUint12 *lhs, uint16_t rhs);

int fhe_uint12_scalar_sub(const struct FheUint12 *lhs, uint16_t rhs, struct FheUint12 **result);

int fhe_uint12_scalar_sub_assign(struct FheUint12 *lhs, uint16_t rhs);

int fhe_uint12_serialize(const struct FheUint12 *sself, DynamicBuffer *result);

int fhe_uint12_shl(const struct FheUint12 *lhs,
                   const struct FheUint12 *rhs,
                   struct FheUint12 **result);

int fhe_uint12_shl_assign(struct FheUint12 *lhs, const struct FheUint12 *rhs);

int fhe_uint12_shr(const struct FheUint12 *lhs,
                   const struct FheUint12 *rhs,
                   struct FheUint12 **result);

int fhe_uint12_shr_assign(struct FheUint12 *lhs, const struct FheUint12 *rhs);

int fhe_uint12_sub(const struct FheUint12 *lhs,
                   const struct FheUint12 *rhs,
                   struct FheUint12 **result);

int fhe_uint12_sub_assign(struct FheUint12 *lhs, const struct FheUint12 *rhs);

int fhe_uint12_sum(const struct FheUint12 *const *lhs, size_t len, struct FheUint12 **out_result);

/**
 * Returns the number of trailing ones in the binary representation of input.
 */
int fhe_uint12_trailing_ones(const struct FheUint12 *input, struct FheUint32 **result);

/**
 * Returns the number of trailing zeros in the binary representation of input.
 */
int fhe_uint12_trailing_zeros(const struct FheUint12 *input, struct FheUint32 **result);

int fhe_uint12_try_decrypt_trivial(const struct FheUint12 *encrypted_value, uint16_t *result);

int fhe_uint12_try_encrypt_trivial_u16(uint16_t value, struct FheUint12 **result);

int fhe_uint12_try_encrypt_with_client_key_u16(uint16_t value,
                                               const struct ClientKey *client_key,
                                               struct FheUint12 **result);

int fhe_uint12_try_encrypt_with_compact_public_key_u16(uint16_t value,
                                                       const struct CompactPublicKey *public_key,
                                                       struct FheUint12 **result);

int fhe_uint12_try_encrypt_with_public_key_u16(uint16_t value,
                                               const struct PublicKey *public_key,
                                               struct FheUint12 **result);

int fhe_uint14_add(const struct FheUint14 *lhs,
                   const struct FheUint14 *rhs,
                   struct FheUint14 **result);

int fhe_uint14_add_assign(struct FheUint14 *lhs, const struct FheUint14 *rhs);

int fhe_uint14_bitand(const struct FheUint14 *lhs,
                      const struct FheUint14 *rhs,
                      struct FheUint14 **result);

int fhe_uint14_bitand_assign(struct FheUint14 *lhs, const struct FheUint14 *rhs);

int fhe_uint14_bitor(const struct FheUint14 *lhs,
                     const struct FheUint14 *rhs,
                     struct FheUint14 **result);

int fhe_uint14_bitor_assign(struct FheUint14 *lhs, const struct FheUint14 *rhs);

int fhe_uint14_bitxor(const struct FheUint14 *lhs,
                      const struct FheUint14 *rhs,
                      struct FheUint14 **result);

int fhe_uint14_bitxor_assign(struct FheUint14 *lhs, const struct FheUint14 *rhs);

int fhe_uint14_cast_into_fhe_int10(const struct FheUint14 *sself, struct FheInt10 **result);

int fhe_uint14_cast_into_fhe_int12(const struct FheUint14 *sself, struct FheInt12 **result);

int fhe_uint14_cast_into_fhe_int128(const struct FheUint14 *sself, struct FheInt128 **result);

int fhe_uint14_cast_into_fhe_int14(const struct FheUint14 *sself, struct FheInt14 **result);

int fhe_uint14_cast_into_fhe_int16(const struct FheUint14 *sself, struct FheInt16 **result);

int fhe_uint14_cast_into_fhe_int160(const struct FheUint14 *sself, struct FheInt160 **result);

int fhe_uint14_cast_into_fhe_int2(const struct FheUint14 *sself, struct FheInt2 **result);

int fhe_uint14_cast_into_fhe_int256(const struct FheUint14 *sself, struct FheInt256 **result);

int fhe_uint14_cast_into_fhe_int32(const struct FheUint14 *sself, struct FheInt32 **result);

int fhe_uint14_cast_into_fhe_int4(const struct FheUint14 *sself, struct FheInt4 **result);

int fhe_uint14_cast_into_fhe_int6(const struct FheUint14 *sself, struct FheInt6 **result);

int fhe_uint14_cast_into_fhe_int64(const struct FheUint14 *sself, struct FheInt64 **result);

int fhe_uint14_cast_into_fhe_int8(const struct FheUint14 *sself, struct FheInt8 **result);

int fhe_uint14_cast_into_fhe_uint10(const struct FheUint14 *sself, struct FheUint10 **result);

int fhe_uint14_cast_into_fhe_uint128(const struct FheUint14 *sself, struct FheUint128 **result);

int fhe_uint14_cast_into_fhe_uint14(const struct FheUint14 *sself, struct FheUint14 **result);

int fhe_uint14_cast_into_fhe_uint16(const struct FheUint14 *sself, struct FheUint16 **result);

int fhe_uint14_cast_into_fhe_uint160(const struct FheUint14 *sself, struct FheUint160 **result);

int fhe_uint14_cast_into_fhe_uint2(const struct FheUint14 *sself, struct FheUint2 **result);

int fhe_uint14_cast_into_fhe_uint256(const struct FheUint14 *sself, struct FheUint256 **result);

int fhe_uint14_cast_into_fhe_uint32(const struct FheUint14 *sself, struct FheUint32 **result);

int fhe_uint14_cast_into_fhe_uint4(const struct FheUint14 *sself, struct FheUint4 **result);

int fhe_uint14_cast_into_fhe_uint6(const struct FheUint14 *sself, struct FheUint6 **result);

int fhe_uint14_cast_into_fhe_uint64(const struct FheUint14 *sself, struct FheUint64 **result);

int fhe_uint14_cast_into_fhe_uint8(const struct FheUint14 *sself, struct FheUint8 **result);

/**
 * Returns the base 2 logarithm of the number, rounded down.
 *
 * Also returns a boolean flag that is true if the result is valid (i.e input was > 0)
 */
int fhe_uint14_checked_ilog2(const struct FheUint14 *input,
                             struct FheUint32 **result_1,
                             struct FheBool **result_2);

int fhe_uint14_clone(const struct FheUint14 *sself, struct FheUint14 **result);

int fhe_uint14_compress(const struct FheUint14 *sself, struct CompressedFheUint14 **result);

int fhe_uint14_decrypt(const struct FheUint14 *encrypted_value,
                       const struct ClientKey *client_key,
                       uint16_t *result);

int fhe_uint14_deserialize(DynamicBufferView buffer_view, struct FheUint14 **result);

/**
 *ptr can be null (no-op in that case)
 */
int fhe_uint14_destroy(struct FheUint14 *ptr);

int fhe_uint14_div(const struct FheUint14 *lhs,
                   const struct FheUint14 *rhs,
                   struct FheUint14 **result);

int fhe_uint14_div_assign(struct FheUint14 *lhs, const struct FheUint14 *rhs);

int fhe_uint14_div_rem(const struct FheUint14 *lhs,
                       const struct FheUint14 *rhs,
                       struct FheUint14 **q_result,
                       struct FheUint14 **r_result);

int fhe_uint14_eq(const struct FheUint14 *lhs,
                  const struct FheUint14 *rhs,
                  struct FheBool **result);

int fhe_uint14_ge(const struct FheUint14 *lhs,
                  const struct FheUint14 *rhs,
                  struct FheBool **result);

int fhe_uint14_gt(const struct FheUint14 *lhs,
                  const struct FheUint14 *rhs,
                  struct FheBool **result);

int fhe_uint14_if_then_else(const struct FheBool *condition_ct,
                            const struct FheUint14 *then_ct,
                            const struct FheUint14 *else_ct,
                            struct FheUint14 **result);

/**
 * Returns the base 2 logarithm of the number, rounded down.
 *
 * Result has no meaning if self encrypts a value that is <= 0.
 * See `checked_ilog2`
 */
int fhe_uint14_ilog2(const struct FheUint14 *input, struct FheUint32 **result);

int fhe_uint14_le(const struct FheUint14 *lhs,
                  const struct FheUint14 *rhs,
                  struct FheBool **result);

/**
 * Returns the number of leading ones in the binary representation of input.
 */
int fhe_uint14_leading_ones(const struct FheUint14 *input, struct FheUint32 **result);

/**
 * Returns the number of leading zeros in the binary representation of input.
 */
int fhe_uint14_leading_zeros(const struct FheUint14 *input, struct FheUint32 **result);

int fhe_uint14_lt(const struct FheUint14 *lhs,
                  const struct FheUint14 *rhs,
                  struct FheBool **result);

int fhe_uint14_max(const struct FheUint14 *lhs,
                   const struct FheUint14 *rhs,
                   struct FheUint14 **result);

int fhe_uint14_min(const struct FheUint14 *lhs,
                   const struct FheUint14 *rhs,
                   struct FheUint14 **result);

int fhe_uint14_mul(const struct FheUint14 *lhs,
                   const struct FheUint14 *rhs,
                   struct FheUint14 **result);

int fhe_uint14_mul_assign(struct FheUint14 *lhs, const struct FheUint14 *rhs);

int fhe_uint14_ne(const struct FheUint14 *lhs,
                  const struct FheUint14 *rhs,
                  struct FheBool **result);

int fhe_uint14_neg(const struct FheUint14 *input, struct FheUint14 **result);

int fhe_uint14_not(const struct FheUint14 *input, struct FheUint14 **result);

int fhe_uint14_overflowing_add(const struct FheUint14 *lhs,
                               const struct FheUint14 *rhs,
                               struct FheUint14 **out_result,
                               struct FheBool **out_overflowed);

int fhe_uint14_overflowing_mul(const struct FheUint14 *lhs,
                               const struct FheUint14 *rhs,
                               struct FheUint14 **out_result,
                               struct FheBool **out_overflowed);

int fhe_uint14_overflowing_sub(const struct FheUint14 *lhs,
                               const struct FheUint14 *rhs,
                               struct FheUint14 **out_result,
                               struct FheBool **out_overflowed);

int fhe_uint14_rem(const struct FheUint14 *lhs,
                   const struct FheUint14 *rhs,
                   struct FheUint14 **result);

int fhe_uint14_rem_assign(struct FheUint14 *lhs, const struct FheUint14 *rhs);

int fhe_uint14_rotate_left(const struct FheUint14 *lhs,
                           const struct FheUint14 *rhs,
                           struct FheUint14 **result);

int fhe_uint14_rotate_left_assign(struct FheUint14 *lhs, const struct FheUint14 *rhs);

int fhe_uint14_rotate_right(const struct FheUint14 *lhs,
                            const struct FheUint14 *rhs,
                            struct FheUint14 **result);

int fhe_uint14_rotate_right_assign(struct FheUint14 *lhs, const struct FheUint14 *rhs);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int fhe_uint14_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                           uint64_t serialized_size_limit,
                                           const struct ServerKey *server_key,
                                           struct FheUint14 **result);

int fhe_uint14_safe_serialize(const struct FheUint14 *sself,
                              DynamicBuffer *result,
                              uint64_t serialized_size_limit);

int fhe_uint14_scalar_add(const struct FheUint14 *lhs, uint16_t rhs, struct FheUint14 **result);

int fhe_uint14_scalar_add_assign(struct FheUint14 *lhs, uint16_t rhs);

int fhe_uint14_scalar_bitand(const struct FheUint14 *lhs, uint16_t rhs, struct FheUint14 **result);

int fhe_uint14_scalar_bitand_assign(struct FheUint14 *lhs, uint16_t rhs);

int fhe_uint14_scalar_bitor(const struct FheUint14 *lhs, uint16_t rhs, struct FheUint14 **result);

int fhe_uint14_scalar_bitor_assign(struct FheUint14 *lhs, uint16_t rhs);

int fhe_uint14_scalar_bitxor(const struct FheUint14 *lhs, uint16_t rhs, struct FheUint14 **result);

int fhe_uint14_scalar_bitxor_assign(struct FheUint14 *lhs, uint16_t rhs);

int fhe_uint14_scalar_div(const struct FheUint14 *lhs, uint16_t rhs, struct FheUint14 **result);

int fhe_uint14_scalar_div_assign(struct FheUint14 *lhs, uint16_t rhs);

int fhe_uint14_scalar_div_rem(const struct FheUint14 *lhs,
                              uint16_t rhs,
                              struct FheUint14 **q_result,
                              struct FheUint14 **r_result);

int fhe_uint14_scalar_eq(const struct FheUint14 *lhs, uint16_t rhs, struct FheBool **result);

int fhe_uint14_scalar_ge(const struct FheUint14 *lhs, uint16_t rhs, struct FheBool **result);

int fhe_uint14_scalar_gt(const struct FheUint14 *lhs, uint16_t rhs, struct FheBool **result);

int fhe_uint14_scalar_le(const struct FheUint14 *lhs, uint16_t rhs, struct FheBool **result);

int fhe_uint14_scalar_lt(const struct FheUint14 *lhs, uint16_t rhs, struct FheBool **result);

int fhe_uint14_scalar_max(const struct FheUint14 *lhs, uint16_t rhs, struct FheUint14 **result);

int fhe_uint14_scalar_min(const struct FheUint14 *lhs, uint16_t rhs, struct FheUint14 **result);

int fhe_uint14_scalar_mul(const struct FheUint14 *lhs, uint16_t rhs, struct FheUint14 **result);

int fhe_uint14_scalar_mul_assign(struct FheUint14 *lhs, uint16_t rhs);

int fhe_uint14_scalar_ne(const struct FheUint14 *lhs, uint16_t rhs, struct FheBool **result);

int fhe_uint14_scalar_rem(const struct FheUint14 *lhs, uint16_t rhs, struct FheUint14 **result);

int fhe_uint14_scalar_rem_assign(struct FheUint14 *lhs, uint16_t rhs);

int fhe_uint14_scalar_rotate_left(const struct FheUint14 *lhs,
                                  uint16_t rhs,
                                  struct FheUint14 **result);

int fhe_uint14_scalar_rotate_left_assign(struct FheUint14 *lhs, uint16_t rhs);

int fhe_uint14_scalar_rotate_right(const struct FheUint14 *lhs,
                                   uint16_t rhs,
                                   struct FheUint14 **result);

int fhe_uint14_scalar_rotate_right_assign(struct FheUint14 *lhs, uint16_t rhs);

int fhe_uint14_scalar_shl(const struct FheUint14 *lhs, uint16_t rhs, struct FheUint14 **result);

int fhe_uint14_scalar_shl_assign(struct FheUint14 *lhs, uint16_t rhs);

int fhe_uint14_scalar_shr(const struct FheUint14 *lhs, uint16_t rhs, struct FheUint14 **result);

int fhe_uint14_scalar_shr_assign(struct FheUint14 *lhs, uint16_t rhs);

int fhe_uint14_scalar_sub(const struct FheUint14 *lhs, uint16_t rhs, struct FheUint14 **result);

int fhe_uint14_scalar_sub_assign(struct FheUint14 *lhs, uint16_t rhs);

int fhe_uint14_serialize(const struct FheUint14 *sself, DynamicBuffer *result);

int fhe_uint14_shl(const struct FheUint14 *lhs,
                   const struct FheUint14 *rhs,
                   struct FheUint14 **result);

int fhe_uint14_shl_assign(struct FheUint14 *lhs, const struct FheUint14 *rhs);

int fhe_uint14_shr(const struct FheUint14 *lhs,
                   const struct FheUint14 *rhs,
                   struct FheUint14 **result);

int fhe_uint14_shr_assign(struct FheUint14 *lhs, const struct FheUint14 *rhs);

int fhe_uint14_sub(const struct FheUint14 *lhs,
                   const struct FheUint14 *rhs,
                   struct FheUint14 **result);

int fhe_uint14_sub_assign(struct FheUint14 *lhs, const struct FheUint14 *rhs);

int fhe_uint14_sum(const struct FheUint14 *const *lhs, size_t len, struct FheUint14 **out_result);

/**
 * Returns the number of trailing ones in the binary representation of input.
 */
int fhe_uint14_trailing_ones(const struct FheUint14 *input, struct FheUint32 **result);

/**
 * Returns the number of trailing zeros in the binary representation of input.
 */
int fhe_uint14_trailing_zeros(const struct FheUint14 *input, struct FheUint32 **result);

int fhe_uint14_try_decrypt_trivial(const struct FheUint14 *encrypted_value, uint16_t *result);

int fhe_uint14_try_encrypt_trivial_u16(uint16_t value, struct FheUint14 **result);

int fhe_uint14_try_encrypt_with_client_key_u16(uint16_t value,
                                               const struct ClientKey *client_key,
                                               struct FheUint14 **result);

int fhe_uint14_try_encrypt_with_compact_public_key_u16(uint16_t value,
                                                       const struct CompactPublicKey *public_key,
                                                       struct FheUint14 **result);

int fhe_uint14_try_encrypt_with_public_key_u16(uint16_t value,
                                               const struct PublicKey *public_key,
                                               struct FheUint14 **result);

int fhe_uint160_add(const struct FheUint160 *lhs,
                    const struct FheUint160 *rhs,
                    struct FheUint160 **result);

int fhe_uint160_add_assign(struct FheUint160 *lhs, const struct FheUint160 *rhs);

int fhe_uint160_bitand(const struct FheUint160 *lhs,
                       const struct FheUint160 *rhs,
                       struct FheUint160 **result);

int fhe_uint160_bitand_assign(struct FheUint160 *lhs, const struct FheUint160 *rhs);

int fhe_uint160_bitor(const struct FheUint160 *lhs,
                      const struct FheUint160 *rhs,
                      struct FheUint160 **result);

int fhe_uint160_bitor_assign(struct FheUint160 *lhs, const struct FheUint160 *rhs);

int fhe_uint160_bitxor(const struct FheUint160 *lhs,
                       const struct FheUint160 *rhs,
                       struct FheUint160 **result);

int fhe_uint160_bitxor_assign(struct FheUint160 *lhs, const struct FheUint160 *rhs);

int fhe_uint160_cast_into_fhe_int10(const struct FheUint160 *sself, struct FheInt10 **result);

int fhe_uint160_cast_into_fhe_int12(const struct FheUint160 *sself, struct FheInt12 **result);

int fhe_uint160_cast_into_fhe_int128(const struct FheUint160 *sself, struct FheInt128 **result);

int fhe_uint160_cast_into_fhe_int14(const struct FheUint160 *sself, struct FheInt14 **result);

int fhe_uint160_cast_into_fhe_int16(const struct FheUint160 *sself, struct FheInt16 **result);

int fhe_uint160_cast_into_fhe_int160(const struct FheUint160 *sself, struct FheInt160 **result);

int fhe_uint160_cast_into_fhe_int2(const struct FheUint160 *sself, struct FheInt2 **result);

int fhe_uint160_cast_into_fhe_int256(const struct FheUint160 *sself, struct FheInt256 **result);

int fhe_uint160_cast_into_fhe_int32(const struct FheUint160 *sself, struct FheInt32 **result);

int fhe_uint160_cast_into_fhe_int4(const struct FheUint160 *sself, struct FheInt4 **result);

int fhe_uint160_cast_into_fhe_int6(const struct FheUint160 *sself, struct FheInt6 **result);

int fhe_uint160_cast_into_fhe_int64(const struct FheUint160 *sself, struct FheInt64 **result);

int fhe_uint160_cast_into_fhe_int8(const struct FheUint160 *sself, struct FheInt8 **result);

int fhe_uint160_cast_into_fhe_uint10(const struct FheUint160 *sself, struct FheUint10 **result);

int fhe_uint160_cast_into_fhe_uint128(const struct FheUint160 *sself, struct FheUint128 **result);

int fhe_uint160_cast_into_fhe_uint14(const struct FheUint160 *sself, struct FheUint14 **result);

int fhe_uint160_cast_into_fhe_uint16(const struct FheUint160 *sself, struct FheUint16 **result);

int fhe_uint160_cast_into_fhe_uint160(const struct FheUint160 *sself, struct FheUint160 **result);

int fhe_uint160_cast_into_fhe_uint2(const struct FheUint160 *sself, struct FheUint2 **result);

int fhe_uint160_cast_into_fhe_uint256(const struct FheUint160 *sself, struct FheUint256 **result);

int fhe_uint160_cast_into_fhe_uint32(const struct FheUint160 *sself, struct FheUint32 **result);

int fhe_uint160_cast_into_fhe_uint4(const struct FheUint160 *sself, struct FheUint4 **result);

int fhe_uint160_cast_into_fhe_uint6(const struct FheUint160 *sself, struct FheUint6 **result);

int fhe_uint160_cast_into_fhe_uint64(const struct FheUint160 *sself, struct FheUint64 **result);

int fhe_uint160_cast_into_fhe_uint8(const struct FheUint160 *sself, struct FheUint8 **result);

/**
 * Returns the base 2 logarithm of the number, rounded down.
 *
 * Also returns a boolean flag that is true if the result is valid (i.e input was > 0)
 */
int fhe_uint160_checked_ilog2(const struct FheUint160 *input,
                              struct FheUint32 **result_1,
                              struct FheBool **result_2);

int fhe_uint160_clone(const struct FheUint160 *sself, struct FheUint160 **result);

int fhe_uint160_compress(const struct FheUint160 *sself, struct CompressedFheUint160 **result);

int fhe_uint160_decrypt(const struct FheUint160 *encrypted_value,
                        const struct ClientKey *client_key,
                        struct U256 *result);

int fhe_uint160_deserialize(DynamicBufferView buffer_view, struct FheUint160 **result);

/**
 *ptr can be null (no-op in that case)
 */
int fhe_uint160_destroy(struct FheUint160 *ptr);

int fhe_uint160_div(const struct FheUint160 *lhs,
                    const struct FheUint160 *rhs,
                    struct FheUint160 **result);

int fhe_uint160_div_assign(struct FheUint160 *lhs, const struct FheUint160 *rhs);

int fhe_uint160_div_rem(const struct FheUint160 *lhs,
                        const struct FheUint160 *rhs,
                        struct FheUint160 **q_result,
                        struct FheUint160 **r_result);

int fhe_uint160_eq(const struct FheUint160 *lhs,
                   const struct FheUint160 *rhs,
                   struct FheBool **result);

int fhe_uint160_ge(const struct FheUint160 *lhs,
                   const struct FheUint160 *rhs,
                   struct FheBool **result);

int fhe_uint160_gt(const struct FheUint160 *lhs,
                   const struct FheUint160 *rhs,
                   struct FheBool **result);

int fhe_uint160_if_then_else(const struct FheBool *condition_ct,
                             const struct FheUint160 *then_ct,
                             const struct FheUint160 *else_ct,
                             struct FheUint160 **result);

/**
 * Returns the base 2 logarithm of the number, rounded down.
 *
 * Result has no meaning if self encrypts a value that is <= 0.
 * See `checked_ilog2`
 */
int fhe_uint160_ilog2(const struct FheUint160 *input, struct FheUint32 **result);

int fhe_uint160_le(const struct FheUint160 *lhs,
                   const struct FheUint160 *rhs,
                   struct FheBool **result);

/**
 * Returns the number of leading ones in the binary representation of input.
 */
int fhe_uint160_leading_ones(const struct FheUint160 *input, struct FheUint32 **result);

/**
 * Returns the number of leading zeros in the binary representation of input.
 */
int fhe_uint160_leading_zeros(const struct FheUint160 *input, struct FheUint32 **result);

int fhe_uint160_lt(const struct FheUint160 *lhs,
                   const struct FheUint160 *rhs,
                   struct FheBool **result);

int fhe_uint160_max(const struct FheUint160 *lhs,
                    const struct FheUint160 *rhs,
                    struct FheUint160 **result);

int fhe_uint160_min(const struct FheUint160 *lhs,
                    const struct FheUint160 *rhs,
                    struct FheUint160 **result);

int fhe_uint160_mul(const struct FheUint160 *lhs,
                    const struct FheUint160 *rhs,
                    struct FheUint160 **result);

int fhe_uint160_mul_assign(struct FheUint160 *lhs, const struct FheUint160 *rhs);

int fhe_uint160_ne(const struct FheUint160 *lhs,
                   const struct FheUint160 *rhs,
                   struct FheBool **result);

int fhe_uint160_neg(const struct FheUint160 *input, struct FheUint160 **result);

int fhe_uint160_not(const struct FheUint160 *input, struct FheUint160 **result);

int fhe_uint160_overflowing_add(const struct FheUint160 *lhs,
                                const struct FheUint160 *rhs,
                                struct FheUint160 **out_result,
                                struct FheBool **out_overflowed);

int fhe_uint160_overflowing_mul(const struct FheUint160 *lhs,
                                const struct FheUint160 *rhs,
                                struct FheUint160 **out_result,
                                struct FheBool **out_overflowed);

int fhe_uint160_overflowing_sub(const struct FheUint160 *lhs,
                                const struct FheUint160 *rhs,
                                struct FheUint160 **out_result,
                                struct FheBool **out_overflowed);

int fhe_uint160_rem(const struct FheUint160 *lhs,
                    const struct FheUint160 *rhs,
                    struct FheUint160 **result);

int fhe_uint160_rem_assign(struct FheUint160 *lhs, const struct FheUint160 *rhs);

int fhe_uint160_rotate_left(const struct FheUint160 *lhs,
                            const struct FheUint160 *rhs,
                            struct FheUint160 **result);

int fhe_uint160_rotate_left_assign(struct FheUint160 *lhs, const struct FheUint160 *rhs);

int fhe_uint160_rotate_right(const struct FheUint160 *lhs,
                             const struct FheUint160 *rhs,
                             struct FheUint160 **result);

int fhe_uint160_rotate_right_assign(struct FheUint160 *lhs, const struct FheUint160 *rhs);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int fhe_uint160_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                            uint64_t serialized_size_limit,
                                            const struct ServerKey *server_key,
                                            struct FheUint160 **result);

int fhe_uint160_safe_serialize(const struct FheUint160 *sself,
                               DynamicBuffer *result,
                               uint64_t serialized_size_limit);

int fhe_uint160_scalar_add(const struct FheUint160 *lhs,
                           struct U256 rhs,
                           struct FheUint160 **result);

int fhe_uint160_scalar_add_assign(struct FheUint160 *lhs, struct U256 rhs);

int fhe_uint160_scalar_bitand(const struct FheUint160 *lhs,
                              struct U256 rhs,
                              struct FheUint160 **result);

int fhe_uint160_scalar_bitand_assign(struct FheUint160 *lhs, struct U256 rhs);

int fhe_uint160_scalar_bitor(const struct FheUint160 *lhs,
                             struct U256 rhs,
                             struct FheUint160 **result);

int fhe_uint160_scalar_bitor_assign(struct FheUint160 *lhs, struct U256 rhs);

int fhe_uint160_scalar_bitxor(const struct FheUint160 *lhs,
                              struct U256 rhs,
                              struct FheUint160 **result);

int fhe_uint160_scalar_bitxor_assign(struct FheUint160 *lhs, struct U256 rhs);

int fhe_uint160_scalar_div(const struct FheUint160 *lhs,
                           struct U256 rhs,
                           struct FheUint160 **result);

int fhe_uint160_scalar_div_assign(struct FheUint160 *lhs, struct U256 rhs);

int fhe_uint160_scalar_div_rem(const struct FheUint160 *lhs,
                               struct U256 rhs,
                               struct FheUint160 **q_result,
                               struct FheUint160 **r_result);

int fhe_uint160_scalar_eq(const struct FheUint160 *lhs, struct U256 rhs, struct FheBool **result);

int fhe_uint160_scalar_ge(const struct FheUint160 *lhs, struct U256 rhs, struct FheBool **result);

int fhe_uint160_scalar_gt(const struct FheUint160 *lhs, struct U256 rhs, struct FheBool **result);

int fhe_uint160_scalar_le(const struct FheUint160 *lhs, struct U256 rhs, struct FheBool **result);

int fhe_uint160_scalar_lt(const struct FheUint160 *lhs, struct U256 rhs, struct FheBool **result);

int fhe_uint160_scalar_max(const struct FheUint160 *lhs,
                           struct U256 rhs,
                           struct FheUint160 **result);

int fhe_uint160_scalar_min(const struct FheUint160 *lhs,
                           struct U256 rhs,
                           struct FheUint160 **result);

int fhe_uint160_scalar_mul(const struct FheUint160 *lhs,
                           struct U256 rhs,
                           struct FheUint160 **result);

int fhe_uint160_scalar_mul_assign(struct FheUint160 *lhs, struct U256 rhs);

int fhe_uint160_scalar_ne(const struct FheUint160 *lhs, struct U256 rhs, struct FheBool **result);

int fhe_uint160_scalar_rem(const struct FheUint160 *lhs,
                           struct U256 rhs,
                           struct FheUint160 **result);

int fhe_uint160_scalar_rem_assign(struct FheUint160 *lhs, struct U256 rhs);

int fhe_uint160_scalar_rotate_left(const struct FheUint160 *lhs,
                                   struct U256 rhs,
                                   struct FheUint160 **result);

int fhe_uint160_scalar_rotate_left_assign(struct FheUint160 *lhs, struct U256 rhs);

int fhe_uint160_scalar_rotate_right(const struct FheUint160 *lhs,
                                    struct U256 rhs,
                                    struct FheUint160 **result);

int fhe_uint160_scalar_rotate_right_assign(struct FheUint160 *lhs, struct U256 rhs);

int fhe_uint160_scalar_shl(const struct FheUint160 *lhs,
                           struct U256 rhs,
                           struct FheUint160 **result);

int fhe_uint160_scalar_shl_assign(struct FheUint160 *lhs, struct U256 rhs);

int fhe_uint160_scalar_shr(const struct FheUint160 *lhs,
                           struct U256 rhs,
                           struct FheUint160 **result);

int fhe_uint160_scalar_shr_assign(struct FheUint160 *lhs, struct U256 rhs);

int fhe_uint160_scalar_sub(const struct FheUint160 *lhs,
                           struct U256 rhs,
                           struct FheUint160 **result);

int fhe_uint160_scalar_sub_assign(struct FheUint160 *lhs, struct U256 rhs);

int fhe_uint160_serialize(const struct FheUint160 *sself, DynamicBuffer *result);

int fhe_uint160_shl(const struct FheUint160 *lhs,
                    const struct FheUint160 *rhs,
                    struct FheUint160 **result);

int fhe_uint160_shl_assign(struct FheUint160 *lhs, const struct FheUint160 *rhs);

int fhe_uint160_shr(const struct FheUint160 *lhs,
                    const struct FheUint160 *rhs,
                    struct FheUint160 **result);

int fhe_uint160_shr_assign(struct FheUint160 *lhs, const struct FheUint160 *rhs);

int fhe_uint160_sub(const struct FheUint160 *lhs,
                    const struct FheUint160 *rhs,
                    struct FheUint160 **result);

int fhe_uint160_sub_assign(struct FheUint160 *lhs, const struct FheUint160 *rhs);

int fhe_uint160_sum(const struct FheUint160 *const *lhs,
                    size_t len,
                    struct FheUint160 **out_result);

/**
 * Returns the number of trailing ones in the binary representation of input.
 */
int fhe_uint160_trailing_ones(const struct FheUint160 *input, struct FheUint32 **result);

/**
 * Returns the number of trailing zeros in the binary representation of input.
 */
int fhe_uint160_trailing_zeros(const struct FheUint160 *input, struct FheUint32 **result);

int fhe_uint160_try_decrypt_trivial(const struct FheUint160 *encrypted_value, struct U256 *result);

int fhe_uint160_try_encrypt_trivial_u256(struct U256 value, struct FheUint160 **result);

int fhe_uint160_try_encrypt_with_client_key_u256(struct U256 value,
                                                 const struct ClientKey *client_key,
                                                 struct FheUint160 **result);

int fhe_uint160_try_encrypt_with_compact_public_key_u256(struct U256 value,
                                                         const struct CompactPublicKey *public_key,
                                                         struct FheUint160 **result);

int fhe_uint160_try_encrypt_with_public_key_u256(struct U256 value,
                                                 const struct PublicKey *public_key,
                                                 struct FheUint160 **result);

int fhe_uint16_add(const struct FheUint16 *lhs,
                   const struct FheUint16 *rhs,
                   struct FheUint16 **result);

int fhe_uint16_add_assign(struct FheUint16 *lhs, const struct FheUint16 *rhs);

int fhe_uint16_bitand(const struct FheUint16 *lhs,
                      const struct FheUint16 *rhs,
                      struct FheUint16 **result);

int fhe_uint16_bitand_assign(struct FheUint16 *lhs, const struct FheUint16 *rhs);

int fhe_uint16_bitor(const struct FheUint16 *lhs,
                     const struct FheUint16 *rhs,
                     struct FheUint16 **result);

int fhe_uint16_bitor_assign(struct FheUint16 *lhs, const struct FheUint16 *rhs);

int fhe_uint16_bitxor(const struct FheUint16 *lhs,
                      const struct FheUint16 *rhs,
                      struct FheUint16 **result);

int fhe_uint16_bitxor_assign(struct FheUint16 *lhs, const struct FheUint16 *rhs);

int fhe_uint16_cast_into_fhe_int10(const struct FheUint16 *sself, struct FheInt10 **result);

int fhe_uint16_cast_into_fhe_int12(const struct FheUint16 *sself, struct FheInt12 **result);

int fhe_uint16_cast_into_fhe_int128(const struct FheUint16 *sself, struct FheInt128 **result);

int fhe_uint16_cast_into_fhe_int14(const struct FheUint16 *sself, struct FheInt14 **result);

int fhe_uint16_cast_into_fhe_int16(const struct FheUint16 *sself, struct FheInt16 **result);

int fhe_uint16_cast_into_fhe_int160(const struct FheUint16 *sself, struct FheInt160 **result);

int fhe_uint16_cast_into_fhe_int2(const struct FheUint16 *sself, struct FheInt2 **result);

int fhe_uint16_cast_into_fhe_int256(const struct FheUint16 *sself, struct FheInt256 **result);

int fhe_uint16_cast_into_fhe_int32(const struct FheUint16 *sself, struct FheInt32 **result);

int fhe_uint16_cast_into_fhe_int4(const struct FheUint16 *sself, struct FheInt4 **result);

int fhe_uint16_cast_into_fhe_int6(const struct FheUint16 *sself, struct FheInt6 **result);

int fhe_uint16_cast_into_fhe_int64(const struct FheUint16 *sself, struct FheInt64 **result);

int fhe_uint16_cast_into_fhe_int8(const struct FheUint16 *sself, struct FheInt8 **result);

int fhe_uint16_cast_into_fhe_uint10(const struct FheUint16 *sself, struct FheUint10 **result);

int fhe_uint16_cast_into_fhe_uint128(const struct FheUint16 *sself, struct FheUint128 **result);

int fhe_uint16_cast_into_fhe_uint14(const struct FheUint16 *sself, struct FheUint14 **result);

int fhe_uint16_cast_into_fhe_uint16(const struct FheUint16 *sself, struct FheUint16 **result);

int fhe_uint16_cast_into_fhe_uint160(const struct FheUint16 *sself, struct FheUint160 **result);

int fhe_uint16_cast_into_fhe_uint2(const struct FheUint16 *sself, struct FheUint2 **result);

int fhe_uint16_cast_into_fhe_uint256(const struct FheUint16 *sself, struct FheUint256 **result);

int fhe_uint16_cast_into_fhe_uint32(const struct FheUint16 *sself, struct FheUint32 **result);

int fhe_uint16_cast_into_fhe_uint4(const struct FheUint16 *sself, struct FheUint4 **result);

int fhe_uint16_cast_into_fhe_uint6(const struct FheUint16 *sself, struct FheUint6 **result);

int fhe_uint16_cast_into_fhe_uint64(const struct FheUint16 *sself, struct FheUint64 **result);

int fhe_uint16_cast_into_fhe_uint8(const struct FheUint16 *sself, struct FheUint8 **result);

/**
 * Returns the base 2 logarithm of the number, rounded down.
 *
 * Also returns a boolean flag that is true if the result is valid (i.e input was > 0)
 */
int fhe_uint16_checked_ilog2(const struct FheUint16 *input,
                             struct FheUint32 **result_1,
                             struct FheBool **result_2);

int fhe_uint16_clone(const struct FheUint16 *sself, struct FheUint16 **result);

int fhe_uint16_compress(const struct FheUint16 *sself, struct CompressedFheUint16 **result);

int fhe_uint16_decrypt(const struct FheUint16 *encrypted_value,
                       const struct ClientKey *client_key,
                       uint16_t *result);

int fhe_uint16_deserialize(DynamicBufferView buffer_view, struct FheUint16 **result);

/**
 *ptr can be null (no-op in that case)
 */
int fhe_uint16_destroy(struct FheUint16 *ptr);

int fhe_uint16_div(const struct FheUint16 *lhs,
                   const struct FheUint16 *rhs,
                   struct FheUint16 **result);

int fhe_uint16_div_assign(struct FheUint16 *lhs, const struct FheUint16 *rhs);

int fhe_uint16_div_rem(const struct FheUint16 *lhs,
                       const struct FheUint16 *rhs,
                       struct FheUint16 **q_result,
                       struct FheUint16 **r_result);

int fhe_uint16_eq(const struct FheUint16 *lhs,
                  const struct FheUint16 *rhs,
                  struct FheBool **result);

int fhe_uint16_ge(const struct FheUint16 *lhs,
                  const struct FheUint16 *rhs,
                  struct FheBool **result);

int fhe_uint16_gt(const struct FheUint16 *lhs,
                  const struct FheUint16 *rhs,
                  struct FheBool **result);

int fhe_uint16_if_then_else(const struct FheBool *condition_ct,
                            const struct FheUint16 *then_ct,
                            const struct FheUint16 *else_ct,
                            struct FheUint16 **result);

/**
 * Returns the base 2 logarithm of the number, rounded down.
 *
 * Result has no meaning if self encrypts a value that is <= 0.
 * See `checked_ilog2`
 */
int fhe_uint16_ilog2(const struct FheUint16 *input, struct FheUint32 **result);

int fhe_uint16_le(const struct FheUint16 *lhs,
                  const struct FheUint16 *rhs,
                  struct FheBool **result);

/**
 * Returns the number of leading ones in the binary representation of input.
 */
int fhe_uint16_leading_ones(const struct FheUint16 *input, struct FheUint32 **result);

/**
 * Returns the number of leading zeros in the binary representation of input.
 */
int fhe_uint16_leading_zeros(const struct FheUint16 *input, struct FheUint32 **result);

int fhe_uint16_lt(const struct FheUint16 *lhs,
                  const struct FheUint16 *rhs,
                  struct FheBool **result);

int fhe_uint16_max(const struct FheUint16 *lhs,
                   const struct FheUint16 *rhs,
                   struct FheUint16 **result);

int fhe_uint16_min(const struct FheUint16 *lhs,
                   const struct FheUint16 *rhs,
                   struct FheUint16 **result);

int fhe_uint16_mul(const struct FheUint16 *lhs,
                   const struct FheUint16 *rhs,
                   struct FheUint16 **result);

int fhe_uint16_mul_assign(struct FheUint16 *lhs, const struct FheUint16 *rhs);

int fhe_uint16_ne(const struct FheUint16 *lhs,
                  const struct FheUint16 *rhs,
                  struct FheBool **result);

int fhe_uint16_neg(const struct FheUint16 *input, struct FheUint16 **result);

int fhe_uint16_not(const struct FheUint16 *input, struct FheUint16 **result);

int fhe_uint16_overflowing_add(const struct FheUint16 *lhs,
                               const struct FheUint16 *rhs,
                               struct FheUint16 **out_result,
                               struct FheBool **out_overflowed);

int fhe_uint16_overflowing_mul(const struct FheUint16 *lhs,
                               const struct FheUint16 *rhs,
                               struct FheUint16 **out_result,
                               struct FheBool **out_overflowed);

int fhe_uint16_overflowing_sub(const struct FheUint16 *lhs,
                               const struct FheUint16 *rhs,
                               struct FheUint16 **out_result,
                               struct FheBool **out_overflowed);

int fhe_uint16_rem(const struct FheUint16 *lhs,
                   const struct FheUint16 *rhs,
                   struct FheUint16 **result);

int fhe_uint16_rem_assign(struct FheUint16 *lhs, const struct FheUint16 *rhs);

int fhe_uint16_rotate_left(const struct FheUint16 *lhs,
                           const struct FheUint16 *rhs,
                           struct FheUint16 **result);

int fhe_uint16_rotate_left_assign(struct FheUint16 *lhs, const struct FheUint16 *rhs);

int fhe_uint16_rotate_right(const struct FheUint16 *lhs,
                            const struct FheUint16 *rhs,
                            struct FheUint16 **result);

int fhe_uint16_rotate_right_assign(struct FheUint16 *lhs, const struct FheUint16 *rhs);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int fhe_uint16_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                           uint64_t serialized_size_limit,
                                           const struct ServerKey *server_key,
                                           struct FheUint16 **result);

int fhe_uint16_safe_serialize(const struct FheUint16 *sself,
                              DynamicBuffer *result,
                              uint64_t serialized_size_limit);

int fhe_uint16_scalar_add(const struct FheUint16 *lhs, uint16_t rhs, struct FheUint16 **result);

int fhe_uint16_scalar_add_assign(struct FheUint16 *lhs, uint16_t rhs);

int fhe_uint16_scalar_bitand(const struct FheUint16 *lhs, uint16_t rhs, struct FheUint16 **result);

int fhe_uint16_scalar_bitand_assign(struct FheUint16 *lhs, uint16_t rhs);

int fhe_uint16_scalar_bitor(const struct FheUint16 *lhs, uint16_t rhs, struct FheUint16 **result);

int fhe_uint16_scalar_bitor_assign(struct FheUint16 *lhs, uint16_t rhs);

int fhe_uint16_scalar_bitxor(const struct FheUint16 *lhs, uint16_t rhs, struct FheUint16 **result);

int fhe_uint16_scalar_bitxor_assign(struct FheUint16 *lhs, uint16_t rhs);

int fhe_uint16_scalar_div(const struct FheUint16 *lhs, uint16_t rhs, struct FheUint16 **result);

int fhe_uint16_scalar_div_assign(struct FheUint16 *lhs, uint16_t rhs);

int fhe_uint16_scalar_div_rem(const struct FheUint16 *lhs,
                              uint16_t rhs,
                              struct FheUint16 **q_result,
                              struct FheUint16 **r_result);

int fhe_uint16_scalar_eq(const struct FheUint16 *lhs, uint16_t rhs, struct FheBool **result);

int fhe_uint16_scalar_ge(const struct FheUint16 *lhs, uint16_t rhs, struct FheBool **result);

int fhe_uint16_scalar_gt(const struct FheUint16 *lhs, uint16_t rhs, struct FheBool **result);

int fhe_uint16_scalar_le(const struct FheUint16 *lhs, uint16_t rhs, struct FheBool **result);

int fhe_uint16_scalar_lt(const struct FheUint16 *lhs, uint16_t rhs, struct FheBool **result);

int fhe_uint16_scalar_max(const struct FheUint16 *lhs, uint16_t rhs, struct FheUint16 **result);

int fhe_uint16_scalar_min(const struct FheUint16 *lhs, uint16_t rhs, struct FheUint16 **result);

int fhe_uint16_scalar_mul(const struct FheUint16 *lhs, uint16_t rhs, struct FheUint16 **result);

int fhe_uint16_scalar_mul_assign(struct FheUint16 *lhs, uint16_t rhs);

int fhe_uint16_scalar_ne(const struct FheUint16 *lhs, uint16_t rhs, struct FheBool **result);

int fhe_uint16_scalar_rem(const struct FheUint16 *lhs, uint16_t rhs, struct FheUint16 **result);

int fhe_uint16_scalar_rem_assign(struct FheUint16 *lhs, uint16_t rhs);

int fhe_uint16_scalar_rotate_left(const struct FheUint16 *lhs,
                                  uint16_t rhs,
                                  struct FheUint16 **result);

int fhe_uint16_scalar_rotate_left_assign(struct FheUint16 *lhs, uint16_t rhs);

int fhe_uint16_scalar_rotate_right(const struct FheUint16 *lhs,
                                   uint16_t rhs,
                                   struct FheUint16 **result);

int fhe_uint16_scalar_rotate_right_assign(struct FheUint16 *lhs, uint16_t rhs);

int fhe_uint16_scalar_shl(const struct FheUint16 *lhs, uint16_t rhs, struct FheUint16 **result);

int fhe_uint16_scalar_shl_assign(struct FheUint16 *lhs, uint16_t rhs);

int fhe_uint16_scalar_shr(const struct FheUint16 *lhs, uint16_t rhs, struct FheUint16 **result);

int fhe_uint16_scalar_shr_assign(struct FheUint16 *lhs, uint16_t rhs);

int fhe_uint16_scalar_sub(const struct FheUint16 *lhs, uint16_t rhs, struct FheUint16 **result);

int fhe_uint16_scalar_sub_assign(struct FheUint16 *lhs, uint16_t rhs);

int fhe_uint16_serialize(const struct FheUint16 *sself, DynamicBuffer *result);

int fhe_uint16_shl(const struct FheUint16 *lhs,
                   const struct FheUint16 *rhs,
                   struct FheUint16 **result);

int fhe_uint16_shl_assign(struct FheUint16 *lhs, const struct FheUint16 *rhs);

int fhe_uint16_shr(const struct FheUint16 *lhs,
                   const struct FheUint16 *rhs,
                   struct FheUint16 **result);

int fhe_uint16_shr_assign(struct FheUint16 *lhs, const struct FheUint16 *rhs);

int fhe_uint16_sub(const struct FheUint16 *lhs,
                   const struct FheUint16 *rhs,
                   struct FheUint16 **result);

int fhe_uint16_sub_assign(struct FheUint16 *lhs, const struct FheUint16 *rhs);

int fhe_uint16_sum(const struct FheUint16 *const *lhs, size_t len, struct FheUint16 **out_result);

/**
 * Returns the number of trailing ones in the binary representation of input.
 */
int fhe_uint16_trailing_ones(const struct FheUint16 *input, struct FheUint32 **result);

/**
 * Returns the number of trailing zeros in the binary representation of input.
 */
int fhe_uint16_trailing_zeros(const struct FheUint16 *input, struct FheUint32 **result);

int fhe_uint16_try_decrypt_trivial(const struct FheUint16 *encrypted_value, uint16_t *result);

int fhe_uint16_try_encrypt_trivial_u16(uint16_t value, struct FheUint16 **result);

int fhe_uint16_try_encrypt_with_client_key_u16(uint16_t value,
                                               const struct ClientKey *client_key,
                                               struct FheUint16 **result);

int fhe_uint16_try_encrypt_with_compact_public_key_u16(uint16_t value,
                                                       const struct CompactPublicKey *public_key,
                                                       struct FheUint16 **result);

int fhe_uint16_try_encrypt_with_public_key_u16(uint16_t value,
                                               const struct PublicKey *public_key,
                                               struct FheUint16 **result);

int fhe_uint256_add(const struct FheUint256 *lhs,
                    const struct FheUint256 *rhs,
                    struct FheUint256 **result);

int fhe_uint256_add_assign(struct FheUint256 *lhs, const struct FheUint256 *rhs);

int fhe_uint256_bitand(const struct FheUint256 *lhs,
                       const struct FheUint256 *rhs,
                       struct FheUint256 **result);

int fhe_uint256_bitand_assign(struct FheUint256 *lhs, const struct FheUint256 *rhs);

int fhe_uint256_bitor(const struct FheUint256 *lhs,
                      const struct FheUint256 *rhs,
                      struct FheUint256 **result);

int fhe_uint256_bitor_assign(struct FheUint256 *lhs, const struct FheUint256 *rhs);

int fhe_uint256_bitxor(const struct FheUint256 *lhs,
                       const struct FheUint256 *rhs,
                       struct FheUint256 **result);

int fhe_uint256_bitxor_assign(struct FheUint256 *lhs, const struct FheUint256 *rhs);

int fhe_uint256_cast_into_fhe_int10(const struct FheUint256 *sself, struct FheInt10 **result);

int fhe_uint256_cast_into_fhe_int12(const struct FheUint256 *sself, struct FheInt12 **result);

int fhe_uint256_cast_into_fhe_int128(const struct FheUint256 *sself, struct FheInt128 **result);

int fhe_uint256_cast_into_fhe_int14(const struct FheUint256 *sself, struct FheInt14 **result);

int fhe_uint256_cast_into_fhe_int16(const struct FheUint256 *sself, struct FheInt16 **result);

int fhe_uint256_cast_into_fhe_int160(const struct FheUint256 *sself, struct FheInt160 **result);

int fhe_uint256_cast_into_fhe_int2(const struct FheUint256 *sself, struct FheInt2 **result);

int fhe_uint256_cast_into_fhe_int256(const struct FheUint256 *sself, struct FheInt256 **result);

int fhe_uint256_cast_into_fhe_int32(const struct FheUint256 *sself, struct FheInt32 **result);

int fhe_uint256_cast_into_fhe_int4(const struct FheUint256 *sself, struct FheInt4 **result);

int fhe_uint256_cast_into_fhe_int6(const struct FheUint256 *sself, struct FheInt6 **result);

int fhe_uint256_cast_into_fhe_int64(const struct FheUint256 *sself, struct FheInt64 **result);

int fhe_uint256_cast_into_fhe_int8(const struct FheUint256 *sself, struct FheInt8 **result);

int fhe_uint256_cast_into_fhe_uint10(const struct FheUint256 *sself, struct FheUint10 **result);

int fhe_uint256_cast_into_fhe_uint128(const struct FheUint256 *sself, struct FheUint128 **result);

int fhe_uint256_cast_into_fhe_uint14(const struct FheUint256 *sself, struct FheUint14 **result);

int fhe_uint256_cast_into_fhe_uint16(const struct FheUint256 *sself, struct FheUint16 **result);

int fhe_uint256_cast_into_fhe_uint160(const struct FheUint256 *sself, struct FheUint160 **result);

int fhe_uint256_cast_into_fhe_uint2(const struct FheUint256 *sself, struct FheUint2 **result);

int fhe_uint256_cast_into_fhe_uint256(const struct FheUint256 *sself, struct FheUint256 **result);

int fhe_uint256_cast_into_fhe_uint32(const struct FheUint256 *sself, struct FheUint32 **result);

int fhe_uint256_cast_into_fhe_uint4(const struct FheUint256 *sself, struct FheUint4 **result);

int fhe_uint256_cast_into_fhe_uint6(const struct FheUint256 *sself, struct FheUint6 **result);

int fhe_uint256_cast_into_fhe_uint64(const struct FheUint256 *sself, struct FheUint64 **result);

int fhe_uint256_cast_into_fhe_uint8(const struct FheUint256 *sself, struct FheUint8 **result);

/**
 * Returns the base 2 logarithm of the number, rounded down.
 *
 * Also returns a boolean flag that is true if the result is valid (i.e input was > 0)
 */
int fhe_uint256_checked_ilog2(const struct FheUint256 *input,
                              struct FheUint32 **result_1,
                              struct FheBool **result_2);

int fhe_uint256_clone(const struct FheUint256 *sself, struct FheUint256 **result);

int fhe_uint256_compress(const struct FheUint256 *sself, struct CompressedFheUint256 **result);

int fhe_uint256_decrypt(const struct FheUint256 *encrypted_value,
                        const struct ClientKey *client_key,
                        struct U256 *result);

int fhe_uint256_deserialize(DynamicBufferView buffer_view, struct FheUint256 **result);

/**
 *ptr can be null (no-op in that case)
 */
int fhe_uint256_destroy(struct FheUint256 *ptr);

int fhe_uint256_div(const struct FheUint256 *lhs,
                    const struct FheUint256 *rhs,
                    struct FheUint256 **result);

int fhe_uint256_div_assign(struct FheUint256 *lhs, const struct FheUint256 *rhs);

int fhe_uint256_div_rem(const struct FheUint256 *lhs,
                        const struct FheUint256 *rhs,
                        struct FheUint256 **q_result,
                        struct FheUint256 **r_result);

int fhe_uint256_eq(const struct FheUint256 *lhs,
                   const struct FheUint256 *rhs,
                   struct FheBool **result);

int fhe_uint256_ge(const struct FheUint256 *lhs,
                   const struct FheUint256 *rhs,
                   struct FheBool **result);

int fhe_uint256_gt(const struct FheUint256 *lhs,
                   const struct FheUint256 *rhs,
                   struct FheBool **result);

int fhe_uint256_if_then_else(const struct FheBool *condition_ct,
                             const struct FheUint256 *then_ct,
                             const struct FheUint256 *else_ct,
                             struct FheUint256 **result);

/**
 * Returns the base 2 logarithm of the number, rounded down.
 *
 * Result has no meaning if self encrypts a value that is <= 0.
 * See `checked_ilog2`
 */
int fhe_uint256_ilog2(const struct FheUint256 *input, struct FheUint32 **result);

int fhe_uint256_le(const struct FheUint256 *lhs,
                   const struct FheUint256 *rhs,
                   struct FheBool **result);

/**
 * Returns the number of leading ones in the binary representation of input.
 */
int fhe_uint256_leading_ones(const struct FheUint256 *input, struct FheUint32 **result);

/**
 * Returns the number of leading zeros in the binary representation of input.
 */
int fhe_uint256_leading_zeros(const struct FheUint256 *input, struct FheUint32 **result);

int fhe_uint256_lt(const struct FheUint256 *lhs,
                   const struct FheUint256 *rhs,
                   struct FheBool **result);

int fhe_uint256_max(const struct FheUint256 *lhs,
                    const struct FheUint256 *rhs,
                    struct FheUint256 **result);

int fhe_uint256_min(const struct FheUint256 *lhs,
                    const struct FheUint256 *rhs,
                    struct FheUint256 **result);

int fhe_uint256_mul(const struct FheUint256 *lhs,
                    const struct FheUint256 *rhs,
                    struct FheUint256 **result);

int fhe_uint256_mul_assign(struct FheUint256 *lhs, const struct FheUint256 *rhs);

int fhe_uint256_ne(const struct FheUint256 *lhs,
                   const struct FheUint256 *rhs,
                   struct FheBool **result);

int fhe_uint256_neg(const struct FheUint256 *input, struct FheUint256 **result);

int fhe_uint256_not(const struct FheUint256 *input, struct FheUint256 **result);

int fhe_uint256_overflowing_add(const struct FheUint256 *lhs,
                                const struct FheUint256 *rhs,
                                struct FheUint256 **out_result,
                                struct FheBool **out_overflowed);

int fhe_uint256_overflowing_mul(const struct FheUint256 *lhs,
                                const struct FheUint256 *rhs,
                                struct FheUint256 **out_result,
                                struct FheBool **out_overflowed);

int fhe_uint256_overflowing_sub(const struct FheUint256 *lhs,
                                const struct FheUint256 *rhs,
                                struct FheUint256 **out_result,
                                struct FheBool **out_overflowed);

int fhe_uint256_rem(const struct FheUint256 *lhs,
                    const struct FheUint256 *rhs,
                    struct FheUint256 **result);

int fhe_uint256_rem_assign(struct FheUint256 *lhs, const struct FheUint256 *rhs);

int fhe_uint256_rotate_left(const struct FheUint256 *lhs,
                            const struct FheUint256 *rhs,
                            struct FheUint256 **result);

int fhe_uint256_rotate_left_assign(struct FheUint256 *lhs, const struct FheUint256 *rhs);

int fhe_uint256_rotate_right(const struct FheUint256 *lhs,
                             const struct FheUint256 *rhs,
                             struct FheUint256 **result);

int fhe_uint256_rotate_right_assign(struct FheUint256 *lhs, const struct FheUint256 *rhs);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int fhe_uint256_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                            uint64_t serialized_size_limit,
                                            const struct ServerKey *server_key,
                                            struct FheUint256 **result);

int fhe_uint256_safe_serialize(const struct FheUint256 *sself,
                               DynamicBuffer *result,
                               uint64_t serialized_size_limit);

int fhe_uint256_scalar_add(const struct FheUint256 *lhs,
                           struct U256 rhs,
                           struct FheUint256 **result);

int fhe_uint256_scalar_add_assign(struct FheUint256 *lhs, struct U256 rhs);

int fhe_uint256_scalar_bitand(const struct FheUint256 *lhs,
                              struct U256 rhs,
                              struct FheUint256 **result);

int fhe_uint256_scalar_bitand_assign(struct FheUint256 *lhs, struct U256 rhs);

int fhe_uint256_scalar_bitor(const struct FheUint256 *lhs,
                             struct U256 rhs,
                             struct FheUint256 **result);

int fhe_uint256_scalar_bitor_assign(struct FheUint256 *lhs, struct U256 rhs);

int fhe_uint256_scalar_bitxor(const struct FheUint256 *lhs,
                              struct U256 rhs,
                              struct FheUint256 **result);

int fhe_uint256_scalar_bitxor_assign(struct FheUint256 *lhs, struct U256 rhs);

int fhe_uint256_scalar_div(const struct FheUint256 *lhs,
                           struct U256 rhs,
                           struct FheUint256 **result);

int fhe_uint256_scalar_div_assign(struct FheUint256 *lhs, struct U256 rhs);

int fhe_uint256_scalar_div_rem(const struct FheUint256 *lhs,
                               struct U256 rhs,
                               struct FheUint256 **q_result,
                               struct FheUint256 **r_result);

int fhe_uint256_scalar_eq(const struct FheUint256 *lhs, struct U256 rhs, struct FheBool **result);

int fhe_uint256_scalar_ge(const struct FheUint256 *lhs, struct U256 rhs, struct FheBool **result);

int fhe_uint256_scalar_gt(const struct FheUint256 *lhs, struct U256 rhs, struct FheBool **result);

int fhe_uint256_scalar_le(const struct FheUint256 *lhs, struct U256 rhs, struct FheBool **result);

int fhe_uint256_scalar_lt(const struct FheUint256 *lhs, struct U256 rhs, struct FheBool **result);

int fhe_uint256_scalar_max(const struct FheUint256 *lhs,
                           struct U256 rhs,
                           struct FheUint256 **result);

int fhe_uint256_scalar_min(const struct FheUint256 *lhs,
                           struct U256 rhs,
                           struct FheUint256 **result);

int fhe_uint256_scalar_mul(const struct FheUint256 *lhs,
                           struct U256 rhs,
                           struct FheUint256 **result);

int fhe_uint256_scalar_mul_assign(struct FheUint256 *lhs, struct U256 rhs);

int fhe_uint256_scalar_ne(const struct FheUint256 *lhs, struct U256 rhs, struct FheBool **result);

int fhe_uint256_scalar_rem(const struct FheUint256 *lhs,
                           struct U256 rhs,
                           struct FheUint256 **result);

int fhe_uint256_scalar_rem_assign(struct FheUint256 *lhs, struct U256 rhs);

int fhe_uint256_scalar_rotate_left(const struct FheUint256 *lhs,
                                   struct U256 rhs,
                                   struct FheUint256 **result);

int fhe_uint256_scalar_rotate_left_assign(struct FheUint256 *lhs, struct U256 rhs);

int fhe_uint256_scalar_rotate_right(const struct FheUint256 *lhs,
                                    struct U256 rhs,
                                    struct FheUint256 **result);

int fhe_uint256_scalar_rotate_right_assign(struct FheUint256 *lhs, struct U256 rhs);

int fhe_uint256_scalar_shl(const struct FheUint256 *lhs,
                           struct U256 rhs,
                           struct FheUint256 **result);

int fhe_uint256_scalar_shl_assign(struct FheUint256 *lhs, struct U256 rhs);

int fhe_uint256_scalar_shr(const struct FheUint256 *lhs,
                           struct U256 rhs,
                           struct FheUint256 **result);

int fhe_uint256_scalar_shr_assign(struct FheUint256 *lhs, struct U256 rhs);

int fhe_uint256_scalar_sub(const struct FheUint256 *lhs,
                           struct U256 rhs,
                           struct FheUint256 **result);

int fhe_uint256_scalar_sub_assign(struct FheUint256 *lhs, struct U256 rhs);

int fhe_uint256_serialize(const struct FheUint256 *sself, DynamicBuffer *result);

int fhe_uint256_shl(const struct FheUint256 *lhs,
                    const struct FheUint256 *rhs,
                    struct FheUint256 **result);

int fhe_uint256_shl_assign(struct FheUint256 *lhs, const struct FheUint256 *rhs);

int fhe_uint256_shr(const struct FheUint256 *lhs,
                    const struct FheUint256 *rhs,
                    struct FheUint256 **result);

int fhe_uint256_shr_assign(struct FheUint256 *lhs, const struct FheUint256 *rhs);

int fhe_uint256_sub(const struct FheUint256 *lhs,
                    const struct FheUint256 *rhs,
                    struct FheUint256 **result);

int fhe_uint256_sub_assign(struct FheUint256 *lhs, const struct FheUint256 *rhs);

int fhe_uint256_sum(const struct FheUint256 *const *lhs,
                    size_t len,
                    struct FheUint256 **out_result);

/**
 * Returns the number of trailing ones in the binary representation of input.
 */
int fhe_uint256_trailing_ones(const struct FheUint256 *input, struct FheUint32 **result);

/**
 * Returns the number of trailing zeros in the binary representation of input.
 */
int fhe_uint256_trailing_zeros(const struct FheUint256 *input, struct FheUint32 **result);

int fhe_uint256_try_decrypt_trivial(const struct FheUint256 *encrypted_value, struct U256 *result);

int fhe_uint256_try_encrypt_trivial_u256(struct U256 value, struct FheUint256 **result);

int fhe_uint256_try_encrypt_with_client_key_u256(struct U256 value,
                                                 const struct ClientKey *client_key,
                                                 struct FheUint256 **result);

int fhe_uint256_try_encrypt_with_compact_public_key_u256(struct U256 value,
                                                         const struct CompactPublicKey *public_key,
                                                         struct FheUint256 **result);

int fhe_uint256_try_encrypt_with_public_key_u256(struct U256 value,
                                                 const struct PublicKey *public_key,
                                                 struct FheUint256 **result);

int fhe_uint2_add(const struct FheUint2 *lhs, const struct FheUint2 *rhs, struct FheUint2 **result);

int fhe_uint2_add_assign(struct FheUint2 *lhs, const struct FheUint2 *rhs);

int fhe_uint2_bitand(const struct FheUint2 *lhs,
                     const struct FheUint2 *rhs,
                     struct FheUint2 **result);

int fhe_uint2_bitand_assign(struct FheUint2 *lhs, const struct FheUint2 *rhs);

int fhe_uint2_bitor(const struct FheUint2 *lhs,
                    const struct FheUint2 *rhs,
                    struct FheUint2 **result);

int fhe_uint2_bitor_assign(struct FheUint2 *lhs, const struct FheUint2 *rhs);

int fhe_uint2_bitxor(const struct FheUint2 *lhs,
                     const struct FheUint2 *rhs,
                     struct FheUint2 **result);

int fhe_uint2_bitxor_assign(struct FheUint2 *lhs, const struct FheUint2 *rhs);

int fhe_uint2_cast_into_fhe_int10(const struct FheUint2 *sself, struct FheInt10 **result);

int fhe_uint2_cast_into_fhe_int12(const struct FheUint2 *sself, struct FheInt12 **result);

int fhe_uint2_cast_into_fhe_int128(const struct FheUint2 *sself, struct FheInt128 **result);

int fhe_uint2_cast_into_fhe_int14(const struct FheUint2 *sself, struct FheInt14 **result);

int fhe_uint2_cast_into_fhe_int16(const struct FheUint2 *sself, struct FheInt16 **result);

int fhe_uint2_cast_into_fhe_int160(const struct FheUint2 *sself, struct FheInt160 **result);

int fhe_uint2_cast_into_fhe_int2(const struct FheUint2 *sself, struct FheInt2 **result);

int fhe_uint2_cast_into_fhe_int256(const struct FheUint2 *sself, struct FheInt256 **result);

int fhe_uint2_cast_into_fhe_int32(const struct FheUint2 *sself, struct FheInt32 **result);

int fhe_uint2_cast_into_fhe_int4(const struct FheUint2 *sself, struct FheInt4 **result);

int fhe_uint2_cast_into_fhe_int6(const struct FheUint2 *sself, struct FheInt6 **result);

int fhe_uint2_cast_into_fhe_int64(const struct FheUint2 *sself, struct FheInt64 **result);

int fhe_uint2_cast_into_fhe_int8(const struct FheUint2 *sself, struct FheInt8 **result);

int fhe_uint2_cast_into_fhe_uint10(const struct FheUint2 *sself, struct FheUint10 **result);

int fhe_uint2_cast_into_fhe_uint128(const struct FheUint2 *sself, struct FheUint128 **result);

int fhe_uint2_cast_into_fhe_uint14(const struct FheUint2 *sself, struct FheUint14 **result);

int fhe_uint2_cast_into_fhe_uint16(const struct FheUint2 *sself, struct FheUint16 **result);

int fhe_uint2_cast_into_fhe_uint160(const struct FheUint2 *sself, struct FheUint160 **result);

int fhe_uint2_cast_into_fhe_uint2(const struct FheUint2 *sself, struct FheUint2 **result);

int fhe_uint2_cast_into_fhe_uint256(const struct FheUint2 *sself, struct FheUint256 **result);

int fhe_uint2_cast_into_fhe_uint32(const struct FheUint2 *sself, struct FheUint32 **result);

int fhe_uint2_cast_into_fhe_uint4(const struct FheUint2 *sself, struct FheUint4 **result);

int fhe_uint2_cast_into_fhe_uint6(const struct FheUint2 *sself, struct FheUint6 **result);

int fhe_uint2_cast_into_fhe_uint64(const struct FheUint2 *sself, struct FheUint64 **result);

int fhe_uint2_cast_into_fhe_uint8(const struct FheUint2 *sself, struct FheUint8 **result);

/**
 * Returns the base 2 logarithm of the number, rounded down.
 *
 * Also returns a boolean flag that is true if the result is valid (i.e input was > 0)
 */
int fhe_uint2_checked_ilog2(const struct FheUint2 *input,
                            struct FheUint32 **result_1,
                            struct FheBool **result_2);

int fhe_uint2_clone(const struct FheUint2 *sself, struct FheUint2 **result);

int fhe_uint2_compress(const struct FheUint2 *sself, struct CompressedFheUint2 **result);

int fhe_uint2_decrypt(const struct FheUint2 *encrypted_value,
                      const struct ClientKey *client_key,
                      uint8_t *result);

int fhe_uint2_deserialize(DynamicBufferView buffer_view, struct FheUint2 **result);

/**
 *ptr can be null (no-op in that case)
 */
int fhe_uint2_destroy(struct FheUint2 *ptr);

int fhe_uint2_div(const struct FheUint2 *lhs, const struct FheUint2 *rhs, struct FheUint2 **result);

int fhe_uint2_div_assign(struct FheUint2 *lhs, const struct FheUint2 *rhs);

int fhe_uint2_div_rem(const struct FheUint2 *lhs,
                      const struct FheUint2 *rhs,
                      struct FheUint2 **q_result,
                      struct FheUint2 **r_result);

int fhe_uint2_eq(const struct FheUint2 *lhs, const struct FheUint2 *rhs, struct FheBool **result);

int fhe_uint2_ge(const struct FheUint2 *lhs, const struct FheUint2 *rhs, struct FheBool **result);

int fhe_uint2_gt(const struct FheUint2 *lhs, const struct FheUint2 *rhs, struct FheBool **result);

int fhe_uint2_if_then_else(const struct FheBool *condition_ct,
                           const struct FheUint2 *then_ct,
                           const struct FheUint2 *else_ct,
                           struct FheUint2 **result);

/**
 * Returns the base 2 logarithm of the number, rounded down.
 *
 * Result has no meaning if self encrypts a value that is <= 0.
 * See `checked_ilog2`
 */
int fhe_uint2_ilog2(const struct FheUint2 *input, struct FheUint32 **result);

int fhe_uint2_le(const struct FheUint2 *lhs, const struct FheUint2 *rhs, struct FheBool **result);

/**
 * Returns the number of leading ones in the binary representation of input.
 */
int fhe_uint2_leading_ones(const struct FheUint2 *input, struct FheUint32 **result);

/**
 * Returns the number of leading zeros in the binary representation of input.
 */
int fhe_uint2_leading_zeros(const struct FheUint2 *input, struct FheUint32 **result);

int fhe_uint2_lt(const struct FheUint2 *lhs, const struct FheUint2 *rhs, struct FheBool **result);

int fhe_uint2_max(const struct FheUint2 *lhs, const struct FheUint2 *rhs, struct FheUint2 **result);

int fhe_uint2_min(const struct FheUint2 *lhs, const struct FheUint2 *rhs, struct FheUint2 **result);

int fhe_uint2_mul(const struct FheUint2 *lhs, const struct FheUint2 *rhs, struct FheUint2 **result);

int fhe_uint2_mul_assign(struct FheUint2 *lhs, const struct FheUint2 *rhs);

int fhe_uint2_ne(const struct FheUint2 *lhs, const struct FheUint2 *rhs, struct FheBool **result);

int fhe_uint2_neg(const struct FheUint2 *input, struct FheUint2 **result);

int fhe_uint2_not(const struct FheUint2 *input, struct FheUint2 **result);

int fhe_uint2_overflowing_add(const struct FheUint2 *lhs,
                              const struct FheUint2 *rhs,
                              struct FheUint2 **out_result,
                              struct FheBool **out_overflowed);

int fhe_uint2_overflowing_mul(const struct FheUint2 *lhs,
                              const struct FheUint2 *rhs,
                              struct FheUint2 **out_result,
                              struct FheBool **out_overflowed);

int fhe_uint2_overflowing_sub(const struct FheUint2 *lhs,
                              const struct FheUint2 *rhs,
                              struct FheUint2 **out_result,
                              struct FheBool **out_overflowed);

int fhe_uint2_rem(const struct FheUint2 *lhs, const struct FheUint2 *rhs, struct FheUint2 **result);

int fhe_uint2_rem_assign(struct FheUint2 *lhs, const struct FheUint2 *rhs);

int fhe_uint2_rotate_left(const struct FheUint2 *lhs,
                          const struct FheUint2 *rhs,
                          struct FheUint2 **result);

int fhe_uint2_rotate_left_assign(struct FheUint2 *lhs, const struct FheUint2 *rhs);

int fhe_uint2_rotate_right(const struct FheUint2 *lhs,
                           const struct FheUint2 *rhs,
                           struct FheUint2 **result);

int fhe_uint2_rotate_right_assign(struct FheUint2 *lhs, const struct FheUint2 *rhs);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int fhe_uint2_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                          uint64_t serialized_size_limit,
                                          const struct ServerKey *server_key,
                                          struct FheUint2 **result);

int fhe_uint2_safe_serialize(const struct FheUint2 *sself,
                             DynamicBuffer *result,
                             uint64_t serialized_size_limit);

int fhe_uint2_scalar_add(const struct FheUint2 *lhs, uint8_t rhs, struct FheUint2 **result);

int fhe_uint2_scalar_add_assign(struct FheUint2 *lhs, uint8_t rhs);

int fhe_uint2_scalar_bitand(const struct FheUint2 *lhs, uint8_t rhs, struct FheUint2 **result);

int fhe_uint2_scalar_bitand_assign(struct FheUint2 *lhs, uint8_t rhs);

int fhe_uint2_scalar_bitor(const struct FheUint2 *lhs, uint8_t rhs, struct FheUint2 **result);

int fhe_uint2_scalar_bitor_assign(struct FheUint2 *lhs, uint8_t rhs);

int fhe_uint2_scalar_bitxor(const struct FheUint2 *lhs, uint8_t rhs, struct FheUint2 **result);

int fhe_uint2_scalar_bitxor_assign(struct FheUint2 *lhs, uint8_t rhs);

int fhe_uint2_scalar_div(const struct FheUint2 *lhs, uint8_t rhs, struct FheUint2 **result);

int fhe_uint2_scalar_div_assign(struct FheUint2 *lhs, uint8_t rhs);

int fhe_uint2_scalar_div_rem(const struct FheUint2 *lhs,
                             uint8_t rhs,
                             struct FheUint2 **q_result,
                             struct FheUint2 **r_result);

int fhe_uint2_scalar_eq(const struct FheUint2 *lhs, uint8_t rhs, struct FheBool **result);

int fhe_uint2_scalar_ge(const struct FheUint2 *lhs, uint8_t rhs, struct FheBool **result);

int fhe_uint2_scalar_gt(const struct FheUint2 *lhs, uint8_t rhs, struct FheBool **result);

int fhe_uint2_scalar_le(const struct FheUint2 *lhs, uint8_t rhs, struct FheBool **result);

int fhe_uint2_scalar_lt(const struct FheUint2 *lhs, uint8_t rhs, struct FheBool **result);

int fhe_uint2_scalar_max(const struct FheUint2 *lhs, uint8_t rhs, struct FheUint2 **result);

int fhe_uint2_scalar_min(const struct FheUint2 *lhs, uint8_t rhs, struct FheUint2 **result);

int fhe_uint2_scalar_mul(const struct FheUint2 *lhs, uint8_t rhs, struct FheUint2 **result);

int fhe_uint2_scalar_mul_assign(struct FheUint2 *lhs, uint8_t rhs);

int fhe_uint2_scalar_ne(const struct FheUint2 *lhs, uint8_t rhs, struct FheBool **result);

int fhe_uint2_scalar_rem(const struct FheUint2 *lhs, uint8_t rhs, struct FheUint2 **result);

int fhe_uint2_scalar_rem_assign(struct FheUint2 *lhs, uint8_t rhs);

int fhe_uint2_scalar_rotate_left(const struct FheUint2 *lhs, uint8_t rhs, struct FheUint2 **result);

int fhe_uint2_scalar_rotate_left_assign(struct FheUint2 *lhs, uint8_t rhs);

int fhe_uint2_scalar_rotate_right(const struct FheUint2 *lhs,
                                  uint8_t rhs,
                                  struct FheUint2 **result);

int fhe_uint2_scalar_rotate_right_assign(struct FheUint2 *lhs, uint8_t rhs);

int fhe_uint2_scalar_shl(const struct FheUint2 *lhs, uint8_t rhs, struct FheUint2 **result);

int fhe_uint2_scalar_shl_assign(struct FheUint2 *lhs, uint8_t rhs);

int fhe_uint2_scalar_shr(const struct FheUint2 *lhs, uint8_t rhs, struct FheUint2 **result);

int fhe_uint2_scalar_shr_assign(struct FheUint2 *lhs, uint8_t rhs);

int fhe_uint2_scalar_sub(const struct FheUint2 *lhs, uint8_t rhs, struct FheUint2 **result);

int fhe_uint2_scalar_sub_assign(struct FheUint2 *lhs, uint8_t rhs);

int fhe_uint2_serialize(const struct FheUint2 *sself, DynamicBuffer *result);

int fhe_uint2_shl(const struct FheUint2 *lhs, const struct FheUint2 *rhs, struct FheUint2 **result);

int fhe_uint2_shl_assign(struct FheUint2 *lhs, const struct FheUint2 *rhs);

int fhe_uint2_shr(const struct FheUint2 *lhs, const struct FheUint2 *rhs, struct FheUint2 **result);

int fhe_uint2_shr_assign(struct FheUint2 *lhs, const struct FheUint2 *rhs);

int fhe_uint2_sub(const struct FheUint2 *lhs, const struct FheUint2 *rhs, struct FheUint2 **result);

int fhe_uint2_sub_assign(struct FheUint2 *lhs, const struct FheUint2 *rhs);

int fhe_uint2_sum(const struct FheUint2 *const *lhs, size_t len, struct FheUint2 **out_result);

/**
 * Returns the number of trailing ones in the binary representation of input.
 */
int fhe_uint2_trailing_ones(const struct FheUint2 *input, struct FheUint32 **result);

/**
 * Returns the number of trailing zeros in the binary representation of input.
 */
int fhe_uint2_trailing_zeros(const struct FheUint2 *input, struct FheUint32 **result);

int fhe_uint2_try_decrypt_trivial(const struct FheUint2 *encrypted_value, uint8_t *result);

int fhe_uint2_try_encrypt_trivial_u8(uint8_t value, struct FheUint2 **result);

int fhe_uint2_try_encrypt_with_client_key_u8(uint8_t value,
                                             const struct ClientKey *client_key,
                                             struct FheUint2 **result);

int fhe_uint2_try_encrypt_with_compact_public_key_u8(uint8_t value,
                                                     const struct CompactPublicKey *public_key,
                                                     struct FheUint2 **result);

int fhe_uint2_try_encrypt_with_public_key_u8(uint8_t value,
                                             const struct PublicKey *public_key,
                                             struct FheUint2 **result);

int fhe_uint32_add(const struct FheUint32 *lhs,
                   const struct FheUint32 *rhs,
                   struct FheUint32 **result);

int fhe_uint32_add_assign(struct FheUint32 *lhs, const struct FheUint32 *rhs);

int fhe_uint32_bitand(const struct FheUint32 *lhs,
                      const struct FheUint32 *rhs,
                      struct FheUint32 **result);

int fhe_uint32_bitand_assign(struct FheUint32 *lhs, const struct FheUint32 *rhs);

int fhe_uint32_bitor(const struct FheUint32 *lhs,
                     const struct FheUint32 *rhs,
                     struct FheUint32 **result);

int fhe_uint32_bitor_assign(struct FheUint32 *lhs, const struct FheUint32 *rhs);

int fhe_uint32_bitxor(const struct FheUint32 *lhs,
                      const struct FheUint32 *rhs,
                      struct FheUint32 **result);

int fhe_uint32_bitxor_assign(struct FheUint32 *lhs, const struct FheUint32 *rhs);

int fhe_uint32_cast_into_fhe_int10(const struct FheUint32 *sself, struct FheInt10 **result);

int fhe_uint32_cast_into_fhe_int12(const struct FheUint32 *sself, struct FheInt12 **result);

int fhe_uint32_cast_into_fhe_int128(const struct FheUint32 *sself, struct FheInt128 **result);

int fhe_uint32_cast_into_fhe_int14(const struct FheUint32 *sself, struct FheInt14 **result);

int fhe_uint32_cast_into_fhe_int16(const struct FheUint32 *sself, struct FheInt16 **result);

int fhe_uint32_cast_into_fhe_int160(const struct FheUint32 *sself, struct FheInt160 **result);

int fhe_uint32_cast_into_fhe_int2(const struct FheUint32 *sself, struct FheInt2 **result);

int fhe_uint32_cast_into_fhe_int256(const struct FheUint32 *sself, struct FheInt256 **result);

int fhe_uint32_cast_into_fhe_int32(const struct FheUint32 *sself, struct FheInt32 **result);

int fhe_uint32_cast_into_fhe_int4(const struct FheUint32 *sself, struct FheInt4 **result);

int fhe_uint32_cast_into_fhe_int6(const struct FheUint32 *sself, struct FheInt6 **result);

int fhe_uint32_cast_into_fhe_int64(const struct FheUint32 *sself, struct FheInt64 **result);

int fhe_uint32_cast_into_fhe_int8(const struct FheUint32 *sself, struct FheInt8 **result);

int fhe_uint32_cast_into_fhe_uint10(const struct FheUint32 *sself, struct FheUint10 **result);

int fhe_uint32_cast_into_fhe_uint128(const struct FheUint32 *sself, struct FheUint128 **result);

int fhe_uint32_cast_into_fhe_uint14(const struct FheUint32 *sself, struct FheUint14 **result);

int fhe_uint32_cast_into_fhe_uint16(const struct FheUint32 *sself, struct FheUint16 **result);

int fhe_uint32_cast_into_fhe_uint160(const struct FheUint32 *sself, struct FheUint160 **result);

int fhe_uint32_cast_into_fhe_uint2(const struct FheUint32 *sself, struct FheUint2 **result);

int fhe_uint32_cast_into_fhe_uint256(const struct FheUint32 *sself, struct FheUint256 **result);

int fhe_uint32_cast_into_fhe_uint32(const struct FheUint32 *sself, struct FheUint32 **result);

int fhe_uint32_cast_into_fhe_uint4(const struct FheUint32 *sself, struct FheUint4 **result);

int fhe_uint32_cast_into_fhe_uint6(const struct FheUint32 *sself, struct FheUint6 **result);

int fhe_uint32_cast_into_fhe_uint64(const struct FheUint32 *sself, struct FheUint64 **result);

int fhe_uint32_cast_into_fhe_uint8(const struct FheUint32 *sself, struct FheUint8 **result);

/**
 * Returns the base 2 logarithm of the number, rounded down.
 *
 * Also returns a boolean flag that is true if the result is valid (i.e input was > 0)
 */
int fhe_uint32_checked_ilog2(const struct FheUint32 *input,
                             struct FheUint32 **result_1,
                             struct FheBool **result_2);

int fhe_uint32_clone(const struct FheUint32 *sself, struct FheUint32 **result);

int fhe_uint32_compress(const struct FheUint32 *sself, struct CompressedFheUint32 **result);

int fhe_uint32_decrypt(const struct FheUint32 *encrypted_value,
                       const struct ClientKey *client_key,
                       uint32_t *result);

int fhe_uint32_deserialize(DynamicBufferView buffer_view, struct FheUint32 **result);

/**
 *ptr can be null (no-op in that case)
 */
int fhe_uint32_destroy(struct FheUint32 *ptr);

int fhe_uint32_div(const struct FheUint32 *lhs,
                   const struct FheUint32 *rhs,
                   struct FheUint32 **result);

int fhe_uint32_div_assign(struct FheUint32 *lhs, const struct FheUint32 *rhs);

int fhe_uint32_div_rem(const struct FheUint32 *lhs,
                       const struct FheUint32 *rhs,
                       struct FheUint32 **q_result,
                       struct FheUint32 **r_result);

int fhe_uint32_eq(const struct FheUint32 *lhs,
                  const struct FheUint32 *rhs,
                  struct FheBool **result);

int fhe_uint32_ge(const struct FheUint32 *lhs,
                  const struct FheUint32 *rhs,
                  struct FheBool **result);

int fhe_uint32_gt(const struct FheUint32 *lhs,
                  const struct FheUint32 *rhs,
                  struct FheBool **result);

int fhe_uint32_if_then_else(const struct FheBool *condition_ct,
                            const struct FheUint32 *then_ct,
                            const struct FheUint32 *else_ct,
                            struct FheUint32 **result);

/**
 * Returns the base 2 logarithm of the number, rounded down.
 *
 * Result has no meaning if self encrypts a value that is <= 0.
 * See `checked_ilog2`
 */
int fhe_uint32_ilog2(const struct FheUint32 *input, struct FheUint32 **result);

int fhe_uint32_le(const struct FheUint32 *lhs,
                  const struct FheUint32 *rhs,
                  struct FheBool **result);

/**
 * Returns the number of leading ones in the binary representation of input.
 */
int fhe_uint32_leading_ones(const struct FheUint32 *input, struct FheUint32 **result);

/**
 * Returns the number of leading zeros in the binary representation of input.
 */
int fhe_uint32_leading_zeros(const struct FheUint32 *input, struct FheUint32 **result);

int fhe_uint32_lt(const struct FheUint32 *lhs,
                  const struct FheUint32 *rhs,
                  struct FheBool **result);

int fhe_uint32_max(const struct FheUint32 *lhs,
                   const struct FheUint32 *rhs,
                   struct FheUint32 **result);

int fhe_uint32_min(const struct FheUint32 *lhs,
                   const struct FheUint32 *rhs,
                   struct FheUint32 **result);

int fhe_uint32_mul(const struct FheUint32 *lhs,
                   const struct FheUint32 *rhs,
                   struct FheUint32 **result);

int fhe_uint32_mul_assign(struct FheUint32 *lhs, const struct FheUint32 *rhs);

int fhe_uint32_ne(const struct FheUint32 *lhs,
                  const struct FheUint32 *rhs,
                  struct FheBool **result);

int fhe_uint32_neg(const struct FheUint32 *input, struct FheUint32 **result);

int fhe_uint32_not(const struct FheUint32 *input, struct FheUint32 **result);

int fhe_uint32_overflowing_add(const struct FheUint32 *lhs,
                               const struct FheUint32 *rhs,
                               struct FheUint32 **out_result,
                               struct FheBool **out_overflowed);

int fhe_uint32_overflowing_mul(const struct FheUint32 *lhs,
                               const struct FheUint32 *rhs,
                               struct FheUint32 **out_result,
                               struct FheBool **out_overflowed);

int fhe_uint32_overflowing_sub(const struct FheUint32 *lhs,
                               const struct FheUint32 *rhs,
                               struct FheUint32 **out_result,
                               struct FheBool **out_overflowed);

int fhe_uint32_rem(const struct FheUint32 *lhs,
                   const struct FheUint32 *rhs,
                   struct FheUint32 **result);

int fhe_uint32_rem_assign(struct FheUint32 *lhs, const struct FheUint32 *rhs);

int fhe_uint32_rotate_left(const struct FheUint32 *lhs,
                           const struct FheUint32 *rhs,
                           struct FheUint32 **result);

int fhe_uint32_rotate_left_assign(struct FheUint32 *lhs, const struct FheUint32 *rhs);

int fhe_uint32_rotate_right(const struct FheUint32 *lhs,
                            const struct FheUint32 *rhs,
                            struct FheUint32 **result);

int fhe_uint32_rotate_right_assign(struct FheUint32 *lhs, const struct FheUint32 *rhs);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int fhe_uint32_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                           uint64_t serialized_size_limit,
                                           const struct ServerKey *server_key,
                                           struct FheUint32 **result);

int fhe_uint32_safe_serialize(const struct FheUint32 *sself,
                              DynamicBuffer *result,
                              uint64_t serialized_size_limit);

int fhe_uint32_scalar_add(const struct FheUint32 *lhs, uint32_t rhs, struct FheUint32 **result);

int fhe_uint32_scalar_add_assign(struct FheUint32 *lhs, uint32_t rhs);

int fhe_uint32_scalar_bitand(const struct FheUint32 *lhs, uint32_t rhs, struct FheUint32 **result);

int fhe_uint32_scalar_bitand_assign(struct FheUint32 *lhs, uint32_t rhs);

int fhe_uint32_scalar_bitor(const struct FheUint32 *lhs, uint32_t rhs, struct FheUint32 **result);

int fhe_uint32_scalar_bitor_assign(struct FheUint32 *lhs, uint32_t rhs);

int fhe_uint32_scalar_bitxor(const struct FheUint32 *lhs, uint32_t rhs, struct FheUint32 **result);

int fhe_uint32_scalar_bitxor_assign(struct FheUint32 *lhs, uint32_t rhs);

int fhe_uint32_scalar_div(const struct FheUint32 *lhs, uint32_t rhs, struct FheUint32 **result);

int fhe_uint32_scalar_div_assign(struct FheUint32 *lhs, uint32_t rhs);

int fhe_uint32_scalar_div_rem(const struct FheUint32 *lhs,
                              uint32_t rhs,
                              struct FheUint32 **q_result,
                              struct FheUint32 **r_result);

int fhe_uint32_scalar_eq(const struct FheUint32 *lhs, uint32_t rhs, struct FheBool **result);

int fhe_uint32_scalar_ge(const struct FheUint32 *lhs, uint32_t rhs, struct FheBool **result);

int fhe_uint32_scalar_gt(const struct FheUint32 *lhs, uint32_t rhs, struct FheBool **result);

int fhe_uint32_scalar_le(const struct FheUint32 *lhs, uint32_t rhs, struct FheBool **result);

int fhe_uint32_scalar_lt(const struct FheUint32 *lhs, uint32_t rhs, struct FheBool **result);

int fhe_uint32_scalar_max(const struct FheUint32 *lhs, uint32_t rhs, struct FheUint32 **result);

int fhe_uint32_scalar_min(const struct FheUint32 *lhs, uint32_t rhs, struct FheUint32 **result);

int fhe_uint32_scalar_mul(const struct FheUint32 *lhs, uint32_t rhs, struct FheUint32 **result);

int fhe_uint32_scalar_mul_assign(struct FheUint32 *lhs, uint32_t rhs);

int fhe_uint32_scalar_ne(const struct FheUint32 *lhs, uint32_t rhs, struct FheBool **result);

int fhe_uint32_scalar_rem(const struct FheUint32 *lhs, uint32_t rhs, struct FheUint32 **result);

int fhe_uint32_scalar_rem_assign(struct FheUint32 *lhs, uint32_t rhs);

int fhe_uint32_scalar_rotate_left(const struct FheUint32 *lhs,
                                  uint32_t rhs,
                                  struct FheUint32 **result);

int fhe_uint32_scalar_rotate_left_assign(struct FheUint32 *lhs, uint32_t rhs);

int fhe_uint32_scalar_rotate_right(const struct FheUint32 *lhs,
                                   uint32_t rhs,
                                   struct FheUint32 **result);

int fhe_uint32_scalar_rotate_right_assign(struct FheUint32 *lhs, uint32_t rhs);

int fhe_uint32_scalar_shl(const struct FheUint32 *lhs, uint32_t rhs, struct FheUint32 **result);

int fhe_uint32_scalar_shl_assign(struct FheUint32 *lhs, uint32_t rhs);

int fhe_uint32_scalar_shr(const struct FheUint32 *lhs, uint32_t rhs, struct FheUint32 **result);

int fhe_uint32_scalar_shr_assign(struct FheUint32 *lhs, uint32_t rhs);

int fhe_uint32_scalar_sub(const struct FheUint32 *lhs, uint32_t rhs, struct FheUint32 **result);

int fhe_uint32_scalar_sub_assign(struct FheUint32 *lhs, uint32_t rhs);

int fhe_uint32_serialize(const struct FheUint32 *sself, DynamicBuffer *result);

int fhe_uint32_shl(const struct FheUint32 *lhs,
                   const struct FheUint32 *rhs,
                   struct FheUint32 **result);

int fhe_uint32_shl_assign(struct FheUint32 *lhs, const struct FheUint32 *rhs);

int fhe_uint32_shr(const struct FheUint32 *lhs,
                   const struct FheUint32 *rhs,
                   struct FheUint32 **result);

int fhe_uint32_shr_assign(struct FheUint32 *lhs, const struct FheUint32 *rhs);

int fhe_uint32_sub(const struct FheUint32 *lhs,
                   const struct FheUint32 *rhs,
                   struct FheUint32 **result);

int fhe_uint32_sub_assign(struct FheUint32 *lhs, const struct FheUint32 *rhs);

int fhe_uint32_sum(const struct FheUint32 *const *lhs, size_t len, struct FheUint32 **out_result);

/**
 * Returns the number of trailing ones in the binary representation of input.
 */
int fhe_uint32_trailing_ones(const struct FheUint32 *input, struct FheUint32 **result);

/**
 * Returns the number of trailing zeros in the binary representation of input.
 */
int fhe_uint32_trailing_zeros(const struct FheUint32 *input, struct FheUint32 **result);

int fhe_uint32_try_decrypt_trivial(const struct FheUint32 *encrypted_value, uint32_t *result);

int fhe_uint32_try_encrypt_trivial_u32(uint32_t value, struct FheUint32 **result);

int fhe_uint32_try_encrypt_with_client_key_u32(uint32_t value,
                                               const struct ClientKey *client_key,
                                               struct FheUint32 **result);

int fhe_uint32_try_encrypt_with_compact_public_key_u32(uint32_t value,
                                                       const struct CompactPublicKey *public_key,
                                                       struct FheUint32 **result);

int fhe_uint32_try_encrypt_with_public_key_u32(uint32_t value,
                                               const struct PublicKey *public_key,
                                               struct FheUint32 **result);

int fhe_uint4_add(const struct FheUint4 *lhs, const struct FheUint4 *rhs, struct FheUint4 **result);

int fhe_uint4_add_assign(struct FheUint4 *lhs, const struct FheUint4 *rhs);

int fhe_uint4_bitand(const struct FheUint4 *lhs,
                     const struct FheUint4 *rhs,
                     struct FheUint4 **result);

int fhe_uint4_bitand_assign(struct FheUint4 *lhs, const struct FheUint4 *rhs);

int fhe_uint4_bitor(const struct FheUint4 *lhs,
                    const struct FheUint4 *rhs,
                    struct FheUint4 **result);

int fhe_uint4_bitor_assign(struct FheUint4 *lhs, const struct FheUint4 *rhs);

int fhe_uint4_bitxor(const struct FheUint4 *lhs,
                     const struct FheUint4 *rhs,
                     struct FheUint4 **result);

int fhe_uint4_bitxor_assign(struct FheUint4 *lhs, const struct FheUint4 *rhs);

int fhe_uint4_cast_into_fhe_int10(const struct FheUint4 *sself, struct FheInt10 **result);

int fhe_uint4_cast_into_fhe_int12(const struct FheUint4 *sself, struct FheInt12 **result);

int fhe_uint4_cast_into_fhe_int128(const struct FheUint4 *sself, struct FheInt128 **result);

int fhe_uint4_cast_into_fhe_int14(const struct FheUint4 *sself, struct FheInt14 **result);

int fhe_uint4_cast_into_fhe_int16(const struct FheUint4 *sself, struct FheInt16 **result);

int fhe_uint4_cast_into_fhe_int160(const struct FheUint4 *sself, struct FheInt160 **result);

int fhe_uint4_cast_into_fhe_int2(const struct FheUint4 *sself, struct FheInt2 **result);

int fhe_uint4_cast_into_fhe_int256(const struct FheUint4 *sself, struct FheInt256 **result);

int fhe_uint4_cast_into_fhe_int32(const struct FheUint4 *sself, struct FheInt32 **result);

int fhe_uint4_cast_into_fhe_int4(const struct FheUint4 *sself, struct FheInt4 **result);

int fhe_uint4_cast_into_fhe_int6(const struct FheUint4 *sself, struct FheInt6 **result);

int fhe_uint4_cast_into_fhe_int64(const struct FheUint4 *sself, struct FheInt64 **result);

int fhe_uint4_cast_into_fhe_int8(const struct FheUint4 *sself, struct FheInt8 **result);

int fhe_uint4_cast_into_fhe_uint10(const struct FheUint4 *sself, struct FheUint10 **result);

int fhe_uint4_cast_into_fhe_uint128(const struct FheUint4 *sself, struct FheUint128 **result);

int fhe_uint4_cast_into_fhe_uint14(const struct FheUint4 *sself, struct FheUint14 **result);

int fhe_uint4_cast_into_fhe_uint16(const struct FheUint4 *sself, struct FheUint16 **result);

int fhe_uint4_cast_into_fhe_uint160(const struct FheUint4 *sself, struct FheUint160 **result);

int fhe_uint4_cast_into_fhe_uint2(const struct FheUint4 *sself, struct FheUint2 **result);

int fhe_uint4_cast_into_fhe_uint256(const struct FheUint4 *sself, struct FheUint256 **result);

int fhe_uint4_cast_into_fhe_uint32(const struct FheUint4 *sself, struct FheUint32 **result);

int fhe_uint4_cast_into_fhe_uint4(const struct FheUint4 *sself, struct FheUint4 **result);

int fhe_uint4_cast_into_fhe_uint6(const struct FheUint4 *sself, struct FheUint6 **result);

int fhe_uint4_cast_into_fhe_uint64(const struct FheUint4 *sself, struct FheUint64 **result);

int fhe_uint4_cast_into_fhe_uint8(const struct FheUint4 *sself, struct FheUint8 **result);

/**
 * Returns the base 2 logarithm of the number, rounded down.
 *
 * Also returns a boolean flag that is true if the result is valid (i.e input was > 0)
 */
int fhe_uint4_checked_ilog2(const struct FheUint4 *input,
                            struct FheUint32 **result_1,
                            struct FheBool **result_2);

int fhe_uint4_clone(const struct FheUint4 *sself, struct FheUint4 **result);

int fhe_uint4_compress(const struct FheUint4 *sself, struct CompressedFheUint4 **result);

int fhe_uint4_decrypt(const struct FheUint4 *encrypted_value,
                      const struct ClientKey *client_key,
                      uint8_t *result);

int fhe_uint4_deserialize(DynamicBufferView buffer_view, struct FheUint4 **result);

/**
 *ptr can be null (no-op in that case)
 */
int fhe_uint4_destroy(struct FheUint4 *ptr);

int fhe_uint4_div(const struct FheUint4 *lhs, const struct FheUint4 *rhs, struct FheUint4 **result);

int fhe_uint4_div_assign(struct FheUint4 *lhs, const struct FheUint4 *rhs);

int fhe_uint4_div_rem(const struct FheUint4 *lhs,
                      const struct FheUint4 *rhs,
                      struct FheUint4 **q_result,
                      struct FheUint4 **r_result);

int fhe_uint4_eq(const struct FheUint4 *lhs, const struct FheUint4 *rhs, struct FheBool **result);

int fhe_uint4_ge(const struct FheUint4 *lhs, const struct FheUint4 *rhs, struct FheBool **result);

int fhe_uint4_gt(const struct FheUint4 *lhs, const struct FheUint4 *rhs, struct FheBool **result);

int fhe_uint4_if_then_else(const struct FheBool *condition_ct,
                           const struct FheUint4 *then_ct,
                           const struct FheUint4 *else_ct,
                           struct FheUint4 **result);

/**
 * Returns the base 2 logarithm of the number, rounded down.
 *
 * Result has no meaning if self encrypts a value that is <= 0.
 * See `checked_ilog2`
 */
int fhe_uint4_ilog2(const struct FheUint4 *input, struct FheUint32 **result);

int fhe_uint4_le(const struct FheUint4 *lhs, const struct FheUint4 *rhs, struct FheBool **result);

/**
 * Returns the number of leading ones in the binary representation of input.
 */
int fhe_uint4_leading_ones(const struct FheUint4 *input, struct FheUint32 **result);

/**
 * Returns the number of leading zeros in the binary representation of input.
 */
int fhe_uint4_leading_zeros(const struct FheUint4 *input, struct FheUint32 **result);

int fhe_uint4_lt(const struct FheUint4 *lhs, const struct FheUint4 *rhs, struct FheBool **result);

int fhe_uint4_max(const struct FheUint4 *lhs, const struct FheUint4 *rhs, struct FheUint4 **result);

int fhe_uint4_min(const struct FheUint4 *lhs, const struct FheUint4 *rhs, struct FheUint4 **result);

int fhe_uint4_mul(const struct FheUint4 *lhs, const struct FheUint4 *rhs, struct FheUint4 **result);

int fhe_uint4_mul_assign(struct FheUint4 *lhs, const struct FheUint4 *rhs);

int fhe_uint4_ne(const struct FheUint4 *lhs, const struct FheUint4 *rhs, struct FheBool **result);

int fhe_uint4_neg(const struct FheUint4 *input, struct FheUint4 **result);

int fhe_uint4_not(const struct FheUint4 *input, struct FheUint4 **result);

int fhe_uint4_overflowing_add(const struct FheUint4 *lhs,
                              const struct FheUint4 *rhs,
                              struct FheUint4 **out_result,
                              struct FheBool **out_overflowed);

int fhe_uint4_overflowing_mul(const struct FheUint4 *lhs,
                              const struct FheUint4 *rhs,
                              struct FheUint4 **out_result,
                              struct FheBool **out_overflowed);

int fhe_uint4_overflowing_sub(const struct FheUint4 *lhs,
                              const struct FheUint4 *rhs,
                              struct FheUint4 **out_result,
                              struct FheBool **out_overflowed);

int fhe_uint4_rem(const struct FheUint4 *lhs, const struct FheUint4 *rhs, struct FheUint4 **result);

int fhe_uint4_rem_assign(struct FheUint4 *lhs, const struct FheUint4 *rhs);

int fhe_uint4_rotate_left(const struct FheUint4 *lhs,
                          const struct FheUint4 *rhs,
                          struct FheUint4 **result);

int fhe_uint4_rotate_left_assign(struct FheUint4 *lhs, const struct FheUint4 *rhs);

int fhe_uint4_rotate_right(const struct FheUint4 *lhs,
                           const struct FheUint4 *rhs,
                           struct FheUint4 **result);

int fhe_uint4_rotate_right_assign(struct FheUint4 *lhs, const struct FheUint4 *rhs);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int fhe_uint4_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                          uint64_t serialized_size_limit,
                                          const struct ServerKey *server_key,
                                          struct FheUint4 **result);

int fhe_uint4_safe_serialize(const struct FheUint4 *sself,
                             DynamicBuffer *result,
                             uint64_t serialized_size_limit);

int fhe_uint4_scalar_add(const struct FheUint4 *lhs, uint8_t rhs, struct FheUint4 **result);

int fhe_uint4_scalar_add_assign(struct FheUint4 *lhs, uint8_t rhs);

int fhe_uint4_scalar_bitand(const struct FheUint4 *lhs, uint8_t rhs, struct FheUint4 **result);

int fhe_uint4_scalar_bitand_assign(struct FheUint4 *lhs, uint8_t rhs);

int fhe_uint4_scalar_bitor(const struct FheUint4 *lhs, uint8_t rhs, struct FheUint4 **result);

int fhe_uint4_scalar_bitor_assign(struct FheUint4 *lhs, uint8_t rhs);

int fhe_uint4_scalar_bitxor(const struct FheUint4 *lhs, uint8_t rhs, struct FheUint4 **result);

int fhe_uint4_scalar_bitxor_assign(struct FheUint4 *lhs, uint8_t rhs);

int fhe_uint4_scalar_div(const struct FheUint4 *lhs, uint8_t rhs, struct FheUint4 **result);

int fhe_uint4_scalar_div_assign(struct FheUint4 *lhs, uint8_t rhs);

int fhe_uint4_scalar_div_rem(const struct FheUint4 *lhs,
                             uint8_t rhs,
                             struct FheUint4 **q_result,
                             struct FheUint4 **r_result);

int fhe_uint4_scalar_eq(const struct FheUint4 *lhs, uint8_t rhs, struct FheBool **result);

int fhe_uint4_scalar_ge(const struct FheUint4 *lhs, uint8_t rhs, struct FheBool **result);

int fhe_uint4_scalar_gt(const struct FheUint4 *lhs, uint8_t rhs, struct FheBool **result);

int fhe_uint4_scalar_le(const struct FheUint4 *lhs, uint8_t rhs, struct FheBool **result);

int fhe_uint4_scalar_lt(const struct FheUint4 *lhs, uint8_t rhs, struct FheBool **result);

int fhe_uint4_scalar_max(const struct FheUint4 *lhs, uint8_t rhs, struct FheUint4 **result);

int fhe_uint4_scalar_min(const struct FheUint4 *lhs, uint8_t rhs, struct FheUint4 **result);

int fhe_uint4_scalar_mul(const struct FheUint4 *lhs, uint8_t rhs, struct FheUint4 **result);

int fhe_uint4_scalar_mul_assign(struct FheUint4 *lhs, uint8_t rhs);

int fhe_uint4_scalar_ne(const struct FheUint4 *lhs, uint8_t rhs, struct FheBool **result);

int fhe_uint4_scalar_rem(const struct FheUint4 *lhs, uint8_t rhs, struct FheUint4 **result);

int fhe_uint4_scalar_rem_assign(struct FheUint4 *lhs, uint8_t rhs);

int fhe_uint4_scalar_rotate_left(const struct FheUint4 *lhs, uint8_t rhs, struct FheUint4 **result);

int fhe_uint4_scalar_rotate_left_assign(struct FheUint4 *lhs, uint8_t rhs);

int fhe_uint4_scalar_rotate_right(const struct FheUint4 *lhs,
                                  uint8_t rhs,
                                  struct FheUint4 **result);

int fhe_uint4_scalar_rotate_right_assign(struct FheUint4 *lhs, uint8_t rhs);

int fhe_uint4_scalar_shl(const struct FheUint4 *lhs, uint8_t rhs, struct FheUint4 **result);

int fhe_uint4_scalar_shl_assign(struct FheUint4 *lhs, uint8_t rhs);

int fhe_uint4_scalar_shr(const struct FheUint4 *lhs, uint8_t rhs, struct FheUint4 **result);

int fhe_uint4_scalar_shr_assign(struct FheUint4 *lhs, uint8_t rhs);

int fhe_uint4_scalar_sub(const struct FheUint4 *lhs, uint8_t rhs, struct FheUint4 **result);

int fhe_uint4_scalar_sub_assign(struct FheUint4 *lhs, uint8_t rhs);

int fhe_uint4_serialize(const struct FheUint4 *sself, DynamicBuffer *result);

int fhe_uint4_shl(const struct FheUint4 *lhs, const struct FheUint4 *rhs, struct FheUint4 **result);

int fhe_uint4_shl_assign(struct FheUint4 *lhs, const struct FheUint4 *rhs);

int fhe_uint4_shr(const struct FheUint4 *lhs, const struct FheUint4 *rhs, struct FheUint4 **result);

int fhe_uint4_shr_assign(struct FheUint4 *lhs, const struct FheUint4 *rhs);

int fhe_uint4_sub(const struct FheUint4 *lhs, const struct FheUint4 *rhs, struct FheUint4 **result);

int fhe_uint4_sub_assign(struct FheUint4 *lhs, const struct FheUint4 *rhs);

int fhe_uint4_sum(const struct FheUint4 *const *lhs, size_t len, struct FheUint4 **out_result);

/**
 * Returns the number of trailing ones in the binary representation of input.
 */
int fhe_uint4_trailing_ones(const struct FheUint4 *input, struct FheUint32 **result);

/**
 * Returns the number of trailing zeros in the binary representation of input.
 */
int fhe_uint4_trailing_zeros(const struct FheUint4 *input, struct FheUint32 **result);

int fhe_uint4_try_decrypt_trivial(const struct FheUint4 *encrypted_value, uint8_t *result);

int fhe_uint4_try_encrypt_trivial_u8(uint8_t value, struct FheUint4 **result);

int fhe_uint4_try_encrypt_with_client_key_u8(uint8_t value,
                                             const struct ClientKey *client_key,
                                             struct FheUint4 **result);

int fhe_uint4_try_encrypt_with_compact_public_key_u8(uint8_t value,
                                                     const struct CompactPublicKey *public_key,
                                                     struct FheUint4 **result);

int fhe_uint4_try_encrypt_with_public_key_u8(uint8_t value,
                                             const struct PublicKey *public_key,
                                             struct FheUint4 **result);

int fhe_uint64_add(const struct FheUint64 *lhs,
                   const struct FheUint64 *rhs,
                   struct FheUint64 **result);

int fhe_uint64_add_assign(struct FheUint64 *lhs, const struct FheUint64 *rhs);

int fhe_uint64_bitand(const struct FheUint64 *lhs,
                      const struct FheUint64 *rhs,
                      struct FheUint64 **result);

int fhe_uint64_bitand_assign(struct FheUint64 *lhs, const struct FheUint64 *rhs);

int fhe_uint64_bitor(const struct FheUint64 *lhs,
                     const struct FheUint64 *rhs,
                     struct FheUint64 **result);

int fhe_uint64_bitor_assign(struct FheUint64 *lhs, const struct FheUint64 *rhs);

int fhe_uint64_bitxor(const struct FheUint64 *lhs,
                      const struct FheUint64 *rhs,
                      struct FheUint64 **result);

int fhe_uint64_bitxor_assign(struct FheUint64 *lhs, const struct FheUint64 *rhs);

int fhe_uint64_cast_into_fhe_int10(const struct FheUint64 *sself, struct FheInt10 **result);

int fhe_uint64_cast_into_fhe_int12(const struct FheUint64 *sself, struct FheInt12 **result);

int fhe_uint64_cast_into_fhe_int128(const struct FheUint64 *sself, struct FheInt128 **result);

int fhe_uint64_cast_into_fhe_int14(const struct FheUint64 *sself, struct FheInt14 **result);

int fhe_uint64_cast_into_fhe_int16(const struct FheUint64 *sself, struct FheInt16 **result);

int fhe_uint64_cast_into_fhe_int160(const struct FheUint64 *sself, struct FheInt160 **result);

int fhe_uint64_cast_into_fhe_int2(const struct FheUint64 *sself, struct FheInt2 **result);

int fhe_uint64_cast_into_fhe_int256(const struct FheUint64 *sself, struct FheInt256 **result);

int fhe_uint64_cast_into_fhe_int32(const struct FheUint64 *sself, struct FheInt32 **result);

int fhe_uint64_cast_into_fhe_int4(const struct FheUint64 *sself, struct FheInt4 **result);

int fhe_uint64_cast_into_fhe_int6(const struct FheUint64 *sself, struct FheInt6 **result);

int fhe_uint64_cast_into_fhe_int64(const struct FheUint64 *sself, struct FheInt64 **result);

int fhe_uint64_cast_into_fhe_int8(const struct FheUint64 *sself, struct FheInt8 **result);

int fhe_uint64_cast_into_fhe_uint10(const struct FheUint64 *sself, struct FheUint10 **result);

int fhe_uint64_cast_into_fhe_uint128(const struct FheUint64 *sself, struct FheUint128 **result);

int fhe_uint64_cast_into_fhe_uint14(const struct FheUint64 *sself, struct FheUint14 **result);

int fhe_uint64_cast_into_fhe_uint16(const struct FheUint64 *sself, struct FheUint16 **result);

int fhe_uint64_cast_into_fhe_uint160(const struct FheUint64 *sself, struct FheUint160 **result);

int fhe_uint64_cast_into_fhe_uint2(const struct FheUint64 *sself, struct FheUint2 **result);

int fhe_uint64_cast_into_fhe_uint256(const struct FheUint64 *sself, struct FheUint256 **result);

int fhe_uint64_cast_into_fhe_uint32(const struct FheUint64 *sself, struct FheUint32 **result);

int fhe_uint64_cast_into_fhe_uint4(const struct FheUint64 *sself, struct FheUint4 **result);

int fhe_uint64_cast_into_fhe_uint6(const struct FheUint64 *sself, struct FheUint6 **result);

int fhe_uint64_cast_into_fhe_uint64(const struct FheUint64 *sself, struct FheUint64 **result);

int fhe_uint64_cast_into_fhe_uint8(const struct FheUint64 *sself, struct FheUint8 **result);

/**
 * Returns the base 2 logarithm of the number, rounded down.
 *
 * Also returns a boolean flag that is true if the result is valid (i.e input was > 0)
 */
int fhe_uint64_checked_ilog2(const struct FheUint64 *input,
                             struct FheUint32 **result_1,
                             struct FheBool **result_2);

int fhe_uint64_clone(const struct FheUint64 *sself, struct FheUint64 **result);

int fhe_uint64_compress(const struct FheUint64 *sself, struct CompressedFheUint64 **result);

int fhe_uint64_decrypt(const struct FheUint64 *encrypted_value,
                       const struct ClientKey *client_key,
                       uint64_t *result);

int fhe_uint64_deserialize(DynamicBufferView buffer_view, struct FheUint64 **result);

/**
 *ptr can be null (no-op in that case)
 */
int fhe_uint64_destroy(struct FheUint64 *ptr);

int fhe_uint64_div(const struct FheUint64 *lhs,
                   const struct FheUint64 *rhs,
                   struct FheUint64 **result);

int fhe_uint64_div_assign(struct FheUint64 *lhs, const struct FheUint64 *rhs);

int fhe_uint64_div_rem(const struct FheUint64 *lhs,
                       const struct FheUint64 *rhs,
                       struct FheUint64 **q_result,
                       struct FheUint64 **r_result);

int fhe_uint64_eq(const struct FheUint64 *lhs,
                  const struct FheUint64 *rhs,
                  struct FheBool **result);

int fhe_uint64_ge(const struct FheUint64 *lhs,
                  const struct FheUint64 *rhs,
                  struct FheBool **result);

int fhe_uint64_gt(const struct FheUint64 *lhs,
                  const struct FheUint64 *rhs,
                  struct FheBool **result);

int fhe_uint64_if_then_else(const struct FheBool *condition_ct,
                            const struct FheUint64 *then_ct,
                            const struct FheUint64 *else_ct,
                            struct FheUint64 **result);

/**
 * Returns the base 2 logarithm of the number, rounded down.
 *
 * Result has no meaning if self encrypts a value that is <= 0.
 * See `checked_ilog2`
 */
int fhe_uint64_ilog2(const struct FheUint64 *input, struct FheUint32 **result);

int fhe_uint64_le(const struct FheUint64 *lhs,
                  const struct FheUint64 *rhs,
                  struct FheBool **result);

/**
 * Returns the number of leading ones in the binary representation of input.
 */
int fhe_uint64_leading_ones(const struct FheUint64 *input, struct FheUint32 **result);

/**
 * Returns the number of leading zeros in the binary representation of input.
 */
int fhe_uint64_leading_zeros(const struct FheUint64 *input, struct FheUint32 **result);

int fhe_uint64_lt(const struct FheUint64 *lhs,
                  const struct FheUint64 *rhs,
                  struct FheBool **result);

int fhe_uint64_max(const struct FheUint64 *lhs,
                   const struct FheUint64 *rhs,
                   struct FheUint64 **result);

int fhe_uint64_min(const struct FheUint64 *lhs,
                   const struct FheUint64 *rhs,
                   struct FheUint64 **result);

int fhe_uint64_mul(const struct FheUint64 *lhs,
                   const struct FheUint64 *rhs,
                   struct FheUint64 **result);

int fhe_uint64_mul_assign(struct FheUint64 *lhs, const struct FheUint64 *rhs);

int fhe_uint64_ne(const struct FheUint64 *lhs,
                  const struct FheUint64 *rhs,
                  struct FheBool **result);

int fhe_uint64_neg(const struct FheUint64 *input, struct FheUint64 **result);

int fhe_uint64_not(const struct FheUint64 *input, struct FheUint64 **result);

int fhe_uint64_overflowing_add(const struct FheUint64 *lhs,
                               const struct FheUint64 *rhs,
                               struct FheUint64 **out_result,
                               struct FheBool **out_overflowed);

int fhe_uint64_overflowing_mul(const struct FheUint64 *lhs,
                               const struct FheUint64 *rhs,
                               struct FheUint64 **out_result,
                               struct FheBool **out_overflowed);

int fhe_uint64_overflowing_sub(const struct FheUint64 *lhs,
                               const struct FheUint64 *rhs,
                               struct FheUint64 **out_result,
                               struct FheBool **out_overflowed);

int fhe_uint64_rem(const struct FheUint64 *lhs,
                   const struct FheUint64 *rhs,
                   struct FheUint64 **result);

int fhe_uint64_rem_assign(struct FheUint64 *lhs, const struct FheUint64 *rhs);

int fhe_uint64_rotate_left(const struct FheUint64 *lhs,
                           const struct FheUint64 *rhs,
                           struct FheUint64 **result);

int fhe_uint64_rotate_left_assign(struct FheUint64 *lhs, const struct FheUint64 *rhs);

int fhe_uint64_rotate_right(const struct FheUint64 *lhs,
                            const struct FheUint64 *rhs,
                            struct FheUint64 **result);

int fhe_uint64_rotate_right_assign(struct FheUint64 *lhs, const struct FheUint64 *rhs);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int fhe_uint64_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                           uint64_t serialized_size_limit,
                                           const struct ServerKey *server_key,
                                           struct FheUint64 **result);

int fhe_uint64_safe_serialize(const struct FheUint64 *sself,
                              DynamicBuffer *result,
                              uint64_t serialized_size_limit);

int fhe_uint64_scalar_add(const struct FheUint64 *lhs, uint64_t rhs, struct FheUint64 **result);

int fhe_uint64_scalar_add_assign(struct FheUint64 *lhs, uint64_t rhs);

int fhe_uint64_scalar_bitand(const struct FheUint64 *lhs, uint64_t rhs, struct FheUint64 **result);

int fhe_uint64_scalar_bitand_assign(struct FheUint64 *lhs, uint64_t rhs);

int fhe_uint64_scalar_bitor(const struct FheUint64 *lhs, uint64_t rhs, struct FheUint64 **result);

int fhe_uint64_scalar_bitor_assign(struct FheUint64 *lhs, uint64_t rhs);

int fhe_uint64_scalar_bitxor(const struct FheUint64 *lhs, uint64_t rhs, struct FheUint64 **result);

int fhe_uint64_scalar_bitxor_assign(struct FheUint64 *lhs, uint64_t rhs);

int fhe_uint64_scalar_div(const struct FheUint64 *lhs, uint64_t rhs, struct FheUint64 **result);

int fhe_uint64_scalar_div_assign(struct FheUint64 *lhs, uint64_t rhs);

int fhe_uint64_scalar_div_rem(const struct FheUint64 *lhs,
                              uint64_t rhs,
                              struct FheUint64 **q_result,
                              struct FheUint64 **r_result);

int fhe_uint64_scalar_eq(const struct FheUint64 *lhs, uint64_t rhs, struct FheBool **result);

int fhe_uint64_scalar_ge(const struct FheUint64 *lhs, uint64_t rhs, struct FheBool **result);

int fhe_uint64_scalar_gt(const struct FheUint64 *lhs, uint64_t rhs, struct FheBool **result);

int fhe_uint64_scalar_le(const struct FheUint64 *lhs, uint64_t rhs, struct FheBool **result);

int fhe_uint64_scalar_lt(const struct FheUint64 *lhs, uint64_t rhs, struct FheBool **result);

int fhe_uint64_scalar_max(const struct FheUint64 *lhs, uint64_t rhs, struct FheUint64 **result);

int fhe_uint64_scalar_min(const struct FheUint64 *lhs, uint64_t rhs, struct FheUint64 **result);

int fhe_uint64_scalar_mul(const struct FheUint64 *lhs, uint64_t rhs, struct FheUint64 **result);

int fhe_uint64_scalar_mul_assign(struct FheUint64 *lhs, uint64_t rhs);

int fhe_uint64_scalar_ne(const struct FheUint64 *lhs, uint64_t rhs, struct FheBool **result);

int fhe_uint64_scalar_rem(const struct FheUint64 *lhs, uint64_t rhs, struct FheUint64 **result);

int fhe_uint64_scalar_rem_assign(struct FheUint64 *lhs, uint64_t rhs);

int fhe_uint64_scalar_rotate_left(const struct FheUint64 *lhs,
                                  uint64_t rhs,
                                  struct FheUint64 **result);

int fhe_uint64_scalar_rotate_left_assign(struct FheUint64 *lhs, uint64_t rhs);

int fhe_uint64_scalar_rotate_right(const struct FheUint64 *lhs,
                                   uint64_t rhs,
                                   struct FheUint64 **result);

int fhe_uint64_scalar_rotate_right_assign(struct FheUint64 *lhs, uint64_t rhs);

int fhe_uint64_scalar_shl(const struct FheUint64 *lhs, uint64_t rhs, struct FheUint64 **result);

int fhe_uint64_scalar_shl_assign(struct FheUint64 *lhs, uint64_t rhs);

int fhe_uint64_scalar_shr(const struct FheUint64 *lhs, uint64_t rhs, struct FheUint64 **result);

int fhe_uint64_scalar_shr_assign(struct FheUint64 *lhs, uint64_t rhs);

int fhe_uint64_scalar_sub(const struct FheUint64 *lhs, uint64_t rhs, struct FheUint64 **result);

int fhe_uint64_scalar_sub_assign(struct FheUint64 *lhs, uint64_t rhs);

int fhe_uint64_serialize(const struct FheUint64 *sself, DynamicBuffer *result);

int fhe_uint64_shl(const struct FheUint64 *lhs,
                   const struct FheUint64 *rhs,
                   struct FheUint64 **result);

int fhe_uint64_shl_assign(struct FheUint64 *lhs, const struct FheUint64 *rhs);

int fhe_uint64_shr(const struct FheUint64 *lhs,
                   const struct FheUint64 *rhs,
                   struct FheUint64 **result);

int fhe_uint64_shr_assign(struct FheUint64 *lhs, const struct FheUint64 *rhs);

int fhe_uint64_sub(const struct FheUint64 *lhs,
                   const struct FheUint64 *rhs,
                   struct FheUint64 **result);

int fhe_uint64_sub_assign(struct FheUint64 *lhs, const struct FheUint64 *rhs);

int fhe_uint64_sum(const struct FheUint64 *const *lhs, size_t len, struct FheUint64 **out_result);

/**
 * Returns the number of trailing ones in the binary representation of input.
 */
int fhe_uint64_trailing_ones(const struct FheUint64 *input, struct FheUint32 **result);

/**
 * Returns the number of trailing zeros in the binary representation of input.
 */
int fhe_uint64_trailing_zeros(const struct FheUint64 *input, struct FheUint32 **result);

int fhe_uint64_try_decrypt_trivial(const struct FheUint64 *encrypted_value, uint64_t *result);

int fhe_uint64_try_encrypt_trivial_u64(uint64_t value, struct FheUint64 **result);

int fhe_uint64_try_encrypt_with_client_key_u64(uint64_t value,
                                               const struct ClientKey *client_key,
                                               struct FheUint64 **result);

int fhe_uint64_try_encrypt_with_compact_public_key_u64(uint64_t value,
                                                       const struct CompactPublicKey *public_key,
                                                       struct FheUint64 **result);

int fhe_uint64_try_encrypt_with_public_key_u64(uint64_t value,
                                               const struct PublicKey *public_key,
                                               struct FheUint64 **result);

int fhe_uint6_add(const struct FheUint6 *lhs, const struct FheUint6 *rhs, struct FheUint6 **result);

int fhe_uint6_add_assign(struct FheUint6 *lhs, const struct FheUint6 *rhs);

int fhe_uint6_bitand(const struct FheUint6 *lhs,
                     const struct FheUint6 *rhs,
                     struct FheUint6 **result);

int fhe_uint6_bitand_assign(struct FheUint6 *lhs, const struct FheUint6 *rhs);

int fhe_uint6_bitor(const struct FheUint6 *lhs,
                    const struct FheUint6 *rhs,
                    struct FheUint6 **result);

int fhe_uint6_bitor_assign(struct FheUint6 *lhs, const struct FheUint6 *rhs);

int fhe_uint6_bitxor(const struct FheUint6 *lhs,
                     const struct FheUint6 *rhs,
                     struct FheUint6 **result);

int fhe_uint6_bitxor_assign(struct FheUint6 *lhs, const struct FheUint6 *rhs);

int fhe_uint6_cast_into_fhe_int10(const struct FheUint6 *sself, struct FheInt10 **result);

int fhe_uint6_cast_into_fhe_int12(const struct FheUint6 *sself, struct FheInt12 **result);

int fhe_uint6_cast_into_fhe_int128(const struct FheUint6 *sself, struct FheInt128 **result);

int fhe_uint6_cast_into_fhe_int14(const struct FheUint6 *sself, struct FheInt14 **result);

int fhe_uint6_cast_into_fhe_int16(const struct FheUint6 *sself, struct FheInt16 **result);

int fhe_uint6_cast_into_fhe_int160(const struct FheUint6 *sself, struct FheInt160 **result);

int fhe_uint6_cast_into_fhe_int2(const struct FheUint6 *sself, struct FheInt2 **result);

int fhe_uint6_cast_into_fhe_int256(const struct FheUint6 *sself, struct FheInt256 **result);

int fhe_uint6_cast_into_fhe_int32(const struct FheUint6 *sself, struct FheInt32 **result);

int fhe_uint6_cast_into_fhe_int4(const struct FheUint6 *sself, struct FheInt4 **result);

int fhe_uint6_cast_into_fhe_int6(const struct FheUint6 *sself, struct FheInt6 **result);

int fhe_uint6_cast_into_fhe_int64(const struct FheUint6 *sself, struct FheInt64 **result);

int fhe_uint6_cast_into_fhe_int8(const struct FheUint6 *sself, struct FheInt8 **result);

int fhe_uint6_cast_into_fhe_uint10(const struct FheUint6 *sself, struct FheUint10 **result);

int fhe_uint6_cast_into_fhe_uint128(const struct FheUint6 *sself, struct FheUint128 **result);

int fhe_uint6_cast_into_fhe_uint14(const struct FheUint6 *sself, struct FheUint14 **result);

int fhe_uint6_cast_into_fhe_uint16(const struct FheUint6 *sself, struct FheUint16 **result);

int fhe_uint6_cast_into_fhe_uint160(const struct FheUint6 *sself, struct FheUint160 **result);

int fhe_uint6_cast_into_fhe_uint2(const struct FheUint6 *sself, struct FheUint2 **result);

int fhe_uint6_cast_into_fhe_uint256(const struct FheUint6 *sself, struct FheUint256 **result);

int fhe_uint6_cast_into_fhe_uint32(const struct FheUint6 *sself, struct FheUint32 **result);

int fhe_uint6_cast_into_fhe_uint4(const struct FheUint6 *sself, struct FheUint4 **result);

int fhe_uint6_cast_into_fhe_uint6(const struct FheUint6 *sself, struct FheUint6 **result);

int fhe_uint6_cast_into_fhe_uint64(const struct FheUint6 *sself, struct FheUint64 **result);

int fhe_uint6_cast_into_fhe_uint8(const struct FheUint6 *sself, struct FheUint8 **result);

/**
 * Returns the base 2 logarithm of the number, rounded down.
 *
 * Also returns a boolean flag that is true if the result is valid (i.e input was > 0)
 */
int fhe_uint6_checked_ilog2(const struct FheUint6 *input,
                            struct FheUint32 **result_1,
                            struct FheBool **result_2);

int fhe_uint6_clone(const struct FheUint6 *sself, struct FheUint6 **result);

int fhe_uint6_compress(const struct FheUint6 *sself, struct CompressedFheUint6 **result);

int fhe_uint6_decrypt(const struct FheUint6 *encrypted_value,
                      const struct ClientKey *client_key,
                      uint8_t *result);

int fhe_uint6_deserialize(DynamicBufferView buffer_view, struct FheUint6 **result);

/**
 *ptr can be null (no-op in that case)
 */
int fhe_uint6_destroy(struct FheUint6 *ptr);

int fhe_uint6_div(const struct FheUint6 *lhs, const struct FheUint6 *rhs, struct FheUint6 **result);

int fhe_uint6_div_assign(struct FheUint6 *lhs, const struct FheUint6 *rhs);

int fhe_uint6_div_rem(const struct FheUint6 *lhs,
                      const struct FheUint6 *rhs,
                      struct FheUint6 **q_result,
                      struct FheUint6 **r_result);

int fhe_uint6_eq(const struct FheUint6 *lhs, const struct FheUint6 *rhs, struct FheBool **result);

int fhe_uint6_ge(const struct FheUint6 *lhs, const struct FheUint6 *rhs, struct FheBool **result);

int fhe_uint6_gt(const struct FheUint6 *lhs, const struct FheUint6 *rhs, struct FheBool **result);

int fhe_uint6_if_then_else(const struct FheBool *condition_ct,
                           const struct FheUint6 *then_ct,
                           const struct FheUint6 *else_ct,
                           struct FheUint6 **result);

/**
 * Returns the base 2 logarithm of the number, rounded down.
 *
 * Result has no meaning if self encrypts a value that is <= 0.
 * See `checked_ilog2`
 */
int fhe_uint6_ilog2(const struct FheUint6 *input, struct FheUint32 **result);

int fhe_uint6_le(const struct FheUint6 *lhs, const struct FheUint6 *rhs, struct FheBool **result);

/**
 * Returns the number of leading ones in the binary representation of input.
 */
int fhe_uint6_leading_ones(const struct FheUint6 *input, struct FheUint32 **result);

/**
 * Returns the number of leading zeros in the binary representation of input.
 */
int fhe_uint6_leading_zeros(const struct FheUint6 *input, struct FheUint32 **result);

int fhe_uint6_lt(const struct FheUint6 *lhs, const struct FheUint6 *rhs, struct FheBool **result);

int fhe_uint6_max(const struct FheUint6 *lhs, const struct FheUint6 *rhs, struct FheUint6 **result);

int fhe_uint6_min(const struct FheUint6 *lhs, const struct FheUint6 *rhs, struct FheUint6 **result);

int fhe_uint6_mul(const struct FheUint6 *lhs, const struct FheUint6 *rhs, struct FheUint6 **result);

int fhe_uint6_mul_assign(struct FheUint6 *lhs, const struct FheUint6 *rhs);

int fhe_uint6_ne(const struct FheUint6 *lhs, const struct FheUint6 *rhs, struct FheBool **result);

int fhe_uint6_neg(const struct FheUint6 *input, struct FheUint6 **result);

int fhe_uint6_not(const struct FheUint6 *input, struct FheUint6 **result);

int fhe_uint6_overflowing_add(const struct FheUint6 *lhs,
                              const struct FheUint6 *rhs,
                              struct FheUint6 **out_result,
                              struct FheBool **out_overflowed);

int fhe_uint6_overflowing_mul(const struct FheUint6 *lhs,
                              const struct FheUint6 *rhs,
                              struct FheUint6 **out_result,
                              struct FheBool **out_overflowed);

int fhe_uint6_overflowing_sub(const struct FheUint6 *lhs,
                              const struct FheUint6 *rhs,
                              struct FheUint6 **out_result,
                              struct FheBool **out_overflowed);

int fhe_uint6_rem(const struct FheUint6 *lhs, const struct FheUint6 *rhs, struct FheUint6 **result);

int fhe_uint6_rem_assign(struct FheUint6 *lhs, const struct FheUint6 *rhs);

int fhe_uint6_rotate_left(const struct FheUint6 *lhs,
                          const struct FheUint6 *rhs,
                          struct FheUint6 **result);

int fhe_uint6_rotate_left_assign(struct FheUint6 *lhs, const struct FheUint6 *rhs);

int fhe_uint6_rotate_right(const struct FheUint6 *lhs,
                           const struct FheUint6 *rhs,
                           struct FheUint6 **result);

int fhe_uint6_rotate_right_assign(struct FheUint6 *lhs, const struct FheUint6 *rhs);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int fhe_uint6_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                          uint64_t serialized_size_limit,
                                          const struct ServerKey *server_key,
                                          struct FheUint6 **result);

int fhe_uint6_safe_serialize(const struct FheUint6 *sself,
                             DynamicBuffer *result,
                             uint64_t serialized_size_limit);

int fhe_uint6_scalar_add(const struct FheUint6 *lhs, uint8_t rhs, struct FheUint6 **result);

int fhe_uint6_scalar_add_assign(struct FheUint6 *lhs, uint8_t rhs);

int fhe_uint6_scalar_bitand(const struct FheUint6 *lhs, uint8_t rhs, struct FheUint6 **result);

int fhe_uint6_scalar_bitand_assign(struct FheUint6 *lhs, uint8_t rhs);

int fhe_uint6_scalar_bitor(const struct FheUint6 *lhs, uint8_t rhs, struct FheUint6 **result);

int fhe_uint6_scalar_bitor_assign(struct FheUint6 *lhs, uint8_t rhs);

int fhe_uint6_scalar_bitxor(const struct FheUint6 *lhs, uint8_t rhs, struct FheUint6 **result);

int fhe_uint6_scalar_bitxor_assign(struct FheUint6 *lhs, uint8_t rhs);

int fhe_uint6_scalar_div(const struct FheUint6 *lhs, uint8_t rhs, struct FheUint6 **result);

int fhe_uint6_scalar_div_assign(struct FheUint6 *lhs, uint8_t rhs);

int fhe_uint6_scalar_div_rem(const struct FheUint6 *lhs,
                             uint8_t rhs,
                             struct FheUint6 **q_result,
                             struct FheUint6 **r_result);

int fhe_uint6_scalar_eq(const struct FheUint6 *lhs, uint8_t rhs, struct FheBool **result);

int fhe_uint6_scalar_ge(const struct FheUint6 *lhs, uint8_t rhs, struct FheBool **result);

int fhe_uint6_scalar_gt(const struct FheUint6 *lhs, uint8_t rhs, struct FheBool **result);

int fhe_uint6_scalar_le(const struct FheUint6 *lhs, uint8_t rhs, struct FheBool **result);

int fhe_uint6_scalar_lt(const struct FheUint6 *lhs, uint8_t rhs, struct FheBool **result);

int fhe_uint6_scalar_max(const struct FheUint6 *lhs, uint8_t rhs, struct FheUint6 **result);

int fhe_uint6_scalar_min(const struct FheUint6 *lhs, uint8_t rhs, struct FheUint6 **result);

int fhe_uint6_scalar_mul(const struct FheUint6 *lhs, uint8_t rhs, struct FheUint6 **result);

int fhe_uint6_scalar_mul_assign(struct FheUint6 *lhs, uint8_t rhs);

int fhe_uint6_scalar_ne(const struct FheUint6 *lhs, uint8_t rhs, struct FheBool **result);

int fhe_uint6_scalar_rem(const struct FheUint6 *lhs, uint8_t rhs, struct FheUint6 **result);

int fhe_uint6_scalar_rem_assign(struct FheUint6 *lhs, uint8_t rhs);

int fhe_uint6_scalar_rotate_left(const struct FheUint6 *lhs, uint8_t rhs, struct FheUint6 **result);

int fhe_uint6_scalar_rotate_left_assign(struct FheUint6 *lhs, uint8_t rhs);

int fhe_uint6_scalar_rotate_right(const struct FheUint6 *lhs,
                                  uint8_t rhs,
                                  struct FheUint6 **result);

int fhe_uint6_scalar_rotate_right_assign(struct FheUint6 *lhs, uint8_t rhs);

int fhe_uint6_scalar_shl(const struct FheUint6 *lhs, uint8_t rhs, struct FheUint6 **result);

int fhe_uint6_scalar_shl_assign(struct FheUint6 *lhs, uint8_t rhs);

int fhe_uint6_scalar_shr(const struct FheUint6 *lhs, uint8_t rhs, struct FheUint6 **result);

int fhe_uint6_scalar_shr_assign(struct FheUint6 *lhs, uint8_t rhs);

int fhe_uint6_scalar_sub(const struct FheUint6 *lhs, uint8_t rhs, struct FheUint6 **result);

int fhe_uint6_scalar_sub_assign(struct FheUint6 *lhs, uint8_t rhs);

int fhe_uint6_serialize(const struct FheUint6 *sself, DynamicBuffer *result);

int fhe_uint6_shl(const struct FheUint6 *lhs, const struct FheUint6 *rhs, struct FheUint6 **result);

int fhe_uint6_shl_assign(struct FheUint6 *lhs, const struct FheUint6 *rhs);

int fhe_uint6_shr(const struct FheUint6 *lhs, const struct FheUint6 *rhs, struct FheUint6 **result);

int fhe_uint6_shr_assign(struct FheUint6 *lhs, const struct FheUint6 *rhs);

int fhe_uint6_sub(const struct FheUint6 *lhs, const struct FheUint6 *rhs, struct FheUint6 **result);

int fhe_uint6_sub_assign(struct FheUint6 *lhs, const struct FheUint6 *rhs);

int fhe_uint6_sum(const struct FheUint6 *const *lhs, size_t len, struct FheUint6 **out_result);

/**
 * Returns the number of trailing ones in the binary representation of input.
 */
int fhe_uint6_trailing_ones(const struct FheUint6 *input, struct FheUint32 **result);

/**
 * Returns the number of trailing zeros in the binary representation of input.
 */
int fhe_uint6_trailing_zeros(const struct FheUint6 *input, struct FheUint32 **result);

int fhe_uint6_try_decrypt_trivial(const struct FheUint6 *encrypted_value, uint8_t *result);

int fhe_uint6_try_encrypt_trivial_u8(uint8_t value, struct FheUint6 **result);

int fhe_uint6_try_encrypt_with_client_key_u8(uint8_t value,
                                             const struct ClientKey *client_key,
                                             struct FheUint6 **result);

int fhe_uint6_try_encrypt_with_compact_public_key_u8(uint8_t value,
                                                     const struct CompactPublicKey *public_key,
                                                     struct FheUint6 **result);

int fhe_uint6_try_encrypt_with_public_key_u8(uint8_t value,
                                             const struct PublicKey *public_key,
                                             struct FheUint6 **result);

int fhe_uint8_add(const struct FheUint8 *lhs, const struct FheUint8 *rhs, struct FheUint8 **result);

int fhe_uint8_add_assign(struct FheUint8 *lhs, const struct FheUint8 *rhs);

int fhe_uint8_bitand(const struct FheUint8 *lhs,
                     const struct FheUint8 *rhs,
                     struct FheUint8 **result);

int fhe_uint8_bitand_assign(struct FheUint8 *lhs, const struct FheUint8 *rhs);

int fhe_uint8_bitor(const struct FheUint8 *lhs,
                    const struct FheUint8 *rhs,
                    struct FheUint8 **result);

int fhe_uint8_bitor_assign(struct FheUint8 *lhs, const struct FheUint8 *rhs);

int fhe_uint8_bitxor(const struct FheUint8 *lhs,
                     const struct FheUint8 *rhs,
                     struct FheUint8 **result);

int fhe_uint8_bitxor_assign(struct FheUint8 *lhs, const struct FheUint8 *rhs);

int fhe_uint8_cast_into_fhe_int10(const struct FheUint8 *sself, struct FheInt10 **result);

int fhe_uint8_cast_into_fhe_int12(const struct FheUint8 *sself, struct FheInt12 **result);

int fhe_uint8_cast_into_fhe_int128(const struct FheUint8 *sself, struct FheInt128 **result);

int fhe_uint8_cast_into_fhe_int14(const struct FheUint8 *sself, struct FheInt14 **result);

int fhe_uint8_cast_into_fhe_int16(const struct FheUint8 *sself, struct FheInt16 **result);

int fhe_uint8_cast_into_fhe_int160(const struct FheUint8 *sself, struct FheInt160 **result);

int fhe_uint8_cast_into_fhe_int2(const struct FheUint8 *sself, struct FheInt2 **result);

int fhe_uint8_cast_into_fhe_int256(const struct FheUint8 *sself, struct FheInt256 **result);

int fhe_uint8_cast_into_fhe_int32(const struct FheUint8 *sself, struct FheInt32 **result);

int fhe_uint8_cast_into_fhe_int4(const struct FheUint8 *sself, struct FheInt4 **result);

int fhe_uint8_cast_into_fhe_int6(const struct FheUint8 *sself, struct FheInt6 **result);

int fhe_uint8_cast_into_fhe_int64(const struct FheUint8 *sself, struct FheInt64 **result);

int fhe_uint8_cast_into_fhe_int8(const struct FheUint8 *sself, struct FheInt8 **result);

int fhe_uint8_cast_into_fhe_uint10(const struct FheUint8 *sself, struct FheUint10 **result);

int fhe_uint8_cast_into_fhe_uint128(const struct FheUint8 *sself, struct FheUint128 **result);

int fhe_uint8_cast_into_fhe_uint14(const struct FheUint8 *sself, struct FheUint14 **result);

int fhe_uint8_cast_into_fhe_uint16(const struct FheUint8 *sself, struct FheUint16 **result);

int fhe_uint8_cast_into_fhe_uint160(const struct FheUint8 *sself, struct FheUint160 **result);

int fhe_uint8_cast_into_fhe_uint2(const struct FheUint8 *sself, struct FheUint2 **result);

int fhe_uint8_cast_into_fhe_uint256(const struct FheUint8 *sself, struct FheUint256 **result);

int fhe_uint8_cast_into_fhe_uint32(const struct FheUint8 *sself, struct FheUint32 **result);

int fhe_uint8_cast_into_fhe_uint4(const struct FheUint8 *sself, struct FheUint4 **result);

int fhe_uint8_cast_into_fhe_uint6(const struct FheUint8 *sself, struct FheUint6 **result);

int fhe_uint8_cast_into_fhe_uint64(const struct FheUint8 *sself, struct FheUint64 **result);

int fhe_uint8_cast_into_fhe_uint8(const struct FheUint8 *sself, struct FheUint8 **result);

/**
 * Returns the base 2 logarithm of the number, rounded down.
 *
 * Also returns a boolean flag that is true if the result is valid (i.e input was > 0)
 */
int fhe_uint8_checked_ilog2(const struct FheUint8 *input,
                            struct FheUint32 **result_1,
                            struct FheBool **result_2);

int fhe_uint8_clone(const struct FheUint8 *sself, struct FheUint8 **result);

int fhe_uint8_compress(const struct FheUint8 *sself, struct CompressedFheUint8 **result);

int fhe_uint8_decrypt(const struct FheUint8 *encrypted_value,
                      const struct ClientKey *client_key,
                      uint8_t *result);

int fhe_uint8_deserialize(DynamicBufferView buffer_view, struct FheUint8 **result);

/**
 *ptr can be null (no-op in that case)
 */
int fhe_uint8_destroy(struct FheUint8 *ptr);

int fhe_uint8_div(const struct FheUint8 *lhs, const struct FheUint8 *rhs, struct FheUint8 **result);

int fhe_uint8_div_assign(struct FheUint8 *lhs, const struct FheUint8 *rhs);

int fhe_uint8_div_rem(const struct FheUint8 *lhs,
                      const struct FheUint8 *rhs,
                      struct FheUint8 **q_result,
                      struct FheUint8 **r_result);

int fhe_uint8_eq(const struct FheUint8 *lhs, const struct FheUint8 *rhs, struct FheBool **result);

int fhe_uint8_ge(const struct FheUint8 *lhs, const struct FheUint8 *rhs, struct FheBool **result);

int fhe_uint8_gt(const struct FheUint8 *lhs, const struct FheUint8 *rhs, struct FheBool **result);

int fhe_uint8_if_then_else(const struct FheBool *condition_ct,
                           const struct FheUint8 *then_ct,
                           const struct FheUint8 *else_ct,
                           struct FheUint8 **result);

/**
 * Returns the base 2 logarithm of the number, rounded down.
 *
 * Result has no meaning if self encrypts a value that is <= 0.
 * See `checked_ilog2`
 */
int fhe_uint8_ilog2(const struct FheUint8 *input, struct FheUint32 **result);

int fhe_uint8_le(const struct FheUint8 *lhs, const struct FheUint8 *rhs, struct FheBool **result);

/**
 * Returns the number of leading ones in the binary representation of input.
 */
int fhe_uint8_leading_ones(const struct FheUint8 *input, struct FheUint32 **result);

/**
 * Returns the number of leading zeros in the binary representation of input.
 */
int fhe_uint8_leading_zeros(const struct FheUint8 *input, struct FheUint32 **result);

int fhe_uint8_lt(const struct FheUint8 *lhs, const struct FheUint8 *rhs, struct FheBool **result);

int fhe_uint8_max(const struct FheUint8 *lhs, const struct FheUint8 *rhs, struct FheUint8 **result);

int fhe_uint8_min(const struct FheUint8 *lhs, const struct FheUint8 *rhs, struct FheUint8 **result);

int fhe_uint8_mul(const struct FheUint8 *lhs, const struct FheUint8 *rhs, struct FheUint8 **result);

int fhe_uint8_mul_assign(struct FheUint8 *lhs, const struct FheUint8 *rhs);

int fhe_uint8_ne(const struct FheUint8 *lhs, const struct FheUint8 *rhs, struct FheBool **result);

int fhe_uint8_neg(const struct FheUint8 *input, struct FheUint8 **result);

int fhe_uint8_not(const struct FheUint8 *input, struct FheUint8 **result);

int fhe_uint8_overflowing_add(const struct FheUint8 *lhs,
                              const struct FheUint8 *rhs,
                              struct FheUint8 **out_result,
                              struct FheBool **out_overflowed);

int fhe_uint8_overflowing_mul(const struct FheUint8 *lhs,
                              const struct FheUint8 *rhs,
                              struct FheUint8 **out_result,
                              struct FheBool **out_overflowed);

int fhe_uint8_overflowing_sub(const struct FheUint8 *lhs,
                              const struct FheUint8 *rhs,
                              struct FheUint8 **out_result,
                              struct FheBool **out_overflowed);

int fhe_uint8_rem(const struct FheUint8 *lhs, const struct FheUint8 *rhs, struct FheUint8 **result);

int fhe_uint8_rem_assign(struct FheUint8 *lhs, const struct FheUint8 *rhs);

int fhe_uint8_rotate_left(const struct FheUint8 *lhs,
                          const struct FheUint8 *rhs,
                          struct FheUint8 **result);

int fhe_uint8_rotate_left_assign(struct FheUint8 *lhs, const struct FheUint8 *rhs);

int fhe_uint8_rotate_right(const struct FheUint8 *lhs,
                           const struct FheUint8 *rhs,
                           struct FheUint8 **result);

int fhe_uint8_rotate_right_assign(struct FheUint8 *lhs, const struct FheUint8 *rhs);

/**
 * Deserializes safely, and checks that the resulting ciphertext
 * is in compliance with the shape of ciphertext that the `server_key` expects.
 *
 * This function can only deserialize, types which have been serialized
 * by a `safe_serialize` function.
 *
 * - `serialized_size_limit`: size limit (in number of byte) of the serialized object
 *    (to avoid out of memory attacks)
 * - `server_key`: ServerKey used in the conformance check
 * - `result`: pointer where resulting deserialized object needs to be stored.
 *    * cannot be NULL
 *    * (*result) will point the deserialized object on success, else NULL
 */
int fhe_uint8_safe_deserialize_conformant(DynamicBufferView buffer_view,
                                          uint64_t serialized_size_limit,
                                          const struct ServerKey *server_key,
                                          struct FheUint8 **result);

int fhe_uint8_safe_serialize(const struct FheUint8 *sself,
                             DynamicBuffer *result,
                             uint64_t serialized_size_limit);

int fhe_uint8_scalar_add(const struct FheUint8 *lhs, uint8_t rhs, struct FheUint8 **result);

int fhe_uint8_scalar_add_assign(struct FheUint8 *lhs, uint8_t rhs);

int fhe_uint8_scalar_bitand(const struct FheUint8 *lhs, uint8_t rhs, struct FheUint8 **result);

int fhe_uint8_scalar_bitand_assign(struct FheUint8 *lhs, uint8_t rhs);

int fhe_uint8_scalar_bitor(const struct FheUint8 *lhs, uint8_t rhs, struct FheUint8 **result);

int fhe_uint8_scalar_bitor_assign(struct FheUint8 *lhs, uint8_t rhs);

int fhe_uint8_scalar_bitxor(const struct FheUint8 *lhs, uint8_t rhs, struct FheUint8 **result);

int fhe_uint8_scalar_bitxor_assign(struct FheUint8 *lhs, uint8_t rhs);

int fhe_uint8_scalar_div(const struct FheUint8 *lhs, uint8_t rhs, struct FheUint8 **result);

int fhe_uint8_scalar_div_assign(struct FheUint8 *lhs, uint8_t rhs);

int fhe_uint8_scalar_div_rem(const struct FheUint8 *lhs,
                             uint8_t rhs,
                             struct FheUint8 **q_result,
                             struct FheUint8 **r_result);

int fhe_uint8_scalar_eq(const struct FheUint8 *lhs, uint8_t rhs, struct FheBool **result);

int fhe_uint8_scalar_ge(const struct FheUint8 *lhs, uint8_t rhs, struct FheBool **result);

int fhe_uint8_scalar_gt(const struct FheUint8 *lhs, uint8_t rhs, struct FheBool **result);

int fhe_uint8_scalar_le(const struct FheUint8 *lhs, uint8_t rhs, struct FheBool **result);

int fhe_uint8_scalar_lt(const struct FheUint8 *lhs, uint8_t rhs, struct FheBool **result);

int fhe_uint8_scalar_max(const struct FheUint8 *lhs, uint8_t rhs, struct FheUint8 **result);

int fhe_uint8_scalar_min(const struct FheUint8 *lhs, uint8_t rhs, struct FheUint8 **result);

int fhe_uint8_scalar_mul(const struct FheUint8 *lhs, uint8_t rhs, struct FheUint8 **result);

int fhe_uint8_scalar_mul_assign(struct FheUint8 *lhs, uint8_t rhs);

int fhe_uint8_scalar_ne(const struct FheUint8 *lhs, uint8_t rhs, struct FheBool **result);

int fhe_uint8_scalar_rem(const struct FheUint8 *lhs, uint8_t rhs, struct FheUint8 **result);

int fhe_uint8_scalar_rem_assign(struct FheUint8 *lhs, uint8_t rhs);

int fhe_uint8_scalar_rotate_left(const struct FheUint8 *lhs, uint8_t rhs, struct FheUint8 **result);

int fhe_uint8_scalar_rotate_left_assign(struct FheUint8 *lhs, uint8_t rhs);

int fhe_uint8_scalar_rotate_right(const struct FheUint8 *lhs,
                                  uint8_t rhs,
                                  struct FheUint8 **result);

int fhe_uint8_scalar_rotate_right_assign(struct FheUint8 *lhs, uint8_t rhs);

int fhe_uint8_scalar_shl(const struct FheUint8 *lhs, uint8_t rhs, struct FheUint8 **result);

int fhe_uint8_scalar_shl_assign(struct FheUint8 *lhs, uint8_t rhs);

int fhe_uint8_scalar_shr(const struct FheUint8 *lhs, uint8_t rhs, struct FheUint8 **result);

int fhe_uint8_scalar_shr_assign(struct FheUint8 *lhs, uint8_t rhs);

int fhe_uint8_scalar_sub(const struct FheUint8 *lhs, uint8_t rhs, struct FheUint8 **result);

int fhe_uint8_scalar_sub_assign(struct FheUint8 *lhs, uint8_t rhs);

int fhe_uint8_serialize(const struct FheUint8 *sself, DynamicBuffer *result);

int fhe_uint8_shl(const struct FheUint8 *lhs, const struct FheUint8 *rhs, struct FheUint8 **result);

int fhe_uint8_shl_assign(struct FheUint8 *lhs, const struct FheUint8 *rhs);

int fhe_uint8_shr(const struct FheUint8 *lhs, const struct FheUint8 *rhs, struct FheUint8 **result);

int fhe_uint8_shr_assign(struct FheUint8 *lhs, const struct FheUint8 *rhs);

int fhe_uint8_sub(const struct FheUint8 *lhs, const struct FheUint8 *rhs, struct FheUint8 **result);

int fhe_uint8_sub_assign(struct FheUint8 *lhs, const struct FheUint8 *rhs);

int fhe_uint8_sum(const struct FheUint8 *const *lhs, size_t len, struct FheUint8 **out_result);

/**
 * Returns the number of trailing ones in the binary representation of input.
 */
int fhe_uint8_trailing_ones(const struct FheUint8 *input, struct FheUint32 **result);

/**
 * Returns the number of trailing zeros in the binary representation of input.
 */
int fhe_uint8_trailing_zeros(const struct FheUint8 *input, struct FheUint32 **result);

int fhe_uint8_try_decrypt_trivial(const struct FheUint8 *encrypted_value, uint8_t *result);

int fhe_uint8_try_encrypt_trivial_u8(uint8_t value, struct FheUint8 **result);

int fhe_uint8_try_encrypt_with_client_key_u8(uint8_t value,
                                             const struct ClientKey *client_key,
                                             struct FheUint8 **result);

int fhe_uint8_try_encrypt_with_compact_public_key_u8(uint8_t value,
                                                     const struct CompactPublicKey *public_key,
                                                     struct FheUint8 **result);

int fhe_uint8_try_encrypt_with_public_key_u8(uint8_t value,
                                             const struct PublicKey *public_key,
                                             struct FheUint8 **result);

int generate_keys(struct Config *config,
                  struct ClientKey **result_client_key,
                  struct ServerKey **result_server_key);

int generate_oblivious_pseudo_random_bits_fhe_uint10(struct FheUint10 **out_result,
                                                     uint64_t seed_low_bytes,
                                                     uint64_t seed_high_bytes,
                                                     uint64_t random_bits_count);

int generate_oblivious_pseudo_random_bits_fhe_uint12(struct FheUint12 **out_result,
                                                     uint64_t seed_low_bytes,
                                                     uint64_t seed_high_bytes,
                                                     uint64_t random_bits_count);

int generate_oblivious_pseudo_random_bits_fhe_uint128(struct FheUint128 **out_result,
                                                      uint64_t seed_low_bytes,
                                                      uint64_t seed_high_bytes,
                                                      uint64_t random_bits_count);

int generate_oblivious_pseudo_random_bits_fhe_uint14(struct FheUint14 **out_result,
                                                     uint64_t seed_low_bytes,
                                                     uint64_t seed_high_bytes,
                                                     uint64_t random_bits_count);

int generate_oblivious_pseudo_random_bits_fhe_uint16(struct FheUint16 **out_result,
                                                     uint64_t seed_low_bytes,
                                                     uint64_t seed_high_bytes,
                                                     uint64_t random_bits_count);

int generate_oblivious_pseudo_random_bits_fhe_uint160(struct FheUint160 **out_result,
                                                      uint64_t seed_low_bytes,
                                                      uint64_t seed_high_bytes,
                                                      uint64_t random_bits_count);

int generate_oblivious_pseudo_random_bits_fhe_uint2(struct FheUint2 **out_result,
                                                    uint64_t seed_low_bytes,
                                                    uint64_t seed_high_bytes,
                                                    uint64_t random_bits_count);

int generate_oblivious_pseudo_random_bits_fhe_uint256(struct FheUint256 **out_result,
                                                      uint64_t seed_low_bytes,
                                                      uint64_t seed_high_bytes,
                                                      uint64_t random_bits_count);

int generate_oblivious_pseudo_random_bits_fhe_uint32(struct FheUint32 **out_result,
                                                     uint64_t seed_low_bytes,
                                                     uint64_t seed_high_bytes,
                                                     uint64_t random_bits_count);

int generate_oblivious_pseudo_random_bits_fhe_uint4(struct FheUint4 **out_result,
                                                    uint64_t seed_low_bytes,
                                                    uint64_t seed_high_bytes,
                                                    uint64_t random_bits_count);

int generate_oblivious_pseudo_random_bits_fhe_uint6(struct FheUint6 **out_result,
                                                    uint64_t seed_low_bytes,
                                                    uint64_t seed_high_bytes,
                                                    uint64_t random_bits_count);

int generate_oblivious_pseudo_random_bits_fhe_uint64(struct FheUint64 **out_result,
                                                     uint64_t seed_low_bytes,
                                                     uint64_t seed_high_bytes,
                                                     uint64_t random_bits_count);

int generate_oblivious_pseudo_random_bits_fhe_uint8(struct FheUint8 **out_result,
                                                    uint64_t seed_low_bytes,
                                                    uint64_t seed_high_bytes,
                                                    uint64_t random_bits_count);

int generate_oblivious_pseudo_random_fhe_uint10(struct FheUint10 **out_result,
                                                uint64_t seed_low_bytes,
                                                uint64_t seed_high_bytes);

int generate_oblivious_pseudo_random_fhe_uint12(struct FheUint12 **out_result,
                                                uint64_t seed_low_bytes,
                                                uint64_t seed_high_bytes);

int generate_oblivious_pseudo_random_fhe_uint128(struct FheUint128 **out_result,
                                                 uint64_t seed_low_bytes,
                                                 uint64_t seed_high_bytes);

int generate_oblivious_pseudo_random_fhe_uint14(struct FheUint14 **out_result,
                                                uint64_t seed_low_bytes,
                                                uint64_t seed_high_bytes);

int generate_oblivious_pseudo_random_fhe_uint16(struct FheUint16 **out_result,
                                                uint64_t seed_low_bytes,
                                                uint64_t seed_high_bytes);

int generate_oblivious_pseudo_random_fhe_uint160(struct FheUint160 **out_result,
                                                 uint64_t seed_low_bytes,
                                                 uint64_t seed_high_bytes);

int generate_oblivious_pseudo_random_fhe_uint2(struct FheUint2 **out_result,
                                               uint64_t seed_low_bytes,
                                               uint64_t seed_high_bytes);

int generate_oblivious_pseudo_random_fhe_uint256(struct FheUint256 **out_result,
                                                 uint64_t seed_low_bytes,
                                                 uint64_t seed_high_bytes);

int generate_oblivious_pseudo_random_fhe_uint32(struct FheUint32 **out_result,
                                                uint64_t seed_low_bytes,
                                                uint64_t seed_high_bytes);

int generate_oblivious_pseudo_random_fhe_uint4(struct FheUint4 **out_result,
                                               uint64_t seed_low_bytes,
                                               uint64_t seed_high_bytes);

int generate_oblivious_pseudo_random_fhe_uint6(struct FheUint6 **out_result,
                                               uint64_t seed_low_bytes,
                                               uint64_t seed_high_bytes);

int generate_oblivious_pseudo_random_fhe_uint64(struct FheUint64 **out_result,
                                                uint64_t seed_low_bytes,
                                                uint64_t seed_high_bytes);

int generate_oblivious_pseudo_random_fhe_uint8(struct FheUint8 **out_result,
                                               uint64_t seed_low_bytes,
                                               uint64_t seed_high_bytes);

int generate_oblivious_pseudo_random_full_signed_range_fhe_int10(struct FheInt10 **out_result,
                                                                 uint64_t seed_low_bytes,
                                                                 uint64_t seed_high_bytes);

int generate_oblivious_pseudo_random_full_signed_range_fhe_int12(struct FheInt12 **out_result,
                                                                 uint64_t seed_low_bytes,
                                                                 uint64_t seed_high_bytes);

int generate_oblivious_pseudo_random_full_signed_range_fhe_int128(struct FheInt128 **out_result,
                                                                  uint64_t seed_low_bytes,
                                                                  uint64_t seed_high_bytes);

int generate_oblivious_pseudo_random_full_signed_range_fhe_int14(struct FheInt14 **out_result,
                                                                 uint64_t seed_low_bytes,
                                                                 uint64_t seed_high_bytes);

int generate_oblivious_pseudo_random_full_signed_range_fhe_int16(struct FheInt16 **out_result,
                                                                 uint64_t seed_low_bytes,
                                                                 uint64_t seed_high_bytes);

int generate_oblivious_pseudo_random_full_signed_range_fhe_int160(struct FheInt160 **out_result,
                                                                  uint64_t seed_low_bytes,
                                                                  uint64_t seed_high_bytes);

int generate_oblivious_pseudo_random_full_signed_range_fhe_int2(struct FheInt2 **out_result,
                                                                uint64_t seed_low_bytes,
                                                                uint64_t seed_high_bytes);

int generate_oblivious_pseudo_random_full_signed_range_fhe_int256(struct FheInt256 **out_result,
                                                                  uint64_t seed_low_bytes,
                                                                  uint64_t seed_high_bytes);

int generate_oblivious_pseudo_random_full_signed_range_fhe_int32(struct FheInt32 **out_result,
                                                                 uint64_t seed_low_bytes,
                                                                 uint64_t seed_high_bytes);

int generate_oblivious_pseudo_random_full_signed_range_fhe_int4(struct FheInt4 **out_result,
                                                                uint64_t seed_low_bytes,
                                                                uint64_t seed_high_bytes);

int generate_oblivious_pseudo_random_full_signed_range_fhe_int6(struct FheInt6 **out_result,
                                                                uint64_t seed_low_bytes,
                                                                uint64_t seed_high_bytes);

int generate_oblivious_pseudo_random_full_signed_range_fhe_int64(struct FheInt64 **out_result,
                                                                 uint64_t seed_low_bytes,
                                                                 uint64_t seed_high_bytes);

int generate_oblivious_pseudo_random_full_signed_range_fhe_int8(struct FheInt8 **out_result,
                                                                uint64_t seed_low_bytes,
                                                                uint64_t seed_high_bytes);

int generate_oblivious_pseudo_random_unsigned_fhe_int10(struct FheInt10 **out_result,
                                                        uint64_t seed_low_bytes,
                                                        uint64_t seed_high_bytes,
                                                        uint64_t random_bits_count);

int generate_oblivious_pseudo_random_unsigned_fhe_int12(struct FheInt12 **out_result,
                                                        uint64_t seed_low_bytes,
                                                        uint64_t seed_high_bytes,
                                                        uint64_t random_bits_count);

int generate_oblivious_pseudo_random_unsigned_fhe_int128(struct FheInt128 **out_result,
                                                         uint64_t seed_low_bytes,
                                                         uint64_t seed_high_bytes,
                                                         uint64_t random_bits_count);

int generate_oblivious_pseudo_random_unsigned_fhe_int14(struct FheInt14 **out_result,
                                                        uint64_t seed_low_bytes,
                                                        uint64_t seed_high_bytes,
                                                        uint64_t random_bits_count);

int generate_oblivious_pseudo_random_unsigned_fhe_int16(struct FheInt16 **out_result,
                                                        uint64_t seed_low_bytes,
                                                        uint64_t seed_high_bytes,
                                                        uint64_t random_bits_count);

int generate_oblivious_pseudo_random_unsigned_fhe_int160(struct FheInt160 **out_result,
                                                         uint64_t seed_low_bytes,
                                                         uint64_t seed_high_bytes,
                                                         uint64_t random_bits_count);

int generate_oblivious_pseudo_random_unsigned_fhe_int2(struct FheInt2 **out_result,
                                                       uint64_t seed_low_bytes,
                                                       uint64_t seed_high_bytes,
                                                       uint64_t random_bits_count);

int generate_oblivious_pseudo_random_unsigned_fhe_int256(struct FheInt256 **out_result,
                                                         uint64_t seed_low_bytes,
                                                         uint64_t seed_high_bytes,
                                                         uint64_t random_bits_count);

int generate_oblivious_pseudo_random_unsigned_fhe_int32(struct FheInt32 **out_result,
                                                        uint64_t seed_low_bytes,
                                                        uint64_t seed_high_bytes,
                                                        uint64_t random_bits_count);

int generate_oblivious_pseudo_random_unsigned_fhe_int4(struct FheInt4 **out_result,
                                                       uint64_t seed_low_bytes,
                                                       uint64_t seed_high_bytes,
                                                       uint64_t random_bits_count);

int generate_oblivious_pseudo_random_unsigned_fhe_int6(struct FheInt6 **out_result,
                                                       uint64_t seed_low_bytes,
                                                       uint64_t seed_high_bytes,
                                                       uint64_t random_bits_count);

int generate_oblivious_pseudo_random_unsigned_fhe_int64(struct FheInt64 **out_result,
                                                        uint64_t seed_low_bytes,
                                                        uint64_t seed_high_bytes,
                                                        uint64_t random_bits_count);

int generate_oblivious_pseudo_random_unsigned_fhe_int8(struct FheInt8 **out_result,
                                                       uint64_t seed_low_bytes,
                                                       uint64_t seed_high_bytes,
                                                       uint64_t random_bits_count);

struct DynamicDistribution new_gaussian_from_std_dev(double std_dev);

struct DynamicDistribution new_t_uniform(uint32_t bound_log2);

int public_key_deserialize(DynamicBufferView buffer_view, struct PublicKey **result);

/**
 *ptr can be null (no-op in that case)
 */
int public_key_destroy(struct PublicKey *ptr);

int public_key_new(const struct ClientKey *client_key, struct PublicKey **result_public_key);

int public_key_serialize(const struct PublicKey *sself, DynamicBuffer *result);

int server_key_deserialize(DynamicBufferView buffer_view, struct ServerKey **result);

/**
 *ptr can be null (no-op in that case)
 */
int server_key_destroy(struct ServerKey *ptr);

int server_key_serialize(const struct ServerKey *sself, DynamicBuffer *result);

int set_server_key(const struct ServerKey *server_key);

int shortint_ciphertext_get_degree(const struct ShortintCiphertext *ciphertext, size_t *result);

int shortint_ciphertext_set_degree(struct ShortintCiphertext *ciphertext, size_t degree);

int shortint_client_key_decrypt(const struct ShortintClientKey *client_key,
                                const struct ShortintCiphertext *ciphertext_to_decrypt,
                                uint64_t *result);

int shortint_client_key_encrypt(const struct ShortintClientKey *client_key,
                                uint64_t value_to_encrypt,
                                struct ShortintCiphertext **result);

int shortint_client_key_encrypt_compressed(const struct ShortintClientKey *client_key,
                                           uint64_t value_to_encrypt,
                                           struct ShortintCompressedCiphertext **result);

int shortint_compressed_public_key_encrypt(const struct ShortintCompressedPublicKey *compressed_public_key,
                                           uint64_t value_to_encrypt,
                                           struct ShortintCiphertext **result);

int shortint_decompress_ciphertext(const struct ShortintCompressedCiphertext *compressed_ciphertext,
                                   struct ShortintCiphertext **result);

int shortint_decompress_public_key(const struct ShortintCompressedPublicKey *compressed_public_key,
                                   struct ShortintPublicKey **result);

int shortint_decompress_server_key(const struct ShortintCompressedServerKey *compressed_server_key,
                                   struct ShortintServerKey **result);

int shortint_deserialize_ciphertext(DynamicBufferView buffer_view,
                                    struct ShortintCiphertext **result);

int shortint_deserialize_client_key(DynamicBufferView buffer_view,
                                    struct ShortintClientKey **result);

int shortint_deserialize_compressed_ciphertext(DynamicBufferView buffer_view,
                                               struct ShortintCompressedCiphertext **result);

int shortint_deserialize_compressed_public_key(DynamicBufferView buffer_view,
                                               struct ShortintCompressedPublicKey **result);

int shortint_deserialize_compressed_server_key(DynamicBufferView buffer_view,
                                               struct ShortintCompressedServerKey **result);

int shortint_deserialize_public_key(DynamicBufferView buffer_view,
                                    struct ShortintPublicKey **result);

int shortint_deserialize_server_key(DynamicBufferView buffer_view,
                                    struct ShortintServerKey **result);

int shortint_destroy_bivariate_pbs_lookup_table(struct ShortintBivariatePBSLookupTable *pbs_lookup_table);

int shortint_destroy_ciphertext(struct ShortintCiphertext *shortint_ciphertext);

int shortint_destroy_client_key(struct ShortintClientKey *client_key);

int shortint_destroy_compressed_ciphertext(struct ShortintCompressedCiphertext *shortint_ciphertext);

int shortint_destroy_compressed_public_key(struct ShortintCompressedPublicKey *compressed_public_key);

int shortint_destroy_compressed_server_key(struct ShortintCompressedServerKey *server_key);

int shortint_destroy_pbs_lookup_table(struct ShortintPBSLookupTable *pbs_lookup_table);

int shortint_destroy_public_key(struct ShortintPublicKey *public_key);

int shortint_destroy_server_key(struct ShortintServerKey *server_key);

int shortint_gen_client_key(struct ShortintPBSParameters shortint_parameters,
                            struct ShortintClientKey **result_client_key);

int shortint_gen_compressed_public_key(const struct ShortintClientKey *client_key,
                                       struct ShortintCompressedPublicKey **result);

int shortint_gen_compressed_server_key(const struct ShortintClientKey *client_key,
                                       struct ShortintCompressedServerKey **result_server_key);

int shortint_gen_keys_with_parameters(struct ShortintPBSParameters shortint_parameters,
                                      struct ShortintClientKey **result_client_key,
                                      struct ShortintServerKey **result_server_key);

int shortint_gen_public_key(const struct ShortintClientKey *client_key,
                            struct ShortintPublicKey **result);

int shortint_gen_server_key(const struct ShortintClientKey *client_key,
                            struct ShortintServerKey **result_server_key);

int shortint_get_parameters(uint32_t message_bits,
                            uint32_t carry_bits,
                            struct ShortintPBSParameters *result);

int shortint_get_parameters_small(uint32_t message_bits,
                                  uint32_t carry_bits,
                                  struct ShortintPBSParameters *result);

int shortint_public_key_encrypt(const struct ShortintPublicKey *public_key,
                                uint64_t value_to_encrypt,
                                struct ShortintCiphertext **result);

int shortint_serialize_ciphertext(const struct ShortintCiphertext *ciphertext,
                                  DynamicBuffer *result);

int shortint_serialize_client_key(const struct ShortintClientKey *client_key,
                                  DynamicBuffer *result);

int shortint_serialize_compressed_ciphertext(const struct ShortintCompressedCiphertext *ciphertext,
                                             DynamicBuffer *result);

int shortint_serialize_compressed_public_key(const struct ShortintCompressedPublicKey *compressed_public_key,
                                             DynamicBuffer *result);

int shortint_serialize_compressed_server_key(const struct ShortintCompressedServerKey *server_key,
                                             DynamicBuffer *result);

int shortint_serialize_public_key(const struct ShortintPublicKey *public_key,
                                  DynamicBuffer *result);

int shortint_serialize_server_key(const struct ShortintServerKey *server_key,
                                  DynamicBuffer *result);

int shortint_server_key_bivariate_programmable_bootstrap(const struct ShortintServerKey *server_key,
                                                         const struct ShortintBivariatePBSLookupTable *lookup_table,
                                                         const struct ShortintCiphertext *ct_left,
                                                         const struct ShortintCiphertext *ct_right,
                                                         struct ShortintCiphertext **result);

int shortint_server_key_bivariate_programmable_bootstrap_assign(const struct ShortintServerKey *server_key,
                                                                const struct ShortintBivariatePBSLookupTable *lookup_table,
                                                                struct ShortintCiphertext *ct_left_and_result,
                                                                struct ShortintCiphertext *ct_right);

int shortint_server_key_create_trivial(const struct ShortintServerKey *server_key,
                                       uint64_t value_to_trivially_encrypt,
                                       struct ShortintCiphertext **result);

int shortint_server_key_generate_bivariate_pbs_lookup_table(const struct ShortintServerKey *server_key,
                                                            BivariateLookupTableCallback lookup_table_callback,
                                                            struct ShortintBivariatePBSLookupTable **result);

int shortint_server_key_generate_pbs_lookup_table(const struct ShortintServerKey *server_key,
                                                  LookupTableCallback lookup_table_callback,
                                                  struct ShortintPBSLookupTable **result);

int shortint_server_key_programmable_bootstrap(const struct ShortintServerKey *server_key,
                                               const struct ShortintPBSLookupTable *lookup_table,
                                               const struct ShortintCiphertext *ct_in,
                                               struct ShortintCiphertext **result);

int shortint_server_key_programmable_bootstrap_assign(const struct ShortintServerKey *server_key,
                                                      const struct ShortintPBSLookupTable *lookup_table,
                                                      struct ShortintCiphertext *ct_in_and_result);

int shortint_server_key_smart_add(const struct ShortintServerKey *server_key,
                                  struct ShortintCiphertext *ct_left,
                                  struct ShortintCiphertext *ct_right,
                                  struct ShortintCiphertext **result);

int shortint_server_key_smart_add_assign(const struct ShortintServerKey *server_key,
                                         struct ShortintCiphertext *ct_left_and_result,
                                         struct ShortintCiphertext *ct_right);

int shortint_server_key_smart_bitand(const struct ShortintServerKey *server_key,
                                     struct ShortintCiphertext *ct_left,
                                     struct ShortintCiphertext *ct_right,
                                     struct ShortintCiphertext **result);

int shortint_server_key_smart_bitand_assign(const struct ShortintServerKey *server_key,
                                            struct ShortintCiphertext *ct_left_and_result,
                                            struct ShortintCiphertext *ct_right);

int shortint_server_key_smart_bitor(const struct ShortintServerKey *server_key,
                                    struct ShortintCiphertext *ct_left,
                                    struct ShortintCiphertext *ct_right,
                                    struct ShortintCiphertext **result);

int shortint_server_key_smart_bitor_assign(const struct ShortintServerKey *server_key,
                                           struct ShortintCiphertext *ct_left_and_result,
                                           struct ShortintCiphertext *ct_right);

int shortint_server_key_smart_bitxor(const struct ShortintServerKey *server_key,
                                     struct ShortintCiphertext *ct_left,
                                     struct ShortintCiphertext *ct_right,
                                     struct ShortintCiphertext **result);

int shortint_server_key_smart_bitxor_assign(const struct ShortintServerKey *server_key,
                                            struct ShortintCiphertext *ct_left_and_result,
                                            struct ShortintCiphertext *ct_right);

int shortint_server_key_smart_div(const struct ShortintServerKey *server_key,
                                  struct ShortintCiphertext *ct_left,
                                  struct ShortintCiphertext *ct_right,
                                  struct ShortintCiphertext **result);

int shortint_server_key_smart_div_assign(const struct ShortintServerKey *server_key,
                                         struct ShortintCiphertext *ct_left_and_result,
                                         struct ShortintCiphertext *ct_right);

int shortint_server_key_smart_equal(const struct ShortintServerKey *server_key,
                                    struct ShortintCiphertext *ct_left,
                                    struct ShortintCiphertext *ct_right,
                                    struct ShortintCiphertext **result);

int shortint_server_key_smart_greater(const struct ShortintServerKey *server_key,
                                      struct ShortintCiphertext *ct_left,
                                      struct ShortintCiphertext *ct_right,
                                      struct ShortintCiphertext **result);

int shortint_server_key_smart_greater_or_equal(const struct ShortintServerKey *server_key,
                                               struct ShortintCiphertext *ct_left,
                                               struct ShortintCiphertext *ct_right,
                                               struct ShortintCiphertext **result);

int shortint_server_key_smart_less(const struct ShortintServerKey *server_key,
                                   struct ShortintCiphertext *ct_left,
                                   struct ShortintCiphertext *ct_right,
                                   struct ShortintCiphertext **result);

int shortint_server_key_smart_less_or_equal(const struct ShortintServerKey *server_key,
                                            struct ShortintCiphertext *ct_left,
                                            struct ShortintCiphertext *ct_right,
                                            struct ShortintCiphertext **result);

int shortint_server_key_smart_mul(const struct ShortintServerKey *server_key,
                                  struct ShortintCiphertext *ct_left,
                                  struct ShortintCiphertext *ct_right,
                                  struct ShortintCiphertext **result);

int shortint_server_key_smart_mul_assign(const struct ShortintServerKey *server_key,
                                         struct ShortintCiphertext *ct_left_and_result,
                                         struct ShortintCiphertext *ct_right);

int shortint_server_key_smart_neg(const struct ShortintServerKey *server_key,
                                  struct ShortintCiphertext *ct_left,
                                  struct ShortintCiphertext **result);

int shortint_server_key_smart_neg_assign(const struct ShortintServerKey *server_key,
                                         struct ShortintCiphertext *ct_left_and_result);

int shortint_server_key_smart_not_equal(const struct ShortintServerKey *server_key,
                                        struct ShortintCiphertext *ct_left,
                                        struct ShortintCiphertext *ct_right,
                                        struct ShortintCiphertext **result);

int shortint_server_key_smart_scalar_add(const struct ShortintServerKey *server_key,
                                         struct ShortintCiphertext *ct_left,
                                         uint8_t scalar_right,
                                         struct ShortintCiphertext **result);

int shortint_server_key_smart_scalar_add_assign(const struct ShortintServerKey *server_key,
                                                struct ShortintCiphertext *ct_left_and_result,
                                                uint8_t scalar_right);

int shortint_server_key_smart_scalar_equal(const struct ShortintServerKey *server_key,
                                           struct ShortintCiphertext *ct_left,
                                           uint8_t right,
                                           struct ShortintCiphertext **result);

int shortint_server_key_smart_scalar_greater(const struct ShortintServerKey *server_key,
                                             struct ShortintCiphertext *ct_left,
                                             uint8_t right,
                                             struct ShortintCiphertext **result);

int shortint_server_key_smart_scalar_greater_or_equal(const struct ShortintServerKey *server_key,
                                                      struct ShortintCiphertext *ct_left,
                                                      uint8_t right,
                                                      struct ShortintCiphertext **result);

int shortint_server_key_smart_scalar_left_shift(const struct ShortintServerKey *server_key,
                                                struct ShortintCiphertext *ct,
                                                uint8_t shift,
                                                struct ShortintCiphertext **result);

int shortint_server_key_smart_scalar_left_shift_assign(const struct ShortintServerKey *server_key,
                                                       struct ShortintCiphertext *ct,
                                                       uint8_t shift);

int shortint_server_key_smart_scalar_less(const struct ShortintServerKey *server_key,
                                          struct ShortintCiphertext *ct_left,
                                          uint8_t right,
                                          struct ShortintCiphertext **result);

int shortint_server_key_smart_scalar_less_or_equal(const struct ShortintServerKey *server_key,
                                                   struct ShortintCiphertext *ct_left,
                                                   uint8_t right,
                                                   struct ShortintCiphertext **result);

int shortint_server_key_smart_scalar_mul(const struct ShortintServerKey *server_key,
                                         struct ShortintCiphertext *ct_left,
                                         uint8_t scalar_right,
                                         struct ShortintCiphertext **result);

int shortint_server_key_smart_scalar_mul_assign(const struct ShortintServerKey *server_key,
                                                struct ShortintCiphertext *ct_left_and_result,
                                                uint8_t scalar_right);

int shortint_server_key_smart_scalar_not_equal(const struct ShortintServerKey *server_key,
                                               struct ShortintCiphertext *ct_left,
                                               uint8_t right,
                                               struct ShortintCiphertext **result);

int shortint_server_key_smart_scalar_right_shift(const struct ShortintServerKey *server_key,
                                                 struct ShortintCiphertext *ct,
                                                 uint8_t shift,
                                                 struct ShortintCiphertext **result);

int shortint_server_key_smart_scalar_right_shift_assign(const struct ShortintServerKey *server_key,
                                                        struct ShortintCiphertext *ct,
                                                        uint8_t shift);

int shortint_server_key_smart_scalar_sub(const struct ShortintServerKey *server_key,
                                         struct ShortintCiphertext *ct_left,
                                         uint8_t scalar_right,
                                         struct ShortintCiphertext **result);

int shortint_server_key_smart_scalar_sub_assign(const struct ShortintServerKey *server_key,
                                                struct ShortintCiphertext *ct_left_and_result,
                                                uint8_t scalar_right);

int shortint_server_key_smart_sub(const struct ShortintServerKey *server_key,
                                  struct ShortintCiphertext *ct_left,
                                  struct ShortintCiphertext *ct_right,
                                  struct ShortintCiphertext **result);

int shortint_server_key_smart_sub_assign(const struct ShortintServerKey *server_key,
                                         struct ShortintCiphertext *ct_left_and_result,
                                         struct ShortintCiphertext *ct_right);

int shortint_server_key_unchecked_add(const struct ShortintServerKey *server_key,
                                      const struct ShortintCiphertext *ct_left,
                                      const struct ShortintCiphertext *ct_right,
                                      struct ShortintCiphertext **result);

int shortint_server_key_unchecked_add_assign(const struct ShortintServerKey *server_key,
                                             struct ShortintCiphertext *ct_left_and_result,
                                             const struct ShortintCiphertext *ct_right);

int shortint_server_key_unchecked_bitand(const struct ShortintServerKey *server_key,
                                         const struct ShortintCiphertext *ct_left,
                                         const struct ShortintCiphertext *ct_right,
                                         struct ShortintCiphertext **result);

int shortint_server_key_unchecked_bitand_assign(const struct ShortintServerKey *server_key,
                                                struct ShortintCiphertext *ct_left_and_result,
                                                const struct ShortintCiphertext *ct_right);

int shortint_server_key_unchecked_bitor(const struct ShortintServerKey *server_key,
                                        const struct ShortintCiphertext *ct_left,
                                        const struct ShortintCiphertext *ct_right,
                                        struct ShortintCiphertext **result);

int shortint_server_key_unchecked_bitor_assign(const struct ShortintServerKey *server_key,
                                               struct ShortintCiphertext *ct_left_and_result,
                                               const struct ShortintCiphertext *ct_right);

int shortint_server_key_unchecked_bitxor(const struct ShortintServerKey *server_key,
                                         const struct ShortintCiphertext *ct_left,
                                         const struct ShortintCiphertext *ct_right,
                                         struct ShortintCiphertext **result);

int shortint_server_key_unchecked_bitxor_assign(const struct ShortintServerKey *server_key,
                                                struct ShortintCiphertext *ct_left_and_result,
                                                const struct ShortintCiphertext *ct_right);

int shortint_server_key_unchecked_div(const struct ShortintServerKey *server_key,
                                      const struct ShortintCiphertext *ct_left,
                                      const struct ShortintCiphertext *ct_right,
                                      struct ShortintCiphertext **result);

int shortint_server_key_unchecked_div_assign(const struct ShortintServerKey *server_key,
                                             struct ShortintCiphertext *ct_left_and_result,
                                             const struct ShortintCiphertext *ct_right);

int shortint_server_key_unchecked_equal(const struct ShortintServerKey *server_key,
                                        const struct ShortintCiphertext *ct_left,
                                        const struct ShortintCiphertext *ct_right,
                                        struct ShortintCiphertext **result);

int shortint_server_key_unchecked_greater(const struct ShortintServerKey *server_key,
                                          const struct ShortintCiphertext *ct_left,
                                          const struct ShortintCiphertext *ct_right,
                                          struct ShortintCiphertext **result);

int shortint_server_key_unchecked_greater_or_equal(const struct ShortintServerKey *server_key,
                                                   const struct ShortintCiphertext *ct_left,
                                                   const struct ShortintCiphertext *ct_right,
                                                   struct ShortintCiphertext **result);

int shortint_server_key_unchecked_less(const struct ShortintServerKey *server_key,
                                       const struct ShortintCiphertext *ct_left,
                                       const struct ShortintCiphertext *ct_right,
                                       struct ShortintCiphertext **result);

int shortint_server_key_unchecked_less_or_equal(const struct ShortintServerKey *server_key,
                                                const struct ShortintCiphertext *ct_left,
                                                const struct ShortintCiphertext *ct_right,
                                                struct ShortintCiphertext **result);

int shortint_server_key_unchecked_mul(const struct ShortintServerKey *server_key,
                                      const struct ShortintCiphertext *ct_left,
                                      const struct ShortintCiphertext *ct_right,
                                      struct ShortintCiphertext **result);

int shortint_server_key_unchecked_mul_assign(const struct ShortintServerKey *server_key,
                                             struct ShortintCiphertext *ct_left_and_result,
                                             const struct ShortintCiphertext *ct_right);

int shortint_server_key_unchecked_neg(const struct ShortintServerKey *server_key,
                                      const struct ShortintCiphertext *ct_left,
                                      struct ShortintCiphertext **result);

int shortint_server_key_unchecked_neg_assign(const struct ShortintServerKey *server_key,
                                             struct ShortintCiphertext *ct_left_and_result);

int shortint_server_key_unchecked_not_equal(const struct ShortintServerKey *server_key,
                                            const struct ShortintCiphertext *ct_left,
                                            const struct ShortintCiphertext *ct_right,
                                            struct ShortintCiphertext **result);

int shortint_server_key_unchecked_scalar_add(const struct ShortintServerKey *server_key,
                                             const struct ShortintCiphertext *ct_left,
                                             uint8_t scalar_right,
                                             struct ShortintCiphertext **result);

int shortint_server_key_unchecked_scalar_add_assign(const struct ShortintServerKey *server_key,
                                                    struct ShortintCiphertext *ct_left_and_result,
                                                    uint8_t scalar_right);

int shortint_server_key_unchecked_scalar_div(const struct ShortintServerKey *server_key,
                                             const struct ShortintCiphertext *ct_left,
                                             uint8_t right,
                                             struct ShortintCiphertext **result);

int shortint_server_key_unchecked_scalar_div_assign(const struct ShortintServerKey *server_key,
                                                    struct ShortintCiphertext *ct_left_and_result,
                                                    uint8_t right);

int shortint_server_key_unchecked_scalar_left_shift(const struct ShortintServerKey *server_key,
                                                    const struct ShortintCiphertext *ct,
                                                    uint8_t shift,
                                                    struct ShortintCiphertext **result);

int shortint_server_key_unchecked_scalar_left_shift_assign(const struct ShortintServerKey *server_key,
                                                           struct ShortintCiphertext *ct,
                                                           uint8_t shift);

int shortint_server_key_unchecked_scalar_mod(const struct ShortintServerKey *server_key,
                                             const struct ShortintCiphertext *ct_left,
                                             uint8_t right,
                                             struct ShortintCiphertext **result);

int shortint_server_key_unchecked_scalar_mod_assign(const struct ShortintServerKey *server_key,
                                                    struct ShortintCiphertext *ct_left_and_result,
                                                    uint8_t right);

int shortint_server_key_unchecked_scalar_mul(const struct ShortintServerKey *server_key,
                                             const struct ShortintCiphertext *ct_left,
                                             uint8_t scalar_right,
                                             struct ShortintCiphertext **result);

int shortint_server_key_unchecked_scalar_mul_assign(const struct ShortintServerKey *server_key,
                                                    struct ShortintCiphertext *ct_left_and_result,
                                                    uint8_t scalar_right);

int shortint_server_key_unchecked_scalar_right_shift(const struct ShortintServerKey *server_key,
                                                     const struct ShortintCiphertext *ct,
                                                     uint8_t shift,
                                                     struct ShortintCiphertext **result);

int shortint_server_key_unchecked_scalar_right_shift_assign(const struct ShortintServerKey *server_key,
                                                            struct ShortintCiphertext *ct,
                                                            uint8_t shift);

int shortint_server_key_unchecked_scalar_sub(const struct ShortintServerKey *server_key,
                                             const struct ShortintCiphertext *ct_left,
                                             uint8_t scalar_right,
                                             struct ShortintCiphertext **result);

int shortint_server_key_unchecked_scalar_sub_assign(const struct ShortintServerKey *server_key,
                                                    struct ShortintCiphertext *ct_left_and_result,
                                                    uint8_t scalar_right);

int shortint_server_key_unchecked_sub(const struct ShortintServerKey *server_key,
                                      const struct ShortintCiphertext *ct_left,
                                      const struct ShortintCiphertext *ct_right,
                                      struct ShortintCiphertext **result);

int shortint_server_key_unchecked_sub_assign(const struct ShortintServerKey *server_key,
                                             struct ShortintCiphertext *ct_left_and_result,
                                             const struct ShortintCiphertext *ct_right);

/**
 * Creates a new threading context
 *
 * - num_threads: number of threads inside this context 0 means it will have number of CPU threads
 */
int tfhe_threading_context_create(size_t num_threads, struct TfheThreadingContext **context);

/**
 * Destroys the threading context
 *
 * `context` may be NULL
 */
void tfhe_threading_context_destroy(struct TfheThreadingContext *context);

/**
 * Runs the given function inside the context
 *
 *
 * Both the `func` and `data` must be thread-safe
 * That is, `data` and `func` must not be used by other
 * threads, unless they do not have data races or have protections
 * to prevent data races.
 */
int tfhe_threading_context_run(struct TfheThreadingContext *context,
                               int (*func)(void*),
                               void *data);

/**
 * Sets the server key inside of all of the threads the context has
 */
int tfhe_threading_context_set_server_key(struct TfheThreadingContext *context,
                                          const struct ServerKey *server_key);

/**
 * len must be 32
 */
int u256_big_endian_bytes(struct U256 input, uint8_t *result, size_t len);

/**
 * Creates a U256 from big endian bytes
 *
 * len must be 32
 */
int u256_from_big_endian_bytes(const uint8_t *input, size_t len, struct U256 *result);

/**
 * Creates a U256 from little endian bytes
 *
 * len must be 32
 */
int u256_from_little_endian_bytes(const uint8_t *input, size_t len, struct U256 *result);

/**
 * len must be 32
 */
int u256_little_endian_bytes(struct U256 input, uint8_t *result, size_t len);

int unset_server_key(void);

#ifdef __cplusplus
} // extern "C"
#endif // __cplusplus

#endif /* TFHE_RS_C_API_H */
